import * as React from 'react';
import { SxProps } from '@mui/system';
import { ButtonBaseProps } from '@mui/material/ButtonBase';
import { Theme } from '@mui/material/styles';
import { ExtendMui } from '../internal/pickers/typings/helpers';
import { PickerSelectionState } from '../internal/pickers/hooks/usePickerState';
export interface PickersDayProps<TDate> extends ExtendMui<ButtonBaseProps> {
    /**
     * If `true`, `onChange` is fired on click even if the same date is selected.
     * @default false
     */
    allowSameDateSelection?: boolean;
    /**
     * Override or extend the styles applied to the component.
     */
    classes?: {
        /** Styles applied to the root element. */
        root?: string;
        /** Styles applied to the root element if `disableMargin=false`. */
        dayWithMargin?: string;
        /** Styles applied to the root element if `outsideCurrentMonth=true` and `showDaysOutsideCurrentMonth=true`. */
        dayOutsideMonth?: string;
        /** Styles applied to the root element if `outsideCurrentMonth=true` and `showDaysOutsideCurrentMonth=false`. */
        hiddenDaySpacingFiller?: string;
        /** Styles applied to the root element if `disableHighlightToday=false` and `today=true`. */
        today?: string;
        /** State class applied to the root element if `selected=true`. */
        selected?: string;
        /** State class applied to the root element if `disabled=true`. */
        disabled?: string;
    };
    /**
     * The date to show.
     */
    day: TDate;
    /**
     * If `true`, renders as disabled.
     * @default false
     */
    disabled?: boolean;
    /**
     * If `true`, todays date is rendering without highlighting with circle.
     * @default false
     */
    disableHighlightToday?: boolean;
    /**
     * If `true`, days are rendering without margin. Useful for displaying linked range of days.
     * @default false
     */
    disableMargin?: boolean;
    isAnimating?: boolean;
    onDayFocus?: (day: TDate) => void;
    onDaySelect: (day: TDate, isFinish: PickerSelectionState) => void;
    /**
     * If `true`, day is outside of month and will be hidden.
     */
    outsideCurrentMonth: boolean;
    /**
     * If `true`, renders as selected.
     * @default false
     */
    selected?: boolean;
    /**
     * If `true`, days that have `outsideCurrentMonth={true}` are displayed.
     * @default false
     */
    showDaysOutsideCurrentMonth?: boolean;
    /**
     * If `true`, renders as today date.
     * @default false
     */
    today?: boolean;
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx?: SxProps<Theme>;
}
export declare type PickersDayClassKey = keyof NonNullable<PickersDayProps<unknown>['classes']>;
export declare function getPickersDayUtilityClass(slot: string): string;
export declare const pickersDayClasses: Record<"root" | "selected" | "disabled" | "dayWithMargin" | "dayOutsideMonth" | "hiddenDaySpacingFiller" | "today", string>;
export declare const areDayPropsEqual: (prevProps: PickersDayProps<any>, nextProps: PickersDayProps<any>) => boolean;
declare const _default: <TDate>(props: PickersDayProps<TDate> & React.RefAttributes<HTMLButtonElement>) => JSX.Element;
/**
 *
 * Demos:
 *
 * - [Date Picker](https://mui.com/components/date-picker/)
 *
 * API:
 *
 * - [PickersDay API](https://mui.com/api/pickers-day/)
 */
export default _default;
