import * as React from 'react';
import { SelectOption, UseSelectMultiProps, UseSelectSingleProps } from './useSelectProps';
import { OptionState } from '../ListboxUnstyled';
interface UseSelectCommonResult<TValue> {
    buttonActive: boolean;
    buttonFocusVisible: boolean;
    disabled: boolean;
    getButtonProps: (otherHandlers?: Record<string, React.EventHandler<any>>) => Record<string, any>;
    getListboxProps: (otherHandlers?: Record<string, React.EventHandler<any>>) => Record<string, any>;
    getOptionProps: (option: SelectOption<TValue>, otherHandlers?: Record<string, React.EventHandler<any>>) => Record<string, any>;
    getOptionState: (option: SelectOption<TValue>) => OptionState;
}
interface UseSelectSingleResult<TValue> extends UseSelectCommonResult<TValue> {
    value: TValue | null;
}
interface UseSelectMultiResult<TValue> extends UseSelectCommonResult<TValue> {
    value: TValue[];
}
declare function useSelect<TValue>(props: UseSelectSingleProps<TValue>): UseSelectSingleResult<TValue>;
declare function useSelect<TValue>(props: UseSelectMultiProps<TValue>): UseSelectMultiResult<TValue>;
export default useSelect;
