# nanoclone
[![license](https://img.shields.io/github/license/kelin2025/nanoclone.svg)](https://github.com/kelin2025/nanoclone/blob/master/LICENSE)
[![npm](https://img.shields.io/npm/v/nanoclone.svg)](https://npmjs.com/package/nanoclone)  
Only **300B** to deep clone JavaScript objects

## Is it small enough?
See the size of the most popular **[clone](https://www.npmjs.com/package/clone)** npm package with **250M+** downloads
![image](https://user-images.githubusercontent.com/4208480/34631395-30df289c-f281-11e7-8442-01502af2097a.png)  
And nanoclone size:  
![image](https://user-images.githubusercontent.com/4208480/35292759-9c839f06-0082-11e8-9196-d710d530a74b.png)

## Supported 
- [x] Primitives
- [x] Arrays
- [x] Plain objects
- [x] DOM Nodes
- [x] Date instances
- [x] RegExp instances
- [x] Maps
- [x] Sets
- [x] Circular structures

## Installation
```
yarn add nanoclone
npm install nanoclone
```

## Usage
```javascript
import clone from 'nanoclone'

let a = {
  num: 2,
  arr: [1, 2, 3],
  nested: {
    obj: {
      a: 0
    }
  }
}

let b = clone(a)
```

## License
MIT
