import type { CSSProperties, FocusEvent, KeyboardEvent, MouseEvent, ReactNode } from 'react';
import type { Data, EventHandler, LabelRenderFunction } from '../commonTypes';
declare type Props = {
    animate?: boolean;
    animationDuration?: number;
    animationEasing?: string;
    background?: string;
    center?: [number, number];
    children?: ReactNode;
    className?: string;
    data: Data;
    lengthAngle?: number;
    lineWidth?: number;
    label?: LabelRenderFunction;
    labelPosition?: number;
    labelStyle?: CSSProperties | ((dataIndex: number) => CSSProperties | undefined);
    onBlur?: EventHandler<FocusEvent>;
    onClick?: EventHandler<MouseEvent>;
    onFocus?: EventHandler<FocusEvent>;
    onKeyDown?: EventHandler<KeyboardEvent>;
    onMouseOut?: EventHandler<MouseEvent>;
    onMouseOver?: EventHandler<MouseEvent>;
    paddingAngle?: number;
    radius?: number;
    reveal?: number;
    rounded?: boolean;
    segmentsShift?: number | ((dataIndex: number) => number | undefined);
    segmentsStyle?: CSSProperties | ((dataIndex: number) => CSSProperties | undefined);
    segmentsTabIndex?: number;
    startAngle?: number;
    style?: CSSProperties;
    totalValue?: number;
    viewBoxSize?: [number, number];
};
declare const defaultProps: {
    animationDuration: number;
    animationEasing: string;
    center: [number, number];
    data: Data;
    labelPosition: number;
    lengthAngle: number;
    lineWidth: number;
    paddingAngle: number;
    radius: number;
    startAngle: number;
    viewBoxSize: [number, number];
};
export declare type PropsWithDefaults = Props & typeof defaultProps;
export declare function ReactMinimalPieChart(props: PropsWithDefaults): JSX.Element;
export declare namespace ReactMinimalPieChart {
    var defaultProps: {
        animationDuration: number;
        animationEasing: string;
        center: [number, number];
        data: Data;
        labelPosition: number;
        lengthAngle: number;
        lineWidth: number;
        paddingAngle: number;
        radius: number;
        startAngle: number;
        viewBoxSize: [number, number];
    };
}
export {};
