import React from 'react';
import { LayoutType, StackOffsetType, CategoricalChartOptions, Margin, ChartOffset, BaseAxisProps, ChartCoordinate, TickItem, AxisDomain } from '../util/types';
import { AccessibilityManager } from './AccessibilityManager';
export declare const getAxisMapByAxes: (props: CategoricalChartProps, { axes, graphicalItems, axisType, axisIdKey, stackGroups, dataStartIndex, dataEndIndex }: any) => any;
export interface CategoricalChartState {
    chartX?: number;
    chartY?: number;
    dataStartIndex?: number;
    dataEndIndex?: number;
    activeTooltipIndex?: number;
    isTooltipActive?: boolean;
    updateId?: number;
    xAxisMap?: {
        [k: string]: BaseAxisProps;
    };
    yAxisMap?: {
        [k: string]: BaseAxisProps;
    };
    orderedTooltipTicks?: any;
    tooltipAxis?: BaseAxisProps;
    tooltipTicks?: TickItem[];
    graphicalItems?: any;
    activeCoordinate?: ChartCoordinate;
    offset?: ChartOffset;
    angleAxisMap?: any;
    radiusAxisMap?: any;
    formattedGraphicalItems?: any;
    activePayload?: any[];
    tooltipAxisBandSize?: number;
    activeItem?: any;
    activeLabel?: string;
    activeIndex?: number;
    xValue?: number;
    yValue?: number;
    legendBBox?: any;
    prevData?: any[];
    prevWidth?: number;
    prevHeight?: number;
    prevLayout?: LayoutType;
    prevStackOffset?: StackOffsetType;
    prevMargin?: Margin;
    prevChildren?: any;
}
export declare type CategoricalChartFunc = (nextState: CategoricalChartState, event: any) => void;
export interface CategoricalChartProps {
    syncId?: number | string;
    syncMethod?: 'index' | 'value' | Function;
    compact?: boolean;
    width?: number;
    height?: number;
    data?: any[];
    layout?: LayoutType;
    stackOffset?: StackOffsetType;
    throttleDelay?: number;
    margin?: Margin;
    barCategoryGap?: number | string;
    barGap?: number | string;
    barSize?: number | string;
    maxBarSize?: number;
    style?: any;
    className?: string;
    children?: any;
    defaultShowTooltip?: boolean;
    onClick?: CategoricalChartFunc;
    onMouseLeave?: CategoricalChartFunc;
    onMouseEnter?: CategoricalChartFunc;
    onMouseMove?: CategoricalChartFunc;
    onMouseDown?: CategoricalChartFunc;
    onMouseUp?: CategoricalChartFunc;
    reverseStackOrder?: boolean;
    id?: string;
    startAngle?: number;
    endAngle?: number;
    cx?: number | string;
    cy?: number | string;
    innerRadius?: number | string;
    outerRadius?: number | string;
    title?: string;
    desc?: string;
    accessibilityLayer?: boolean;
    role?: string;
    tabIndex?: number;
}
export declare const generateCategoricalChart: ({ chartName, GraphicalChild, defaultTooltipEventType, validateTooltipEventTypes, axisComponents, legendContent, formatAxisMap, defaultProps, }: CategoricalChartOptions) => {
    new (props: CategoricalChartProps): {
        uniqueChartId: any;
        clipPathId: any;
        legendInstance: any;
        deferId: any;
        accessibilityManager: AccessibilityManager;
        container?: any;
        componentDidMount(): void;
        getSnapshotBeforeUpdate(prevProps: Readonly<CategoricalChartProps>, prevState: Readonly<CategoricalChartState>): null;
        componentDidUpdate(prevProps: CategoricalChartProps): void;
        componentWillUnmount(): void;
        cancelThrottledTriggerAfterMouseMove(): void;
        getTooltipEventType(): string;
        getMouseInfo(event: any): {
            xValue: any;
            yValue: any;
            chartX: number;
            chartY: number;
        } | {
            activeTooltipIndex: number;
            activeLabel: any;
            activePayload: any[];
            activeCoordinate: ChartCoordinate;
            chartX: number;
            chartY: number;
        };
        getCursorRectangle(): any;
        getCursorPoints(): any;
        inRange(x: number, y: number): any;
        parseEventsOfWrapper(): any;
        addListener(): void;
        removeListener(): void;
        clearDeferId: () => void;
        handleLegendBBoxUpdate: (box: any) => void;
        handleReceiveSyncEvent: (cId: number | string, chartId: string, data: CategoricalChartState) => void;
        handleBrushChange: ({ startIndex, endIndex }: any) => void;
        handleMouseEnter: (e: any) => void;
        triggeredAfterMouseMove: (e: any) => any;
        handleItemMouseEnter: (el: any) => void;
        handleItemMouseLeave: () => void;
        handleMouseMove: (e: any) => void;
        handleMouseLeave: (e: any) => void;
        handleOuterEvent: (e: any) => void;
        handleClick: (e: any) => void;
        handleMouseDown: (e: any) => void;
        handleMouseUp: (e: any) => void;
        handleTouchMove: (e: any) => void;
        handleTouchStart: (e: any) => void;
        handleTouchEnd: (e: any) => void;
        triggerSyncEvent(data: CategoricalChartState): void;
        applySyncEvent(data: CategoricalChartState): void;
        verticalCoordinatesGenerator: ({ xAxis, width, height, offset }: ChartCoordinate) => number[];
        horizontalCoordinatesGenerator: ({ yAxis, width, height, offset }: ChartCoordinate) => number[];
        axesTicksGenerator: (axis?: any) => TickItem[];
        filterFormatItem(item: any, displayName: any, childIndex: any): any;
        renderCursor: (element: any) => React.DetailedReactHTMLElement<any, HTMLElement> | React.CElement<any, React.Component<any, any, any>>;
        renderPolarAxis: (element: any, displayName: string, index: number) => React.DetailedReactHTMLElement<{
            className: any;
            key: any;
            ticks: TickItem[];
            type?: "number" | "category";
            dataKey?: import("../util/types").DataKey<any>;
            hide?: boolean;
            scale?: Function | "auto" | "linear" | "pow" | "sqrt" | "log" | "identity" | "time" | "band" | "point" | "ordinal" | "quantile" | "quantize" | "utc" | "sequential" | "threshold";
            tick?: boolean | React.SVGProps<SVGTextElement> | React.ReactElement<SVGElement, string | ((props: any) => React.ReactElement<any, any>) | (new (props: any) => React.Component<any, any, any>)> | ((props: any) => React.ReactElement<SVGElement, string | ((props: any) => React.ReactElement<any, any>) | (new (props: any) => React.Component<any, any, any>)>);
            tickCount?: number;
            axisLine?: boolean | React.SVGProps<SVGLineElement>;
            tickLine?: boolean | React.SVGProps<SVGTextElement>;
            tickSize?: number;
            tickFormatter?: (value: any, index: number) => string;
            allowDataOverflow?: boolean;
            allowDuplicatedCategory?: boolean;
            allowDecimals?: boolean;
            domain?: AxisDomain;
            includeHidden?: boolean;
            name?: string;
            unit?: string | number;
            axisType?: import("../util/types").AxisType;
            range?: number[];
            AxisComp?: any;
            label?: string | number | object | React.ReactElement<any, string | ((props: any) => React.ReactElement<any, any>) | (new (props: any) => React.Component<any, any, any>)>;
        }, HTMLElement>;
        renderXAxis: (element: any, displayName: string, index: number) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, any>) | (new (props: any) => React.Component<any, any, any>)>;
        renderYAxis: (element: any, displayName: string, index: number) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, any>) | (new (props: any) => React.Component<any, any, any>)>;
        renderAxis(axisOptions: BaseAxisProps, element: any, displayName: string, index: number): React.ReactElement;
        renderGrid: (element: React.ReactElement) => React.ReactElement;
        renderPolarGrid: (element: React.ReactElement) => React.ReactElement;
        renderLegend: () => React.ReactElement;
        renderTooltip: () => React.ReactElement;
        renderBrush: (element: React.ReactElement) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, any>) | (new (props: any) => React.Component<any, any, any>)>;
        renderReferenceElement: (element: React.ReactElement, displayName: string, index: number) => React.ReactElement;
        renderActivePoints: ({ item, activePoint, basePoint, childIndex, isRange }: any) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, any>) | (new (props: any) => React.Component<any, any, any>)>[];
        renderGraphicChild: (element: React.ReactElement, displayName: string, index: number) => any[];
        renderCustomized: (element: React.ReactElement, displayName: string, index: number) => React.ReactElement;
        renderClipPath(): React.JSX.Element;
        getXScales(): {
            [x: string]: Function | "auto" | "linear" | "pow" | "sqrt" | "log" | "identity" | "time" | "band" | "point" | "ordinal" | "quantile" | "quantize" | "utc" | "sequential" | "threshold";
        };
        getYScales(): {
            [x: string]: Function | "auto" | "linear" | "pow" | "sqrt" | "log" | "identity" | "time" | "band" | "point" | "ordinal" | "quantile" | "quantize" | "utc" | "sequential" | "threshold";
        };
        getXScaleByAxisId(axisId: string): Function | "auto" | "linear" | "pow" | "sqrt" | "log" | "identity" | "time" | "band" | "point" | "ordinal" | "quantile" | "quantize" | "utc" | "sequential" | "threshold";
        getYScaleByAxisId(axisId: string): Function | "auto" | "linear" | "pow" | "sqrt" | "log" | "identity" | "time" | "band" | "point" | "ordinal" | "quantile" | "quantize" | "utc" | "sequential" | "threshold";
        getItemByXY(chartXY: {
            x: number;
            y: number;
        }): {
            graphicalItem: any;
            payload: any;
        };
        render(): React.JSX.Element;
        context: any;
        setState<K extends "offset" | "prevData" | "dataStartIndex" | "activeIndex" | "formattedGraphicalItems" | "prevWidth" | "updateId" | "graphicalItems" | "dataEndIndex" | "xAxisMap" | "yAxisMap" | "tooltipAxis" | "tooltipTicks" | "orderedTooltipTicks" | "chartX" | "chartY" | "activeTooltipIndex" | "isTooltipActive" | "activeCoordinate" | "angleAxisMap" | "radiusAxisMap" | "activePayload" | "tooltipAxisBandSize" | "activeItem" | "activeLabel" | "xValue" | "yValue" | "legendBBox" | "prevHeight" | "prevLayout" | "prevStackOffset" | "prevMargin" | "prevChildren">(state: CategoricalChartState | ((prevState: Readonly<CategoricalChartState>, props: Readonly<CategoricalChartProps>) => CategoricalChartState | Pick<CategoricalChartState, K>) | Pick<CategoricalChartState, K>, callback?: () => void): void;
        forceUpdate(callback?: () => void): void;
        readonly props: Readonly<CategoricalChartProps> & Readonly<{
            children?: React.ReactNode;
        }>;
        state: Readonly<CategoricalChartState>;
        refs: {
            [key: string]: React.ReactInstance;
        };
        shouldComponentUpdate?(nextProps: Readonly<CategoricalChartProps>, nextState: Readonly<CategoricalChartState>, nextContext: any): boolean;
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        componentWillMount?(): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<CategoricalChartProps>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<CategoricalChartProps>, nextContext: any): void;
        componentWillUpdate?(nextProps: Readonly<CategoricalChartProps>, nextState: Readonly<CategoricalChartState>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<CategoricalChartProps>, nextState: Readonly<CategoricalChartState>, nextContext: any): void;
    };
    displayName: string;
    defaultProps: CategoricalChartProps;
    getDerivedStateFromProps: (nextProps: CategoricalChartProps, prevState: CategoricalChartState) => CategoricalChartState;
    renderActiveDot: (option: any, props: any) => React.ReactElement;
    contextType?: React.Context<any>;
};
