import React, { SVGProps } from 'react';
import { SymbolType as D3SymbolType } from 'victory-vendor/d3-shape';
import { SymbolType } from '../util/types';
declare type SizeType = 'area' | 'diameter';
interface SymbolsProp {
    className?: string;
    type: SymbolType;
    cx?: number;
    cy?: number;
    size?: number;
    sizeType?: SizeType;
}
export declare type Props = SVGProps<SVGPathElement> & SymbolsProp;
export declare const Symbols: {
    (props: Props): React.JSX.Element;
    defaultProps: {
        type: string;
        size: number;
        sizeType: string;
    };
    registerSymbol: (key: string, factory: D3SymbolType) => void;
};
export {};
