# How to Contribute
## Contribute to Development
Welcome! We are glad that you want to contribute to our project! 🚀

Below you can find some options

### Answer Questions on the Community Forum
Our [Community Forum](https://forum.opennebula.io) is the place to ask questions and help them to solve. If you are interested in contribute and have knowledge about virtualization, cloud, automation, etc. You can help us by answering questions from other users. Create an account if you don't have one, and start checking the forum.

### Bug Reporting
You can report a bug by opening a new issue [here](https://github.com/OpenNebula/one/issues/new?template=bug_report.md). Please, make sure that you follow the template for bug reports and all sections have been completed:
* Version of OpenNebula
* Component
* Brief description
* Expected behavior
* How to reproduce

You can find more information on our Wiki page: [How to Report Bugs](https://github.com/OpenNebula/one/wiki/How-to-Report-Bugs-and-Make-Feature-Requests)

### Feature Request
You can request a new feature by opening an issue [here](https://github.com/OpenNebula/one/issues/new?template=enhancement-request.md). Please, make sure that you follow the template for new features and all sections have been completed:

* Brief description of the new functionality
* How are you going to use this new feature? Why do you need it?
* Describe any changes to current interfaces including Sunstone, CLI and/or API

More information can be found on the wiki: [Feature Request](https://github.com/OpenNebula/one/wiki/How-to-Report-Bugs-and-Make-Feature-Requests#how-do-i-submit-a-new-feature-request)

### Contribute to Addons Development
You can participate by developing a new addon, or contributing to the existing addons we have on [our marketplace](https://github.com/OpenNebula/one/wiki/Add_ons-Catalog). Please check our [guidelines and recommendations](https://github.com/OpenNebula/one/wiki/How-to-participate-in-Add_on-Development) on the wiki page.

We strongly suggest to use the [Community Forum](https://forum.opennebula.io) in order to ask for help, or to make your addon official.

### Quality Assurance
QA & Testing of a cloud management tool is particularly challenging as it requires validating the integration of multiple software components, from different hypervisors and storage architectures to operating systems and DB backends.

As part of OpenNebula QA we perform the following activities:

* Development and maintenance of a testing framework to exercise all the OpenNebula components
* Maintenance of a testing infrastructure with multiple hypervisors and storage configurations
* Regular test execution and circling feedback through to the development process by filing issues
* Manage up-to-date set of test cases for wide functionality scenario coverage.
* Automation of testing and bug identification process

You can find how to help us on the [Quality Assurance Page](https://github.com/OpenNebula/one/wiki/Quality-Assurance)

### Localization
We welcome contributions also to translate our platform to different languages. We use Transifex to localize the project, so you'll need to create an account (if you don't have one), or use your existing Transifex credential. Please check the status of the locale on the [OpenNebula Transifex page](https://explore.transifex.com/opennebula/one/)

### Report a Vulnerability
The OpenNebula Vulnerability Management Team (VMT) is responsible for coordinating the process of evaluating, fixing and disclosing those security vulnerabilities reported by members of the OpenNebula Community. Members of the VMT are all part of the Engineering Team at [OpenNebula Systems](https://opennebula.io), the company that manages and coordinates the development of the OpenNebula project. Membership of this team is intentionally limited to a small number of people.

Please check our Wiki to know more about how to [Report a Security Vulnerability](https://github.com/OpenNebula/one/wiki/Vulnerability-Management-Process)
