/* ------------------------------------------------------------------------- *
 * Copyright 2002-2025, OpenNebula Project, OpenNebula Systems               *
 *                                                                           *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may   *
 * not use this file except in compliance with the License. You may obtain   *
 * a copy of the License at                                                  *
 *                                                                           *
 * http://www.apache.org/licenses/LICENSE-2.0                                *
 *                                                                           *
 * Unless required by applicable law or agreed to in writing, software       *
 * distributed under the License is distributed on an "AS IS" BASIS,         *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
 * See the License for the specific language governing permissions and       *
 * limitations under the License.                                            *
 * ------------------------------------------------------------------------- */
/* eslint-disable jsdoc/require-jsdoc */
import { CategoryFilter } from '@modules/components/Tables/Enhanced/Utils'
import { getMarketplaceState } from '@ModelsModule'

const getTotalOfResources = (resources) =>
  [resources?.ID ?? []].flat().length || 0

export default [
  { Header: 'ID', accessor: 'ID', sortType: 'number' },
  { Header: 'Name', accessor: 'NAME' },
  { Header: 'Owner', accessor: 'UNAME' },
  { Header: 'Group', accessor: 'GNAME' },
  {
    Header: 'State',
    id: 'STATE',
    accessor: (row) => getMarketplaceState(row)?.name,
    disableFilters: false,
    Filter: ({ column }) =>
      CategoryFilter({
        column,
        multiple: true,
        title: 'State',
      }),
    filter: 'includesValue',
  },
  {
    Header: 'Market',
    accessor: 'MARKET_MAD',
    disableFilters: false,
    Filter: ({ column }) =>
      CategoryFilter({
        column,
        multiple: true,
        title: 'Market mad',
      }),
    filter: 'includesValue',
  },
  { Header: 'Total Capacity', accessor: 'TOTAL_MB' },
  { Header: 'Free Capacity', accessor: 'USED_MB' },
  { Header: 'Zone ID', accessor: 'ZONE_ID' },
  {
    Header: 'Total Apps',
    id: 'TOTAL_APPS',
    accessor: (row) => getTotalOfResources(row?.MARKETPLACEAPPS),
  },
]
