/* ------------------------------------------------------------------------- *
 * Copyright 2002-2025, OpenNebula Project, OpenNebula Systems               *
 *                                                                           *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may   *
 * not use this file except in compliance with the License. You may obtain   *
 * a copy of the License at                                                  *
 *                                                                           *
 * http://www.apache.org/licenses/LICENSE-2.0                                *
 *                                                                           *
 * Unless required by applicable law or agreed to in writing, software       *
 * distributed under the License is distributed on an "AS IS" BASIS,         *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
 * See the License for the specific language governing permissions and       *
 * limitations under the License.                                            *
 * ------------------------------------------------------------------------- */

/**
 * @typedef {object} StateInfo
 * @property {string} color - Color.
 * @property {string} name - Name.
 * @property {string} [displayName] - Display name.
 * @property {string} [meaning] - Meaning.
 * @property {string} [shortName] - Short name.
 */

export const ACTIVE = 'ACTIVE'
export const BOOT = 'BOOT'
export const BOOT_FAILURE = 'BOOT_FAILURE'
export const BOOT_MIGRATE = 'BOOT_MIGRATE'
export const BOOT_MIGRATE_FAILURE = 'BOOT_MIGRATE_FAILURE'
export const BOOT_POWEROFF = 'BOOT_POWEROFF'
export const BOOT_STOPPED = 'BOOT_STOPPED'
export const BOOT_STOPPED_FAILURE = 'BOOT_STOPPED_FAILURE'
export const BOOT_SUSPENDED = 'BOOT_SUSPENDED'
export const BOOT_UNDEPLOY = 'BOOT_UNDEPLOY'
export const BOOT_UNDEPLOY_FAILURE = 'BOOT_UNDEPLOY_FAILURE'
export const BOOT_UNKNOWN = 'BOOT_UNKNOWN'
export const CANCEL = 'CANCEL'
export const CLEANUP_DELETE = 'CLEANUP_DELETE'
export const CLEANUP_RESUBMIT = 'CLEANUP_RESUBMIT'
export const CLONE = 'CLONE'
export const CLONING = 'CLONING'
export const CLONING_FAILURE = 'CLONING_FAILURE'
export const CLOSED = 'CLOSED'
export const CONFIGURING = 'CONFIGURING'
export const COOLDOWN = 'COOLDOWN'
export const DELETE = 'DELETE'
export const DELETING = 'DELETING'
export const DEPLOYING = 'DEPLOYING'
export const DEPLOYING_NETS = 'DEPLOYING_NETS'
export const DISABLED = 'DISABLED'
export const DISK_RESIZE = 'DISK_RESIZE'
export const DISK_RESIZE_POWEROFF = 'DISK_RESIZE_POWEROFF'
export const DISK_RESIZE_UNDEPLOYED = 'DISK_RESIZE_UNDEPLOYED'
export const DISK_SNAPSHOT = 'DISK_SNAPSHOT'
export const DISK_SNAPSHOT_DELETE = 'DISK_SNAPSHOT_DELETE'
export const DISK_SNAPSHOT_DELETE_POWEROFF = 'DISK_SNAPSHOT_DELETE_POWEROFF'
export const DISK_SNAPSHOT_DELETE_SUSPENDED = 'DISK_SNAPSHOT_DELETE_SUSPENDED'
export const DISK_SNAPSHOT_POWEROFF = 'DISK_SNAPSHOT_POWEROFF'
export const DISK_SNAPSHOT_REVERT = 'DISK_SNAPSHOT_REVERT'
export const DISK_SNAPSHOT_REVERT_POWEROFF = 'DISK_SNAPSHOT_REVERT_POWEROFF'
export const DISK_SNAPSHOT_REVERT_SUSPENDED = 'DISK_SNAPSHOT_REVERT_SUSPENDED'
export const DISK_SNAPSHOT_SUSPENDED = 'DISK_SNAPSHOT_SUSPENDED'
export const DONE = 'DONE'
export const ENABLED = 'ENABLED'
export const EPILOG = 'EPILOG'
export const EPILOG_FAILURE = 'EPILOG_FAILURE'
export const EPILOG_STOP = 'EPILOG_STOP'
export const EPILOG_STOP_FAILURE = 'EPILOG_STOP_FAILURE'
export const EPILOG_UNDEPLOY = 'EPILOG_UNDEPLOY'
export const EPILOG_UNDEPLOY_FAILURE = 'EPILOG_UNDEPLOY_FAILURE'
export const ERROR = 'ERROR'
export const FAILED = 'FAILED'
export const FAILED_DEPLOYING = 'FAILED_DEPLOYING'
export const FAILED_DEPLOYING_NETS = 'FAILED_DEPLOYING_NETS'
export const FAILED_SCALING = 'FAILED_SCALING'
export const FAILED_UNDEPLOYING = 'FAILED_UNDEPLOYING'
export const FAILED_UNDEPLOYING_NETS = 'FAILED_UNDEPLOYING_NETS'
export const FAILURE = 'FAILURE'
export const HOLD = 'HOLD'
export const HOTPLUG = 'HOTPLUG'
export const HOTPLUG_EPILOG_POWEROFF = 'HOTPLUG_EPILOG_POWEROFF'
export const HOTPLUG_NIC = 'HOTPLUG_NIC'
export const HOTPLUG_NIC_POWEROFF = 'HOTPLUG_NIC_POWEROFF'
export const HOTPLUG_PROLOG_POWEROFF = 'HOTPLUG_PROLOG_POWEROFF'
export const HOTPLUG_RESIZE = 'HOTPLUG_RESIZE'
export const HOTPLUG_SAVEAS = 'HOTPLUG_SAVEAS'
export const HOTPLUG_SAVEAS_POWEROFF = 'HOTPLUG_SAVEAS_POWEROFF'
export const HOTPLUG_SAVEAS_STOPPED = 'HOTPLUG_SAVEAS_STOPPED'
export const HOTPLUG_SAVEAS_SUSPENDED = 'HOTPLUG_SAVEAS_SUSPENDED'
export const HOTPLUG_SAVEAS_UNDEPLOYED = 'HOTPLUG_SAVEAS_UNDEPLOYED'
export const HOTPLUG_SNAPSHOT = 'HOTPLUG_SNAPSHOT'
export const INIT = 'INIT'
export const LCM_INIT = 'LCM_INIT'
export const LOCK_CREATE = 'LOCK_CREATE'
export const LOCK_DELETE = 'LOCK_DELETE'
export const LOCKED = 'LOCKED'
export const LOCKED_USED = 'LOCKED_USED'
export const LOCKED_USED_PERS = 'LOCKED_USED_PERS'
export const MIGRATE = 'MIGRATE'
export const MONITORED = 'MONITORED'
export const MONITORING_DISABLED = 'MONITORING_DISABLED'
export const MONITORING_ERROR = 'MONITORING_ERROR'
export const MONITORING_INIT = 'MONITORING_INIT'
export const MONITORING_MONITORED = 'MONITORING_MONITORED'
export const NEW = 'NEW'
export const OFFLINE = 'OFFLINE'
export const OPEN = 'OPEN'
export const PENDING = 'PENDING'
export const POWEROFF = 'POWEROFF'
export const PROLOG = 'PROLOG'
export const PROLOG_FAILURE = 'PROLOG_FAILURE'
export const PROLOG_MIGRATE = 'PROLOG_MIGRATE'
export const PROLOG_MIGRATE_FAILURE = 'PROLOG_MIGRATE_FAILURE'
export const PROLOG_MIGRATE_POWEROFF = 'PROLOG_MIGRATE_POWEROFF'
export const PROLOG_MIGRATE_POWEROFF_FAILURE = 'PROLOG_MIGRATE_POWEROFF_FAILURE'
export const PROLOG_MIGRATE_SUSPEND = 'PROLOG_MIGRATE_SUSPEND'
export const PROLOG_MIGRATE_SUSPEND_FAILURE = 'PROLOG_MIGRATE_SUSPEND_FAILURE'
export const PROLOG_MIGRATE_UNKNOWN = 'PROLOG_MIGRATE_UNKNOWN'
export const PROLOG_MIGRATE_UNKNOWN_FAILURE = 'PROLOG_MIGRATE_UNKNOWN_FAILURE'
export const PROLOG_RESUME = 'PROLOG_RESUME'
export const PROLOG_RESUME_FAILURE = 'PROLOG_RESUME_FAILURE'
export const PROLOG_UNDEPLOY = 'PROLOG_UNDEPLOY'
export const PROLOG_UNDEPLOY_FAILURE = 'PROLOG_UNDEPLOY_FAILURE'
export const READY = 'READY'
export const RESTORE = 'RESTORE'
export const RUNNING = 'RUNNING'
export const SAVE_MIGRATE = 'SAVE_MIGRATE'
export const SAVE_STOP = 'SAVE_STOP'
export const SAVE_SUSPEND = 'SAVE_SUSPEND'
export const SCALING = 'SCALING'
export const SHUTDOWN = 'SHUTDOWN'
export const SHUTDOWN_POWEROFF = 'SHUTDOWN_POWEROFF'
export const SHUTDOWN_UNDEPLOY = 'SHUTDOWN_UNDEPLOY'
export const SOLVED = 'SOLVED'
export const STOPPED = 'STOPPED'
export const SUCCESS = 'SUCCESS'
export const SUSPENDED = 'SUSPENDED'
export const UNDEPLOYED = 'UNDEPLOYED'
export const UNDEPLOYING = 'UNDEPLOYING'
export const UNDEPLOYING_NETS = 'UNDEPLOYING_NETS'
export const UNKNOWN = 'UNKNOWN'
export const USED = 'USED'
export const USED_PERS = 'USED_PERS'
export const WARNING = 'WARNING'
export const BACKUP = 'BACKUP'
export const BACKUP_POWEROFF = 'BACKUP_POWEROFF'
export const UPDATE_FAILURE = 'UPDATE_FAILURE'
