import { Noop } from '../types';
export declare type Observer<T> = {
    next: (value: T) => void;
};
export declare type TearDown = Noop;
export declare type Subscription = {
    add: (tearDown: TearDown) => void;
    unsubscribe: () => void;
};
export declare type Subject<T> = {
    readonly observers: Observer<T>[];
    next: (value: T) => void;
    subscribe: (value: Observer<T>) => {
        unsubscribe: TearDown;
    };
    unsubscribe: Noop;
};
export default function createSubject<T>(): Subject<T>;
