import type { ReactElement } from 'react';
import type { LabelRenderProps } from './Label';
export declare type EventHandler<Event> = (event: Event, dataIndex: number) => void;
export declare type LabelRenderFunction = (labelRenderProps: LabelRenderProps) => number | string | ReactElement | undefined | null;
export declare type DataEntry = {
    title?: string | number;
    color: string;
    value: number;
    key?: string | number;
    [key: string]: any;
};
export declare type ExtendedDataEntry = DataEntry & {
    degrees: number;
    startAngle: number;
    percentage: number;
};
export declare type Data = DataEntry[];
export declare type ExtendedData = ExtendedDataEntry[];
