import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import clsx from 'clsx';
import { useForkRef, capitalize } from '@mui/material/utils';
import { alpha, styled } from '@mui/material/styles';
import { unstable_composeClasses as composeClasses, generateUtilityClass, generateUtilityClasses } from '@mui/base';
import { WrapperVariantContext } from '../internal/pickers/wrappers/WrapperVariantContext';
import { jsx as _jsx } from "react/jsx-runtime";
export function getPickersYearUtilityClass(slot) {
  return generateUtilityClass('PrivatePickersYear', slot);
}
export var pickersYearClasses = generateUtilityClasses('PrivatePickersYear', ['root', 'modeMobile', 'modeDesktop', 'yearButton', 'disabled', 'selected']);

var useUtilityClasses = function useUtilityClasses(ownerState) {
  var wrapperVariant = ownerState.wrapperVariant,
      disabled = ownerState.disabled,
      selected = ownerState.selected,
      classes = ownerState.classes;
  var slots = {
    root: ['root', wrapperVariant && "mode".concat(capitalize(wrapperVariant))],
    yearButton: ['yearButton', disabled && 'disabled', selected && 'selected']
  };
  return composeClasses(slots, getPickersYearUtilityClass, classes);
};

var PickersYearRoot = styled('div', {
  skipSx: true
})(function (_ref) {
  var ownerState = _ref.ownerState;
  return _extends({
    flexBasis: '33.3%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  }, (ownerState == null ? void 0 : ownerState.wrapperVariant) === 'desktop' && {
    flexBasis: '25%'
  });
});
var PickersYearButton = styled('button', {
  skipSx: true
})(function (_ref2) {
  var _extends2;

  var theme = _ref2.theme;
  return _extends({
    color: 'unset',
    backgroundColor: 'transparent',
    border: 0,
    outline: 0
  }, theme.typography.subtitle1, (_extends2 = {
    margin: '8px 0',
    height: 36,
    width: 72,
    borderRadius: 18,
    cursor: 'pointer',
    '&:focus, &:hover': {
      backgroundColor: alpha(theme.palette.action.active, theme.palette.action.hoverOpacity)
    }
  }, _defineProperty(_extends2, "&.".concat(pickersYearClasses.disabled), {
    color: theme.palette.text.secondary
  }), _defineProperty(_extends2, "&.".concat(pickersYearClasses.selected), {
    color: theme.palette.primary.contrastText,
    backgroundColor: theme.palette.primary.main,
    '&:focus, &:hover': {
      backgroundColor: theme.palette.primary.dark
    }
  }), _extends2));
});
/**
 * @ignore - internal component.
 */

var PickersYear = /*#__PURE__*/React.forwardRef(function PickersYear(props, forwardedRef) {
  var autoFocus = props.autoFocus,
      className = props.className,
      children = props.children,
      disabled = props.disabled,
      _onClick = props.onClick,
      _onKeyDown = props.onKeyDown,
      selected = props.selected,
      value = props.value;
  var ref = React.useRef(null);
  var refHandle = useForkRef(ref, forwardedRef);
  var wrapperVariant = React.useContext(WrapperVariantContext);

  var ownerState = _extends({}, props, {
    wrapperVariant: wrapperVariant
  });

  var classes = useUtilityClasses(ownerState); // TODO: Can we just forward this to the button?

  React.useEffect(function () {
    if (autoFocus) {
      // `ref.current` being `null` would be a bug in MUIu
      ref.current.focus();
    }
  }, [autoFocus]);
  return /*#__PURE__*/_jsx(PickersYearRoot, {
    className: clsx(classes.root, className),
    ownerState: ownerState,
    children: /*#__PURE__*/_jsx(PickersYearButton, {
      ref: refHandle,
      disabled: disabled,
      type: "button",
      tabIndex: selected ? 0 : -1,
      onClick: function onClick(event) {
        return _onClick(event, value);
      },
      onKeyDown: function onKeyDown(event) {
        return _onKeyDown(event, value);
      },
      className: classes.yearButton,
      ownerState: ownerState,
      children: children
    })
  });
});
export default PickersYear;