/* ------------------------------------------------------------------------- *
 * Copyright 2002-2025, OpenNebula Project, OpenNebula Systems               *
 *                                                                           *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may   *
 * not use this file except in compliance with the License. You may obtain   *
 * a copy of the License at                                                  *
 *                                                                           *
 * http://www.apache.org/licenses/LICENSE-2.0                                *
 *                                                                           *
 * Unless required by applicable law or agreed to in writing, software       *
 * distributed under the License is distributed on an "AS IS" BASIS,         *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
 * See the License for the specific language governing permissions and       *
 * limitations under the License.                                            *
 * ------------------------------------------------------------------------- */
/* eslint-disable jsdoc/require-jsdoc */
const getTotalOfResources = (resources) =>
  [resources?.ID ?? []].flat().length || 0

export default [
  { Header: 'ID', accessor: 'ID', sortType: 'number' },
  { Header: 'Name', accessor: 'NAME' },
  {
    Header: 'Total Hosts',
    id: 'HOSTS',
    accessor: (row) => getTotalOfResources(row?.HOSTS),
    sortType: 'number',
  },
  {
    Header: 'Total Datastores',
    id: 'DATASTORES',
    accessor: (row) => getTotalOfResources(row?.DATASTORES),
    sortType: 'number',
  },
  {
    Header: 'Total VNets',
    id: 'VNETS',
    accessor: (row) => getTotalOfResources(row?.VNETS),
    sortType: 'number',
  },
]
