/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OneSystem {
    protected Client client;
    private static final String USER_QUOTA_INFO = "userquota.info";
    private static final String USER_QUOTA_UPDATE = "userquota.update";
    private static final String GROUP_QUOTA_INFO = "groupquota.info";
    private static final String GROUP_QUOTA_UPDATE = "groupquota.update";
    public static final String VERSION = "7.0.1";

    public OneSystem(Client client) {
        this.client = client;
    }

    public OneResponse getOnedVersion() {
        return this.client.call("system.version", new Object[0]);
    }

    public boolean compatibleVersion() {
        String[] stringArray;
        OneResponse oneResponse = this.getOnedVersion();
        if (oneResponse.isError()) {
            return false;
        }
        String[] stringArray2 = VERSION.split("\\.", 3);
        return stringArray2.length == (stringArray = oneResponse.getMessage().split("\\.", 3)).length && stringArray2[0].equals(stringArray[0]) && stringArray2[1].equals(stringArray[1]);
    }

    public OneResponse getConfiguration() {
        return this.client.call("system.config", new Object[0]);
    }

    public Node getConfigurationXML() {
        OneResponse oneResponse = this.getConfiguration();
        Element element = null;
        if (oneResponse.isError()) {
            return null;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(oneResponse.getMessage().getBytes("UTF-8")));
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    public OneResponse getUserQuotas() {
        return this.client.call(USER_QUOTA_INFO, new Object[0]);
    }

    public Node getUserQuotasXML() {
        OneResponse oneResponse = this.getUserQuotas();
        Element element = null;
        if (oneResponse.isError()) {
            return null;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(oneResponse.getMessage().getBytes("UTF-8")));
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    public OneResponse setUserQuotas(String string) {
        return this.client.call(USER_QUOTA_UPDATE, string);
    }

    public OneResponse getGroupQuotas() {
        return this.client.call(GROUP_QUOTA_INFO, new Object[0]);
    }

    public Node getGroupQuotasXML() {
        OneResponse oneResponse = this.getGroupQuotas();
        Element element = null;
        if (oneResponse.isError()) {
            return null;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(oneResponse.getMessage().getBytes("UTF-8")));
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    public OneResponse setGroupQuotas(String string) {
        return this.client.call(GROUP_QUOTA_UPDATE, string);
    }
}

