/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.backupjob;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class BackupJob
extends PoolElement {
    private static final String METHOD_PREFIX = "backupjob.";
    private static final String ALLOCATE = "backupjob.allocate";
    private static final String DELETE = "backupjob.delete";
    private static final String UPDATE = "backupjob.update";
    private static final String RENAME = "backupjob.rename";
    private static final String INFO = "backupjob.info";
    private static final String CHOWN = "backupjob.chown";
    private static final String CHMOD = "backupjob.chmod";
    private static final String LOCK = "backupjob.lock";
    private static final String UNLOCK = "backupjob.unlock";
    private static final String BACKUP = "backupjob.backup";
    private static final String CANCEL = "backupjob.cancel";
    private static final String RETRY = "backupjob.retry";
    private static final String PRIORITY = "backupjob.priority";
    private static final String SCHEDADD = "backupjob.schedadd";
    private static final String SCHEDDELETE = "backupjob.scheddelete";
    private static final String SCHEDUPDATE = "backupjob.schedupdate";

    public BackupJob(int n, Client client) {
        super(n, client);
    }

    protected BackupJob(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return BackupJob.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return BackupJob.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return BackupJob.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public static OneResponse backup(Client client, int n) {
        return client.call(BACKUP, n);
    }

    public static OneResponse cancel(Client client, int n) {
        return client.call(CANCEL, n);
    }

    public static OneResponse retry(Client client, int n) {
        return client.call(RETRY, n);
    }

    public static OneResponse priority(Client client, int n, int n2) {
        return client.call(PRIORITY, n, n2);
    }

    public static OneResponse schedadd(Client client, int n, String string) {
        return client.call(SCHEDADD, n, string);
    }

    public static OneResponse schedupdate(Client client, int n, int n2, String string) {
        return client.call(SCHEDUPDATE, n, n2, string);
    }

    public static OneResponse scheddelete(Client client, int n, int n2) {
        return client.call(SCHEDDELETE, n, n2);
    }

    public OneResponse info() {
        OneResponse oneResponse = BackupJob.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return BackupJob.delete(this.client, this.id);
    }

    public OneResponse update(String string, boolean bl) {
        return BackupJob.update(this.client, this.id, string, bl);
    }

    public OneResponse rename(String string) {
        return BackupJob.rename(this.client, this.id, string);
    }

    public OneResponse chown(int n, int n2) {
        return BackupJob.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return BackupJob.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return BackupJob.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return BackupJob.chmod(this.client, this.id, n);
    }

    public OneResponse lock(int n) {
        return BackupJob.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return BackupJob.unlock(this.client, this.id);
    }

    public OneResponse backup() {
        return BackupJob.backup(this.client, this.id);
    }

    public OneResponse cancel() {
        return BackupJob.cancel(this.client, this.id);
    }

    public OneResponse retry() {
        return BackupJob.retry(this.client, this.id);
    }

    public OneResponse priority(int n) {
        return BackupJob.priority(this.client, this.id, n);
    }

    public OneResponse schedadd(String string) {
        return BackupJob.schedadd(this.client, this.id, string);
    }

    public OneResponse schedupdate(int n, String string) {
        return BackupJob.schedupdate(this.client, this.id, n, string);
    }

    public OneResponse scheddelete(int n) {
        return BackupJob.scheddelete(this.client, this.id, n);
    }
}

