/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.cluster;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class Cluster
extends PoolElement {
    private static final String METHOD_PREFIX = "cluster.";
    private static final String ALLOCATE = "cluster.allocate";
    private static final String DELETE = "cluster.delete";
    private static final String INFO = "cluster.info";
    private static final String UPDATE = "cluster.update";
    private static final String ADDHOST = "cluster.addhost";
    private static final String DELHOST = "cluster.delhost";
    private static final String ADDDATASTORE = "cluster.adddatastore";
    private static final String DELDATASTORE = "cluster.deldatastore";
    private static final String ADDVNET = "cluster.addvnet";
    private static final String DELVNET = "cluster.delvnet";
    private static final String RENAME = "cluster.rename";
    private static final String OPTIMIZE = "cluster.optimize";
    private static final String PLANEXECUTE = "cluster.planexecute";
    private static final String PLANDELETE = "cluster.plandelete";

    public Cluster(int n, Client client) {
        super(n, client);
    }

    protected Cluster(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse addHost(Client client, int n, int n2) {
        return client.call(ADDHOST, n, n2);
    }

    public static OneResponse delHost(Client client, int n, int n2) {
        return client.call(DELHOST, n, n2);
    }

    public static OneResponse addDatastore(Client client, int n, int n2) {
        return client.call(ADDDATASTORE, n, n2);
    }

    public static OneResponse delDatastore(Client client, int n, int n2) {
        return client.call(DELDATASTORE, n, n2);
    }

    public static OneResponse addVnet(Client client, int n, int n2) {
        return client.call(ADDVNET, n, n2);
    }

    public static OneResponse delVnet(Client client, int n, int n2) {
        return client.call(DELVNET, n, n2);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse optimize(Client client, int n) {
        return client.call(OPTIMIZE, n);
    }

    public static OneResponse planExecute(Client client, int n) {
        return client.call(PLANEXECUTE, n);
    }

    public static OneResponse planDelete(Client client, int n) {
        return client.call(PLANDELETE, n);
    }

    public OneResponse info() {
        OneResponse oneResponse = Cluster.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return Cluster.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return Cluster.update(this.client, this.id, string, bl);
    }

    public OneResponse addHost(int n) {
        return Cluster.addHost(this.client, this.id, n);
    }

    public OneResponse delHost(int n) {
        return Cluster.delHost(this.client, this.id, n);
    }

    public OneResponse addDatastore(int n) {
        return Cluster.addDatastore(this.client, this.id, n);
    }

    public OneResponse delDatastore(int n) {
        return Cluster.delDatastore(this.client, this.id, n);
    }

    public OneResponse addVnet(int n) {
        return Cluster.addVnet(this.client, this.id, n);
    }

    public OneResponse delVnet(int n) {
        return Cluster.delVnet(this.client, this.id, n);
    }

    public OneResponse rename(String string) {
        return Cluster.rename(this.client, this.id, string);
    }

    public OneResponse optimize() {
        return Cluster.optimize(this.client, this.id);
    }

    public OneResponse planExecute() {
        return Cluster.planExecute(this.client, this.id);
    }

    public OneResponse planDelete() {
        return Cluster.planDelete(this.client, this.id);
    }

    public boolean containsHost(int n) {
        return this.containsResource("HOSTS", n);
    }

    public boolean containsDatastore(int n) {
        return this.containsResource("DATASTORES", n);
    }

    public boolean containsVnet(int n) {
        return this.containsResource("VNETS", n);
    }

    private boolean containsResource(String string, int n) {
        String string2 = this.xpath(string + "/ID[.=" + n + "]");
        return string2 != null && string2.equals("" + n);
    }
}

