/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.image;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class Image
extends PoolElement {
    private static final String METHOD_PREFIX = "image.";
    private static final String ALLOCATE = "image.allocate";
    private static final String INFO = "image.info";
    private static final String DELETE = "image.delete";
    private static final String UPDATE = "image.update";
    private static final String ENABLE = "image.enable";
    private static final String PERSISTENT = "image.persistent";
    private static final String CHOWN = "image.chown";
    private static final String CHMOD = "image.chmod";
    private static final String CHTYPE = "image.chtype";
    private static final String CLONE = "image.clone";
    private static final String RENAME = "image.rename";
    private static final String SNAPSHOTDELETE = "image.snapshotdelete";
    private static final String SNAPSHOTREVERT = "image.snapshotrevert";
    private static final String SNAPSHOTFLATTEN = "image.snapshotflatten";
    private static final String LOCK = "image.lock";
    private static final String UNLOCK = "image.unlock";
    private static final String[] IMAGE_STATES = new String[]{"INIT", "READY", "USED", "DISABLED", "LOCKED", "ERROR", "CLONE", "DELETE", "USED_PERS", "LOCKED_USED", "LOCKED_USED_PERS"};
    private static final String[] SHORT_IMAGE_STATES = new String[]{"init", "rdy", "used", "disa", "lock", "err", "clon", "dele", "used", "lock", "lock"};
    private static final String[] IMAGE_TYPES = new String[]{"OS", "CDROM", "DATABLOCK", "KERNEL", "RAMDISK", "CONTEXT"};
    private static final String[] SHORT_IMAGE_TYPES = new String[]{"OS", "CD", "DB", "KL", "RD", "CX"};

    public Image(int n, Client client) {
        super(n, client);
    }

    protected Image(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string, int n) {
        return client.call(ALLOCATE, string, n, false);
    }

    public static OneResponse allocate(Client client, String string, int n, boolean bl) {
        return client.call(ALLOCATE, string, n, bl);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n, boolean bl) {
        return client.call(DELETE, n, bl);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse enable(Client client, int n, boolean bl) {
        return client.call(ENABLE, n, bl);
    }

    public static OneResponse persistent(Client client, int n, boolean bl) {
        return client.call(PERSISTENT, n, bl);
    }

    public static OneResponse publish(Client client, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return Image.chmod(client, n, -1, -1, -1, n2, -1, -1, -1, -1, -1);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return Image.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return Image.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return Image.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse chtype(Client client, int n, String string) {
        return client.call(CHTYPE, n, string);
    }

    public static OneResponse clone(Client client, int n, String string, int n2) {
        return client.call(CLONE, n, string, n2);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse snapshotDelete(Client client, int n, int n2) {
        return client.call(SNAPSHOTDELETE, n, n2);
    }

    public static OneResponse snapshotRevert(Client client, int n, int n2) {
        return client.call(SNAPSHOTREVERT, n, n2);
    }

    public static OneResponse snapshotFlatten(Client client, int n, int n2) {
        return client.call(SNAPSHOTFLATTEN, n, n2);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public OneResponse info() {
        OneResponse oneResponse = Image.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete(boolean bl) {
        return Image.delete(this.client, this.id, bl);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return Image.update(this.client, this.id, string, bl);
    }

    public OneResponse enable(boolean bl) {
        return Image.enable(this.client, this.id, bl);
    }

    public OneResponse enable() {
        return this.enable(true);
    }

    public OneResponse disable() {
        return this.enable(false);
    }

    public OneResponse persistent(boolean bl) {
        return Image.persistent(this.client, this.id, bl);
    }

    public OneResponse persistent() {
        return this.persistent(true);
    }

    public OneResponse nonpersistent() {
        return this.persistent(false);
    }

    public OneResponse publish(boolean bl) {
        return Image.publish(this.client, this.id, bl);
    }

    public OneResponse publish() {
        return this.publish(true);
    }

    public OneResponse unpublish() {
        return this.publish(false);
    }

    public OneResponse chown(int n, int n2) {
        return Image.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Image.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return Image.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return Image.chmod(this.client, this.id, n);
    }

    public OneResponse chtype(String string) {
        return Image.chtype(this.client, this.id, string);
    }

    public OneResponse clone(String string) {
        return Image.clone(this.client, this.id, string, -1);
    }

    public OneResponse clone(String string, int n) {
        return Image.clone(this.client, this.id, string, n);
    }

    public OneResponse rename(String string) {
        return Image.rename(this.client, this.id, string);
    }

    public OneResponse snapshotDelete(int n) {
        return Image.snapshotDelete(this.client, this.id, n);
    }

    public OneResponse snapshotRevert(int n) {
        return Image.snapshotRevert(this.client, this.id, n);
    }

    public OneResponse snapshotFlatten(int n) {
        return Image.snapshotFlatten(this.client, this.id, n);
    }

    public OneResponse lock(int n) {
        return Image.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return Image.unlock(this.client, this.id);
    }

    public String stateString() {
        int n = this.state();
        return n != -1 ? IMAGE_STATES[n] : null;
    }

    public String shortStateStr() {
        int n = this.state();
        return n != -1 ? SHORT_IMAGE_STATES[n] : null;
    }

    public int type() {
        String string = this.xpath("TYPE");
        return string != null ? Integer.parseInt(string) : -1;
    }

    public String typeStr() {
        int n = this.type();
        return n != -1 ? IMAGE_TYPES[n] : null;
    }

    public String shortTypeStr() {
        int n = this.type();
        return n != -1 ? SHORT_IMAGE_TYPES[n] : null;
    }

    public boolean isEnabled() {
        return this.state() != 3;
    }
}

