/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.marketplaceapp;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class MarketPlaceApp
extends PoolElement {
    private static final String METHOD_PREFIX = "marketapp.";
    private static final String ALLOCATE = "marketapp.allocate";
    private static final String INFO = "marketapp.info";
    private static final String DELETE = "marketapp.delete";
    private static final String UPDATE = "marketapp.update";
    private static final String ENABLE = "marketapp.enable";
    private static final String CHOWN = "marketapp.chown";
    private static final String CHMOD = "marketapp.chmod";
    private static final String RENAME = "marketapp.rename";
    private static final String LOCK = "marketapp.lock";
    private static final String UNLOCK = "marketapp.unlock";
    private static final String[] MARKETPLACEAPP_STATES = new String[]{"INIT", "READY", "LOCKED", "ERROR", "DISABLED"};
    private static final String[] SHORT_MARKETPLACEAPP_STATES = new String[]{"ini", "rdy", "lck", "err", "dis"};
    private static final String[] MARKETPLACEAPP_TYPES = new String[]{"UNKNOWN", "IMAGE", "VMTEMPLATE", "SERVICE_TEMPLATE"};
    private static final String[] SHORT_MARKETPLACEAPP_TYPES = new String[]{"unk", "img", "tpl", "srv"};

    public MarketPlaceApp(int n, Client client) {
        super(n, client);
    }

    protected MarketPlaceApp(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string, int n) {
        return client.call(ALLOCATE, string, n);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse enable(Client client, int n, boolean bl) {
        return client.call(ENABLE, n, bl);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return MarketPlaceApp.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return MarketPlaceApp.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return MarketPlaceApp.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public OneResponse info() {
        OneResponse oneResponse = MarketPlaceApp.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return MarketPlaceApp.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return MarketPlaceApp.update(this.client, this.id, string, bl);
    }

    public OneResponse enable(boolean bl) {
        return MarketPlaceApp.enable(this.client, this.id, bl);
    }

    public OneResponse enable() {
        return this.enable(true);
    }

    public OneResponse disable() {
        return this.enable(false);
    }

    public OneResponse chown(int n, int n2) {
        return MarketPlaceApp.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return MarketPlaceApp.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return MarketPlaceApp.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return MarketPlaceApp.chmod(this.client, this.id, n);
    }

    public OneResponse rename(String string) {
        return MarketPlaceApp.rename(this.client, this.id, string);
    }

    public OneResponse lock(int n) {
        return MarketPlaceApp.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return MarketPlaceApp.unlock(this.client, this.id);
    }

    public String stateString() {
        int n = this.state();
        return n != -1 ? MARKETPLACEAPP_STATES[n] : null;
    }

    public String shortStateStr() {
        int n = this.state();
        return n != -1 ? SHORT_MARKETPLACEAPP_STATES[n] : null;
    }

    public int type() {
        String string = this.xpath("TYPE");
        return string != null ? Integer.parseInt(string) : -1;
    }

    public String typeStr() {
        int n = this.type();
        return n != -1 ? MARKETPLACEAPP_TYPES[n] : null;
    }

    public String shortTypeStr() {
        int n = this.type();
        return n != -1 ? SHORT_MARKETPLACEAPP_TYPES[n] : null;
    }

    public boolean isEnabled() {
        return this.state() != 3;
    }
}

