/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.secgroup;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class SecurityGroup
extends PoolElement {
    private static final String METHOD_PREFIX = "secgroup.";
    private static final String ALLOCATE = "secgroup.allocate";
    private static final String INFO = "secgroup.info";
    private static final String UPDATE = "secgroup.update";
    private static final String DELETE = "secgroup.delete";
    private static final String CHOWN = "secgroup.chown";
    private static final String CHMOD = "secgroup.chmod";
    private static final String CLONE = "secgroup.clone";
    private static final String RENAME = "secgroup.rename";
    private static final String COMMIT = "secgroup.commit";

    public SecurityGroup(int n, Client client) {
        super(n, client);
    }

    protected SecurityGroup(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return SecurityGroup.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return SecurityGroup.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return SecurityGroup.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse clone(Client client, int n, String string) {
        return client.call(CLONE, n, string);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse commit(Client client, int n, boolean bl) {
        return client.call(COMMIT, n, bl);
    }

    public OneResponse info() {
        OneResponse oneResponse = SecurityGroup.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return SecurityGroup.delete(this.client, this.id);
    }

    public OneResponse chown(int n, int n2) {
        return SecurityGroup.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return SecurityGroup.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return SecurityGroup.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return SecurityGroup.chmod(this.client, this.id, n);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return SecurityGroup.update(this.client, this.id, string, bl);
    }

    public OneResponse clone(String string) {
        return SecurityGroup.clone(this.client, this.id, string);
    }

    public OneResponse rename(String string) {
        return SecurityGroup.rename(this.client, this.id, string);
    }

    public OneResponse commit(boolean bl) {
        return SecurityGroup.commit(this.client, this.id, bl);
    }
}

