/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vmgroup;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class VMGroup
extends PoolElement {
    private static final String METHOD_PREFIX = "vmgroup.";
    private static final String ALLOCATE = "vmgroup.allocate";
    private static final String INFO = "vmgroup.info";
    private static final String UPDATE = "vmgroup.update";
    private static final String DELETE = "vmgroup.delete";
    private static final String CHOWN = "vmgroup.chown";
    private static final String CHMOD = "vmgroup.chmod";
    private static final String RENAME = "vmgroup.rename";
    private static final String LOCK = "vmgroup.lock";
    private static final String UNLOCK = "vmgroup.unlock";
    private static final String ROLEADD = "vmgroup.roleadd";
    private static final String ROLEDELETE = "vmgroup.roledelete";
    private static final String ROLEUPDATE = "vmgroup.roleupdate";

    public VMGroup(int n, Client client) {
        super(n, client);
    }

    protected VMGroup(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return VMGroup.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return VMGroup.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return VMGroup.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public static OneResponse roleAdd(Client client, int n, String string) {
        return client.call(ROLEADD, n, string);
    }

    public static OneResponse roleDelete(Client client, int n, int n2) {
        return client.call(ROLEDELETE, n, n2);
    }

    public static OneResponse roleUpdate(Client client, int n, int n2, String string) {
        return client.call(ROLEUPDATE, n, n2, string);
    }

    public OneResponse info() {
        OneResponse oneResponse = VMGroup.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return VMGroup.delete(this.client, this.id);
    }

    public OneResponse chown(int n, int n2) {
        return VMGroup.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return VMGroup.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return VMGroup.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return VMGroup.chmod(this.client, this.id, n);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return VMGroup.update(this.client, this.id, string, bl);
    }

    public OneResponse rename(String string) {
        return VMGroup.rename(this.client, this.id, string);
    }

    public OneResponse lock(int n) {
        return VMGroup.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return VMGroup.unlock(this.client, this.id);
    }

    public OneResponse roleAdd(String string) {
        return VMGroup.roleAdd(this.client, this.id, string);
    }

    public OneResponse roleDelete(int n) {
        return VMGroup.roleDelete(this.client, this.id, n);
    }

    public OneResponse roleUpdate(int n, String string) {
        return VMGroup.roleUpdate(this.client, this.id, n, string);
    }
}

