import React, { SVGProps } from 'react';
import { AnimationTiming } from '../util/types';
declare type RectRadius = [number, number, number, number];
interface RectangleProps {
    className?: string;
    x?: number;
    y?: number;
    width?: number;
    height?: number;
    radius?: number | RectRadius;
    isAnimationActive?: boolean;
    isUpdateAnimationActive?: boolean;
    animationBegin?: number;
    animationDuration?: number;
    animationEasing?: AnimationTiming;
}
export declare const isInRectangle: (point: {
    x: number;
    y: number;
}, rect: {
    x: number;
    y: number;
    width: number;
    height: number;
}) => boolean;
export declare type Props = Omit<SVGProps<SVGPathElement>, 'radius'> & RectangleProps;
export declare const Rectangle: React.FC<Props>;
export {};
