import * as React from 'react';
import { UseListboxProps, OptionState } from './types';
export default function useListbox<TOption>(props: UseListboxProps<TOption>): {
    getRootProps: (other?: Record<string, React.EventHandler<any>>) => {
        'aria-activedescendant': string | undefined;
        id: string | undefined;
        onBlur: (event: React.FocusEvent<HTMLElement>) => void;
        onKeyDown: (event: React.KeyboardEvent<HTMLElement>) => void;
        role: string;
        tabIndex: number;
        ref: React.Ref<any>;
    };
    getOptionProps: (option: TOption, other?: Record<string, React.EventHandler<any>>) => {
        'aria-disabled': true | undefined;
        'aria-selected': boolean;
        id: string;
        onClick: (event: React.MouseEvent) => void;
        role: string;
    };
    getOptionState: (option: TOption) => OptionState;
    selectedOption: TOption | TOption[] | null;
    highlightedOption: NonNullable<TOption> | null;
};
