import React, { CSSProperties, HTMLAttributes, MouseEvent as ReactMouseEvent, WheelEvent } from 'react';
import { Elements, NodeTypesType, EdgeTypesType, OnLoadFunc, Node, Edge, Connection, ConnectionMode, ConnectionLineType, ConnectionLineComponent, FlowTransform, OnConnectStartFunc, OnConnectStopFunc, OnConnectEndFunc, TranslateExtent, KeyCode, PanOnScrollMode, OnEdgeUpdateFunc, NodeExtent } from '../../types';
import '../../style.css';
import '../../theme-default.css';
export interface ReactFlowProps extends Omit<HTMLAttributes<HTMLDivElement>, 'onLoad'> {
    elements: Elements;
    onElementClick?: (event: ReactMouseEvent, element: Node | Edge) => void;
    onElementsRemove?: (elements: Elements) => void;
    onNodeDoubleClick?: (event: ReactMouseEvent, node: Node) => void;
    onNodeMouseEnter?: (event: ReactMouseEvent, node: Node) => void;
    onNodeMouseMove?: (event: ReactMouseEvent, node: Node) => void;
    onNodeMouseLeave?: (event: ReactMouseEvent, node: Node) => void;
    onNodeContextMenu?: (event: ReactMouseEvent, node: Node) => void;
    onNodeDragStart?: (event: ReactMouseEvent, node: Node) => void;
    onNodeDrag?: (event: ReactMouseEvent, node: Node) => void;
    onNodeDragStop?: (event: ReactMouseEvent, node: Node) => void;
    onConnect?: (connection: Edge | Connection) => void;
    onConnectStart?: OnConnectStartFunc;
    onConnectStop?: OnConnectStopFunc;
    onConnectEnd?: OnConnectEndFunc;
    onLoad?: OnLoadFunc;
    onMove?: (flowTransform?: FlowTransform) => void;
    onMoveStart?: (flowTransform?: FlowTransform) => void;
    onMoveEnd?: (flowTransform?: FlowTransform) => void;
    onSelectionChange?: (elements: Elements | null) => void;
    onSelectionDragStart?: (event: ReactMouseEvent, nodes: Node[]) => void;
    onSelectionDrag?: (event: ReactMouseEvent, nodes: Node[]) => void;
    onSelectionDragStop?: (event: ReactMouseEvent, nodes: Node[]) => void;
    onSelectionContextMenu?: (event: ReactMouseEvent, nodes: Node[]) => void;
    onPaneScroll?: (event?: WheelEvent) => void;
    onPaneClick?: (event: ReactMouseEvent) => void;
    onPaneContextMenu?: (event: ReactMouseEvent) => void;
    nodeTypes?: NodeTypesType;
    edgeTypes?: EdgeTypesType;
    connectionMode?: ConnectionMode;
    connectionLineType?: ConnectionLineType;
    connectionLineStyle?: CSSProperties;
    connectionLineComponent?: ConnectionLineComponent;
    deleteKeyCode?: KeyCode;
    selectionKeyCode?: KeyCode;
    multiSelectionKeyCode?: KeyCode;
    zoomActivationKeyCode?: KeyCode;
    snapToGrid?: boolean;
    snapGrid?: [number, number];
    onlyRenderVisibleElements?: boolean;
    nodesDraggable?: boolean;
    nodesConnectable?: boolean;
    elementsSelectable?: boolean;
    selectNodesOnDrag?: boolean;
    paneMoveable?: boolean;
    minZoom?: number;
    maxZoom?: number;
    defaultZoom?: number;
    defaultPosition?: [number, number];
    translateExtent?: TranslateExtent;
    nodeExtent?: NodeExtent;
    arrowHeadColor?: string;
    markerEndId?: string;
    zoomOnScroll?: boolean;
    zoomOnPinch?: boolean;
    panOnScroll?: boolean;
    panOnScrollSpeed?: number;
    panOnScrollMode?: PanOnScrollMode;
    zoomOnDoubleClick?: boolean;
    onEdgeUpdate?: OnEdgeUpdateFunc;
    onEdgeContextMenu?: (event: ReactMouseEvent, edge: Edge) => void;
    onEdgeMouseEnter?: (event: ReactMouseEvent, edge: Edge) => void;
    onEdgeMouseMove?: (event: ReactMouseEvent, edge: Edge) => void;
    onEdgeMouseLeave?: (event: ReactMouseEvent, edge: Edge) => void;
    onEdgeDoubleClick?: (event: ReactMouseEvent, edge: Edge) => void;
    onEdgeUpdateStart?: (event: ReactMouseEvent, edge: Edge) => void;
    onEdgeUpdateEnd?: (event: MouseEvent, edge: Edge) => void;
    edgeUpdaterRadius?: number;
    nodeTypesId?: string;
    edgeTypesId?: string;
}
export declare type ReactFlowRefType = HTMLDivElement;
declare const ReactFlow: React.ForwardRefExoticComponent<ReactFlowProps & React.RefAttributes<HTMLDivElement>>;
export default ReactFlow;
