# -------------------------------------------------------------------------- #
# Autogenerated from a Treetop grammar. Edits may be lost.


# Copyright 2002-2025, OpenNebula Project, OpenNebula Systems                #
#                                                                            #
# Licensed under the Apache License, Version 2.0 (the "License"); you may    #
# not use this file except in compliance with the License. You may obtain    #
# a copy of the License at                                                   #
#                                                                            #
# http://www.apache.org/licenses/LICENSE-2.0                                 #
#                                                                            #
# Unless required by applicable law or agreed to in writing, software        #
# distributed under the License is distributed on an "AS IS" BASIS,          #
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   #
# See the License for the specific language governing permissions and        #
# limitations under the License.                                             #
#--------------------------------------------------------------------------- #

module ElasticityGrammar
  include Treetop::Runtime

  def root
    @root ||= :expression
  end

  module Expression0
    def space1
      elements[0]
    end

    def exp
      elements[1]
    end

    def space2
      elements[2]
    end
  end

  module Expression1
    def result(role, vm_pool)
        return exp.result(role, vm_pool)
    end
  end

  def _nt_expression
    start_index = index
    if node_cache[:expression].has_key?(index)
      cached = node_cache[:expression][index]
      if cached
        node_cache[:expression][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    r1 = _nt_space
    s0 << r1
    if r1
      i2 = index
      r3 = _nt_boolean_exp
      if r3
        r3 = SyntaxNode.new(input, (index-1)...index) if r3 == true
        r2 = r3
      else
        r4 = _nt_logic_cond
        if r4
          r4 = SyntaxNode.new(input, (index-1)...index) if r4 == true
          r2 = r4
        else
          @index = i2
          r2 = nil
        end
      end
      s0 << r2
      if r2
        r5 = _nt_space
        s0 << r5
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Expression0)
      r0.extend(Expression1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:expression][start_index] = r0

    r0
  end

  module BooleanExp0
    def left
      elements[0]
    end

    def space1
      elements[1]
    end

    def op
      elements[2]
    end

    def space2
      elements[3]
    end

    def right
      elements[4]
    end
  end

  module BooleanExp1
    def result(role, vm_pool)
        l_val, l_st = left.result(role, vm_pool)
        r_val, r_st = right.result(role, vm_pool)

        st = "#{l_st} #{op.text_value} #{r_st}"
        val = l_val && r_val

        return [val, st]
    end
  end

  module BooleanExp2
    def left
      elements[0]
    end

    def space1
      elements[1]
    end

    def op
      elements[2]
    end

    def space2
      elements[3]
    end

    def right
      elements[4]
    end
  end

  module BooleanExp3
    def result(role, vm_pool)
        l_val, l_st = left.result(role, vm_pool)
        r_val, r_st = right.result(role, vm_pool)

        st = "#{l_st} #{op.text_value} #{r_st}"
        val = l_val || r_val

        return [val, st]
    end
  end

  def _nt_boolean_exp
    start_index = index
    if node_cache[:boolean_exp].has_key?(index)
      cached = node_cache[:boolean_exp][index]
      if cached
        node_cache[:boolean_exp][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1, s1 = index, []
    r2 = _nt_logic_cond
    s1 << r2
    if r2
      r3 = _nt_space
      s1 << r3
      if r3
        i4 = index
        if (match_len = has_terminal?('&&', false, index))
          r5 = instantiate_node(SyntaxNode,input, index...(index + match_len))
          @index += match_len
        else
          terminal_parse_failure('\'&&\'')
          r5 = nil
        end
        if r5
          r5 = SyntaxNode.new(input, (index-1)...index) if r5 == true
          r4 = r5
        else
          if (match_len = has_terminal?('&', false, index))
            r6 = true
            @index += match_len
          else
            terminal_parse_failure('\'&\'')
            r6 = nil
          end
          if r6
            r6 = SyntaxNode.new(input, (index-1)...index) if r6 == true
            r4 = r6
          else
            @index = i4
            r4 = nil
          end
        end
        s1 << r4
        if r4
          r7 = _nt_space
          s1 << r7
          if r7
            r8 = _nt_expression
            s1 << r8
          end
        end
      end
    end
    if s1.last
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
      r1.extend(BooleanExp0)
      r1.extend(BooleanExp1)
    else
      @index = i1
      r1 = nil
    end
    if r1
      r1 = SyntaxNode.new(input, (index-1)...index) if r1 == true
      r0 = r1
    else
      i9, s9 = index, []
      r10 = _nt_logic_cond
      s9 << r10
      if r10
        r11 = _nt_space
        s9 << r11
        if r11
          i12 = index
          if (match_len = has_terminal?('||', false, index))
            r13 = instantiate_node(SyntaxNode,input, index...(index + match_len))
            @index += match_len
          else
            terminal_parse_failure('\'||\'')
            r13 = nil
          end
          if r13
            r13 = SyntaxNode.new(input, (index-1)...index) if r13 == true
            r12 = r13
          else
            if (match_len = has_terminal?('|', false, index))
              r14 = true
              @index += match_len
            else
              terminal_parse_failure('\'|\'')
              r14 = nil
            end
            if r14
              r14 = SyntaxNode.new(input, (index-1)...index) if r14 == true
              r12 = r14
            else
              @index = i12
              r12 = nil
            end
          end
          s9 << r12
          if r12
            r15 = _nt_space
            s9 << r15
            if r15
              r16 = _nt_expression
              s9 << r16
            end
          end
        end
      end
      if s9.last
        r9 = instantiate_node(SyntaxNode,input, i9...index, s9)
        r9.extend(BooleanExp2)
        r9.extend(BooleanExp3)
      else
        @index = i9
        r9 = nil
      end
      if r9
        r9 = SyntaxNode.new(input, (index-1)...index) if r9 == true
        r0 = r9
      else
        @index = i0
        r0 = nil
      end
    end

    node_cache[:boolean_exp][start_index] = r0

    r0
  end

  module LogicCond0
    def left
      elements[0]
    end

    def space1
      elements[1]
    end

    def comp_op
      elements[2]
    end

    def space2
      elements[3]
    end

    def right
      elements[4]
    end
  end

  module LogicCond1
    def result(role, vm_pool)
        l_val, l_st = left.result(role, vm_pool)
        r_val, r_st = right.result(role, vm_pool)

        st = "#{l_st} #{comp_op.text_value} #{r_st}"

        if l_val.nil? || r_val.nil?
            # An attribute was not found, we return false instead
            # of assuming a value of 0

            val = false
        else
            val = comp_op.apply(l_val, r_val)
        end

        return [val, st]
    end
  end

  module LogicCond2
    def space
      elements[1]
    end

    def expression
      elements[2]
    end
  end

  module LogicCond3
    def result(role, vm_pool)
        e_val, e_st = expression.result(role, vm_pool)

        val = !e_val
        st = "!#{e_st}"

        return [val, st]
    end
  end

  module LogicCond4
    def space1
      elements[1]
    end

    def expression
      elements[2]
    end

    def space2
      elements[3]
    end

  end

  module LogicCond5
    def result(role, vm_pool)
        e_val, e_st = expression.result(role, vm_pool)

        st = "(#{e_st})"

        return [e_val, st]
    end
  end

  def _nt_logic_cond
    start_index = index
    if node_cache[:logic_cond].has_key?(index)
      cached = node_cache[:logic_cond][index]
      if cached
        node_cache[:logic_cond][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1, s1 = index, []
    r2 = _nt_operand
    s1 << r2
    if r2
      r3 = _nt_space
      s1 << r3
      if r3
        r4 = _nt_comp_op
        s1 << r4
        if r4
          r5 = _nt_space
          s1 << r5
          if r5
            r6 = _nt_operand
            s1 << r6
          end
        end
      end
    end
    if s1.last
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
      r1.extend(LogicCond0)
      r1.extend(LogicCond1)
    else
      @index = i1
      r1 = nil
    end
    if r1
      r1 = SyntaxNode.new(input, (index-1)...index) if r1 == true
      r0 = r1
    else
      i7, s7 = index, []
      if (match_len = has_terminal?('!', false, index))
        r8 = true
        @index += match_len
      else
        terminal_parse_failure('\'!\'')
        r8 = nil
      end
      s7 << r8
      if r8
        r9 = _nt_space
        s7 << r9
        if r9
          r10 = _nt_expression
          s7 << r10
        end
      end
      if s7.last
        r7 = instantiate_node(SyntaxNode,input, i7...index, s7)
        r7.extend(LogicCond2)
        r7.extend(LogicCond3)
      else
        @index = i7
        r7 = nil
      end
      if r7
        r7 = SyntaxNode.new(input, (index-1)...index) if r7 == true
        r0 = r7
      else
        i11, s11 = index, []
        if (match_len = has_terminal?('(', false, index))
          r12 = true
          @index += match_len
        else
          terminal_parse_failure('\'(\'')
          r12 = nil
        end
        s11 << r12
        if r12
          r13 = _nt_space
          s11 << r13
          if r13
            r14 = _nt_expression
            s11 << r14
            if r14
              r15 = _nt_space
              s11 << r15
              if r15
                if (match_len = has_terminal?(')', false, index))
                  r16 = true
                  @index += match_len
                else
                  terminal_parse_failure('\')\'')
                  r16 = nil
                end
                s11 << r16
              end
            end
          end
        end
        if s11.last
          r11 = instantiate_node(SyntaxNode,input, i11...index, s11)
          r11.extend(LogicCond4)
          r11.extend(LogicCond5)
        else
          @index = i11
          r11 = nil
        end
        if r11
          r11 = SyntaxNode.new(input, (index-1)...index) if r11 == true
          r0 = r11
        else
          @index = i0
          r0 = nil
        end
      end
    end

    node_cache[:logic_cond][start_index] = r0

    r0
  end

  module CompOp0
    def apply(a,b)
        a == b
    end
  end

  module CompOp1
    def apply(a,b)
        a != b
    end
  end

  module CompOp2
    def apply(a,b)
        a >= b
    end
  end

  module CompOp3
    def apply(a,b)
        a > b
    end
  end

  module CompOp4
    def apply(a,b)
        a <= b
    end
  end

  module CompOp5
    def apply(a,b)
        a < b
    end
  end

  def _nt_comp_op
    start_index = index
    if node_cache[:comp_op].has_key?(index)
      cached = node_cache[:comp_op][index]
      if cached
        node_cache[:comp_op][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1 = index
    if (match_len = has_terminal?('==', false, index))
      r2 = instantiate_node(SyntaxNode,input, index...(index + match_len))
      @index += match_len
    else
      terminal_parse_failure('\'==\'')
      r2 = nil
    end
    if r2
      r2 = SyntaxNode.new(input, (index-1)...index) if r2 == true
      r1 = r2
      r1.extend(CompOp0)
    else
      if (match_len = has_terminal?('=', false, index))
        r3 = true
        @index += match_len
      else
        terminal_parse_failure('\'=\'')
        r3 = nil
      end
      if r3
        r3 = SyntaxNode.new(input, (index-1)...index) if r3 == true
        r1 = r3
        r1.extend(CompOp0)
      else
        @index = i1
        r1 = nil
      end
    end
    if r1
      r1 = SyntaxNode.new(input, (index-1)...index) if r1 == true
      r0 = r1
    else
      i4 = index
      if (match_len = has_terminal?('!=', false, index))
        r5 = instantiate_node(SyntaxNode,input, index...(index + match_len))
        @index += match_len
      else
        terminal_parse_failure('\'!=\'')
        r5 = nil
      end
      if r5
        r5 = SyntaxNode.new(input, (index-1)...index) if r5 == true
        r4 = r5
        r4.extend(CompOp1)
      else
        if (match_len = has_terminal?('<>', false, index))
          r6 = instantiate_node(SyntaxNode,input, index...(index + match_len))
          @index += match_len
        else
          terminal_parse_failure('\'<>\'')
          r6 = nil
        end
        if r6
          r6 = SyntaxNode.new(input, (index-1)...index) if r6 == true
          r4 = r6
          r4.extend(CompOp1)
        else
          @index = i4
          r4 = nil
        end
      end
      if r4
        r4 = SyntaxNode.new(input, (index-1)...index) if r4 == true
        r0 = r4
      else
        if (match_len = has_terminal?('>=', false, index))
          r7 = instantiate_node(SyntaxNode,input, index...(index + match_len))
          r7.extend(CompOp2)
          @index += match_len
        else
          terminal_parse_failure('\'>=\'')
          r7 = nil
        end
        if r7
          r7 = SyntaxNode.new(input, (index-1)...index) if r7 == true
          r0 = r7
        else
          if (match_len = has_terminal?('>', false, index))
            r8 = instantiate_node(SyntaxNode,input, index...(index + match_len))
            r8.extend(CompOp3)
            @index += match_len
          else
            terminal_parse_failure('\'>\'')
            r8 = nil
          end
          if r8
            r8 = SyntaxNode.new(input, (index-1)...index) if r8 == true
            r0 = r8
          else
            if (match_len = has_terminal?('<=', false, index))
              r9 = instantiate_node(SyntaxNode,input, index...(index + match_len))
              r9.extend(CompOp4)
              @index += match_len
            else
              terminal_parse_failure('\'<=\'')
              r9 = nil
            end
            if r9
              r9 = SyntaxNode.new(input, (index-1)...index) if r9 == true
              r0 = r9
            else
              if (match_len = has_terminal?('<', false, index))
                r10 = instantiate_node(SyntaxNode,input, index...(index + match_len))
                r10.extend(CompOp5)
                @index += match_len
              else
                terminal_parse_failure('\'<\'')
                r10 = nil
              end
              if r10
                r10 = SyntaxNode.new(input, (index-1)...index) if r10 == true
                r0 = r10
              else
                @index = i0
                r0 = nil
              end
            end
          end
        end
      end
    end

    node_cache[:comp_op][start_index] = r0

    r0
  end

  module Operand0
    def result
        number.result(role)
    end
  end

  module Operand1
    def result
        variable.result(role)
    end
  end

  def _nt_operand
    start_index = index
    if node_cache[:operand].has_key?(index)
      cached = node_cache[:operand][index]
      if cached
        node_cache[:operand][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    r1 = _nt_number
    if r1
      r1 = SyntaxNode.new(input, (index-1)...index) if r1 == true
      r0 = r1
    else
      r2 = _nt_variable
      if r2
        r2 = SyntaxNode.new(input, (index-1)...index) if r2 == true
        r0 = r2
      else
        @index = i0
        r0 = nil
      end
    end

    node_cache[:operand][start_index] = r0

    r0
  end

  module Number0
  end

  module Number1
    def result(role, _vm_pool = nil)
        val = text_value.to_f
        st = val.to_s

        return [val, st]
    end
  end

  module Number2
  end

  module Number3
    def result(role, _vm_pool = nil)
        val = text_value.to_i
        st = val.to_s

        return [val, st]
    end
  end

  def _nt_number
    start_index = index
    if node_cache[:number].has_key?(index)
      cached = node_cache[:number][index]
      if cached
        node_cache[:number][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1, s1 = index, []
    if (match_len = has_terminal?('-', false, index))
      r3 = true
      @index += match_len
    else
      terminal_parse_failure('\'-\'')
      r3 = nil
    end
    if r3
      r2 = r3
    else
      r2 = instantiate_node(SyntaxNode,input, index...index)
    end
    s1 << r2
    if r2
      s4, i4 = [], index
      loop do
        if has_terminal?(@regexps[gr = '\A[0-9]'] ||= Regexp.new(gr), :regexp, index)
          r5 = true
          @index += 1
        else
          terminal_parse_failure('[0-9]')
          r5 = nil
        end
        if r5
          s4 << r5
        else
          break
        end
      end
      if s4.empty?
        @index = i4
        r4 = nil
      else
        r4 = instantiate_node(SyntaxNode,input, i4...index, s4)
      end
      s1 << r4
      if r4
        if (match_len = has_terminal?('.', false, index))
          r6 = true
          @index += match_len
        else
          terminal_parse_failure('\'.\'')
          r6 = nil
        end
        s1 << r6
        if r6
          s7, i7 = [], index
          loop do
            if has_terminal?(@regexps[gr = '\A[0-9]'] ||= Regexp.new(gr), :regexp, index)
              r8 = true
              @index += 1
            else
              terminal_parse_failure('[0-9]')
              r8 = nil
            end
            if r8
              s7 << r8
            else
              break
            end
          end
          if s7.empty?
            @index = i7
            r7 = nil
          else
            r7 = instantiate_node(SyntaxNode,input, i7...index, s7)
          end
          s1 << r7
        end
      end
    end
    if s1.last
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
      r1.extend(Number0)
      r1.extend(Number1)
    else
      @index = i1
      r1 = nil
    end
    if r1
      r1 = SyntaxNode.new(input, (index-1)...index) if r1 == true
      r0 = r1
    else
      i9, s9 = index, []
      if (match_len = has_terminal?('-', false, index))
        r11 = true
        @index += match_len
      else
        terminal_parse_failure('\'-\'')
        r11 = nil
      end
      if r11
        r10 = r11
      else
        r10 = instantiate_node(SyntaxNode,input, index...index)
      end
      s9 << r10
      if r10
        s12, i12 = [], index
        loop do
          if has_terminal?(@regexps[gr = '\A[0-9]'] ||= Regexp.new(gr), :regexp, index)
            r13 = true
            @index += 1
          else
            terminal_parse_failure('[0-9]')
            r13 = nil
          end
          if r13
            s12 << r13
          else
            break
          end
        end
        if s12.empty?
          @index = i12
          r12 = nil
        else
          r12 = instantiate_node(SyntaxNode,input, i12...index, s12)
        end
        s9 << r12
      end
      if s9.last
        r9 = instantiate_node(SyntaxNode,input, i9...index, s9)
        r9.extend(Number2)
        r9.extend(Number3)
      else
        @index = i9
        r9 = nil
      end
      if r9
        r9 = SyntaxNode.new(input, (index-1)...index) if r9 == true
        r0 = r9
      else
        @index = i0
        r0 = nil
      end
    end

    node_cache[:number][start_index] = r0

    r0
  end

  module Variable0
  end

  module Variable1
  end

  module Variable2
  end

  module Variable3

    def result(role, vm_pool)
        nodes = role.info_nodes(vm_pool)
        total = 0
        n_nodes = 0
        att = text_value.upcase

        nodes.each { |node|
            if node && node['vm_info']

                vm_state = node['vm_info']['VM']['STATE']
                lcm_state = node['vm_info']['VM']['LCM_STATE']

                # Use values from VMs in RUNNING only

                if vm_state != '3' || lcm_state != '3'
                    next
                end

                value = nil
                if node['vm_info']['VM']['USER_TEMPLATE'][att]
                    value = node['vm_info']['VM']['USER_TEMPLATE'][att]
                elsif node['vm_info']['VM']['MONITORING'][att]
                    value = node['vm_info']['VM']['MONITORING'][att]
                elsif node['vm_info']['VM']['TEMPLATE'][att]
                    value = node['vm_info']['VM']['TEMPLATE'][att]
                elsif node['vm_info']['VM'][att]
                    value = node['vm_info']['VM'][att]
                end

                if value && value.respond_to?(:to_f)
                    total += value.to_f
                    n_nodes += 1
                end
            end
        }

        # The attribute wasn't found for any of the nodes
        if n_nodes == 0
            val = nil
            st = "#{att}[--]"
        else
            val = ((total / n_nodes)*100).round/100.0
            st = "#{att}[#{val.to_s}]"
        end

        return [val, st]
    end
  end

  def _nt_variable
    start_index = index
    if node_cache[:variable].has_key?(index)
      cached = node_cache[:variable][index]
      if cached
        node_cache[:variable][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1, s1 = index, []
    if (match_len = has_terminal?('"', false, index))
      r2 = true
      @index += match_len
    else
      terminal_parse_failure('\'"\'')
      r2 = nil
    end
    s1 << r2
    if r2
      if has_terminal?(@regexps[gr = '\A[a-zA-Z]'] ||= Regexp.new(gr), :regexp, index)
        r3 = true
        @index += 1
      else
        terminal_parse_failure('[a-zA-Z]')
        r3 = nil
      end
      s1 << r3
      if r3
        s4, i4 = [], index
        loop do
          if has_terminal?(@regexps[gr = '\A[0-9a-zA-Z_]'] ||= Regexp.new(gr), :regexp, index)
            r5 = true
            @index += 1
          else
            terminal_parse_failure('[0-9a-zA-Z_]')
            r5 = nil
          end
          if r5
            s4 << r5
          else
            break
          end
        end
        r4 = instantiate_node(SyntaxNode,input, i4...index, s4)
        s1 << r4
        if r4
          if (match_len = has_terminal?('"', false, index))
            r6 = true
            @index += match_len
          else
            terminal_parse_failure('\'"\'')
            r6 = nil
          end
          s1 << r6
        end
      end
    end
    if s1.last
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
      r1.extend(Variable0)
    else
      @index = i1
      r1 = nil
    end
    if r1
      r1 = SyntaxNode.new(input, (index-1)...index) if r1 == true
      r0 = r1
      r0.extend(Variable3)
    else
      i7, s7 = index, []
      if (match_len = has_terminal?('\'', false, index))
        r8 = true
        @index += match_len
      else
        terminal_parse_failure('\'\\\'\'')
        r8 = nil
      end
      s7 << r8
      if r8
        if has_terminal?(@regexps[gr = '\A[a-zA-Z]'] ||= Regexp.new(gr), :regexp, index)
          r9 = true
          @index += 1
        else
          terminal_parse_failure('[a-zA-Z]')
          r9 = nil
        end
        s7 << r9
        if r9
          s10, i10 = [], index
          loop do
            if has_terminal?(@regexps[gr = '\A[0-9a-zA-Z_]'] ||= Regexp.new(gr), :regexp, index)
              r11 = true
              @index += 1
            else
              terminal_parse_failure('[0-9a-zA-Z_]')
              r11 = nil
            end
            if r11
              s10 << r11
            else
              break
            end
          end
          r10 = instantiate_node(SyntaxNode,input, i10...index, s10)
          s7 << r10
          if r10
            if (match_len = has_terminal?('\'', false, index))
              r12 = true
              @index += match_len
            else
              terminal_parse_failure('\'\\\'\'')
              r12 = nil
            end
            s7 << r12
          end
        end
      end
      if s7.last
        r7 = instantiate_node(SyntaxNode,input, i7...index, s7)
        r7.extend(Variable1)
      else
        @index = i7
        r7 = nil
      end
      if r7
        r7 = SyntaxNode.new(input, (index-1)...index) if r7 == true
        r0 = r7
        r0.extend(Variable3)
      else
        i13, s13 = index, []
        if has_terminal?(@regexps[gr = '\A[a-zA-Z]'] ||= Regexp.new(gr), :regexp, index)
          r14 = true
          @index += 1
        else
          terminal_parse_failure('[a-zA-Z]')
          r14 = nil
        end
        s13 << r14
        if r14
          s15, i15 = [], index
          loop do
            if has_terminal?(@regexps[gr = '\A[0-9a-zA-Z_]'] ||= Regexp.new(gr), :regexp, index)
              r16 = true
              @index += 1
            else
              terminal_parse_failure('[0-9a-zA-Z_]')
              r16 = nil
            end
            if r16
              s15 << r16
            else
              break
            end
          end
          r15 = instantiate_node(SyntaxNode,input, i15...index, s15)
          s13 << r15
        end
        if s13.last
          r13 = instantiate_node(SyntaxNode,input, i13...index, s13)
          r13.extend(Variable2)
        else
          @index = i13
          r13 = nil
        end
        if r13
          r13 = SyntaxNode.new(input, (index-1)...index) if r13 == true
          r0 = r13
          r0.extend(Variable3)
        else
          @index = i0
          r0 = nil
        end
      end
    end

    node_cache[:variable][start_index] = r0

    r0
  end

  def _nt_space
    start_index = index
    if node_cache[:space].has_key?(index)
      cached = node_cache[:space][index]
      if cached
        node_cache[:space][index] = cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      if (match_len = has_terminal?(' ', false, index))
        r1 = true
        @index += match_len
      else
        terminal_parse_failure('\' \'')
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)

    node_cache[:space][start_index] = r0

    r0
  end

end

class ElasticityGrammarParser < Treetop::Runtime::CompiledParser
  include ElasticityGrammar
end
