import _extends from "@babel/runtime/helpers/esm/extends";
import { ActionTypes } from './types';
const pageSize = 5;

function findValidOptionToHighlight(index, lookupDirection, options, focusDisabled, isOptionDisabled, wrapAround) {
  if (options.length === 0 || options.every((o, i) => isOptionDisabled(o, i))) {
    return -1;
  }

  let nextFocus = index;

  for (;;) {
    // No valid options found
    if (!wrapAround && lookupDirection === 'next' && nextFocus === options.length || !wrapAround && lookupDirection === 'previous' && nextFocus === -1) {
      return -1;
    }

    const nextFocusDisabled = focusDisabled ? false : isOptionDisabled(options[nextFocus], nextFocus);

    if (nextFocusDisabled) {
      nextFocus += lookupDirection === 'next' ? 1 : -1;

      if (wrapAround) {
        nextFocus = (nextFocus + options.length) % options.length;
      }
    } else {
      return nextFocus;
    }
  }
}

function getNewHighlightedIndex(options, previouslyHighlightedIndex, diff, lookupDirection, highlightDisabled, isOptionDisabled, wrapAround) {
  const maxIndex = options.length - 1;
  const defaultHighlightedIndex = -1;
  let nextIndexCandidate;

  if (diff === 'reset') {
    return defaultHighlightedIndex;
  }

  if (diff === 'start') {
    nextIndexCandidate = 0;
  } else if (diff === 'end') {
    nextIndexCandidate = maxIndex;
  } else {
    const newIndex = previouslyHighlightedIndex + diff;

    if (newIndex < 0) {
      if (!wrapAround && previouslyHighlightedIndex !== -1 || Math.abs(diff) > 1) {
        nextIndexCandidate = 0;
      } else {
        nextIndexCandidate = maxIndex;
      }
    } else if (newIndex > maxIndex) {
      if (!wrapAround || Math.abs(diff) > 1) {
        nextIndexCandidate = maxIndex;
      } else {
        nextIndexCandidate = 0;
      }
    } else {
      nextIndexCandidate = newIndex;
    }
  }

  const nextIndex = findValidOptionToHighlight(nextIndexCandidate, lookupDirection, options, highlightDisabled, isOptionDisabled, wrapAround);
  return nextIndex;
}

function handleOptionSelection(option, state, props) {
  const {
    multiple,
    optionComparer = (o, v) => o === v,
    isOptionDisabled = () => false
  } = props;
  const {
    selectedValue
  } = state;
  const optionIndex = props.options.indexOf(option);

  if (isOptionDisabled(option, optionIndex)) {
    return state;
  }

  if (multiple) {
    var _ref, _ref2;

    const selectedValues = (_ref = selectedValue) != null ? _ref : []; // if the option is already selected, remove it from the selection, otherwise add it

    const newSelectedValues = selectedValues.some(sv => optionComparer(sv, option)) ? selectedValue.filter(v => !optionComparer(v, option)) : [...((_ref2 = selectedValue) != null ? _ref2 : []), option];
    return {
      selectedValue: newSelectedValues,
      highlightedIndex: optionIndex
    };
  }

  if (selectedValue != null && optionComparer(option, selectedValue)) {
    return state;
  }

  return {
    selectedValue: option,
    highlightedIndex: optionIndex
  };
}

function handleKeyDown(event, state, props) {
  const {
    options,
    isOptionDisabled,
    disableListWrap,
    disabledItemsFocusable
  } = props;

  const moveHighlight = (diff, direction, wrapAround) => {
    return getNewHighlightedIndex(options, state.highlightedIndex, diff, direction, disabledItemsFocusable != null ? disabledItemsFocusable : false, isOptionDisabled != null ? isOptionDisabled : () => false, wrapAround);
  };

  switch (event.key) {
    case 'Home':
      return _extends({}, state, {
        highlightedIndex: moveHighlight('start', 'next', false)
      });

    case 'End':
      return _extends({}, state, {
        highlightedIndex: moveHighlight('end', 'previous', false)
      });

    case 'PageUp':
      return _extends({}, state, {
        highlightedIndex: moveHighlight(-pageSize, 'previous', false)
      });

    case 'PageDown':
      return _extends({}, state, {
        highlightedIndex: moveHighlight(pageSize, 'next', false)
      });

    case 'ArrowUp':
      // TODO: extend current selection with Shift modifier
      return _extends({}, state, {
        highlightedIndex: moveHighlight(-1, 'previous', !(disableListWrap != null ? disableListWrap : false))
      });

    case 'ArrowDown':
      // TODO: extend current selection with Shift modifier
      return _extends({}, state, {
        highlightedIndex: moveHighlight(1, 'next', !(disableListWrap != null ? disableListWrap : false))
      });

    case 'Enter':
    case ' ':
      if (state.highlightedIndex === -1 || options[state.highlightedIndex] === undefined) {
        return state;
      }

      return handleOptionSelection(options[state.highlightedIndex], state, props);

    default:
      break;
  }

  return state;
}

function handleBlur(state) {
  return _extends({}, state, {
    highlightedIndex: -1
  });
}

function handleOptionsChange(options, previousOptions, state, props) {
  var _options$find;

  const {
    multiple,
    optionComparer
  } = props;
  const highlightedOption = previousOptions[state.highlightedIndex];
  const hightlightedOptionNewIndex = options.findIndex(option => optionComparer(option, highlightedOption));

  if (multiple) {
    var _ref3;

    // exclude selected values that are no longer in the options
    const selectedValues = (_ref3 = state.selectedValue) != null ? _ref3 : [];
    const newSelectedValues = selectedValues.filter(selectedValue => options.some(option => optionComparer(option, selectedValue)));
    return {
      highlightedIndex: hightlightedOptionNewIndex,
      selectedValue: newSelectedValues
    };
  }

  const newSelectedValue = (_options$find = options.find(option => optionComparer(option, state.selectedValue))) != null ? _options$find : null;
  return {
    highlightedIndex: hightlightedOptionNewIndex,
    selectedValue: newSelectedValue
  };
}

export default function defaultListboxReducer(state, action) {
  const {
    type
  } = action;

  switch (type) {
    case ActionTypes.keyDown:
      return handleKeyDown(action.event, state, action.props);

    case ActionTypes.optionClick:
      return handleOptionSelection(action.option, state, action.props);

    case ActionTypes.blur:
      return handleBlur(state);

    case ActionTypes.setControlledValue:
      return _extends({}, state, {
        selectedValue: action.value
      });

    case ActionTypes.optionsChange:
      return handleOptionsChange(action.options, action.previousOptions, state, action.props);

    default:
      return state;
  }
}