import { FieldValues } from './fields';
import { Control } from './form';
import { FieldArrayPath, FieldArrayPathValue } from './utils';
export declare type FieldArrayName = string;
export declare type UseFieldArrayProps<TFieldValues extends FieldValues = FieldValues, TFieldArrayName extends FieldArrayPath<TFieldValues> = FieldArrayPath<TFieldValues>, TKeyName extends string = 'id'> = {
    name: TFieldArrayName;
    keyName?: TKeyName;
    control?: Control<TFieldValues>;
    shouldUnregister?: boolean;
};
export declare type FieldArrayWithId<TFieldValues extends FieldValues = FieldValues, TFieldArrayName extends FieldArrayPath<TFieldValues> = FieldArrayPath<TFieldValues>, TKeyName extends string = 'id'> = FieldArray<TFieldValues, TFieldArrayName> & Record<TKeyName, string>;
export declare type FieldArray<TFieldValues extends FieldValues = FieldValues, TFieldArrayName extends FieldArrayPath<TFieldValues> = FieldArrayPath<TFieldValues>> = FieldArrayPathValue<TFieldValues, TFieldArrayName> extends ReadonlyArray<infer U> | null | undefined ? U : never;
export declare type FieldArrayMethodProps = {
    shouldFocus?: boolean;
    focusIndex?: number;
    focusName?: string;
};
export declare type UseFieldArrayReturn<TFieldValues extends FieldValues = FieldValues, TFieldArrayName extends FieldArrayPath<TFieldValues> = FieldArrayPath<TFieldValues>, TKeyName extends string = 'id'> = {
    swap: (indexA: number, indexB: number) => void;
    move: (indexA: number, indexB: number) => void;
    prepend: (value: Partial<FieldArray<TFieldValues, TFieldArrayName>> | Partial<FieldArray<TFieldValues, TFieldArrayName>>[], options?: FieldArrayMethodProps) => void;
    append: (value: Partial<FieldArray<TFieldValues, TFieldArrayName>> | Partial<FieldArray<TFieldValues, TFieldArrayName>>[], options?: FieldArrayMethodProps) => void;
    remove: (index?: number | number[]) => void;
    insert: (index: number, value: Partial<FieldArray<TFieldValues, TFieldArrayName>> | Partial<FieldArray<TFieldValues, TFieldArrayName>>[], options?: FieldArrayMethodProps) => void;
    update: (index: number, value: Partial<FieldArray<TFieldValues, TFieldArrayName>>) => void;
    replace: (value: Partial<FieldArray<TFieldValues, TFieldArrayName>> | Partial<FieldArray<TFieldValues, TFieldArrayName>>[]) => void;
    fields: FieldArrayWithId<TFieldValues, TFieldArrayName, TKeyName>[];
};
