export interface BadgeUnstyledClasses {
    /** Class name applied to the root element. */
    root: string;
    /** Class name applied to the badge `span` element. */
    badge: string;
    /** Class name applied to the badge `span` element if `variant="dot"`. */
    dot: string;
    /** Class name applied to the badge `span` element if `variant="standard"`. */
    standard: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'top', 'right' }} overlap="rectangular"`. */
    anchorOriginTopRightRectangular: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'right' }} overlap="rectangular"`. */
    anchorOriginBottomRightRectangular: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'top', 'left' }} overlap="rectangular"`. */
    anchorOriginTopLeftRectangular: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'left' }} overlap="rectangular"`. */
    anchorOriginBottomLeftRectangular: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'top', 'right' }} overlap="circular"`. */
    anchorOriginTopRightCircular: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'right' }} overlap="circular"`. */
    anchorOriginBottomRightCircular: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'top', 'left' }} overlap="circular"`. */
    anchorOriginTopLeftCircular: string;
    /** Class name applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'left' }} overlap="circular"`. */
    anchorOriginBottomLeftCircular: string;
    /** State class applied to the badge `span` element if `invisible={true}`. */
    invisible: string;
}
export declare type BadgeUnstyledClassKey = keyof BadgeUnstyledClasses;
export declare function getBadgeUtilityClass(slot: string): string;
declare const badgeUnstyledClasses: BadgeUnstyledClasses;
export default badgeUnstyledClasses;
