import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import * as React from 'react';
import clsx from 'clsx';
import { useTheme, styled } from '@mui/material/styles';
import { unstable_composeClasses as composeClasses, generateUtilityClass, generateUtilityClasses } from '@mui/base';
import PickersToolbarText from '../internal/pickers/PickersToolbarText';
import PickersToolbarButton from '../internal/pickers/PickersToolbarButton';
import PickersToolbar from '../internal/pickers/PickersToolbar';
import { arrayIncludes } from '../internal/pickers/utils';
import { useUtils } from '../internal/pickers/hooks/useUtils';
import { useMeridiemMode } from '../internal/pickers/hooks/date-helpers-hooks';
import { jsx as _jsx } from "react/jsx-runtime";
import { jsxs as _jsxs } from "react/jsx-runtime";
export function getTimePickerToolbarUtilityClass(slot) {
  return generateUtilityClass('PrivateTimePickerToolbar', slot);
}
export var timePickerToolbarClasses = generateUtilityClasses('PrivateTimePickerToolbar', ['separator', 'hourMinuteLabel', 'hourMinuteLabelLandscape', 'hourMinuteLabelReverse', 'ampmSelection', 'ampmLandscape', 'ampmLabel', 'penIconLandscape']);

var useUtilityClasses = function useUtilityClasses(ownerState) {
  var theme = ownerState.theme,
      isLandscape = ownerState.isLandscape,
      classes = ownerState.classes;
  var slots = {
    penIconLandscape: ['penIconLandscape'],
    separator: ['separator'],
    hourMinuteLabel: ['hourMinuteLabel', isLandscape && 'hourMinuteLabelLandscape', theme.direction === 'rtl' && 'hourMinuteLabelReverse'],
    ampmSelection: ['ampmSelection', isLandscape && 'ampmLandscape'],
    ampmLabel: ['ampmLabel']
  };
  return composeClasses(slots, getTimePickerToolbarUtilityClass, classes);
};

var TimePickerToolbarRoot = styled(PickersToolbar, {
  skipSx: true
})(_defineProperty({}, "& .".concat(timePickerToolbarClasses.penIconLandscape), {
  marginTop: 'auto'
}));
var TimePickerToolbarSeparator = styled(PickersToolbarText, {
  skipSx: true
})({
  outline: 0,
  margin: '0 4px 0 2px',
  cursor: 'default'
});
var TimePickerToolbarHourMinuteLabel = styled('div', {
  skipSx: true
})(function (_ref) {
  var theme = _ref.theme,
      ownerState = _ref.ownerState;
  return _extends({
    display: 'flex',
    justifyContent: 'flex-end',
    alignItems: 'flex-end'
  }, ownerState.isLandscape && {
    marginTop: 'auto'
  }, theme.direction === 'rtl' && {
    flexDirection: 'row-reverse'
  });
});
var TimePickerToolbarAmPmSelection = styled('div', {
  skipSx: true
})(function (_ref2) {
  var ownerState = _ref2.ownerState;
  return _extends({
    display: 'flex',
    flexDirection: 'column',
    marginRight: 'auto',
    marginLeft: 12
  }, ownerState.isLandscape && {
    margin: '4px 0 auto',
    flexDirection: 'row',
    justifyContent: 'space-around',
    flexBasis: '100%'
  }, _defineProperty({}, "& .".concat(timePickerToolbarClasses.ampmLabel), {
    fontSize: 17
  }));
});
/**
 * @ignore - internal component.
 */

var TimePickerToolbar = function TimePickerToolbar(props) {
  var ampm = props.ampm,
      ampmInClock = props.ampmInClock,
      date = props.date,
      isLandscape = props.isLandscape,
      isMobileKeyboardViewOpen = props.isMobileKeyboardViewOpen,
      onChange = props.onChange,
      openView = props.openView,
      setOpenView = props.setOpenView,
      toggleMobileKeyboardView = props.toggleMobileKeyboardView,
      _props$toolbarTitle = props.toolbarTitle,
      toolbarTitle = _props$toolbarTitle === void 0 ? 'Select time' : _props$toolbarTitle,
      views = props.views,
      other = _objectWithoutProperties(props, ["ampm", "ampmInClock", "date", "isLandscape", "isMobileKeyboardViewOpen", "onChange", "openView", "setOpenView", "toggleMobileKeyboardView", "toolbarTitle", "views"]);

  var utils = useUtils();
  var theme = useTheme();
  var showAmPmControl = Boolean(ampm && !ampmInClock);

  var _useMeridiemMode = useMeridiemMode(date, ampm, onChange),
      meridiemMode = _useMeridiemMode.meridiemMode,
      handleMeridiemChange = _useMeridiemMode.handleMeridiemChange;

  var formatHours = function formatHours(time) {
    return ampm ? utils.format(time, 'hours12h') : utils.format(time, 'hours24h');
  };

  var ownerState = props;
  var classes = useUtilityClasses(_extends({}, ownerState, {
    theme: theme
  }));

  var separator = /*#__PURE__*/_jsx(TimePickerToolbarSeparator, {
    tabIndex: -1,
    value: ":",
    variant: "h3",
    selected: false,
    className: classes.separator
  });

  return /*#__PURE__*/_jsxs(TimePickerToolbarRoot, _extends({
    viewType: "clock",
    landscapeDirection: "row",
    toolbarTitle: toolbarTitle,
    isLandscape: isLandscape,
    isMobileKeyboardViewOpen: isMobileKeyboardViewOpen,
    toggleMobileKeyboardView: toggleMobileKeyboardView,
    ownerState: ownerState,
    penIconClassName: clsx(isLandscape && classes.penIconLandscape)
  }, other, {
    children: [/*#__PURE__*/_jsxs(TimePickerToolbarHourMinuteLabel, {
      className: classes.hourMinuteLabel,
      ownerState: ownerState,
      children: [arrayIncludes(views, 'hours') && /*#__PURE__*/_jsx(PickersToolbarButton, {
        tabIndex: -1,
        variant: "h3",
        onClick: function onClick() {
          return setOpenView('hours');
        },
        selected: openView === 'hours',
        value: date ? formatHours(date) : '--'
      }), arrayIncludes(views, ['hours', 'minutes']) && separator, arrayIncludes(views, 'minutes') && /*#__PURE__*/_jsx(PickersToolbarButton, {
        tabIndex: -1,
        variant: "h3",
        onClick: function onClick() {
          return setOpenView('minutes');
        },
        selected: openView === 'minutes',
        value: date ? utils.format(date, 'minutes') : '--'
      }), arrayIncludes(views, ['minutes', 'seconds']) && separator, arrayIncludes(views, 'seconds') && /*#__PURE__*/_jsx(PickersToolbarButton, {
        variant: "h3",
        onClick: function onClick() {
          return setOpenView('seconds');
        },
        selected: openView === 'seconds',
        value: date ? utils.format(date, 'seconds') : '--'
      })]
    }), showAmPmControl && /*#__PURE__*/_jsxs(TimePickerToolbarAmPmSelection, {
      className: classes.ampmSelection,
      ownerState: ownerState,
      children: [/*#__PURE__*/_jsx(PickersToolbarButton, {
        disableRipple: true,
        variant: "subtitle2",
        selected: meridiemMode === 'am',
        typographyClassName: classes.ampmLabel,
        value: utils.getMeridiemText('am'),
        onClick: function onClick() {
          return handleMeridiemChange('am');
        }
      }), /*#__PURE__*/_jsx(PickersToolbarButton, {
        disableRipple: true,
        variant: "subtitle2",
        selected: meridiemMode === 'pm',
        typographyClassName: classes.ampmLabel,
        value: utils.getMeridiemText('pm'),
        onClick: function onClick() {
          return handleMeridiemChange('pm');
        }
      })]
    })]
  }));
};

export default TimePickerToolbar;