"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _styles = require("@mui/material/styles");

var _shared = require("./shared");

var _jsxRuntime = require("react/jsx-runtime");

const _excluded = ["className", "hasSelected", "isInner", "type", "value"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const ClockPointerRoot = (0, _styles.styled)('div', {
  skipSx: true
})(({
  theme,
  ownerState
}) => (0, _extends2.default)({
  width: 2,
  backgroundColor: theme.palette.primary.main,
  position: 'absolute',
  left: 'calc(50% - 1px)',
  bottom: '50%',
  transformOrigin: 'center bottom 0px'
}, ownerState.toAnimateTransform && {
  transition: theme.transitions.create(['transform', 'height'])
}));
const ClockPointerThumb = (0, _styles.styled)('div', {
  skipSx: true
})(({
  theme,
  ownerState
}) => (0, _extends2.default)({
  width: 4,
  height: 4,
  backgroundColor: theme.palette.primary.contrastText,
  borderRadius: '50%',
  position: 'absolute',
  top: -21,
  left: `calc(50% - ${_shared.CLOCK_HOUR_WIDTH / 2}px)`,
  border: `${(_shared.CLOCK_HOUR_WIDTH - 4) / 2}px solid ${theme.palette.primary.main}`,
  boxSizing: 'content-box'
}, ownerState.hasSelected && {
  backgroundColor: theme.palette.primary.main
}));
/**
 * @ignore - internal component.
 */

class ClockPointer extends React.Component {
  constructor(...args) {
    super(...args);
    this.state = {
      toAnimateTransform: false,
      previousType: undefined
    };
  }

  render() {
    const _this$props = this.props,
          {
      className,
      isInner,
      type,
      value
    } = _this$props,
          other = (0, _objectWithoutPropertiesLoose2.default)(_this$props, _excluded);
    const ownerState = (0, _extends2.default)({}, this.props, this.state);

    const getAngleStyle = () => {
      const max = type === 'hours' ? 12 : 60;
      let angle = 360 / max * value;

      if (type === 'hours' && value > 12) {
        angle -= 360; // round up angle to max 360 degrees
      }

      return {
        height: Math.round((isInner ? 0.26 : 0.4) * _shared.CLOCK_WIDTH),
        transform: `rotateZ(${angle}deg)`
      };
    };

    return /*#__PURE__*/(0, _jsxRuntime.jsx)(ClockPointerRoot, (0, _extends2.default)({
      style: getAngleStyle(),
      className: className,
      ownerState: ownerState
    }, other, {
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(ClockPointerThumb, {
        ownerState: ownerState
      })
    }));
  }

}

ClockPointer.getDerivedStateFromProps = (nextProps, state) => {
  if (nextProps.type !== state.previousType) {
    return {
      toAnimateTransform: true,
      previousType: nextProps.type
    };
  }

  return {
    toAnimateTransform: false,
    previousType: nextProps.type
  };
};

var _default = ClockPointer;
exports.default = _default;