/// <reference types="react" />
import { SelectOption } from './useSelectProps';
import PopperUnstyled from '../PopperUnstyled';
export interface SelectUnstyledComponentsPropsOverrides {
}
export interface SelectUnstyledCommonProps {
    /**
     * If `true`, the select element is focused during the first mount
     * @default false
     */
    autoFocus?: boolean;
    children?: React.ReactNode;
    className?: string;
    component?: React.ElementType;
    /**
     * The components used for each slot inside the Select.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components?: {
        Root?: React.ElementType;
        Listbox?: React.ElementType;
        Popper?: React.ElementType;
    };
    /**
     * The props used for each slot inside the Input.
     * @default {}
     */
    componentsProps?: {
        root?: React.ComponentPropsWithRef<'button'> & SelectUnstyledComponentsPropsOverrides;
        listbox?: React.ComponentPropsWithRef<'ul'> & SelectUnstyledComponentsPropsOverrides;
        popper?: Partial<React.ComponentPropsWithRef<typeof PopperUnstyled>> & SelectUnstyledComponentsPropsOverrides;
    };
    /**
     * If `true`, the select is disabled.
     * @default false
     */
    disabled?: boolean;
    /**
     * If `true`, the select will be initially open.
     * @default false
     */
    defaultListboxOpen?: boolean;
    /**
     * Controls the open state of the select's listbox.
     * @default undefined
     */
    listboxOpen?: boolean;
    /**
     * Callback fired when the component requests to be opened.
     * Use in controlled mode (see listboxOpen).
     */
    onListboxOpenChange?: (isOpen: boolean) => void;
}
export interface SelectUnstyledProps<TValue extends {}> extends SelectUnstyledCommonProps {
    /**
     * The default selected value. Use when the component is not controlled.
     */
    defaultValue?: TValue | null;
    /**
     * Callback fired when an option is selected.
     */
    onChange?: (value: TValue | null) => void;
    /**
     * Function that customizes the rendering of the selected value.
     */
    renderValue?: (option: SelectOption<TValue> | null) => React.ReactNode;
    /**
     * The selected value.
     * Set to `null` to deselect all options.
     */
    value?: TValue | null;
}
export interface SelectUnstyledOwnerState<TValue> extends SelectUnstyledProps<TValue> {
    active: boolean;
    disabled: boolean;
    open: boolean;
    focusVisible: boolean;
}
