import type { BuildConfiguration } from "./config-types.d";
import type { RuntimeDistribution } from "./runtimeDistribution.js";
export declare class ArgumentBuilder {
    private config;
    private rtd;
    constructor(config: BuildConfiguration, rtd: RuntimeDistribution);
    configureCommand(): Promise<[string, string[]]>;
    buildCommand(stagingDir: string): [string, string[]];
    buildDefines(): Promise<[string, string][]>;
}
/**
 * Get the architecture for cmake
 * @param arch - The architecture of the target
 * @param os - The operating system of the target
 * @returns The architecture for cmake
 *
 * @note Based on https://stackoverflow.com/a/70498851/7910299
 */
export declare function getCMakeArchitecture(arch: NodeJS.Architecture, os: NodeJS.Platform): string;
