import type { ExtractOptions as TarExtractOptions } from "tar";
export type HashType = "sha256" | "sha512" | "sha1" | "md5" | "sha384" | "sha224";
export type DownloadCoreOptions = {
    hashType?: HashType;
    hashSum?: string;
    timeout?: number;
};
export type DownloadOptions = DownloadCoreOptions & {
    path?: string;
};
export type DownloadFileOptions = DownloadCoreOptions & {
    path: string;
};
export type DownloadTgzOptions = DownloadOptions & {
    removeAfterExtract?: boolean;
    extractOptions?: TarExtractOptions;
};
/** Calculates the hash of a file */
export declare function calculateHash(filePath: string, hashType: HashType): Promise<string>;
/** Downloads content from a URL and returns it as a string */
export declare function downloadToString(url: string, options?: DownloadCoreOptions): Promise<string>;
/** Downloads a file from a URL to a specified path */
export declare function downloadFile(url: string, options: DownloadFileOptions): Promise<string | undefined>;
/** Downloads and extracts a .tgz file */
export declare function downloadTgz(url: string, options: DownloadTgzOptions): Promise<string | undefined>;
