/**
 * Retries an async function a specified number of times with a delay between attempts.
 * @param fn - The function to retry.
 * @param retries - The number of times to retry the function.
 * @param delay - The delay in milliseconds between attempts.
 * @returns The result of the function.
 */
export declare function retry<T>(fn: () => Promise<T>, retries?: number, delay?: number): Promise<T>;
/**
 * Sleeps for a specified number of milliseconds.
 * @param ms - The number of milliseconds to sleep.
 * @returns A promise that resolves after the specified number of milliseconds.
 */
export declare function sleep(ms: number): Promise<unknown>;
