import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["maxScrollSize"];
/*:: import type {Alignment, CellSizeGetter, VisibleCellRange} from '../types';*/
import CellSizeAndPositionManager from './CellSizeAndPositionManager';
import { getMaxElementSize } from './maxElementSize.js';
/*:: type ContainerSizeAndOffset = {
  containerSize: number,
  offset: number,
};*/
/*:: type Params = {
  maxScrollSize?: number,
  cellCount: number,
  cellSizeGetter: CellSizeGetter,
  estimatedCellSize: number,
};*/
/**
 * Browsers have scroll offset limitations (eg Chrome stops scrolling at ~33.5M pixels where as Edge tops out at ~1.5M pixels).
 * After a certain position, the browser won't allow the user to scroll further (even via JavaScript scroll offset adjustments).
 * This util picks a lower ceiling for max size and artificially adjusts positions within to make it transparent for users.
 */
/**
 * Extends CellSizeAndPositionManager and adds scaling behavior for lists that are too large to fit within a browser's native limits.
 */
var ScalingCellSizeAndPositionManager = /*#__PURE__*/function () {
  function ScalingCellSizeAndPositionManager(_ref /*:: */) {
    var _ref$maxScrollSize = _ref /*:: */.maxScrollSize,
      maxScrollSize = _ref$maxScrollSize === void 0 ? getMaxElementSize() : _ref$maxScrollSize,
      params = _objectWithoutProperties(_ref /*:: */, _excluded);
    _classCallCheck(this, ScalingCellSizeAndPositionManager);
    _defineProperty(this, "_cellSizeAndPositionManager", void 0);
    _defineProperty(this, "_maxScrollSize", void 0);
    // Favor composition over inheritance to simplify IE10 support
    this._cellSizeAndPositionManager = new CellSizeAndPositionManager(params);
    this._maxScrollSize = maxScrollSize;
  }
  return _createClass(ScalingCellSizeAndPositionManager, [{
    key: "areOffsetsAdjusted",
    value: function areOffsetsAdjusted() /*: boolean*/{
      return this._cellSizeAndPositionManager.getTotalSize() > this._maxScrollSize;
    }
  }, {
    key: "configure",
    value: function configure(params
    /*: {
        cellCount: number,
        estimatedCellSize: number,
        cellSizeGetter: CellSizeGetter,
      }*/
    ) {
      this._cellSizeAndPositionManager.configure(params);
    }
  }, {
    key: "getCellCount",
    value: function getCellCount() /*: number*/{
      return this._cellSizeAndPositionManager.getCellCount();
    }
  }, {
    key: "getEstimatedCellSize",
    value: function getEstimatedCellSize() /*: number*/{
      return this._cellSizeAndPositionManager.getEstimatedCellSize();
    }
  }, {
    key: "getLastMeasuredIndex",
    value: function getLastMeasuredIndex() /*: number*/{
      return this._cellSizeAndPositionManager.getLastMeasuredIndex();
    }

    /**
     * Number of pixels a cell at the given position (offset) should be shifted in order to fit within the scaled container.
     * The offset passed to this function is scaled (safe) as well.
     */
  }, {
    key: "getOffsetAdjustment",
    value: function getOffsetAdjustment(_ref2 /*:: */) /*: number*/{
      var containerSize = _ref2 /*:: */.containerSize,
        offset = _ref2 /*:: */.offset;
      var totalSize = this._cellSizeAndPositionManager.getTotalSize();
      var safeTotalSize = this.getTotalSize();
      var offsetPercentage = this._getOffsetPercentage({
        containerSize: containerSize,
        offset: offset,
        totalSize: safeTotalSize
      });
      return Math.round(offsetPercentage * (safeTotalSize - totalSize));
    }
  }, {
    key: "getSizeAndPositionOfCell",
    value: function getSizeAndPositionOfCell(index /*: number*/) {
      return this._cellSizeAndPositionManager.getSizeAndPositionOfCell(index);
    }
  }, {
    key: "getSizeAndPositionOfLastMeasuredCell",
    value: function getSizeAndPositionOfLastMeasuredCell() {
      return this._cellSizeAndPositionManager.getSizeAndPositionOfLastMeasuredCell();
    }

    /** See CellSizeAndPositionManager#getTotalSize */
  }, {
    key: "getTotalSize",
    value: function getTotalSize() /*: number*/{
      return Math.min(this._maxScrollSize, this._cellSizeAndPositionManager.getTotalSize());
    }

    /** See CellSizeAndPositionManager#getUpdatedOffsetForIndex */
  }, {
    key: "getUpdatedOffsetForIndex",
    value: function getUpdatedOffsetForIndex(_ref3 /*:: */) {
      var _ref3$align = _ref3 /*:: */.align,
        align = _ref3$align === void 0 ? 'auto' : _ref3$align,
        containerSize = _ref3 /*:: */.containerSize,
        currentOffset = _ref3 /*:: */.currentOffset,
        targetIndex = _ref3 /*:: */.targetIndex;
      currentOffset = this._safeOffsetToOffset({
        containerSize: containerSize,
        offset: currentOffset
      });
      var offset = this._cellSizeAndPositionManager.getUpdatedOffsetForIndex({
        align: align,
        containerSize: containerSize,
        currentOffset: currentOffset,
        targetIndex: targetIndex
      });
      return this._offsetToSafeOffset({
        containerSize: containerSize,
        offset: offset
      });
    }

    /** See CellSizeAndPositionManager#getVisibleCellRange */
  }, {
    key: "getVisibleCellRange",
    value: function getVisibleCellRange(_ref4 /*:: */) /*: VisibleCellRange*/{
      var containerSize = _ref4 /*:: */.containerSize,
        offset = _ref4 /*:: */.offset;
      offset = this._safeOffsetToOffset({
        containerSize: containerSize,
        offset: offset
      });
      return this._cellSizeAndPositionManager.getVisibleCellRange({
        containerSize: containerSize,
        offset: offset
      });
    }
  }, {
    key: "resetCell",
    value: function resetCell(index /*: number*/) /*: void*/{
      this._cellSizeAndPositionManager.resetCell(index);
    }
  }, {
    key: "_getOffsetPercentage",
    value: function _getOffsetPercentage(_ref5 /*:: */) {
      var containerSize = _ref5 /*:: */.containerSize,
        offset = _ref5 /*:: */.offset,
        totalSize = _ref5 /*:: */.totalSize;
      return totalSize <= containerSize ? 0 : offset / (totalSize - containerSize);
    }
  }, {
    key: "_offsetToSafeOffset",
    value: function _offsetToSafeOffset(_ref6 /*:: */) /*: number*/{
      var containerSize = _ref6 /*:: */.containerSize,
        offset = _ref6 /*:: */.offset;
      var totalSize = this._cellSizeAndPositionManager.getTotalSize();
      var safeTotalSize = this.getTotalSize();
      if (totalSize === safeTotalSize) {
        return offset;
      } else {
        var offsetPercentage = this._getOffsetPercentage({
          containerSize: containerSize,
          offset: offset,
          totalSize: totalSize
        });
        return Math.round(offsetPercentage * (safeTotalSize - containerSize));
      }
    }
  }, {
    key: "_safeOffsetToOffset",
    value: function _safeOffsetToOffset(_ref7 /*:: */) /*: number*/{
      var containerSize = _ref7 /*:: */.containerSize,
        offset = _ref7 /*:: */.offset;
      var totalSize = this._cellSizeAndPositionManager.getTotalSize();
      var safeTotalSize = this.getTotalSize();
      if (totalSize === safeTotalSize) {
        return offset;
      } else {
        var offsetPercentage = this._getOffsetPercentage({
          containerSize: containerSize,
          offset: offset,
          totalSize: safeTotalSize
        });
        return Math.round(offsetPercentage * (totalSize - containerSize));
      }
    }
  }]);
}();
export { ScalingCellSizeAndPositionManager as default };