"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Symbols = void 0;
var _upperFirst2 = _interopRequireDefault(require("lodash/upperFirst"));
var _react = _interopRequireDefault(require("react"));
var _d3Shape = require("victory-vendor/d3-shape");
var _classnames = _interopRequireDefault(require("classnames"));
var _ReactUtils = require("../util/ReactUtils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); } /**
                                                                                                                                                                                                                                                                                                                                                     * @fileOverview Curve
                                                                                                                                                                                                                                                                                                                                                     */
var symbolFactories = {
  symbolCircle: _d3Shape.symbolCircle,
  symbolCross: _d3Shape.symbolCross,
  symbolDiamond: _d3Shape.symbolDiamond,
  symbolSquare: _d3Shape.symbolSquare,
  symbolStar: _d3Shape.symbolStar,
  symbolTriangle: _d3Shape.symbolTriangle,
  symbolWye: _d3Shape.symbolWye
};
var RADIAN = Math.PI / 180;
var getSymbolFactory = function getSymbolFactory(type) {
  var name = "symbol".concat((0, _upperFirst2["default"])(type));
  return symbolFactories[name] || _d3Shape.symbolCircle;
};
var calculateAreaSize = function calculateAreaSize(size, sizeType, type) {
  if (sizeType === 'area') {
    return size;
  }
  switch (type) {
    case 'cross':
      return 5 * size * size / 9;
    case 'diamond':
      return 0.5 * size * size / Math.sqrt(3);
    case 'square':
      return size * size;
    case 'star':
      {
        var angle = 18 * RADIAN;
        return 1.25 * size * size * (Math.tan(angle) - Math.tan(angle * 2) * Math.pow(Math.tan(angle), 2));
      }
    case 'triangle':
      return Math.sqrt(3) * size * size / 4;
    case 'wye':
      return (21 - 10 * Math.sqrt(3)) * size * size / 8;
    default:
      return Math.PI * size * size / 4;
  }
};
var symbolsDefaultProps = {
  type: 'circle',
  size: 64,
  sizeType: 'area'
};
var registerSymbol = function registerSymbol(key, factory) {
  symbolFactories["symbol".concat((0, _upperFirst2["default"])(key))] = factory;
};
var Symbols = function Symbols(props) {
  /**
   * Calculate the path of curve
   * @return {String} path
   */
  var getPath = function getPath() {
    var size = props.size,
      sizeType = props.sizeType,
      type = props.type;
    var symbolFactory = getSymbolFactory(type);
    var symbol = (0, _d3Shape.symbol)().type(symbolFactory).size(calculateAreaSize(size, sizeType, type));
    return symbol();
  };
  var className = props.className,
    cx = props.cx,
    cy = props.cy,
    size = props.size;
  var filteredProps = (0, _ReactUtils.filterProps)(props, true);
  if (cx === +cx && cy === +cy && size === +size) {
    return /*#__PURE__*/_react["default"].createElement("path", _extends({}, filteredProps, {
      className: (0, _classnames["default"])('recharts-symbols', className),
      transform: "translate(".concat(cx, ", ").concat(cy, ")"),
      d: getPath()
    }));
  }
  return null;
};
exports.Symbols = Symbols;
Symbols.defaultProps = symbolsDefaultProps;
Symbols.registerSymbol = registerSymbol;