import React from 'react';
import { OverrideProps } from '@mui/types';
import { FormControlUnstyledState } from '../FormControlUnstyled/FormControlContext';
export interface InputOwnerState extends Omit<InputUnstyledProps, 'component' | 'components' | 'componentsProps'> {
    formControl: FormControlUnstyledState;
    focused: boolean;
}
export interface UseInputProps {
    /**
     * The default value. Use when the component is not controlled.
     */
    defaultValue?: unknown;
    /**
     * If `true`, the component is disabled.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    disabled?: boolean;
    /**
     * If `true`, the `input` will indicate an error.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    error?: boolean;
    onBlur?: React.FocusEventHandler;
    onClick?: React.MouseEventHandler;
    onChange?: React.ChangeEventHandler<HTMLInputElement>;
    onFocus?: React.FocusEventHandler;
    /**
     * If `true`, the `input` element is required.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    required?: boolean;
    value?: unknown;
}
export interface InputUnstyledOwnProps extends UseInputProps {
    'aria-describedby'?: string;
    'aria-label'?: string;
    'aria-labelledby'?: string;
    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete?: string;
    /**
     * If `true`, the `input` element is focused during the first mount.
     */
    autoFocus?: boolean;
    /**
     * Class name applied to the root element.
     */
    className?: string;
    /**
     * The components used for each slot inside the InputBase.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components?: {
        Root?: React.ElementType;
        Input?: React.ElementType;
        Textarea?: React.ElementType;
    };
    /**
     * The props used for each slot inside the Input.
     * @default {}
     */
    componentsProps?: {
        root?: React.ComponentPropsWithRef<'div'> & {
            ownerState: InputOwnerState;
        };
        input?: React.ComponentPropsWithRef<'input'> & {
            ownerState: InputOwnerState;
        };
    };
    /**
     * Trailing adornment for this input.
     */
    endAdornment?: React.ReactNode;
    /**
     * The id of the `input` element.
     */
    id?: string;
    /**
     * If `true`, a `textarea` element is rendered.
     * @default false
     */
    multiline?: boolean;
    /**
     * Name attribute of the `input` element.
     */
    name?: string;
    onKeyDown?: React.KeyboardEventHandler<HTMLInputElement>;
    onKeyUp?: React.KeyboardEventHandler<HTMLInputElement>;
    /**
     * The short hint displayed in the `input` before the user enters a value.
     */
    placeholder?: string;
    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly?: boolean;
    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows?: number;
    /**
     * Leading adornment for this input.
     */
    startAdornment?: React.ReactNode;
    /**
     * Minimum number of rows to display when multiline option is set to true.
     */
    minRows?: number;
    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    maxRows?: number;
    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     * @default 'text'
     */
    type?: string;
    /**
     * The value of the `input` element, required for a controlled component.
     */
    value?: unknown;
}
export interface InputUnstyledTypeMap<P = {}, D extends React.ElementType = 'div'> {
    props: P & InputUnstyledOwnProps;
    defaultComponent: D;
}
declare type InputUnstyledProps<D extends React.ElementType = InputUnstyledTypeMap['defaultComponent'], P = {}> = OverrideProps<InputUnstyledTypeMap<P, D>, D> & {
    /**
     * The component used for the Root slot.
     * Either a string to use a HTML element or a component.
     * This is equivalent to `components.Root`. If both are provided, the `component` is used.
     */
    component?: D;
};
export default InputUnstyledProps;
