import { type PathLike, type StatOptions, type Stats, type StatsBase } from "fs-extra";
export declare function getEnvVar(name: string): string | undefined;
/**
 * Capture the output of a command
 * @note this ignores the running errors
 */
export declare function execCapture(command: string): Promise<string>;
export declare function runProgram(program: string, args: string[], cwd?: string, silent?: boolean): Promise<void>;
type FunctionalStats = Pick<StatsBase<never>, "isFile" | "isDirectory" | "isBlockDevice" | "isCharacterDevice" | "isSymbolicLink" | "isFIFO" | "isSocket">;
/** Exception safe version of stat */
export declare function stat(path: PathLike, options?: StatOptions & {
    bigint: false;
}): Promise<Stats | FunctionalStats>;
export {};
