import type { PathLike, StatOptions, Stats, StatsBase } from "fs";
/** Exception safe version of stat */
export declare function stat(path: PathLike, options?: StatOptions & {
    bigint: false;
}): Promise<Stats | FunctionalStats>;
export type FunctionalStats = Pick<StatsBase<never>, "isFile" | "isDirectory" | "isBlockDevice" | "isCharacterDevice" | "isSymbolicLink" | "isFIFO" | "isSocket">;
export declare class NoStats implements FunctionalStats {
    isFile: () => boolean;
    isDirectory: () => boolean;
    isBlockDevice: () => boolean;
    isCharacterDevice: () => boolean;
    isSymbolicLink: () => boolean;
    isFIFO: () => boolean;
    isSocket: () => boolean;
}
