/* ------------------------------------------------------------------------- *
 * Copyright 2002-2025, OpenNebula Project, OpenNebula Systems               *
 *                                                                           *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may   *
 * not use this file except in compliance with the License. You may obtain   *
 * a copy of the License at                                                  *
 *                                                                           *
 * http://www.apache.org/licenses/LICENSE-2.0                                *
 *                                                                           *
 * Unless required by applicable law or agreed to in writing, software       *
 * distributed under the License is distributed on an "AS IS" BASIS,         *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
 * See the License for the specific language governing permissions and       *
 * limitations under the License.                                            *
 * ------------------------------------------------------------------------- */

const { Actions, Commands } = require('server/routes/api/sunstone/routes')
const {
  getConfig,
  getViews,
  getAvailableViews,
} = require('server/routes/api/sunstone/functions')

const { SUNSTONE_VIEWS, SUNSTONE_CONFIG, SUNSTONE_AVAILABLE_VIEWS } = Actions

module.exports = [
  {
    ...Commands[SUNSTONE_VIEWS],
    action: getViews,
  },
  {
    ...Commands[SUNSTONE_CONFIG],
    action: getConfig,
  },
  {
    ...Commands[SUNSTONE_AVAILABLE_VIEWS],
    action: getAvailableViews,
  },
]
