# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

module Aws::EC2
  module Types

    # The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon
    # Web Services Inferentia chips) on an instance.
    #
    # @!attribute [rw] min
    #   The minimum number of accelerators. If this parameter is not
    #   specified, there is no minimum limit.
    #   @return [Integer]
    #
    # @!attribute [rw] max
    #   The maximum number of accelerators. If this parameter is not
    #   specified, there is no maximum limit.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceleratorCount AWS API Documentation
    #
    class AcceleratorCount < Struct.new(
      :min,
      :max)
      SENSITIVE = []
      include Aws::Structure
    end

    # The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon
    # Web Services Inferentia chips) on an instance. To exclude
    # accelerator-enabled instance types, set `Max` to `0`.
    #
    # @!attribute [rw] min
    #   The minimum number of accelerators. To specify no minimum limit,
    #   omit this parameter.
    #   @return [Integer]
    #
    # @!attribute [rw] max
    #   The maximum number of accelerators. To specify no maximum limit,
    #   omit this parameter. To exclude accelerator-enabled instance types,
    #   set `Max` to `0`.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceleratorCountRequest AWS API Documentation
    #
    class AcceleratorCountRequest < Struct.new(
      :min,
      :max)
      SENSITIVE = []
      include Aws::Structure
    end

    # The minimum and maximum amount of total accelerator memory, in MiB.
    #
    # @!attribute [rw] min
    #   The minimum amount of accelerator memory, in MiB. If this parameter
    #   is not specified, there is no minimum limit.
    #   @return [Integer]
    #
    # @!attribute [rw] max
    #   The maximum amount of accelerator memory, in MiB. If this parameter
    #   is not specified, there is no maximum limit.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceleratorTotalMemoryMiB AWS API Documentation
    #
    class AcceleratorTotalMemoryMiB < Struct.new(
      :min,
      :max)
      SENSITIVE = []
      include Aws::Structure
    end

    # The minimum and maximum amount of total accelerator memory, in MiB.
    #
    # @!attribute [rw] min
    #   The minimum amount of accelerator memory, in MiB. To specify no
    #   minimum limit, omit this parameter.
    #   @return [Integer]
    #
    # @!attribute [rw] max
    #   The maximum amount of accelerator memory, in MiB. To specify no
    #   maximum limit, omit this parameter.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceleratorTotalMemoryMiBRequest AWS API Documentation
    #
    class AcceleratorTotalMemoryMiBRequest < Struct.new(
      :min,
      :max)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] address
    #   The Elastic IP address you are accepting for transfer.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
    #   the resource. Use the tag key in the filter name and the tag value
    #   as the filter value. For example, to find all resources that have a
    #   tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #   for the filter name and `TeamA` for the filter value.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransferRequest AWS API Documentation
    #
    class AcceptAddressTransferRequest < Struct.new(
      :address,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] address_transfer
    #   An Elastic IP address transfer.
    #   @return [Types::AddressTransfer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransferResult AWS API Documentation
    #
    class AcceptAddressTransferResult < Struct.new(
      :address_transfer)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation for which to accept the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptCapacityReservationBillingOwnershipRequest AWS API Documentation
    #
    class AcceptCapacityReservationBillingOwnershipRequest < Struct.new(
      :dry_run,
      :capacity_reservation_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptCapacityReservationBillingOwnershipResult AWS API Documentation
    #
    class AcceptCapacityReservationBillingOwnershipResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for accepting the quote.
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] reserved_instance_ids
    #   The IDs of the Convertible Reserved Instances to exchange for
    #   another Convertible Reserved Instance of the same or higher value.
    #   @return [Array<String>]
    #
    # @!attribute [rw] target_configurations
    #   The configuration of the target Convertible Reserved Instance to
    #   exchange for your current Convertible Reserved Instances.
    #   @return [Array<Types::TargetConfigurationRequest>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuoteRequest AWS API Documentation
    #
    class AcceptReservedInstancesExchangeQuoteRequest < Struct.new(
      :dry_run,
      :reserved_instance_ids,
      :target_configurations)
      SENSITIVE = []
      include Aws::Structure
    end

    # The result of the exchange and whether it was `successful`.
    #
    # @!attribute [rw] exchange_id
    #   The ID of the successful exchange.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuoteResult AWS API Documentation
    #
    class AcceptReservedInstancesExchangeQuoteResult < Struct.new(
      :exchange_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets to associate with the transit gateway
    #   multicast domain.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociationsRequest AWS API Documentation
    #
    class AcceptTransitGatewayMulticastDomainAssociationsRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :transit_gateway_attachment_id,
      :subnet_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] associations
    #   Information about the multicast domain associations.
    #   @return [Types::TransitGatewayMulticastDomainAssociations]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociationsResult AWS API Documentation
    #
    class AcceptTransitGatewayMulticastDomainAssociationsResult < Struct.new(
      :associations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachmentRequest AWS API Documentation
    #
    class AcceptTransitGatewayPeeringAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_peering_attachment
    #   The transit gateway peering attachment.
    #   @return [Types::TransitGatewayPeeringAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachmentResult AWS API Documentation
    #
    class AcceptTransitGatewayPeeringAttachmentResult < Struct.new(
      :transit_gateway_peering_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachmentRequest AWS API Documentation
    #
    class AcceptTransitGatewayVpcAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_vpc_attachment
    #   The VPC attachment.
    #   @return [Types::TransitGatewayVpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachmentResult AWS API Documentation
    #
    class AcceptTransitGatewayVpcAttachmentResult < Struct.new(
      :transit_gateway_vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_id
    #   The ID of the VPC endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] vpc_endpoint_ids
    #   The IDs of the interface VPC endpoints.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnectionsRequest AWS API Documentation
    #
    class AcceptVpcEndpointConnectionsRequest < Struct.new(
      :dry_run,
      :service_id,
      :vpc_endpoint_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the interface endpoints that were not accepted, if
    #   applicable.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnectionsResult AWS API Documentation
    #
    class AcceptVpcEndpointConnectionsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of the VPC peering connection. You must specify this
    #   parameter in the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnectionRequest AWS API Documentation
    #
    class AcceptVpcPeeringConnectionRequest < Struct.new(
      :dry_run,
      :vpc_peering_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_peering_connection
    #   Information about the VPC peering connection.
    #   @return [Types::VpcPeeringConnection]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnectionResult AWS API Documentation
    #
    class AcceptVpcPeeringConnectionResult < Struct.new(
      :vpc_peering_connection)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a finding for a Network Access Scope.
    #
    # @!attribute [rw] network_insights_access_scope_analysis_id
    #   The ID of the Network Access Scope analysis.
    #   @return [String]
    #
    # @!attribute [rw] network_insights_access_scope_id
    #   The ID of the Network Access Scope.
    #   @return [String]
    #
    # @!attribute [rw] finding_id
    #   The ID of the finding.
    #   @return [String]
    #
    # @!attribute [rw] finding_components
    #   The finding components.
    #   @return [Array<Types::PathComponent>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccessScopeAnalysisFinding AWS API Documentation
    #
    class AccessScopeAnalysisFinding < Struct.new(
      :network_insights_access_scope_analysis_id,
      :network_insights_access_scope_id,
      :finding_id,
      :finding_components)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a path.
    #
    # @!attribute [rw] source
    #   The source.
    #   @return [Types::PathStatement]
    #
    # @!attribute [rw] destination
    #   The destination.
    #   @return [Types::PathStatement]
    #
    # @!attribute [rw] through_resources
    #   The through resources.
    #   @return [Array<Types::ThroughResourcesStatement>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccessScopePath AWS API Documentation
    #
    class AccessScopePath < Struct.new(
      :source,
      :destination,
      :through_resources)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a path.
    #
    # @!attribute [rw] source
    #   The source.
    #   @return [Types::PathStatementRequest]
    #
    # @!attribute [rw] destination
    #   The destination.
    #   @return [Types::PathStatementRequest]
    #
    # @!attribute [rw] through_resources
    #   The through resources.
    #   @return [Array<Types::ThroughResourcesStatementRequest>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccessScopePathRequest AWS API Documentation
    #
    class AccessScopePathRequest < Struct.new(
      :source,
      :destination,
      :through_resources)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an account attribute.
    #
    # @!attribute [rw] attribute_name
    #   The name of the account attribute.
    #   @return [String]
    #
    # @!attribute [rw] attribute_values
    #   The values for the account attribute.
    #   @return [Array<Types::AccountAttributeValue>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttribute AWS API Documentation
    #
    class AccountAttribute < Struct.new(
      :attribute_name,
      :attribute_values)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a value of an account attribute.
    #
    # @!attribute [rw] attribute_value
    #   The value of the attribute.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttributeValue AWS API Documentation
    #
    class AccountAttributeValue < Struct.new(
      :attribute_value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a running instance in a Spot Fleet.
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type.
    #   @return [String]
    #
    # @!attribute [rw] spot_instance_request_id
    #   The ID of the Spot Instance request.
    #   @return [String]
    #
    # @!attribute [rw] instance_health
    #   The health status of the instance. If the status of either the
    #   instance status check or the system status check is `impaired`, the
    #   health status of the instance is `unhealthy`. Otherwise, the health
    #   status is `healthy`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ActiveInstance AWS API Documentation
    #
    class ActiveInstance < Struct.new(
      :instance_id,
      :instance_type,
      :spot_instance_request_id,
      :instance_health)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains information about the current security configuration of an
    # active VPN tunnel.
    #
    # @!attribute [rw] phase_1_encryption_algorithm
    #   The encryption algorithm negotiated in Phase 1 IKE negotiations.
    #   @return [String]
    #
    # @!attribute [rw] phase_2_encryption_algorithm
    #   The encryption algorithm negotiated in Phase 2 IKE negotiations.
    #   @return [String]
    #
    # @!attribute [rw] phase_1_integrity_algorithm
    #   The integrity algorithm negotiated in Phase 1 IKE negotiations.
    #   @return [String]
    #
    # @!attribute [rw] phase_2_integrity_algorithm
    #   The integrity algorithm negotiated in Phase 2 IKE negotiations.
    #   @return [String]
    #
    # @!attribute [rw] phase_1_dh_group
    #   The Diffie-Hellman group number being used in Phase 1 IKE
    #   negotiations.
    #   @return [Integer]
    #
    # @!attribute [rw] phase_2_dh_group
    #   The Diffie-Hellman group number being used in Phase 2 IKE
    #   negotiations.
    #   @return [Integer]
    #
    # @!attribute [rw] ike_version
    #   The version of the Internet Key Exchange (IKE) protocol being used.
    #   @return [String]
    #
    # @!attribute [rw] provisioning_status
    #   The current provisioning status of the VPN tunnel.
    #   @return [String]
    #
    # @!attribute [rw] provisioning_status_reason
    #   The reason for the current provisioning status.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ActiveVpnTunnelStatus AWS API Documentation
    #
    class ActiveVpnTunnelStatus < Struct.new(
      :phase_1_encryption_algorithm,
      :phase_2_encryption_algorithm,
      :phase_1_integrity_algorithm,
      :phase_2_integrity_algorithm,
      :phase_1_dh_group,
      :phase_2_dh_group,
      :ike_version,
      :provisioning_status,
      :provisioning_status_reason)
      SENSITIVE = []
      include Aws::Structure
    end

    # Add an operating Region to an IPAM. Operating Regions are Amazon Web
    # Services Regions where the IPAM is allowed to manage IP address CIDRs.
    # IPAM only discovers and monitors resources in the Amazon Web Services
    # Regions you select as operating Regions.
    #
    # For more information about operating Regions, see [Create an IPAM][1]
    # in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html
    #
    # @!attribute [rw] region_name
    #   The name of the operating Region.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddIpamOperatingRegion AWS API Documentation
    #
    class AddIpamOperatingRegion < Struct.new(
      :region_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM
    # is integrated with Amazon Web Services Organizations and you add an
    # organizational unit (OU) exclusion, IPAM will not manage the IP
    # addresses in accounts in that OU exclusion. There is a limit on the
    # number of exclusions you can create. For more information, see [Quotas
    # for your IPAM][1] in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html
    #
    # @!attribute [rw] organizations_entity_path
    #   An Amazon Web Services Organizations entity path. Build the path for
    #   the OU(s) using Amazon Web Services Organizations IDs separated by a
    #   `/`. Include all child OUs by ending the path with `/*`.
    #
    #   * Example 1
    #
    #     * Path to a child OU:
    #       `o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/ou-jkl0-awsddddd/`
    #
    #     * In this example, `o-a1b2c3d4e5` is the organization ID,
    #       `r-f6g7h8i9j0example` is the root ID , `ou-ghi0-awsccccc` is an
    #       OU ID, and `ou-jkl0-awsddddd` is a child OU ID.
    #
    #     * IPAM will not manage the IP addresses in accounts in the child
    #       OU.
    #   * Example 2
    #
    #     * Path where all child OUs will be part of the exclusion:
    #       `o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/*`
    #
    #     * In this example, IPAM will not manage the IP addresses in
    #       accounts in the OU (`ou-ghi0-awsccccc`) or in accounts in any
    #       OUs that are children of the OU.
    #
    #   For more information on how to construct an entity path, see
    #   [Understand the Amazon Web Services Organizations entity path][1] in
    #   the *Amazon Web Services Identity and Access Management User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddIpamOrganizationalUnitExclusion AWS API Documentation
    #
    class AddIpamOrganizationalUnitExclusion < Struct.new(
      :organizations_entity_path)
      SENSITIVE = []
      include Aws::Structure
    end

    # An entry for a prefix list.
    #
    # @!attribute [rw] cidr
    #   The CIDR block.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the entry.
    #
    #   Constraints: Up to 255 characters in length.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddPrefixListEntry AWS API Documentation
    #
    class AddPrefixListEntry < Struct.new(
      :cidr,
      :description)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a principal.
    #
    # @!attribute [rw] principal_type
    #   The type of principal.
    #   @return [String]
    #
    # @!attribute [rw] principal
    #   The Amazon Resource Name (ARN) of the principal.
    #   @return [String]
    #
    # @!attribute [rw] service_permission_id
    #   The ID of the service permission.
    #   @return [String]
    #
    # @!attribute [rw] service_id
    #   The ID of the service.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddedPrincipal AWS API Documentation
    #
    class AddedPrincipal < Struct.new(
      :principal_type,
      :principal,
      :service_permission_id,
      :service_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an additional detail for a path analysis. For more
    # information, see [Reachability Analyzer additional detail codes][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/reachability/additional-detail-codes.html
    #
    # @!attribute [rw] additional_detail_type
    #   The additional detail code.
    #   @return [String]
    #
    # @!attribute [rw] component
    #   The path component.
    #   @return [Types::AnalysisComponent]
    #
    # @!attribute [rw] vpc_endpoint_service
    #   The VPC endpoint service.
    #   @return [Types::AnalysisComponent]
    #
    # @!attribute [rw] rule_options
    #   The rule options.
    #   @return [Array<Types::RuleOption>]
    #
    # @!attribute [rw] rule_group_type_pairs
    #   The rule group type.
    #   @return [Array<Types::RuleGroupTypePair>]
    #
    # @!attribute [rw] rule_group_rule_options_pairs
    #   The rule options.
    #   @return [Array<Types::RuleGroupRuleOptionsPair>]
    #
    # @!attribute [rw] service_name
    #   The name of the VPC endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] load_balancers
    #   The load balancers.
    #   @return [Array<Types::AnalysisComponent>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdditionalDetail AWS API Documentation
    #
    class AdditionalDetail < Struct.new(
      :additional_detail_type,
      :component,
      :vpc_endpoint_service,
      :rule_options,
      :rule_group_type_pairs,
      :rule_group_rule_options_pairs,
      :service_name,
      :load_balancers)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an Elastic IP address, or a carrier IP address.
    #
    # @!attribute [rw] allocation_id
    #   The ID representing the allocation of the address.
    #   @return [String]
    #
    # @!attribute [rw] association_id
    #   The ID representing the association of the address with an instance.
    #   @return [String]
    #
    # @!attribute [rw] domain
    #   The network (`vpc`).
    #   @return [String]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_owner_id
    #   The ID of the Amazon Web Services account that owns the network
    #   interface.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_address
    #   The private IP address associated with the Elastic IP address.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the Elastic IP address.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] public_ipv_4_pool
    #   The ID of an address pool.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   The name of the unique set of Availability Zones, Local Zones, or
    #   Wavelength Zones from which Amazon Web Services advertises IP
    #   addresses.
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ip
    #   The customer-owned IP address.
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ipv_4_pool
    #   The ID of the customer-owned address pool.
    #   @return [String]
    #
    # @!attribute [rw] carrier_ip
    #   The carrier IP address associated. This option is only available for
    #   network interfaces which reside in a subnet in a Wavelength Zone
    #   (for example an EC2 instance).
    #   @return [String]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet where the IP address is allocated.
    #   @return [String]
    #
    # @!attribute [rw] service_managed
    #   The service that manages the elastic IP address.
    #
    #   <note markdown="1"> The only option supported today is `alb`.
    #
    #    </note>
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance that the address is associated with (if any).
    #   @return [String]
    #
    # @!attribute [rw] public_ip
    #   The Elastic IP address.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Address AWS API Documentation
    #
    class Address < Struct.new(
      :allocation_id,
      :association_id,
      :domain,
      :network_interface_id,
      :network_interface_owner_id,
      :private_ip_address,
      :tags,
      :public_ipv_4_pool,
      :network_border_group,
      :customer_owned_ip,
      :customer_owned_ipv_4_pool,
      :carrier_ip,
      :subnet_id,
      :service_managed,
      :instance_id,
      :public_ip)
      SENSITIVE = []
      include Aws::Structure
    end

    # The attributes associated with an Elastic IP address.
    #
    # @!attribute [rw] public_ip
    #   The public IP address.
    #   @return [String]
    #
    # @!attribute [rw] allocation_id
    #   \[EC2-VPC\] The allocation ID.
    #   @return [String]
    #
    # @!attribute [rw] ptr_record
    #   The pointer (PTR) record for the IP address.
    #   @return [String]
    #
    # @!attribute [rw] ptr_record_update
    #   The updated PTR record for the IP address.
    #   @return [Types::PtrUpdateStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddressAttribute AWS API Documentation
    #
    class AddressAttribute < Struct.new(
      :public_ip,
      :allocation_id,
      :ptr_record,
      :ptr_record_update)
      SENSITIVE = []
      include Aws::Structure
    end

    # Details on the Elastic IP address transfer. For more information, see
    # [Transfer Elastic IP addresses][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro
    #
    # @!attribute [rw] public_ip
    #   The Elastic IP address being transferred.
    #   @return [String]
    #
    # @!attribute [rw] allocation_id
    #   The allocation ID of an Elastic IP address.
    #   @return [String]
    #
    # @!attribute [rw] transfer_account_id
    #   The ID of the account that you want to transfer the Elastic IP
    #   address to.
    #   @return [String]
    #
    # @!attribute [rw] transfer_offer_expiration_timestamp
    #   The timestamp when the Elastic IP address transfer expired. When the
    #   source account starts the transfer, the transfer account has seven
    #   hours to allocate the Elastic IP address to complete the transfer,
    #   or the Elastic IP address will return to its original owner.
    #   @return [Time]
    #
    # @!attribute [rw] transfer_offer_accepted_timestamp
    #   The timestamp when the Elastic IP address transfer was accepted.
    #   @return [Time]
    #
    # @!attribute [rw] address_transfer_status
    #   The Elastic IP address transfer status.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddressTransfer AWS API Documentation
    #
    class AddressTransfer < Struct.new(
      :public_ip,
      :allocation_id,
      :transfer_account_id,
      :transfer_offer_expiration_timestamp,
      :transfer_offer_accepted_timestamp,
      :address_transfer_status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cidr
    #   The address range, in CIDR notation. This must be the exact range
    #   that you provisioned. You can't advertise only a portion of the
    #   provisioned range.
    #   @return [String]
    #
    # @!attribute [rw] asn
    #   The public 2-byte or 4-byte ASN that you want to advertise.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_border_group
    #   If you have [Local Zones][1] enabled, you can choose a network
    #   border group for Local Zones when you provision and advertise a
    #   BYOIPv4 CIDR. Choose the network border group carefully as the EIP
    #   and the Amazon Web Services resource it is associated with must
    #   reside in the same network border group.
    #
    #   You can provision BYOIP address ranges to and advertise them in the
    #   following Local Zone network border groups:
    #
    #   * us-east-1-dfw-2
    #
    #   * us-west-2-lax-1
    #
    #   * us-west-2-phx-2
    #
    #   <note markdown="1"> You cannot provision or advertise BYOIPv6 address ranges in Local
    #   Zones at this time.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidrRequest AWS API Documentation
    #
    class AdvertiseByoipCidrRequest < Struct.new(
      :cidr,
      :asn,
      :dry_run,
      :network_border_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoip_cidr
    #   Information about the address range.
    #   @return [Types::ByoipCidr]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidrResult AWS API Documentation
    #
    class AdvertiseByoipCidrResult < Struct.new(
      :byoip_cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] domain
    #   The network (`vpc`).
    #   @return [String]
    #
    # @!attribute [rw] address
    #   The Elastic IP address to recover or an IPv4 address from an address
    #   pool.
    #   @return [String]
    #
    # @!attribute [rw] public_ipv_4_pool
    #   The ID of an address pool that you own. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. To specify a
    #   specific address from the address pool, use the `Address` parameter
    #   instead.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   A unique set of Availability Zones, Local Zones, or Wavelength Zones
    #   from which Amazon Web Services advertises IP addresses. Use this
    #   parameter to limit the IP address to this location. IP addresses
    #   cannot move between network border groups.
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ipv_4_pool
    #   The ID of a customer-owned address pool. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. Alternatively,
    #   specify a specific address from the address pool.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Elastic IP address.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] ipam_pool_id
    #   The ID of an IPAM pool which has an Amazon-provided or BYOIP public
    #   IPv4 CIDR provisioned to it. For more information, see [Allocate
    #   sequential Elastic IP addresses from an IPAM pool][1] in the *Amazon
    #   VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-eip-pool.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddressRequest AWS API Documentation
    #
    class AllocateAddressRequest < Struct.new(
      :domain,
      :address,
      :public_ipv_4_pool,
      :network_border_group,
      :customer_owned_ipv_4_pool,
      :tag_specifications,
      :ipam_pool_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] allocation_id
    #   The ID that represents the allocation of the Elastic IP address.
    #   @return [String]
    #
    # @!attribute [rw] public_ipv_4_pool
    #   The ID of an address pool that you own.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   The set of Availability Zones, Local Zones, or Wavelength Zones from
    #   which Amazon Web Services advertises IP addresses.
    #   @return [String]
    #
    # @!attribute [rw] domain
    #   The network (`vpc`).
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ip
    #   The customer-owned IP address.
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ipv_4_pool
    #   The ID of the customer-owned address pool.
    #   @return [String]
    #
    # @!attribute [rw] carrier_ip
    #   The carrier IP address. Available only for network interfaces that
    #   reside in a subnet in a Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] public_ip
    #   The Amazon-owned IP address. Not available when using an address
    #   pool that you own.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddressResult AWS API Documentation
    #
    class AllocateAddressResult < Struct.new(
      :allocation_id,
      :public_ipv_4_pool,
      :network_border_group,
      :domain,
      :customer_owned_ip,
      :customer_owned_ipv_4_pool,
      :carrier_ip,
      :public_ip)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_family
    #   Specifies the instance family to be supported by the Dedicated
    #   Hosts. If you specify an instance family, the Dedicated Hosts
    #   support multiple instance types within that instance family.
    #
    #   If you want the Dedicated Hosts to support a specific instance type
    #   only, omit this parameter and specify **InstanceType** instead. You
    #   cannot specify **InstanceFamily** and **InstanceType** in the same
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Dedicated Host during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] host_recovery
    #   Indicates whether to enable or disable host recovery for the
    #   Dedicated Host. Host recovery is disabled by default. For more
    #   information, see [ Host recovery][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `off`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html
    #   @return [String]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on
    #   which to allocate the Dedicated Host. If you specify **OutpostArn**,
    #   you can optionally specify **AssetIds**.
    #
    #   If you are allocating the Dedicated Host in a Region, omit this
    #   parameter.
    #   @return [String]
    #
    # @!attribute [rw] host_maintenance
    #   Indicates whether to enable or disable host maintenance for the
    #   Dedicated Host. For more information, see [Host maintenance][1] in
    #   the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html
    #   @return [String]
    #
    # @!attribute [rw] asset_ids
    #   The IDs of the Outpost hardware assets on which to allocate the
    #   Dedicated Hosts. Targeting specific hardware assets on an Outpost
    #   can help to minimize latency between your workloads. This parameter
    #   is supported only if you specify **OutpostArn**. If you are
    #   allocating the Dedicated Hosts in a Region, omit this parameter.
    #
    #   * If you specify this parameter, you can omit **Quantity**. In this
    #     case, Amazon EC2 allocates a Dedicated Host on each specified
    #     hardware asset.
    #
    #   * If you specify both **AssetIds** and **Quantity**, then the value
    #     for **Quantity** must be equal to the number of asset IDs
    #     specified.
    #   @return [Array<String>]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] auto_placement
    #   Indicates whether the host accepts any untargeted instance launches
    #   that match its instance type configuration, or if it only accepts
    #   Host tenancy instance launches that specify its unique host ID. For
    #   more information, see [ Understanding auto-placement and
    #   affinity][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `off`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   Specifies the instance type to be supported by the Dedicated Hosts.
    #   If you specify an instance type, the Dedicated Hosts support
    #   instances of the specified instance type only.
    #
    #   If you want the Dedicated Hosts to support multiple instance types
    #   in a specific instance family, omit this parameter and specify
    #   **InstanceFamily** instead. You cannot specify **InstanceType** and
    #   **InstanceFamily** in the same request.
    #   @return [String]
    #
    # @!attribute [rw] quantity
    #   The number of Dedicated Hosts to allocate to your account with these
    #   parameters. If you are allocating the Dedicated Hosts on an Outpost,
    #   and you specify **AssetIds**, you can omit this parameter. In this
    #   case, Amazon EC2 allocates a Dedicated Host on each specified
    #   hardware asset. If you specify both **AssetIds** and **Quantity**,
    #   then the value that you specify for **Quantity** must be equal to
    #   the number of asset IDs specified.
    #   @return [Integer]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which to allocate the Dedicated Host.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHostsRequest AWS API Documentation
    #
    class AllocateHostsRequest < Struct.new(
      :instance_family,
      :tag_specifications,
      :host_recovery,
      :outpost_arn,
      :host_maintenance,
      :asset_ids,
      :availability_zone_id,
      :auto_placement,
      :client_token,
      :instance_type,
      :quantity,
      :availability_zone)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AllocateHosts.
    #
    # @!attribute [rw] host_ids
    #   The ID of the allocated Dedicated Host. This is used to launch an
    #   instance onto a specific host.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHostsResult AWS API Documentation
    #
    class AllocateHostsResult < Struct.new(
      :host_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_pool_id
    #   The ID of the IPAM pool from which you would like to allocate a
    #   CIDR.
    #   @return [String]
    #
    # @!attribute [rw] cidr
    #   The CIDR you would like to allocate from the IPAM pool. Note the
    #   following:
    #
    #   * If there is no DefaultNetmaskLength allocation rule set on the
    #     pool, you must specify either the NetmaskLength or the CIDR.
    #
    #   * If the DefaultNetmaskLength allocation rule is set on the pool,
    #     you can specify either the NetmaskLength or the CIDR and the
    #     DefaultNetmaskLength allocation rule will be ignored.
    #
    #   Possible values: Any available IPv4 or IPv6 CIDR.
    #   @return [String]
    #
    # @!attribute [rw] netmask_length
    #   The netmask length of the CIDR you would like to allocate from the
    #   IPAM pool. Note the following:
    #
    #   * If there is no DefaultNetmaskLength allocation rule set on the
    #     pool, you must specify either the NetmaskLength or the CIDR.
    #
    #   * If the DefaultNetmaskLength allocation rule is set on the pool,
    #     you can specify either the NetmaskLength or the CIDR and the
    #     DefaultNetmaskLength allocation rule will be ignored.
    #
    #   Possible netmask lengths for IPv4 addresses are 0 - 32. Possible
    #   netmask lengths for IPv6 addresses are 0 - 128.
    #   @return [Integer]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the allocation.
    #   @return [String]
    #
    # @!attribute [rw] preview_next_cidr
    #   A preview of the next available CIDR in a pool.
    #   @return [Boolean]
    #
    # @!attribute [rw] allowed_cidrs
    #   Include a particular CIDR range that can be returned by the pool.
    #   Allowed CIDRs are only allowed if using netmask length for
    #   allocation.
    #   @return [Array<String>]
    #
    # @!attribute [rw] disallowed_cidrs
    #   Exclude a particular CIDR range from being returned by the pool.
    #   Disallowed CIDRs are only allowed if using netmask length for
    #   allocation.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidrRequest AWS API Documentation
    #
    class AllocateIpamPoolCidrRequest < Struct.new(
      :dry_run,
      :ipam_pool_id,
      :cidr,
      :netmask_length,
      :client_token,
      :description,
      :preview_next_cidr,
      :allowed_cidrs,
      :disallowed_cidrs)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_pool_allocation
    #   Information about the allocation created.
    #   @return [Types::IpamPoolAllocation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidrResult AWS API Documentation
    #
    class AllocateIpamPoolCidrResult < Struct.new(
      :ipam_pool_allocation)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a principal.
    #
    # @!attribute [rw] principal_type
    #   The type of principal.
    #   @return [String]
    #
    # @!attribute [rw] principal
    #   The Amazon Resource Name (ARN) of the principal.
    #   @return [String]
    #
    # @!attribute [rw] service_permission_id
    #   The ID of the service permission.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] service_id
    #   The ID of the service.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllowedPrincipal AWS API Documentation
    #
    class AllowedPrincipal < Struct.new(
      :principal_type,
      :principal,
      :service_permission_id,
      :tags,
      :service_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an potential intermediate component of a feasible path.
    #
    # @!attribute [rw] component_id
    #   The ID of the component.
    #   @return [String]
    #
    # @!attribute [rw] component_arn
    #   The Amazon Resource Name (ARN) of the component.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AlternatePathHint AWS API Documentation
    #
    class AlternatePathHint < Struct.new(
      :component_id,
      :component_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a network access control (ACL) rule.
    #
    # @!attribute [rw] cidr
    #   The IPv4 address range, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] egress
    #   Indicates whether the rule is an outbound rule.
    #   @return [Boolean]
    #
    # @!attribute [rw] port_range
    #   The range of ports.
    #   @return [Types::PortRange]
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] rule_action
    #   Indicates whether to allow or deny traffic that matches the rule.
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The rule number.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisAclRule AWS API Documentation
    #
    class AnalysisAclRule < Struct.new(
      :cidr,
      :egress,
      :port_range,
      :protocol,
      :rule_action,
      :rule_number)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a path component.
    #
    # @!attribute [rw] id
    #   The ID of the component.
    #   @return [String]
    #
    # @!attribute [rw] arn
    #   The Amazon Resource Name (ARN) of the component.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   The name of the analysis component.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisComponent AWS API Documentation
    #
    class AnalysisComponent < Struct.new(
      :id,
      :arn,
      :name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a load balancer listener.
    #
    # @!attribute [rw] load_balancer_port
    #   The port on which the load balancer is listening.
    #   @return [Integer]
    #
    # @!attribute [rw] instance_port
    #   \[Classic Load Balancers\] The back-end port for the listener.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisLoadBalancerListener AWS API Documentation
    #
    class AnalysisLoadBalancerListener < Struct.new(
      :load_balancer_port,
      :instance_port)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a load balancer target.
    #
    # @!attribute [rw] address
    #   The IP address.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] instance
    #   Information about the instance.
    #   @return [Types::AnalysisComponent]
    #
    # @!attribute [rw] port
    #   The port on which the target is listening.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisLoadBalancerTarget AWS API Documentation
    #
    class AnalysisLoadBalancerTarget < Struct.new(
      :address,
      :availability_zone,
      :availability_zone_id,
      :instance,
      :port)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a header. Reflects any changes made by a component as
    # traffic passes through. The fields of an inbound header are null
    # except for the first component of a path.
    #
    # @!attribute [rw] destination_addresses
    #   The destination addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] destination_port_ranges
    #   The destination port ranges.
    #   @return [Array<Types::PortRange>]
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] source_addresses
    #   The source addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] source_port_ranges
    #   The source port ranges.
    #   @return [Array<Types::PortRange>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisPacketHeader AWS API Documentation
    #
    class AnalysisPacketHeader < Struct.new(
      :destination_addresses,
      :destination_port_ranges,
      :protocol,
      :source_addresses,
      :source_port_ranges)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a route table route.
    #
    # @!attribute [rw] destination_cidr
    #   The destination IPv4 address, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] destination_prefix_list_id
    #   The prefix of the Amazon Web Services service.
    #   @return [String]
    #
    # @!attribute [rw] egress_only_internet_gateway_id
    #   The ID of an egress-only internet gateway.
    #   @return [String]
    #
    # @!attribute [rw] gateway_id
    #   The ID of the gateway, such as an internet gateway or virtual
    #   private gateway.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance, such as a NAT instance.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway_id
    #   The ID of a NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of a network interface.
    #   @return [String]
    #
    # @!attribute [rw] origin
    #   Describes how the route was created. The following are the possible
    #   values:
    #
    #   * CreateRouteTable - The route was automatically created when the
    #     route table was created.
    #
    #   * CreateRoute - The route was manually added to the route table.
    #
    #   * EnableVgwRoutePropagation - The route was propagated by route
    #     propagation.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of a transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of a VPC peering connection.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state. The following are the possible values:
    #
    #   * active
    #
    #   * blackhole
    #   @return [String]
    #
    # @!attribute [rw] carrier_gateway_id
    #   The ID of a carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] core_network_arn
    #   The Amazon Resource Name (ARN) of a core network.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_id
    #   The ID of a local gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisRouteTableRoute AWS API Documentation
    #
    class AnalysisRouteTableRoute < Struct.new(
      :destination_cidr,
      :destination_prefix_list_id,
      :egress_only_internet_gateway_id,
      :gateway_id,
      :instance_id,
      :nat_gateway_id,
      :network_interface_id,
      :origin,
      :transit_gateway_id,
      :vpc_peering_connection_id,
      :state,
      :carrier_gateway_id,
      :core_network_arn,
      :local_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a security group rule.
    #
    # @!attribute [rw] cidr
    #   The IPv4 address range, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] direction
    #   The direction. The following are the possible values:
    #
    #   * egress
    #
    #   * ingress
    #   @return [String]
    #
    # @!attribute [rw] security_group_id
    #   The security group ID.
    #   @return [String]
    #
    # @!attribute [rw] port_range
    #   The port range.
    #   @return [Types::PortRange]
    #
    # @!attribute [rw] prefix_list_id
    #   The prefix list ID.
    #   @return [String]
    #
    # @!attribute [rw] protocol
    #   The protocol name.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisSecurityGroupRule AWS API Documentation
    #
    class AnalysisSecurityGroupRule < Struct.new(
      :cidr,
      :direction,
      :security_group_id,
      :port_range,
      :prefix_list_id,
      :protocol)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC in which the associated target network is located.
    #   @return [String]
    #
    # @!attribute [rw] security_group_ids
    #   The IDs of the security groups to apply to the associated target
    #   network. Up to 5 security groups can be applied to an associated
    #   target network.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetworkRequest AWS API Documentation
    #
    class ApplySecurityGroupsToClientVpnTargetNetworkRequest < Struct.new(
      :client_vpn_endpoint_id,
      :vpc_id,
      :security_group_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] security_group_ids
    #   The IDs of the applied security groups.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetworkResult AWS API Documentation
    #
    class ApplySecurityGroupsToClientVpnTargetNetworkResult < Struct.new(
      :security_group_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # An Autonomous System Number (ASN) and BYOIP CIDR association.
    #
    # @!attribute [rw] asn
    #   The association's ASN.
    #   @return [String]
    #
    # @!attribute [rw] cidr
    #   The association's CIDR.
    #   @return [String]
    #
    # @!attribute [rw] status_message
    #   The association's status message.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The association's state.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AsnAssociation AWS API Documentation
    #
    class AsnAssociation < Struct.new(
      :asn,
      :cidr,
      :status_message,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Provides authorization for Amazon to bring an Autonomous System Number
    # (ASN) to a specific Amazon Web Services account using bring your own
    # ASN (BYOASN). For details on the format of the message and signature,
    # see [Tutorial: Bring your ASN to IPAM][1] in the *Amazon VPC IPAM
    # guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html
    #
    # @!attribute [rw] message
    #   The authorization context's message.
    #   @return [String]
    #
    # @!attribute [rw] signature
    #   The authorization context's signature.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AsnAuthorizationContext AWS API Documentation
    #
    class AsnAuthorizationContext < Struct.new(
      :message,
      :signature)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_prefix_count
    #   The number of IPv6 prefixes that Amazon Web Services automatically
    #   assigns to the network interface. You cannot use this option if you
    #   use the `Ipv6Prefixes` option.
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_prefixes
    #   One or more IPv6 prefixes assigned to the network interface. You
    #   can't use this option if you use the `Ipv6PrefixCount` option.
    #   @return [Array<String>]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_addresses
    #   The IPv6 addresses to be assigned to the network interface. You
    #   can't use this option if you're specifying a number of IPv6
    #   addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] ipv_6_address_count
    #   The number of additional IPv6 addresses to assign to the network
    #   interface. The specified number of IPv6 addresses are assigned in
    #   addition to the existing IPv6 addresses that are already assigned to
    #   the network interface. Amazon EC2 automatically selects the IPv6
    #   addresses from the subnet range. You can't use this option if
    #   specifying specific IPv6 addresses.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6AddressesRequest AWS API Documentation
    #
    class AssignIpv6AddressesRequest < Struct.new(
      :ipv_6_prefix_count,
      :ipv_6_prefixes,
      :network_interface_id,
      :ipv_6_addresses,
      :ipv_6_address_count)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] assigned_ipv_6_addresses
    #   The new IPv6 addresses assigned to the network interface. Existing
    #   IPv6 addresses that were assigned to the network interface before
    #   the request are not included.
    #   @return [Array<String>]
    #
    # @!attribute [rw] assigned_ipv_6_prefixes
    #   The IPv6 prefixes that are assigned to the network interface.
    #   @return [Array<String>]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6AddressesResult AWS API Documentation
    #
    class AssignIpv6AddressesResult < Struct.new(
      :assigned_ipv_6_addresses,
      :assigned_ipv_6_prefixes,
      :network_interface_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AssignPrivateIpAddresses.
    #
    # @!attribute [rw] ipv_4_prefixes
    #   One or more IPv4 prefixes assigned to the network interface. You
    #   can't use this option if you use the `Ipv4PrefixCount` option.
    #   @return [Array<String>]
    #
    # @!attribute [rw] ipv_4_prefix_count
    #   The number of IPv4 prefixes that Amazon Web Services automatically
    #   assigns to the network interface. You can't use this option if you
    #   use the `Ipv4 Prefixes` option.
    #   @return [Integer]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_addresses
    #   The IP addresses to be assigned as a secondary private IP address to
    #   the network interface. You can't specify this parameter when also
    #   specifying a number of secondary IP addresses.
    #
    #   If you don't specify an IP address, Amazon EC2 automatically
    #   selects an IP address within the subnet range.
    #   @return [Array<String>]
    #
    # @!attribute [rw] secondary_private_ip_address_count
    #   The number of secondary IP addresses to assign to the network
    #   interface. You can't specify this parameter when also specifying
    #   private IP addresses.
    #   @return [Integer]
    #
    # @!attribute [rw] allow_reassignment
    #   Indicates whether to allow an IP address that is already assigned to
    #   another network interface or instance to be reassigned to the
    #   specified network interface.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddressesRequest AWS API Documentation
    #
    class AssignPrivateIpAddressesRequest < Struct.new(
      :ipv_4_prefixes,
      :ipv_4_prefix_count,
      :network_interface_id,
      :private_ip_addresses,
      :secondary_private_ip_address_count,
      :allow_reassignment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] assigned_private_ip_addresses
    #   The private IP addresses assigned to the network interface.
    #   @return [Array<Types::AssignedPrivateIpAddress>]
    #
    # @!attribute [rw] assigned_ipv_4_prefixes
    #   The IPv4 prefixes that are assigned to the network interface.
    #   @return [Array<Types::Ipv4PrefixSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddressesResult AWS API Documentation
    #
    class AssignPrivateIpAddressesResult < Struct.new(
      :network_interface_id,
      :assigned_private_ip_addresses,
      :assigned_ipv_4_prefixes)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_addresses
    #   The private IPv4 addresses you want to assign to the private NAT
    #   gateway.
    #   @return [Array<String>]
    #
    # @!attribute [rw] private_ip_address_count
    #   The number of private IP addresses to assign to the NAT gateway. You
    #   can't specify this parameter when also specifying private IP
    #   addresses.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddressRequest AWS API Documentation
    #
    class AssignPrivateNatGatewayAddressRequest < Struct.new(
      :nat_gateway_id,
      :private_ip_addresses,
      :private_ip_address_count,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway_addresses
    #   NAT gateway IP addresses.
    #   @return [Array<Types::NatGatewayAddress>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddressResult AWS API Documentation
    #
    class AssignPrivateNatGatewayAddressResult < Struct.new(
      :nat_gateway_id,
      :nat_gateway_addresses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the private IP addresses assigned to a network interface.
    #
    # @!attribute [rw] private_ip_address
    #   The private IP address assigned to the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignedPrivateIpAddress AWS API Documentation
    #
    class AssignedPrivateIpAddress < Struct.new(
      :private_ip_address)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] allocation_id
    #   The allocation ID. This is required.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance. The instance must have exactly one attached
    #   network interface. You can specify either the instance ID or the
    #   network interface ID, but not both.
    #   @return [String]
    #
    # @!attribute [rw] public_ip
    #   Deprecated.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface. If the instance has more than one
    #   network interface, you must specify a network interface ID.
    #
    #   You can specify either the instance ID or the network interface ID,
    #   but not both.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_address
    #   The primary or secondary private IP address to associate with the
    #   Elastic IP address. If no private IP address is specified, the
    #   Elastic IP address is associated with the primary private IP
    #   address.
    #   @return [String]
    #
    # @!attribute [rw] allow_reassociation
    #   Reassociation is automatic, but you can specify false to ensure the
    #   operation fails if the Elastic IP address is already associated with
    #   another resource.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddressRequest AWS API Documentation
    #
    class AssociateAddressRequest < Struct.new(
      :allocation_id,
      :instance_id,
      :public_ip,
      :dry_run,
      :network_interface_id,
      :private_ip_address,
      :allow_reassociation)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_id
    #   The ID that represents the association of the Elastic IP address
    #   with an instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddressResult AWS API Documentation
    #
    class AssociateAddressResult < Struct.new(
      :association_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] unused_reservation_billing_owner_id
    #   The ID of the consumer account to which to assign billing.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateCapacityReservationBillingOwnerRequest AWS API Documentation
    #
    class AssociateCapacityReservationBillingOwnerRequest < Struct.new(
      :dry_run,
      :capacity_reservation_id,
      :unused_reservation_billing_owner_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateCapacityReservationBillingOwnerResult AWS API Documentation
    #
    class AssociateCapacityReservationBillingOwnerResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet to associate with the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetworkRequest AWS API Documentation
    #
    class AssociateClientVpnTargetNetworkRequest < Struct.new(
      :client_vpn_endpoint_id,
      :subnet_id,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_id
    #   The unique ID of the target network association.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the target network association.
    #   @return [Types::AssociationStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetworkResult AWS API Documentation
    #
    class AssociateClientVpnTargetNetworkResult < Struct.new(
      :association_id,
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dhcp_options_id
    #   The ID of the DHCP options set, or `default` to associate no DHCP
    #   options with the VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptionsRequest AWS API Documentation
    #
    class AssociateDhcpOptionsRequest < Struct.new(
      :dhcp_options_id,
      :vpc_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] certificate_arn
    #   The ARN of the ACM certificate with which to associate the IAM role.
    #   @return [String]
    #
    # @!attribute [rw] role_arn
    #   The ARN of the IAM role to associate with the ACM certificate. You
    #   can associate up to 16 IAM roles with an ACM certificate.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRoleRequest AWS API Documentation
    #
    class AssociateEnclaveCertificateIamRoleRequest < Struct.new(
      :certificate_arn,
      :role_arn,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] certificate_s3_bucket_name
    #   The name of the Amazon S3 bucket to which the certificate was
    #   uploaded.
    #   @return [String]
    #
    # @!attribute [rw] certificate_s3_object_key
    #   The Amazon S3 object key where the certificate, certificate chain,
    #   and encrypted private key bundle are stored. The object key is
    #   formatted as follows: `role_arn`/`certificate_arn`.
    #   @return [String]
    #
    # @!attribute [rw] encryption_kms_key_id
    #   The ID of the KMS key used to encrypt the private key of the
    #   certificate.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRoleResult AWS API Documentation
    #
    class AssociateEnclaveCertificateIamRoleResult < Struct.new(
      :certificate_s3_bucket_name,
      :certificate_s3_object_key,
      :encryption_kms_key_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] iam_instance_profile
    #   The IAM instance profile.
    #   @return [Types::IamInstanceProfileSpecification]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfileRequest AWS API Documentation
    #
    class AssociateIamInstanceProfileRequest < Struct.new(
      :iam_instance_profile,
      :instance_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] iam_instance_profile_association
    #   Information about the IAM instance profile association.
    #   @return [Types::IamInstanceProfileAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfileResult AWS API Documentation
    #
    class AssociateIamInstanceProfileResult < Struct.new(
      :iam_instance_profile_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_event_window_id
    #   The ID of the event window.
    #   @return [String]
    #
    # @!attribute [rw] association_target
    #   One or more targets associated with the specified event window.
    #   @return [Types::InstanceEventWindowAssociationRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindowRequest AWS API Documentation
    #
    class AssociateInstanceEventWindowRequest < Struct.new(
      :dry_run,
      :instance_event_window_id,
      :association_target)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_event_window
    #   Information about the event window.
    #   @return [Types::InstanceEventWindow]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindowResult AWS API Documentation
    #
    class AssociateInstanceEventWindowResult < Struct.new(
      :instance_event_window)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] asn
    #   A public 2-byte or 4-byte ASN.
    #   @return [String]
    #
    # @!attribute [rw] cidr
    #   The BYOIP CIDR you want to associate with an ASN.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasnRequest AWS API Documentation
    #
    class AssociateIpamByoasnRequest < Struct.new(
      :dry_run,
      :asn,
      :cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] asn_association
    #   The ASN and BYOIP CIDR association.
    #   @return [Types::AsnAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasnResult AWS API Documentation
    #
    class AssociateIpamByoasnResult < Struct.new(
      :asn_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_id
    #   An IPAM ID.
    #   @return [String]
    #
    # @!attribute [rw] ipam_resource_discovery_id
    #   A resource discovery ID.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   Tag specifications.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A client token.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscoveryRequest AWS API Documentation
    #
    class AssociateIpamResourceDiscoveryRequest < Struct.new(
      :dry_run,
      :ipam_id,
      :ipam_resource_discovery_id,
      :tag_specifications,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_resource_discovery_association
    #   A resource discovery association. An associated resource discovery
    #   is a resource discovery that has been associated with an IPAM.
    #   @return [Types::IpamResourceDiscoveryAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscoveryResult AWS API Documentation
    #
    class AssociateIpamResourceDiscoveryResult < Struct.new(
      :ipam_resource_discovery_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] allocation_ids
    #   The allocation IDs of EIPs that you want to associate with your NAT
    #   gateway.
    #   @return [Array<String>]
    #
    # @!attribute [rw] private_ip_addresses
    #   The private IPv4 addresses that you want to assign to the NAT
    #   gateway.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] availability_zone
    #   For regional NAT gateways only: The Availability Zone where you want
    #   to associate an Elastic IP address (EIP). The regional NAT gateway
    #   uses a separate EIP in each AZ to handle outbound NAT traffic from
    #   that AZ.
    #
    #   A regional NAT gateway is a single NAT Gateway that works across
    #   multiple availability zones (AZs) in your VPC, providing redundancy,
    #   scalability and availability across all the AZs in a Region.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   For regional NAT gateways only: The ID of the Availability Zone
    #   where you want to associate an Elastic IP address (EIP). The
    #   regional NAT gateway uses a separate EIP in each AZ to handle
    #   outbound NAT traffic from that AZ. Use this instead of
    #   AvailabilityZone for consistent identification of AZs across Amazon
    #   Web Services Regions.
    #
    #   A regional NAT gateway is a single NAT Gateway that works across
    #   multiple availability zones (AZs) in your VPC, providing redundancy,
    #   scalability and availability across all the AZs in a Region.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddressRequest AWS API Documentation
    #
    class AssociateNatGatewayAddressRequest < Struct.new(
      :nat_gateway_id,
      :allocation_ids,
      :private_ip_addresses,
      :dry_run,
      :availability_zone,
      :availability_zone_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway_addresses
    #   The IP addresses.
    #   @return [Array<Types::NatGatewayAddress>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddressResult AWS API Documentation
    #
    class AssociateNatGatewayAddressResult < Struct.new(
      :nat_gateway_id,
      :nat_gateway_addresses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_id
    #   The unique identifier for the route server to be associated.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC to associate with the route server.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteServerRequest AWS API Documentation
    #
    class AssociateRouteServerRequest < Struct.new(
      :route_server_id,
      :vpc_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_association
    #   Information about the association between the route server and the
    #   VPC.
    #   @return [Types::RouteServerAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteServerResult AWS API Documentation
    #
    class AssociateRouteServerResult < Struct.new(
      :route_server_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] gateway_id
    #   The ID of the internet gateway or virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] public_ipv_4_pool
    #   The ID of a public IPv4 pool. A public IPv4 pool is a pool of IPv4
    #   addresses that you've brought to Amazon Web Services with BYOIP.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTableRequest AWS API Documentation
    #
    class AssociateRouteTableRequest < Struct.new(
      :gateway_id,
      :public_ipv_4_pool,
      :dry_run,
      :subnet_id,
      :route_table_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_id
    #   The route table association ID. This ID is required for
    #   disassociating the route table.
    #   @return [String]
    #
    # @!attribute [rw] association_state
    #   The state of the association.
    #   @return [Types::RouteTableAssociationState]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTableResult AWS API Documentation
    #
    class AssociateRouteTableResult < Struct.new(
      :association_id,
      :association_state)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] group_id
    #   A security group ID.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   A VPC ID.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSecurityGroupVpcRequest AWS API Documentation
    #
    class AssociateSecurityGroupVpcRequest < Struct.new(
      :group_id,
      :vpc_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] state
    #   The state of the association.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSecurityGroupVpcResult AWS API Documentation
    #
    class AssociateSecurityGroupVpcResult < Struct.new(
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_ipam_pool_id
    #   An IPv6 IPAM pool ID.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_netmask_length
    #   An IPv6 netmask length.
    #   @return [Integer]
    #
    # @!attribute [rw] subnet_id
    #   The ID of your subnet.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 CIDR block for your subnet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlockRequest AWS API Documentation
    #
    class AssociateSubnetCidrBlockRequest < Struct.new(
      :ipv_6_ipam_pool_id,
      :ipv_6_netmask_length,
      :subnet_id,
      :ipv_6_cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_cidr_block_association
    #   Information about the IPv6 association.
    #   @return [Types::SubnetIpv6CidrBlockAssociation]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlockResult AWS API Documentation
    #
    class AssociateSubnetCidrBlockResult < Struct.new(
      :ipv_6_cidr_block_association,
      :subnet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway attachment to associate with the
    #   transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets to associate with the transit gateway
    #   multicast domain.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomainRequest AWS API Documentation
    #
    class AssociateTransitGatewayMulticastDomainRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :transit_gateway_attachment_id,
      :subnet_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] associations
    #   Information about the transit gateway multicast domain associations.
    #   @return [Types::TransitGatewayMulticastDomainAssociations]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomainResult AWS API Documentation
    #
    class AssociateTransitGatewayMulticastDomainResult < Struct.new(
      :associations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_policy_table_id
    #   The ID of the transit gateway policy table to associate with the
    #   transit gateway attachment.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway attachment to associate with the
    #   policy table.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTableRequest AWS API Documentation
    #
    class AssociateTransitGatewayPolicyTableRequest < Struct.new(
      :transit_gateway_policy_table_id,
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association
    #   Describes the association of a transit gateway and a transit gateway
    #   policy table.
    #   @return [Types::TransitGatewayPolicyTableAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTableResult AWS API Documentation
    #
    class AssociateTransitGatewayPolicyTableResult < Struct.new(
      :association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTableRequest AWS API Documentation
    #
    class AssociateTransitGatewayRouteTableRequest < Struct.new(
      :transit_gateway_route_table_id,
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association
    #   The ID of the association.
    #   @return [Types::TransitGatewayAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTableResult AWS API Documentation
    #
    class AssociateTransitGatewayRouteTableResult < Struct.new(
      :association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] branch_interface_id
    #   The ID of the branch network interface.
    #   @return [String]
    #
    # @!attribute [rw] trunk_interface_id
    #   The ID of the trunk network interface.
    #   @return [String]
    #
    # @!attribute [rw] vlan_id
    #   The ID of the VLAN. This applies to the VLAN protocol.
    #   @return [Integer]
    #
    # @!attribute [rw] gre_key
    #   The application key. This applies to the GRE protocol.
    #   @return [Integer]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterfaceRequest AWS API Documentation
    #
    class AssociateTrunkInterfaceRequest < Struct.new(
      :branch_interface_id,
      :trunk_interface_id,
      :vlan_id,
      :gre_key,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] interface_association
    #   Information about the association between the trunk network
    #   interface and branch network interface.
    #   @return [Types::TrunkInterfaceAssociation]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterfaceResult AWS API Documentation
    #
    class AssociateTrunkInterfaceResult < Struct.new(
      :interface_association,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cidr_block
    #   An IPv4 CIDR block to associate with the VPC.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block_network_border_group
    #   The name of the location from which we advertise the IPV6 CIDR
    #   block. Use this parameter to limit the CIDR block to this location.
    #
    #   You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
    #   parameter.
    #
    #   You can have one IPv6 CIDR block association per network border
    #   group.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_pool
    #   The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
    #   block.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   An IPv6 CIDR block from the IPv6 address pool. You must also specify
    #   `Ipv6Pool` in the request.
    #
    #   To let Amazon choose the IPv6 CIDR block for you, omit this
    #   parameter.
    #   @return [String]
    #
    # @!attribute [rw] ipv_4_ipam_pool_id
    #   Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more
    #   information about Amazon VPC IP Address Manager (IPAM), see [What is
    #   IPAM?][1] in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [String]
    #
    # @!attribute [rw] ipv_4_netmask_length
    #   The netmask length of the IPv4 CIDR you would like to associate from
    #   an Amazon VPC IP Address Manager (IPAM) pool. For more information
    #   about IPAM, see [What is IPAM?][1] in the *Amazon VPC IPAM User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_ipam_pool_id
    #   Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For
    #   more information about Amazon VPC IP Address Manager (IPAM), see
    #   [What is IPAM?][1] in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_netmask_length
    #   The netmask length of the IPv6 CIDR you would like to associate from
    #   an Amazon VPC IP Address Manager (IPAM) pool. For more information
    #   about IPAM, see [What is IPAM?][1] in the *Amazon VPC IPAM User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [Integer]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IPv6 addresses or the
    #   size of the CIDR block.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlockRequest AWS API Documentation
    #
    class AssociateVpcCidrBlockRequest < Struct.new(
      :cidr_block,
      :ipv_6_cidr_block_network_border_group,
      :ipv_6_pool,
      :ipv_6_cidr_block,
      :ipv_4_ipam_pool_id,
      :ipv_4_netmask_length,
      :ipv_6_ipam_pool_id,
      :ipv_6_netmask_length,
      :vpc_id,
      :amazon_provided_ipv_6_cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_cidr_block_association
    #   Information about the IPv6 CIDR block association.
    #   @return [Types::VpcIpv6CidrBlockAssociation]
    #
    # @!attribute [rw] cidr_block_association
    #   Information about the IPv4 CIDR block association.
    #   @return [Types::VpcCidrBlockAssociation]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlockResult AWS API Documentation
    #
    class AssociateVpcCidrBlockResult < Struct.new(
      :ipv_6_cidr_block_association,
      :cidr_block_association,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the associated IAM roles.
    #
    # @!attribute [rw] associated_role_arn
    #   The ARN of the associated IAM role.
    #   @return [String]
    #
    # @!attribute [rw] certificate_s3_bucket_name
    #   The name of the Amazon S3 bucket in which the Amazon S3 object is
    #   stored.
    #   @return [String]
    #
    # @!attribute [rw] certificate_s3_object_key
    #   The key of the Amazon S3 object where the certificate, certificate
    #   chain, and encrypted private key bundle are stored. The object key
    #   is formatted as follows: `role_arn`/`certificate_arn`.
    #   @return [String]
    #
    # @!attribute [rw] encryption_kms_key_id
    #   The ID of the KMS key used to encrypt the private key.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociatedRole AWS API Documentation
    #
    class AssociatedRole < Struct.new(
      :associated_role_arn,
      :certificate_s3_bucket_name,
      :certificate_s3_object_key,
      :encryption_kms_key_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a target network that is associated with a Client VPN
    # endpoint. A target network is a subnet in a VPC.
    #
    # @!attribute [rw] network_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] network_type
    #   The target network type.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociatedTargetNetwork AWS API Documentation
    #
    class AssociatedTargetNetwork < Struct.new(
      :network_id,
      :network_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a target network association.
    #
    # @!attribute [rw] code
    #   The state of the target network association.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the target network association, if
    #   applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociationStatus AWS API Documentation
    #
    class AssociationStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes integration options for Amazon Athena.
    #
    # @!attribute [rw] integration_result_s3_destination_arn
    #   The location in Amazon S3 to store the generated CloudFormation
    #   template.
    #   @return [String]
    #
    # @!attribute [rw] partition_load_frequency
    #   The schedule for adding new partitions to the table.
    #   @return [String]
    #
    # @!attribute [rw] partition_start_date
    #   The start date for the partition.
    #   @return [Time]
    #
    # @!attribute [rw] partition_end_date
    #   The end date for the partition.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AthenaIntegration AWS API Documentation
    #
    class AthenaIntegration < Struct.new(
      :integration_result_s3_destination_arn,
      :partition_load_frequency,
      :partition_start_date,
      :partition_end_date)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the EC2-Classic instance.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the ClassicLink-enabled VPC.
    #   @return [String]
    #
    # @!attribute [rw] groups
    #   The IDs of the security groups. You cannot specify security groups
    #   from a different VPC.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcRequest AWS API Documentation
    #
    class AttachClassicLinkVpcRequest < Struct.new(
      :dry_run,
      :instance_id,
      :vpc_id,
      :groups)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcResult AWS API Documentation
    #
    class AttachClassicLinkVpcResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] internet_gateway_id
    #   The ID of the internet gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGatewayRequest AWS API Documentation
    #
    class AttachInternetGatewayRequest < Struct.new(
      :dry_run,
      :internet_gateway_id,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AttachNetworkInterface.
    #
    # @!attribute [rw] network_card_index
    #   The index of the network card. Some instance types support multiple
    #   network cards. The primary network interface must be assigned to
    #   network card index 0. The default is network card index 0.
    #   @return [Integer]
    #
    # @!attribute [rw] ena_srd_specification
    #   Configures ENA Express for the network interface that this action
    #   attaches to the instance.
    #   @return [Types::EnaSrdSpecification]
    #
    # @!attribute [rw] ena_queue_count
    #   The number of ENA queues to be created with the instance.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] device_index
    #   The index of the device for the network interface attachment.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterfaceRequest AWS API Documentation
    #
    class AttachNetworkInterfaceRequest < Struct.new(
      :network_card_index,
      :ena_srd_specification,
      :ena_queue_count,
      :dry_run,
      :network_interface_id,
      :instance_id,
      :device_index)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AttachNetworkInterface.
    #
    # @!attribute [rw] attachment_id
    #   The ID of the network interface attachment.
    #   @return [String]
    #
    # @!attribute [rw] network_card_index
    #   The index of the network card.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterfaceResult AWS API Documentation
    #
    class AttachNetworkInterfaceResult < Struct.new(
      :attachment_id,
      :network_card_index)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_instance_id
    #   The ID of the Verified Access instance.
    #   @return [String]
    #
    # @!attribute [rw] verified_access_trust_provider_id
    #   The ID of the Verified Access trust provider.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProviderRequest AWS API Documentation
    #
    class AttachVerifiedAccessTrustProviderRequest < Struct.new(
      :verified_access_instance_id,
      :verified_access_trust_provider_id,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_trust_provider
    #   Details about the Verified Access trust provider.
    #   @return [Types::VerifiedAccessTrustProvider]
    #
    # @!attribute [rw] verified_access_instance
    #   Details about the Verified Access instance.
    #   @return [Types::VerifiedAccessInstance]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProviderResult AWS API Documentation
    #
    class AttachVerifiedAccessTrustProviderResult < Struct.new(
      :verified_access_trust_provider,
      :verified_access_instance)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] device
    #   The device name (for example, `/dev/sdh` or `xvdh`).
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] volume_id
    #   The ID of the EBS volume. The volume and instance must be within the
    #   same Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] ebs_card_index
    #   The index of the EBS card. Some instance types support multiple EBS
    #   cards. The default EBS card index is 0.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolumeRequest AWS API Documentation
    #
    class AttachVolumeRequest < Struct.new(
      :device,
      :instance_id,
      :volume_id,
      :ebs_card_index,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AttachVpnGateway.
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpn_gateway_id
    #   The ID of the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGatewayRequest AWS API Documentation
    #
    class AttachVpnGatewayRequest < Struct.new(
      :vpc_id,
      :vpn_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AttachVpnGateway.
    #
    # @!attribute [rw] vpc_attachment
    #   Information about the attachment.
    #   @return [Types::VpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGatewayResult AWS API Documentation
    #
    class AttachVpnGatewayResult < Struct.new(
      :vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # ENA Express uses Amazon Web Services Scalable Reliable Datagram (SRD)
    # technology to increase the maximum bandwidth used per stream and
    # minimize tail latency of network traffic between EC2 instances. With
    # ENA Express, you can communicate between two EC2 instances in the same
    # subnet within the same account, or in different accounts. Both sending
    # and receiving instances must have ENA Express enabled.
    #
    # To improve the reliability of network packet delivery, ENA Express
    # reorders network packets on the receiving end by default. However,
    # some UDP-based applications are designed to handle network packets
    # that are out of order to reduce the overhead for packet delivery at
    # the network layer. When ENA Express is enabled, you can specify
    # whether UDP network traffic uses it.
    #
    # @!attribute [rw] ena_srd_enabled
    #   Indicates whether ENA Express is enabled for the network interface.
    #   @return [Boolean]
    #
    # @!attribute [rw] ena_srd_udp_specification
    #   Configures ENA Express for UDP network traffic.
    #   @return [Types::AttachmentEnaSrdUdpSpecification]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachmentEnaSrdSpecification AWS API Documentation
    #
    class AttachmentEnaSrdSpecification < Struct.new(
      :ena_srd_enabled,
      :ena_srd_udp_specification)
      SENSITIVE = []
      include Aws::Structure
    end

    # ENA Express is compatible with both TCP and UDP transport protocols.
    # When it's enabled, TCP traffic automatically uses it. However, some
    # UDP-based applications are designed to handle network packets that are
    # out of order, without a need for retransmission, such as live video
    # broadcasting or other near-real-time applications. For UDP traffic,
    # you can specify whether to use ENA Express, based on your application
    # environment needs.
    #
    # @!attribute [rw] ena_srd_udp_enabled
    #   Indicates whether UDP traffic to and from the instance uses ENA
    #   Express. To specify this setting, you must first enable ENA Express.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachmentEnaSrdUdpSpecification AWS API Documentation
    #
    class AttachmentEnaSrdUdpSpecification < Struct.new(
      :ena_srd_udp_enabled)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a value for a resource attribute that is a Boolean value.
    #
    # @!attribute [rw] value
    #   The attribute value. The valid values are `true` or `false`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeBooleanValue AWS API Documentation
    #
    class AttributeBooleanValue < Struct.new(
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # A summary report for the attribute across all Regions.
    #
    # @!attribute [rw] attribute_name
    #   The name of the attribute.
    #   @return [String]
    #
    # @!attribute [rw] most_frequent_value
    #   The configuration value that is most frequently observed for the
    #   attribute.
    #   @return [String]
    #
    # @!attribute [rw] number_of_matched_accounts
    #   The number of accounts with the same configuration value for the
    #   attribute that is most frequently observed.
    #   @return [Integer]
    #
    # @!attribute [rw] number_of_unmatched_accounts
    #   The number of accounts with a configuration value different from the
    #   most frequently observed value for the attribute.
    #   @return [Integer]
    #
    # @!attribute [rw] regional_summaries
    #   The summary report for each Region for the attribute.
    #   @return [Array<Types::RegionalSummary>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeSummary AWS API Documentation
    #
    class AttributeSummary < Struct.new(
      :attribute_name,
      :most_frequent_value,
      :number_of_matched_accounts,
      :number_of_unmatched_accounts,
      :regional_summaries)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a value for a resource attribute that is a String.
    #
    # @!attribute [rw] value
    #   The attribute value. The value is case-sensitive.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeValue AWS API Documentation
    #
    class AttributeValue < Struct.new(
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about an authorization rule.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint with which the authorization rule
    #   is associated.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A brief description of the authorization rule.
    #   @return [String]
    #
    # @!attribute [rw] group_id
    #   The ID of the Active Directory group to which the authorization rule
    #   grants access.
    #   @return [String]
    #
    # @!attribute [rw] access_all
    #   Indicates whether the authorization rule grants access to all
    #   clients.
    #   @return [Boolean]
    #
    # @!attribute [rw] destination_cidr
    #   The IPv4 address range, in CIDR notation, of the network to which
    #   the authorization rule applies.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the authorization rule.
    #   @return [Types::ClientVpnAuthorizationRuleStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizationRule AWS API Documentation
    #
    class AuthorizationRule < Struct.new(
      :client_vpn_endpoint_id,
      :description,
      :group_id,
      :access_all,
      :destination_cidr,
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] target_network_cidr
    #   The IPv4 address range, in CIDR notation, of the network for which
    #   access is being authorized.
    #   @return [String]
    #
    # @!attribute [rw] access_group_id
    #   The ID of the group to grant access to, for example, the Active
    #   Directory group or identity provider (IdP) group. Required if
    #   `AuthorizeAllGroups` is `false` or not specified.
    #   @return [String]
    #
    # @!attribute [rw] authorize_all_groups
    #   Indicates whether to grant access to all clients. Specify `true` to
    #   grant all clients who successfully establish a VPN connection access
    #   to the network. Must be set to `true` if `AccessGroupId` is not
    #   specified.
    #   @return [Boolean]
    #
    # @!attribute [rw] description
    #   A brief description of the authorization rule.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngressRequest AWS API Documentation
    #
    class AuthorizeClientVpnIngressRequest < Struct.new(
      :client_vpn_endpoint_id,
      :target_network_cidr,
      :access_group_id,
      :authorize_all_groups,
      :description,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the authorization rule.
    #   @return [Types::ClientVpnAuthorizationRuleStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngressResult AWS API Documentation
    #
    class AuthorizeClientVpnIngressResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] tag_specifications
    #   The tags applied to the security group rule.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_id
    #   The ID of the security group.
    #   @return [String]
    #
    # @!attribute [rw] source_security_group_name
    #   Not supported. Use IP permissions instead.
    #   @return [String]
    #
    # @!attribute [rw] source_security_group_owner_id
    #   Not supported. Use IP permissions instead.
    #   @return [String]
    #
    # @!attribute [rw] ip_protocol
    #   Not supported. Use IP permissions instead.
    #   @return [String]
    #
    # @!attribute [rw] from_port
    #   Not supported. Use IP permissions instead.
    #   @return [Integer]
    #
    # @!attribute [rw] to_port
    #   Not supported. Use IP permissions instead.
    #   @return [Integer]
    #
    # @!attribute [rw] cidr_ip
    #   Not supported. Use IP permissions instead.
    #   @return [String]
    #
    # @!attribute [rw] ip_permissions
    #   The permissions for the security group rules.
    #   @return [Array<Types::IpPermission>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgressRequest AWS API Documentation
    #
    class AuthorizeSecurityGroupEgressRequest < Struct.new(
      :tag_specifications,
      :dry_run,
      :group_id,
      :source_security_group_name,
      :source_security_group_owner_id,
      :ip_protocol,
      :from_port,
      :to_port,
      :cidr_ip,
      :ip_permissions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, returns an error.
    #   @return [Boolean]
    #
    # @!attribute [rw] security_group_rules
    #   Information about the outbound (egress) security group rules that
    #   were added.
    #   @return [Array<Types::SecurityGroupRule>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgressResult AWS API Documentation
    #
    class AuthorizeSecurityGroupEgressResult < Struct.new(
      :return,
      :security_group_rules)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cidr_ip
    #   The IPv4 address range, in CIDR format.
    #
    #   <note markdown="1"> Amazon Web Services [canonicalizes][1] IPv4 and IPv6 CIDRs. For
    #   example, if you specify 100.68.0.18/18 for the CIDR block, Amazon
    #   Web Services canonicalizes the CIDR block to 100.68.0.0/18. Any
    #   subsequent DescribeSecurityGroups and DescribeSecurityGroupRules
    #   calls will return the canonicalized form of the CIDR block.
    #   Additionally, if you attempt to add another rule with the
    #   non-canonical form of the CIDR (such as 100.68.0.18/18) and there is
    #   already a rule for the canonicalized form of the CIDR block (such as
    #   100.68.0.0/18), the API throws an duplicate rule error.
    #
    #    </note>
    #
    #   To specify an IPv6 address range, use IP permissions instead.
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #
    #
    #
    #   [1]: https://en.wikipedia.org/wiki/Canonicalization
    #   @return [String]
    #
    # @!attribute [rw] from_port
    #   If the protocol is TCP or UDP, this is the start of the port range.
    #   If the protocol is ICMP, this is the ICMP type or -1 (all ICMP
    #   types).
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #   @return [Integer]
    #
    # @!attribute [rw] group_id
    #   The ID of the security group.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   \[Default VPC\] The name of the security group. For security groups
    #   for a default VPC you can specify either the ID or the name of the
    #   security group. For security groups for a nondefault VPC, you must
    #   specify the ID of the security group.
    #   @return [String]
    #
    # @!attribute [rw] ip_permissions
    #   The permissions for the security group rules.
    #   @return [Array<Types::IpPermission>]
    #
    # @!attribute [rw] ip_protocol
    #   The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
    #   Numbers][1]). To specify all protocols, use `-1`.
    #
    #   To specify `icmpv6`, use IP permissions instead.
    #
    #   If you specify a protocol other than one of the supported values,
    #   traffic is allowed on all ports, regardless of any ports that you
    #   specify.
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #
    #
    #
    #   [1]: http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #   @return [String]
    #
    # @!attribute [rw] source_security_group_name
    #   \[Default VPC\] The name of the source security group.
    #
    #   The rule grants full ICMP, UDP, and TCP access. To create a rule
    #   with a specific protocol and port range, specify a set of IP
    #   permissions instead.
    #   @return [String]
    #
    # @!attribute [rw] source_security_group_owner_id
    #   The Amazon Web Services account ID for the source security group, if
    #   the source security group is in a different account.
    #
    #   The rule grants full ICMP, UDP, and TCP access. To create a rule
    #   with a specific protocol and port range, use IP permissions instead.
    #   @return [String]
    #
    # @!attribute [rw] to_port
    #   If the protocol is TCP or UDP, this is the end of the port range. If
    #   the protocol is ICMP, this is the ICMP code or -1 (all ICMP codes).
    #   If the start port is -1 (all ICMP types), then the end port must be
    #   -1 (all ICMP codes).
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags applied to the security group rule.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngressRequest AWS API Documentation
    #
    class AuthorizeSecurityGroupIngressRequest < Struct.new(
      :cidr_ip,
      :from_port,
      :group_id,
      :group_name,
      :ip_permissions,
      :ip_protocol,
      :source_security_group_name,
      :source_security_group_owner_id,
      :to_port,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, returns an error.
    #   @return [Boolean]
    #
    # @!attribute [rw] security_group_rules
    #   Information about the inbound (ingress) security group rules that
    #   were added.
    #   @return [Array<Types::SecurityGroupRule>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngressResult AWS API Documentation
    #
    class AuthorizeSecurityGroupIngressResult < Struct.new(
      :return,
      :security_group_rules)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes Availability Zones, Local Zones, and Wavelength Zones.
    #
    # @!attribute [rw] opt_in_status
    #   For Availability Zones, this parameter always has the value of
    #   `opt-in-not-required`.
    #
    #   For Local Zones and Wavelength Zones, this parameter is the opt-in
    #   status. The possible values are `opted-in` and `not-opted-in`.
    #   @return [String]
    #
    # @!attribute [rw] messages
    #   Any messages about the Availability Zone, Local Zone, or Wavelength
    #   Zone.
    #   @return [Array<Types::AvailabilityZoneMessage>]
    #
    # @!attribute [rw] region_name
    #   The name of the Region.
    #   @return [String]
    #
    # @!attribute [rw] zone_name
    #   The name of the Availability Zone, Local Zone, or Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] zone_id
    #   The ID of the Availability Zone, Local Zone, or Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   The name of the zone group. For example:
    #
    #   * Availability Zones - `us-east-1-zg-1`
    #
    #   * Local Zones - `us-west-2-lax-1`
    #
    #   * Wavelength Zones - `us-east-1-wl1-bos-wlz-1`
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   The name of the network border group.
    #   @return [String]
    #
    # @!attribute [rw] zone_type
    #   The type of zone.
    #
    #   Valid values: `availability-zone` \| `local-zone` \|
    #   `wavelength-zone`
    #   @return [String]
    #
    # @!attribute [rw] parent_zone_name
    #   The name of the zone that handles some of the Local Zone or
    #   Wavelength Zone control plane operations, such as API calls.
    #   @return [String]
    #
    # @!attribute [rw] parent_zone_id
    #   The ID of the zone that handles some of the Local Zone or Wavelength
    #   Zone control plane operations, such as API calls.
    #   @return [String]
    #
    # @!attribute [rw] group_long_name
    #   The long name of the Availability Zone group, Local Zone group, or
    #   Wavelength Zone group.
    #   @return [String]
    #
    # @!attribute [rw] geography
    #   The geography information for the Availability Zone or Local Zone.
    #   The geography is returned as a list.
    #   @return [Array<Types::AvailabilityZoneGeography>]
    #
    # @!attribute [rw] sub_geography
    #   The sub-geography information for the Availability Zone or Local
    #   Zone. The sub-geography is returned as a list.
    #   @return [Array<Types::AvailabilityZoneSubGeography>]
    #
    # @!attribute [rw] state
    #   The state of the Availability Zone, Local Zone, or Wavelength Zone.
    #   The possible values are `available`, `unavailable`, and
    #   `constrained`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZone AWS API Documentation
    #
    class AvailabilityZone < Struct.new(
      :opt_in_status,
      :messages,
      :region_name,
      :zone_name,
      :zone_id,
      :group_name,
      :network_border_group,
      :zone_type,
      :parent_zone_name,
      :parent_zone_id,
      :group_long_name,
      :geography,
      :sub_geography,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # For regional NAT gateways only: The configuration specifying which
    # Elastic IP address (EIP) to use for handling outbound NAT traffic from
    # a specific Availability Zone.
    #
    # A regional NAT gateway is a single NAT Gateway that works across
    # multiple availability zones (AZs) in your VPC, providing redundancy,
    # scalability and availability across all the AZs in a Region.
    #
    # For more information, see [Regional NAT gateways for automatic
    # multi-AZ expansion][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html
    #
    # @!attribute [rw] availability_zone
    #   For regional NAT gateways only: The Availability Zone where this
    #   specific NAT gateway configuration will be active. Each AZ in a
    #   regional NAT gateway has its own configuration to handle outbound
    #   NAT traffic from that AZ.
    #
    #   A regional NAT gateway is a single NAT Gateway that works across
    #   multiple availability zones (AZs) in your VPC, providing redundancy,
    #   scalability and availability across all the AZs in a Region.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   For regional NAT gateways only: The ID of the Availability Zone
    #   where this specific NAT gateway configuration will be active. Each
    #   AZ in a regional NAT gateway has its own configuration to handle
    #   outbound NAT traffic from that AZ. Use this instead of
    #   AvailabilityZone for consistent identification of AZs across Amazon
    #   Web Services Regions.
    #
    #   A regional NAT gateway is a single NAT Gateway that works across
    #   multiple availability zones (AZs) in your VPC, providing redundancy,
    #   scalability and availability across all the AZs in a Region.
    #   @return [String]
    #
    # @!attribute [rw] allocation_ids
    #   The allocation IDs of the Elastic IP addresses (EIPs) to be used for
    #   handling outbound NAT traffic in this specific Availability Zone.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZoneAddress AWS API Documentation
    #
    class AvailabilityZoneAddress < Struct.new(
      :availability_zone,
      :availability_zone_id,
      :allocation_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the geography information for an Availability Zone or Local
    # Zone.
    #
    # @!attribute [rw] name
    #   The name of the geography, for example, `United States of America`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZoneGeography AWS API Documentation
    #
    class AvailabilityZoneGeography < Struct.new(
      :name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a message about an Availability Zone, Local Zone, or
    # Wavelength Zone.
    #
    # @!attribute [rw] message
    #   The message about the Availability Zone, Local Zone, or Wavelength
    #   Zone.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZoneMessage AWS API Documentation
    #
    class AvailabilityZoneMessage < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the sub-geography information for an Availability Zone or
    # Local Zone.
    #
    # @!attribute [rw] name
    #   The name of the sub-geography, for example, `Oregon.`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZoneSubGeography AWS API Documentation
    #
    class AvailabilityZoneSubGeography < Struct.new(
      :name)
      SENSITIVE = []
      include Aws::Structure
    end

    # The capacity information for instances that can be launched onto the
    # Dedicated Host.
    #
    # @!attribute [rw] available_instance_capacity
    #   The number of instances that can be launched onto the Dedicated Host
    #   depending on the host's available capacity. For Dedicated Hosts
    #   that support multiple instance types, this parameter represents the
    #   number of instances for each instance size that is supported on the
    #   host.
    #   @return [Array<Types::InstanceCapacity>]
    #
    # @!attribute [rw] available_v_cpus
    #   The number of vCPUs available for launching instances onto the
    #   Dedicated Host.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailableCapacity AWS API Documentation
    #
    class AvailableCapacity < Struct.new(
      :available_instance_capacity,
      :available_v_cpus)
      SENSITIVE = []
      include Aws::Structure
    end

    # The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For
    # more information, see [Amazon EBS–optimized instances][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html
    #
    # @!attribute [rw] min
    #   The minimum baseline bandwidth, in Mbps. If this parameter is not
    #   specified, there is no minimum limit.
    #   @return [Integer]
    #
    # @!attribute [rw] max
    #   The maximum baseline bandwidth, in Mbps. If this parameter is not
    #   specified, there is no maximum limit.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BaselineEbsBandwidthMbps AWS API Documentation
    #
    class BaselineEbsBandwidthMbps < Struct.new(
      :min,
      :max)
      SENSITIVE = []
      include Aws::Structure
    end

    # The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For
    # more information, see [Amazon EBS–optimized instances][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html
    #
    # @!attribute [rw] min
    #   The minimum baseline bandwidth, in Mbps. To specify no minimum
    #   limit, omit this parameter.
    #   @return [Integer]
    #
    # @!attribute [rw] max
    #   The maximum baseline bandwidth, in Mbps. To specify no maximum
    #   limit, omit this parameter.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BaselineEbsBandwidthMbpsRequest AWS API Documentation
    #
    class BaselineEbsBandwidthMbpsRequest < Struct.new(
      :min,
      :max)
      SENSITIVE = []
      include Aws::Structure
    end

    # The baseline performance to consider, using an instance family as a
    # baseline reference. The instance family establishes the lowest
    # acceptable level of performance. Amazon EC2 uses this baseline to
    # guide instance type selection, but there is no guarantee that the
    # selected instance types will always exceed the baseline for every
    # application.
    #
    # Currently, this parameter only supports CPU performance as a baseline
    # performance factor. For example, specifying `c6i` would use the CPU
    # performance of the `c6i` family as the baseline reference.
    #
    # @!attribute [rw] cpu
    #   The CPU performance to consider, using an instance family as the
    #   baseline reference.
    #   @return [Types::CpuPerformanceFactor]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BaselinePerformanceFactors AWS API Documentation
    #
    class BaselinePerformanceFactors < Struct.new(
      :cpu)
      SENSITIVE = []
      include Aws::Structure
    end

    # The baseline performance to consider, using an instance family as a
    # baseline reference. The instance family establishes the lowest
    # acceptable level of performance. Amazon EC2 uses this baseline to
    # guide instance type selection, but there is no guarantee that the
    # selected instance types will always exceed the baseline for every
    # application.
    #
    # Currently, this parameter only supports CPU performance as a baseline
    # performance factor. For example, specifying `c6i` would use the CPU
    # performance of the `c6i` family as the baseline reference.
    #
    # @!attribute [rw] cpu
    #   The CPU performance to consider, using an instance family as the
    #   baseline reference.
    #   @return [Types::CpuPerformanceFactorRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BaselinePerformanceFactorsRequest AWS API Documentation
    #
    class BaselinePerformanceFactorsRequest < Struct.new(
      :cpu)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] value
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlobAttributeValue AWS API Documentation
    #
    class BlobAttributeValue < Struct.new(
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a block device mapping, which defines the EBS volumes and
    # instance store volumes to attach to an instance at launch.
    #
    # @!attribute [rw] ebs
    #   Parameters used to automatically set up EBS volumes when the
    #   instance is launched.
    #   @return [Types::EbsBlockDevice]
    #
    # @!attribute [rw] no_device
    #   To omit the device from the block device mapping, specify an empty
    #   string. When this property is specified, the device is removed from
    #   the block device mapping regardless of the assigned value.
    #   @return [String]
    #
    # @!attribute [rw] device_name
    #   The device name. For available device names, see [Device names for
    #   volumes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html
    #   @return [String]
    #
    # @!attribute [rw] virtual_name
    #   The virtual device name (`ephemeral`N). Instance store volumes are
    #   numbered starting from 0. An instance type with 2 available instance
    #   store volumes can specify mappings for `ephemeral0` and
    #   `ephemeral1`. The number of available instance store volumes depends
    #   on the instance type. After you connect to the instance, you must
    #   mount the volume.
    #
    #   NVMe instance store volumes are automatically enumerated and
    #   assigned a device name. Including them in your block device mapping
    #   has no effect.
    #
    #   Constraints: For M3 instances, you must specify instance store
    #   volumes in the block device mapping for the instance. When you
    #   launch an M3 instance, we ignore any instance store volumes
    #   specified in the block device mapping for the AMI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlockDeviceMapping AWS API Documentation
    #
    class BlockDeviceMapping < Struct.new(
      :ebs,
      :no_device,
      :device_name,
      :virtual_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a block device mapping, which defines the EBS volumes and
    # instance store volumes to attach to an instance at launch.
    #
    # @!attribute [rw] device_name
    #   The device name (for example, `/dev/sdh` or `xvdh`).
    #   @return [String]
    #
    # @!attribute [rw] virtual_name
    #   The virtual device name.
    #   @return [String]
    #
    # @!attribute [rw] ebs
    #   Parameters used to automatically set up EBS volumes when the
    #   instance is launched.
    #   @return [Types::EbsBlockDeviceResponse]
    #
    # @!attribute [rw] no_device
    #   Suppresses the specified device included in the block device
    #   mapping.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlockDeviceMappingResponse AWS API Documentation
    #
    class BlockDeviceMappingResponse < Struct.new(
      :device_name,
      :virtual_name,
      :ebs,
      :no_device)
      SENSITIVE = []
      include Aws::Structure
    end

    # The state of VPC Block Public Access (BPA).
    #
    # @!attribute [rw] internet_gateway_block_mode
    #   The mode of VPC BPA.
    #
    #   * `off`: VPC BPA is not enabled and traffic is allowed to and from
    #     internet gateways and egress-only internet gateways in this
    #     Region.
    #
    #   * `block-bidirectional`: Block all traffic to and from internet
    #     gateways and egress-only internet gateways in this Region (except
    #     for excluded VPCs and subnets).
    #
    #   * `block-ingress`: Block all internet traffic to the VPCs in this
    #     Region (except for VPCs or subnets which are excluded). Only
    #     traffic to and from NAT gateways and egress-only internet gateways
    #     is allowed because these gateways only allow outbound connections
    #     to be established.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlockPublicAccessStates AWS API Documentation
    #
    class BlockPublicAccessStates < Struct.new(
      :internet_gateway_block_mode)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for BundleInstance.
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance to bundle.
    #
    #   Default: None
    #   @return [String]
    #
    # @!attribute [rw] storage
    #   The bucket in which to store the AMI. You can specify a bucket that
    #   you already own or a new bucket that Amazon EC2 creates on your
    #   behalf. If you specify a bucket that belongs to someone else, Amazon
    #   EC2 returns an error.
    #   @return [Types::Storage]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstanceRequest AWS API Documentation
    #
    class BundleInstanceRequest < Struct.new(
      :instance_id,
      :storage,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of BundleInstance.
    #
    # @!attribute [rw] bundle_task
    #   Information about the bundle task.
    #   @return [Types::BundleTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstanceResult AWS API Documentation
    #
    class BundleInstanceResult < Struct.new(
      :bundle_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a bundle task.
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance associated with this bundle task.
    #   @return [String]
    #
    # @!attribute [rw] bundle_id
    #   The ID of the bundle task.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the task.
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The time this task started.
    #   @return [Time]
    #
    # @!attribute [rw] update_time
    #   The time of the most recent update for the task.
    #   @return [Time]
    #
    # @!attribute [rw] storage
    #   The Amazon S3 storage locations.
    #   @return [Types::Storage]
    #
    # @!attribute [rw] progress
    #   The level of task completion, as a percent (for example, 20%).
    #   @return [String]
    #
    # @!attribute [rw] bundle_task_error
    #   If the task fails, a description of the error.
    #   @return [Types::BundleTaskError]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTask AWS API Documentation
    #
    class BundleTask < Struct.new(
      :instance_id,
      :bundle_id,
      :state,
      :start_time,
      :update_time,
      :storage,
      :progress,
      :bundle_task_error)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an error for BundleInstance.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The error message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTaskError AWS API Documentation
    #
    class BundleTaskError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The Autonomous System Number (ASN) and BYOIP CIDR association.
    #
    # @!attribute [rw] asn
    #   A public 2-byte or 4-byte ASN.
    #   @return [String]
    #
    # @!attribute [rw] ipam_id
    #   An IPAM ID.
    #   @return [String]
    #
    # @!attribute [rw] status_message
    #   The status message.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The provisioning state of the BYOASN.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Byoasn AWS API Documentation
    #
    class Byoasn < Struct.new(
      :asn,
      :ipam_id,
      :status_message,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about an address range that is provisioned for use with
    # your Amazon Web Services resources through bring your own IP addresses
    # (BYOIP).
    #
    # @!attribute [rw] cidr
    #   The address range, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description of the address range.
    #   @return [String]
    #
    # @!attribute [rw] asn_associations
    #   The BYOIP CIDR associations with ASNs.
    #   @return [Array<Types::AsnAssociation>]
    #
    # @!attribute [rw] status_message
    #   Upon success, contains the ID of the address pool. Otherwise,
    #   contains an error message.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the address range.
    #
    #   * `advertised`: The address range is being advertised to the
    #     internet by Amazon Web Services.
    #
    #   * `deprovisioned`: The address range is deprovisioned.
    #
    #   * `failed-deprovision`: The request to deprovision the address range
    #     was unsuccessful. Ensure that all EIPs from the range have been
    #     deallocated and try again.
    #
    #   * `failed-provision`: The request to provision the address range was
    #     unsuccessful.
    #
    #   * `pending-deprovision`: You’ve submitted a request to deprovision
    #     an address range and it's pending.
    #
    #   * `pending-provision`: You’ve submitted a request to provision an
    #     address range and it's pending.
    #
    #   * `provisioned`: The address range is provisioned and can be
    #     advertised. The range is not currently advertised.
    #
    #   * `provisioned-not-publicly-advertisable`: The address range is
    #     provisioned and cannot be advertised.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   If you have [Local Zones][1] enabled, you can choose a network
    #   border group for Local Zones when you provision and advertise a
    #   BYOIPv4 CIDR. Choose the network border group carefully as the EIP
    #   and the Amazon Web Services resource it is associated with must
    #   reside in the same network border group.
    #
    #   You can provision BYOIP address ranges to and advertise them in the
    #   following Local Zone network border groups:
    #
    #   * us-east-1-dfw-2
    #
    #   * us-west-2-lax-1
    #
    #   * us-west-2-phx-2
    #
    #   <note markdown="1"> You cannot provision or advertise BYOIPv6 address ranges in Local
    #   Zones at this time.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html
    #   @return [String]
    #
    # @!attribute [rw] advertisement_type
    #   Specifies the advertisement method for the BYOIP CIDR. Valid values
    #   are:
    #
    #   * `unicast`: IP is advertised from a single location (regional
    #     services like EC2)
    #
    #   * `anycast`: IP is advertised from multiple global locations
    #     simultaneously (global services like CloudFront)
    #
    #   For more information, see [Bring your own IP to CloudFront using
    #   IPAM][1] in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoip-cloudfront.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ByoipCidr AWS API Documentation
    #
    class ByoipCidr < Struct.new(
      :cidr,
      :description,
      :asn_associations,
      :status_message,
      :state,
      :network_border_group,
      :advertisement_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelBundleTask.
    #
    # @!attribute [rw] bundle_id
    #   The ID of the bundle task.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTaskRequest AWS API Documentation
    #
    class CancelBundleTaskRequest < Struct.new(
      :bundle_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelBundleTask.
    #
    # @!attribute [rw] bundle_task
    #   Information about the bundle task.
    #   @return [Types::BundleTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTaskResult AWS API Documentation
    #
    class CancelBundleTaskResult < Struct.new(
      :bundle_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Capacity Reservation Fleet cancellation error.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The error message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleetError AWS API Documentation
    #
    class CancelCapacityReservationFleetError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] capacity_reservation_fleet_ids
    #   The IDs of the Capacity Reservation Fleets to cancel.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleetsRequest AWS API Documentation
    #
    class CancelCapacityReservationFleetsRequest < Struct.new(
      :dry_run,
      :capacity_reservation_fleet_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successful_fleet_cancellations
    #   Information about the Capacity Reservation Fleets that were
    #   successfully cancelled.
    #   @return [Array<Types::CapacityReservationFleetCancellationState>]
    #
    # @!attribute [rw] failed_fleet_cancellations
    #   Information about the Capacity Reservation Fleets that could not be
    #   cancelled.
    #   @return [Array<Types::FailedCapacityReservationFleetCancellationResult>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleetsResult AWS API Documentation
    #
    class CancelCapacityReservationFleetsResult < Struct.new(
      :successful_fleet_cancellations,
      :failed_fleet_cancellations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation to be cancelled.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationRequest AWS API Documentation
    #
    class CancelCapacityReservationRequest < Struct.new(
      :capacity_reservation_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationResult AWS API Documentation
    #
    class CancelCapacityReservationResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] conversion_task_id
    #   The ID of the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] reason_message
    #   The reason for canceling the conversion task.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionRequest AWS API Documentation
    #
    class CancelConversionRequest < Struct.new(
      :dry_run,
      :conversion_task_id,
      :reason_message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] report_id
    #   The ID of the report.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelDeclarativePoliciesReportRequest AWS API Documentation
    #
    class CancelDeclarativePoliciesReportRequest < Struct.new(
      :dry_run,
      :report_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Is `true` if the request succeeds, and an error otherwise.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelDeclarativePoliciesReportResult AWS API Documentation
    #
    class CancelDeclarativePoliciesReportResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] export_task_id
    #   The ID of the export task. This is the ID returned by the
    #   `CreateInstanceExportTask` and `ExportImage` operations.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTaskRequest AWS API Documentation
    #
    class CancelExportTaskRequest < Struct.new(
      :export_task_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_id
    #   The ID of the AMI that was shared with your Amazon Web Services
    #   account.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermissionRequest AWS API Documentation
    #
    class CancelImageLaunchPermissionRequest < Struct.new(
      :image_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermissionResult AWS API Documentation
    #
    class CancelImageLaunchPermissionResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cancel_reason
    #   The reason for canceling the task.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] import_task_id
    #   The ID of the import image or import snapshot task to be canceled.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTaskRequest AWS API Documentation
    #
    class CancelImportTaskRequest < Struct.new(
      :cancel_reason,
      :dry_run,
      :import_task_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] import_task_id
    #   The ID of the task being canceled.
    #   @return [String]
    #
    # @!attribute [rw] previous_state
    #   The current state of the task being canceled.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The current state of the task being canceled.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTaskResult AWS API Documentation
    #
    class CancelImportTaskResult < Struct.new(
      :import_task_id,
      :previous_state,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelReservedInstancesListing.
    #
    # @!attribute [rw] reserved_instances_listing_id
    #   The ID of the Reserved Instance listing.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListingRequest AWS API Documentation
    #
    class CancelReservedInstancesListingRequest < Struct.new(
      :reserved_instances_listing_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelReservedInstancesListing.
    #
    # @!attribute [rw] reserved_instances_listings
    #   The Reserved Instance listing.
    #   @return [Array<Types::ReservedInstancesListing>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListingResult AWS API Documentation
    #
    class CancelReservedInstancesListingResult < Struct.new(
      :reserved_instances_listings)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Spot Fleet error.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The description for the error code.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsError AWS API Documentation
    #
    class CancelSpotFleetRequestsError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Spot Fleet request that was not successfully canceled.
    #
    # @!attribute [rw] error
    #   The error.
    #   @return [Types::CancelSpotFleetRequestsError]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsErrorItem AWS API Documentation
    #
    class CancelSpotFleetRequestsErrorItem < Struct.new(
      :error,
      :spot_fleet_request_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelSpotFleetRequests.
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] spot_fleet_request_ids
    #   The IDs of the Spot Fleet requests.
    #
    #   Constraint: You can specify up to 100 IDs in a single request.
    #   @return [Array<String>]
    #
    # @!attribute [rw] terminate_instances
    #   Indicates whether to terminate the associated instances when the
    #   Spot Fleet request is canceled. The default is to terminate the
    #   instances.
    #
    #   To let the instances continue to run after the Spot Fleet request is
    #   canceled, specify `no-terminate-instances`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsRequest AWS API Documentation
    #
    class CancelSpotFleetRequestsRequest < Struct.new(
      :dry_run,
      :spot_fleet_request_ids,
      :terminate_instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelSpotFleetRequests.
    #
    # @!attribute [rw] successful_fleet_requests
    #   Information about the Spot Fleet requests that are successfully
    #   canceled.
    #   @return [Array<Types::CancelSpotFleetRequestsSuccessItem>]
    #
    # @!attribute [rw] unsuccessful_fleet_requests
    #   Information about the Spot Fleet requests that are not successfully
    #   canceled.
    #   @return [Array<Types::CancelSpotFleetRequestsErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsResponse AWS API Documentation
    #
    class CancelSpotFleetRequestsResponse < Struct.new(
      :successful_fleet_requests,
      :unsuccessful_fleet_requests)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Spot Fleet request that was successfully canceled.
    #
    # @!attribute [rw] current_spot_fleet_request_state
    #   The current state of the Spot Fleet request.
    #   @return [String]
    #
    # @!attribute [rw] previous_spot_fleet_request_state
    #   The previous state of the Spot Fleet request.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsSuccessItem AWS API Documentation
    #
    class CancelSpotFleetRequestsSuccessItem < Struct.new(
      :current_spot_fleet_request_state,
      :previous_spot_fleet_request_state,
      :spot_fleet_request_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelSpotInstanceRequests.
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] spot_instance_request_ids
    #   The IDs of the Spot Instance requests.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequestsRequest AWS API Documentation
    #
    class CancelSpotInstanceRequestsRequest < Struct.new(
      :dry_run,
      :spot_instance_request_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelSpotInstanceRequests.
    #
    # @!attribute [rw] cancelled_spot_instance_requests
    #   The Spot Instance requests.
    #   @return [Array<Types::CancelledSpotInstanceRequest>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequestsResult AWS API Documentation
    #
    class CancelSpotInstanceRequestsResult < Struct.new(
      :cancelled_spot_instance_requests)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a request to cancel a Spot Instance.
    #
    # @!attribute [rw] spot_instance_request_id
    #   The ID of the Spot Instance request.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the Spot Instance request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelledSpotInstanceRequest AWS API Documentation
    #
    class CancelledSpotInstanceRequest < Struct.new(
      :spot_instance_request_id,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about instance capacity usage for a Capacity Reservation.
    #
    # @!attribute [rw] allocation_type
    #   The usage type. `used` indicates that the instance capacity is in
    #   use by instances that are running in the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] count
    #   The amount of instance capacity associated with the usage. For
    #   example a value of `4` indicates that instance capacity for 4
    #   instances is currently in use.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityAllocation AWS API Documentation
    #
    class CapacityAllocation < Struct.new(
      :allocation_type,
      :count)
      SENSITIVE = []
      include Aws::Structure
    end

    # Reserve powerful GPU instances on a future date to support your short
    # duration machine learning (ML) workloads. Instances that run inside a
    # Capacity Block are automatically placed close together inside [Amazon
    # EC2 UltraClusters][1], for low-latency, petabit-scale, non-blocking
    # networking.
    #
    # You can also reserve Amazon EC2 UltraServers. UltraServers connect
    # multiple EC2 instances using a low-latency, high-bandwidth accelerator
    # interconnect (NeuronLink). They are built to tackle very large-scale
    # AI/ML workloads that require significant processing power. For more
    # information, see Amazon EC2 UltraServers.
    #
    #
    #
    # [1]: http://aws.amazon.com/ec2/ultraclusters/
    #
    # @!attribute [rw] capacity_block_id
    #   The ID of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] ultraserver_type
    #   The EC2 UltraServer type of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The Availability Zone ID of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_ids
    #   The ID of the Capacity Reservation.
    #   @return [Array<String>]
    #
    # @!attribute [rw] start_date
    #   The date and time at which the Capacity Block was started.
    #   @return [Time]
    #
    # @!attribute [rw] end_date
    #   The date and time at which the Capacity Block expires. When a
    #   Capacity Block expires, all instances in the Capacity Block are
    #   terminated.
    #   @return [Time]
    #
    # @!attribute [rw] create_date
    #   The date and time at which the Capacity Block was created.
    #   @return [Time]
    #
    # @!attribute [rw] state
    #   The state of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags assigned to the Capacity Block.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityBlock AWS API Documentation
    #
    class CapacityBlock < Struct.new(
      :capacity_block_id,
      :ultraserver_type,
      :availability_zone,
      :availability_zone_id,
      :capacity_reservation_ids,
      :start_date,
      :end_date,
      :create_date,
      :state,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Capacity Block extension. With an extension, you can
    # extend the duration of time for an existing Capacity Block.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The reservation ID of the Capacity Block extension.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type of the Capacity Block extension.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances in the Capacity Block extension.
    #   @return [Integer]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone of the Capacity Block extension.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The Availability Zone ID of the Capacity Block extension.
    #   @return [String]
    #
    # @!attribute [rw] capacity_block_extension_offering_id
    #   The ID of the Capacity Block extension offering.
    #   @return [String]
    #
    # @!attribute [rw] capacity_block_extension_duration_hours
    #   The duration of the Capacity Block extension in hours.
    #   @return [Integer]
    #
    # @!attribute [rw] capacity_block_extension_status
    #   The status of the Capacity Block extension. A Capacity Block
    #   extension can have one of the following statuses:
    #
    #   * `payment-pending` - The Capacity Block extension payment is
    #     processing. If your payment can't be processed within 12 hours,
    #     the Capacity Block extension is failed.
    #
    #   * `payment-failed` - Payment for the Capacity Block extension
    #     request was not successful.
    #
    #   * `payment-succeeded` - Payment for the Capacity Block extension
    #     request was successful. You receive an invoice that reflects the
    #     one-time upfront payment. In the invoice, you can associate the
    #     paid amount with the Capacity Block reservation ID.
    #   @return [String]
    #
    # @!attribute [rw] capacity_block_extension_purchase_date
    #   The date when the Capacity Block extension was purchased.
    #   @return [Time]
    #
    # @!attribute [rw] capacity_block_extension_start_date
    #   The start date of the Capacity Block extension.
    #   @return [Time]
    #
    # @!attribute [rw] capacity_block_extension_end_date
    #   The end date of the Capacity Block extension.
    #   @return [Time]
    #
    # @!attribute [rw] upfront_fee
    #   The total price to be paid up front.
    #   @return [String]
    #
    # @!attribute [rw] currency_code
    #   The currency of the payment for the Capacity Block extension.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityBlockExtension AWS API Documentation
    #
    class CapacityBlockExtension < Struct.new(
      :capacity_reservation_id,
      :instance_type,
      :instance_count,
      :availability_zone,
      :availability_zone_id,
      :capacity_block_extension_offering_id,
      :capacity_block_extension_duration_hours,
      :capacity_block_extension_status,
      :capacity_block_extension_purchase_date,
      :capacity_block_extension_start_date,
      :capacity_block_extension_end_date,
      :upfront_fee,
      :currency_code)
      SENSITIVE = []
      include Aws::Structure
    end

    # The recommended Capacity Block extension that fits your search
    # requirements.
    #
    # @!attribute [rw] capacity_block_extension_offering_id
    #   The ID of the Capacity Block extension offering.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type of the Capacity Block that will be extended.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances in the Capacity Block extension offering.
    #   @return [Integer]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone of the Capacity Block that will be extended.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The Availability Zone ID of the Capacity Block that will be
    #   extended.
    #   @return [String]
    #
    # @!attribute [rw] start_date
    #   The start date of the Capacity Block that will be extended.
    #   @return [Time]
    #
    # @!attribute [rw] capacity_block_extension_start_date
    #   The date and time at which the Capacity Block extension will start.
    #   This date is also the same as the end date of the Capacity Block
    #   that will be extended.
    #   @return [Time]
    #
    # @!attribute [rw] capacity_block_extension_end_date
    #   The date and time at which the Capacity Block extension expires.
    #   When a Capacity Block expires, the reserved capacity is released and
    #   you can no longer launch instances into it. The Capacity Block's
    #   state changes to `expired` when it reaches its end date
    #   @return [Time]
    #
    # @!attribute [rw] capacity_block_extension_duration_hours
    #   The amount of time of the Capacity Block extension offering in
    #   hours.
    #   @return [Integer]
    #
    # @!attribute [rw] upfront_fee
    #   The total price of the Capacity Block extension offering, to be paid
    #   up front.
    #   @return [String]
    #
    # @!attribute [rw] currency_code
    #   The currency of the payment for the Capacity Block extension
    #   offering.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   Indicates the tenancy of the Capacity Block extension offering. A
    #   Capacity Block can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Block is created on hardware that is
    #     shared with other Amazon Web Services accounts.
    #
    #   * `dedicated` - The Capacity Block is created on single-tenant
    #     hardware that is dedicated to a single Amazon Web Services
    #     account.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityBlockExtensionOffering AWS API Documentation
    #
    class CapacityBlockExtensionOffering < Struct.new(
      :capacity_block_extension_offering_id,
      :instance_type,
      :instance_count,
      :availability_zone,
      :availability_zone_id,
      :start_date,
      :capacity_block_extension_start_date,
      :capacity_block_extension_end_date,
      :capacity_block_extension_duration_hours,
      :upfront_fee,
      :currency_code,
      :tenancy)
      SENSITIVE = []
      include Aws::Structure
    end

    # The recommended Capacity Block that fits your search requirements.
    #
    # @!attribute [rw] capacity_block_offering_id
    #   The ID of the Capacity Block offering.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type of the Capacity Block offering.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone of the Capacity Block offering.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances in the Capacity Block offering.
    #   @return [Integer]
    #
    # @!attribute [rw] start_date
    #   The start date of the Capacity Block offering.
    #   @return [Time]
    #
    # @!attribute [rw] end_date
    #   The end date of the Capacity Block offering.
    #   @return [Time]
    #
    # @!attribute [rw] capacity_block_duration_hours
    #   The number of hours (in addition to `capacityBlockDurationMinutes`)
    #   for the duration of the Capacity Block reservation. For example, if
    #   a Capacity Block starts at **04:55** and ends at **11:30**, the
    #   hours field would be **6**.
    #   @return [Integer]
    #
    # @!attribute [rw] upfront_fee
    #   The total price to be paid up front.
    #   @return [String]
    #
    # @!attribute [rw] currency_code
    #   The currency of the payment for the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   The tenancy of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] ultraserver_type
    #   The EC2 UltraServer type of the Capacity Block offering.
    #   @return [String]
    #
    # @!attribute [rw] ultraserver_count
    #   The number of EC2 UltraServers in the offering.
    #   @return [Integer]
    #
    # @!attribute [rw] capacity_block_duration_minutes
    #   The number of minutes (in addition to `capacityBlockDurationHours`)
    #   for the duration of the Capacity Block reservation. For example, if
    #   a Capacity Block starts at **08:55** and ends at **11:30**, the
    #   minutes field would be **35**.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityBlockOffering AWS API Documentation
    #
    class CapacityBlockOffering < Struct.new(
      :capacity_block_offering_id,
      :instance_type,
      :availability_zone,
      :instance_count,
      :start_date,
      :end_date,
      :capacity_block_duration_hours,
      :upfront_fee,
      :currency_code,
      :tenancy,
      :ultraserver_type,
      :ultraserver_count,
      :capacity_block_duration_minutes)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the availability of capacity for a Capacity Block.
    #
    # @!attribute [rw] capacity_block_id
    #   The ID of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] interconnect_status
    #   The status of the high-bandwidth accelerator interconnect. Possible
    #   states include:
    #
    #   * `ok` the accelerator interconnect is healthy.
    #
    #   * `impaired` - accelerator interconnect communication is impaired.
    #
    #   * `insufficient-data` - insufficient data to determine accelerator
    #     interconnect status.
    #   @return [String]
    #
    # @!attribute [rw] total_capacity
    #   The combined amount of `Available` and `Unavailable` capacity in the
    #   Capacity Block.
    #   @return [Integer]
    #
    # @!attribute [rw] total_available_capacity
    #   The remaining capacity. Indicates the number of resources that can
    #   be launched into the Capacity Block.
    #   @return [Integer]
    #
    # @!attribute [rw] total_unavailable_capacity
    #   The unavailable capacity. Indicates the instance capacity that is
    #   unavailable for use due to a system status check failure.
    #   @return [Integer]
    #
    # @!attribute [rw] capacity_reservation_statuses
    #   The availability of capacity for the Capacity Block reservations.
    #   @return [Array<Types::CapacityReservationStatus>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityBlockStatus AWS API Documentation
    #
    class CapacityBlockStatus < Struct.new(
      :capacity_block_id,
      :interconnect_status,
      :total_capacity,
      :total_available_capacity,
      :total_unavailable_capacity,
      :capacity_reservation_statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Represents a filter condition for Capacity Manager queries. Contains
    # dimension-based filtering criteria used to narrow down metric data and
    # dimension results.
    #
    # @!attribute [rw] dimension_condition
    #   The dimension-based condition that specifies how to filter the data
    #   based on dimension values.
    #   @return [Types::DimensionCondition]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityManagerCondition AWS API Documentation
    #
    class CapacityManagerCondition < Struct.new(
      :dimension_condition)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains information about a Capacity Manager data export
    # configuration, including export settings, delivery status, and recent
    # export activity.
    #
    # @!attribute [rw] capacity_manager_data_export_id
    #   The unique identifier for the data export configuration.
    #   @return [String]
    #
    # @!attribute [rw] s3_bucket_name
    #   The name of the S3 bucket where export files are delivered.
    #   @return [String]
    #
    # @!attribute [rw] s3_bucket_prefix
    #   The S3 key prefix used for organizing export files within the
    #   bucket.
    #   @return [String]
    #
    # @!attribute [rw] schedule
    #   The frequency at which data exports are generated.
    #   @return [String]
    #
    # @!attribute [rw] output_format
    #   The file format of the exported data.
    #   @return [String]
    #
    # @!attribute [rw] create_time
    #   The timestamp when the data export configuration was created.
    #   @return [Time]
    #
    # @!attribute [rw] latest_delivery_status
    #   The status of the most recent export delivery.
    #   @return [String]
    #
    # @!attribute [rw] latest_delivery_status_message
    #   A message describing the status of the most recent export delivery,
    #   including any error details if the delivery failed.
    #   @return [String]
    #
    # @!attribute [rw] latest_delivery_s3_location_uri
    #   The S3 URI of the most recently delivered export file.
    #   @return [String]
    #
    # @!attribute [rw] latest_delivery_time
    #   The timestamp when the most recent export was delivered to S3.
    #   @return [Time]
    #
    # @!attribute [rw] tags
    #   The tags associated with the data export configuration.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityManagerDataExportResponse AWS API Documentation
    #
    class CapacityManagerDataExportResponse < Struct.new(
      :capacity_manager_data_export_id,
      :s3_bucket_name,
      :s3_bucket_prefix,
      :schedule,
      :output_format,
      :create_time,
      :latest_delivery_status,
      :latest_delivery_status_message,
      :latest_delivery_s3_location_uri,
      :latest_delivery_time,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Represents dimension values for capacity metrics, including resource
    # identifiers, geographic information, and reservation details used for
    # grouping and filtering capacity data.
    #
    # @!attribute [rw] resource_region
    #   The Amazon Web Services Region where the capacity resource is
    #   located.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The unique identifier of the Availability Zone where the capacity
    #   resource is located.
    #   @return [String]
    #
    # @!attribute [rw] account_id
    #   The Amazon Web Services account ID that owns the capacity resource.
    #   @return [String]
    #
    # @!attribute [rw] instance_family
    #   The EC2 instance family of the capacity resource.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The specific EC2 instance type of the capacity resource.
    #   @return [String]
    #
    # @!attribute [rw] instance_platform
    #   The platform or operating system of the instance.
    #   @return [String]
    #
    # @!attribute [rw] reservation_arn
    #   The Amazon Resource Name (ARN) of the capacity reservation. This
    #   provides a unique identifier that can be used across Amazon Web
    #   Services services to reference the specific reservation.
    #   @return [String]
    #
    # @!attribute [rw] reservation_id
    #   The unique identifier of the capacity reservation.
    #   @return [String]
    #
    # @!attribute [rw] reservation_type
    #   The type of capacity reservation.
    #   @return [String]
    #
    # @!attribute [rw] reservation_create_timestamp
    #   The timestamp when the capacity reservation was originally created,
    #   in milliseconds since epoch. This differs from the start timestamp
    #   as reservations can be created before they become active.
    #   @return [Time]
    #
    # @!attribute [rw] reservation_start_timestamp
    #   The timestamp when the capacity reservation becomes active and
    #   available for use, in milliseconds since epoch. This is when the
    #   reservation begins providing capacity.
    #   @return [Time]
    #
    # @!attribute [rw] reservation_end_timestamp
    #   The timestamp when the capacity reservation expires and is no longer
    #   available, in milliseconds since epoch. After this time, the
    #   reservation will not provide any capacity.
    #   @return [Time]
    #
    # @!attribute [rw] reservation_end_date_type
    #   The type of end date for the capacity reservation. This indicates
    #   whether the reservation has a fixed end date, is open-ended, or
    #   follows a specific termination pattern.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   The tenancy of the EC2 instances associated with this capacity
    #   dimension. Valid values are 'default' for shared tenancy,
    #   'dedicated' for dedicated instances, or 'host' for dedicated
    #   hosts.
    #   @return [String]
    #
    # @!attribute [rw] reservation_state
    #   The current state of the capacity reservation.
    #   @return [String]
    #
    # @!attribute [rw] reservation_instance_match_criteria
    #   The instance matching criteria for the capacity reservation,
    #   determining how instances are matched to the reservation.
    #   @return [String]
    #
    # @!attribute [rw] reservation_unused_financial_owner
    #   The Amazon Web Services account ID that is financially responsible
    #   for unused capacity reservation costs.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityManagerDimension AWS API Documentation
    #
    class CapacityManagerDimension < Struct.new(
      :resource_region,
      :availability_zone_id,
      :account_id,
      :instance_family,
      :instance_type,
      :instance_platform,
      :reservation_arn,
      :reservation_id,
      :reservation_type,
      :reservation_create_timestamp,
      :reservation_start_timestamp,
      :reservation_end_timestamp,
      :reservation_end_date_type,
      :tenancy,
      :reservation_state,
      :reservation_instance_match_criteria,
      :reservation_unused_financial_owner)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Capacity Reservation.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the Amazon Web Services account that owns the Capacity
    #   Reservation.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_arn
    #   The Amazon Resource Name (ARN) of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone in which the capacity is reserved.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The type of instance for which the Capacity Reservation reserves
    #   capacity.
    #   @return [String]
    #
    # @!attribute [rw] instance_platform
    #   The type of operating system for which the Capacity Reservation
    #   reserves capacity.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which the capacity is reserved.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   Indicates the tenancy of the Capacity Reservation. A Capacity
    #   Reservation can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation is created on hardware that
    #     is shared with other Amazon Web Services accounts.
    #
    #   * `dedicated` - The Capacity Reservation is created on single-tenant
    #     hardware that is dedicated to a single Amazon Web Services
    #     account.
    #   @return [String]
    #
    # @!attribute [rw] total_instance_count
    #   The total number of instances for which the Capacity Reservation
    #   reserves capacity.
    #   @return [Integer]
    #
    # @!attribute [rw] available_instance_count
    #   The remaining capacity. Indicates the number of instances that can
    #   be launched in the Capacity Reservation.
    #   @return [Integer]
    #
    # @!attribute [rw] ebs_optimized
    #   Indicates whether the Capacity Reservation supports EBS-optimized
    #   instances. This optimization provides dedicated throughput to Amazon
    #   EBS and an optimized configuration stack to provide optimal I/O
    #   performance. This optimization isn't available with all instance
    #   types. Additional usage charges apply when using an EBS- optimized
    #   instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] ephemeral_storage
    #   *Deprecated.*
    #   @return [Boolean]
    #
    # @!attribute [rw] state
    #   The current state of the Capacity Reservation. A Capacity
    #   Reservation can be in one of the following states:
    #
    #   * `active` - The capacity is available for use.
    #
    #   * `expired` - The Capacity Reservation expired automatically at the
    #     date and time specified in your reservation request. The reserved
    #     capacity is no longer available for your use.
    #
    #   * `cancelled` - The Capacity Reservation was canceled. The reserved
    #     capacity is no longer available for your use.
    #
    #   * `pending` - The Capacity Reservation request was successful but
    #     the capacity provisioning is still pending.
    #
    #   * `failed` - The Capacity Reservation request has failed. A request
    #     can fail due to request parameters that are not valid, capacity
    #     constraints, or instance limit constraints. You can view a failed
    #     request for 60 minutes.
    #
    #   * `scheduled` - (*Future-dated Capacity Reservations*) The
    #     future-dated Capacity Reservation request was approved and the
    #     Capacity Reservation is scheduled for delivery on the requested
    #     start date.
    #
    #   * `payment-pending` - (*Capacity Blocks*) The upfront payment has
    #     not been processed yet.
    #
    #   * `payment-failed` - (*Capacity Blocks*) The upfront payment was not
    #     processed in the 12-hour time frame. Your Capacity Block was
    #     released.
    #
    #   * `assessing` - (*Future-dated Capacity Reservations*) Amazon EC2 is
    #     assessing your request for a future-dated Capacity Reservation.
    #
    #   * `delayed` - (*Future-dated Capacity Reservations*) Amazon EC2
    #     encountered a delay in provisioning the requested future-dated
    #     Capacity Reservation. Amazon EC2 is unable to deliver the
    #     requested capacity by the requested start date and time.
    #
    #   * `unsupported` - (*Future-dated Capacity Reservations*) Amazon EC2
    #     can't support the future-dated Capacity Reservation request due
    #     to capacity constraints. You can view unsupported requests for 30
    #     days. The Capacity Reservation will not be delivered.
    #   @return [String]
    #
    # @!attribute [rw] start_date
    #   The date and time the Capacity Reservation was started.
    #   @return [Time]
    #
    # @!attribute [rw] end_date
    #   The date and time the Capacity Reservation expires. When a Capacity
    #   Reservation expires, the reserved capacity is released and you can
    #   no longer launch instances into it. The Capacity Reservation's
    #   state changes to `expired` when it reaches its end date and time.
    #   @return [Time]
    #
    # @!attribute [rw] end_date_type
    #   Indicates the way in which the Capacity Reservation ends. A Capacity
    #   Reservation can have one of the following end types:
    #
    #   * `unlimited` - The Capacity Reservation remains active until you
    #     explicitly cancel it.
    #
    #   * `limited` - The Capacity Reservation expires automatically at a
    #     specified date and time.
    #   @return [String]
    #
    # @!attribute [rw] instance_match_criteria
    #   Indicates the type of instance launches that the Capacity
    #   Reservation accepts. The options include:
    #
    #   * `open` - The Capacity Reservation accepts all instances that have
    #     matching attributes (instance type, platform, and Availability
    #     Zone). Instances that have matching attributes launch into the
    #     Capacity Reservation automatically without specifying any
    #     additional parameters.
    #
    #   * `targeted` - The Capacity Reservation only accepts instances that
    #     have matching attributes (instance type, platform, and
    #     Availability Zone), and explicitly target the Capacity
    #     Reservation. This ensures that only permitted instances can use
    #     the reserved capacity.
    #   @return [String]
    #
    # @!attribute [rw] create_date
    #   The date and time the Capacity Reservation was created.
    #   @return [Time]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the Capacity Reservation.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost on which the Capacity
    #   Reservation was created.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_fleet_id
    #   The ID of the Capacity Reservation Fleet to which the Capacity
    #   Reservation belongs. Only valid for Capacity Reservations that were
    #   created by a Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] placement_group_arn
    #   The Amazon Resource Name (ARN) of the cluster placement group in
    #   which the Capacity Reservation was created. For more information,
    #   see [ Capacity Reservations for cluster placement groups][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html
    #   @return [String]
    #
    # @!attribute [rw] capacity_allocations
    #   Information about instance capacity usage.
    #   @return [Array<Types::CapacityAllocation>]
    #
    # @!attribute [rw] reservation_type
    #   The type of Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] unused_reservation_billing_owner_id
    #   The ID of the Amazon Web Services account to which billing of the
    #   unused capacity of the Capacity Reservation is assigned.
    #   @return [String]
    #
    # @!attribute [rw] commitment_info
    #   Information about your commitment for a future-dated Capacity
    #   Reservation.
    #   @return [Types::CapacityReservationCommitmentInfo]
    #
    # @!attribute [rw] delivery_preference
    #   The delivery method for a future-dated Capacity Reservation.
    #   `incremental` indicates that the requested capacity is delivered in
    #   addition to any running instances and reserved capacity that you
    #   have in your account at the requested date and time.
    #   @return [String]
    #
    # @!attribute [rw] capacity_block_id
    #   The ID of the Capacity Block.
    #   @return [String]
    #
    # @!attribute [rw] interruptible
    #   Indicates whether this Capacity Reservation is interruptible,
    #   meaning instances may be terminated when the owner reclaims
    #   capacity.
    #   @return [Boolean]
    #
    # @!attribute [rw] interruptible_capacity_allocation
    #   Contains allocation details for interruptible reservations,
    #   including current allocated instances and target instance counts
    #   within the interruptibleCapacityAllocation object.
    #   @return [Types::InterruptibleCapacityAllocation]
    #
    # @!attribute [rw] interruption_info
    #   Information about the interruption configuration and association
    #   with the source reservation for interruptible Capacity Reservations.
    #   @return [Types::InterruptionInfo]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservation AWS API Documentation
    #
    class CapacityReservation < Struct.new(
      :capacity_reservation_id,
      :owner_id,
      :capacity_reservation_arn,
      :availability_zone_id,
      :instance_type,
      :instance_platform,
      :availability_zone,
      :tenancy,
      :total_instance_count,
      :available_instance_count,
      :ebs_optimized,
      :ephemeral_storage,
      :state,
      :start_date,
      :end_date,
      :end_date_type,
      :instance_match_criteria,
      :create_date,
      :tags,
      :outpost_arn,
      :capacity_reservation_fleet_id,
      :placement_group_arn,
      :capacity_allocations,
      :reservation_type,
      :unused_reservation_billing_owner_id,
      :commitment_info,
      :delivery_preference,
      :capacity_block_id,
      :interruptible,
      :interruptible_capacity_allocation,
      :interruption_info)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a request to assign billing of the unused capacity
    # of a Capacity Reservation.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] requested_by
    #   The ID of the Amazon Web Services account that initiated the
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] unused_reservation_billing_owner_id
    #   The ID of the Amazon Web Services account to which the request was
    #   sent.
    #   @return [String]
    #
    # @!attribute [rw] last_update_time
    #   The date and time, in UTC time format, at which the request was
    #   initiated.
    #   @return [Time]
    #
    # @!attribute [rw] status
    #   The status of the request. For more information, see [ View billing
    #   assignment requests for a shared Amazon EC2 Capacity
    #   Reservation][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html
    #   @return [String]
    #
    # @!attribute [rw] status_message
    #   Information about the status.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_info
    #   Information about the Capacity Reservation.
    #   @return [Types::CapacityReservationInfo]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationBillingRequest AWS API Documentation
    #
    class CapacityReservationBillingRequest < Struct.new(
      :capacity_reservation_id,
      :requested_by,
      :unused_reservation_billing_owner_id,
      :last_update_time,
      :status,
      :status_message,
      :capacity_reservation_info)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about your commitment for a future-dated Capacity
    # Reservation.
    #
    # @!attribute [rw] committed_instance_count
    #   The instance capacity that you committed to when you requested the
    #   future-dated Capacity Reservation.
    #   @return [Integer]
    #
    # @!attribute [rw] commitment_end_date
    #   The date and time at which the commitment duration expires, in the
    #   ISO8601 format in the UTC time zone (`YYYY-MM-DDThh:mm:ss.sssZ`).
    #   You can't decrease the instance count or cancel the Capacity
    #   Reservation before this date and time.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationCommitmentInfo AWS API Documentation
    #
    class CapacityReservationCommitmentInfo < Struct.new(
      :committed_instance_count,
      :commitment_end_date)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a Capacity Reservation Fleet.
    #
    # @!attribute [rw] capacity_reservation_fleet_id
    #   The ID of the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_fleet_arn
    #   The ARN of the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the Capacity Reservation Fleet. Possible states
    #   include:
    #
    #   * `submitted` - The Capacity Reservation Fleet request has been
    #     submitted and Amazon Elastic Compute Cloud is preparing to create
    #     the Capacity Reservations.
    #
    #   * `modifying` - The Capacity Reservation Fleet is being modified.
    #     The Fleet remains in this state until the modification is
    #     complete.
    #
    #   * `active` - The Capacity Reservation Fleet has fulfilled its total
    #     target capacity and it is attempting to maintain this capacity.
    #     The Fleet remains in this state until it is modified or deleted.
    #
    #   * `partially_fulfilled` - The Capacity Reservation Fleet has
    #     partially fulfilled its total target capacity. There is
    #     insufficient Amazon EC2 to fulfill the total target capacity. The
    #     Fleet is attempting to asynchronously fulfill its total target
    #     capacity.
    #
    #   * `expiring` - The Capacity Reservation Fleet has reach its end date
    #     and it is in the process of expiring. One or more of its Capacity
    #     reservations might still be active.
    #
    #   * `expired` - The Capacity Reservation Fleet has reach its end date.
    #     The Fleet and its Capacity Reservations are expired. The Fleet
    #     can't create new Capacity Reservations.
    #
    #   * `cancelling` - The Capacity Reservation Fleet is in the process of
    #     being cancelled. One or more of its Capacity reservations might
    #     still be active.
    #
    #   * `cancelled` - The Capacity Reservation Fleet has been manually
    #     cancelled. The Fleet and its Capacity Reservations are cancelled
    #     and the Fleet can't create new Capacity Reservations.
    #
    #   * `failed` - The Capacity Reservation Fleet failed to reserve
    #     capacity for the specified instance types.
    #   @return [String]
    #
    # @!attribute [rw] total_target_capacity
    #   The total number of capacity units for which the Capacity
    #   Reservation Fleet reserves capacity. For more information, see
    #   [Total target capacity][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity
    #   @return [Integer]
    #
    # @!attribute [rw] total_fulfilled_capacity
    #   The capacity units that have been fulfilled.
    #   @return [Float]
    #
    # @!attribute [rw] tenancy
    #   The tenancy of the Capacity Reservation Fleet. Tenancies include:
    #
    #   * `default` - The Capacity Reservation Fleet is created on hardware
    #     that is shared with other Amazon Web Services accounts.
    #
    #   * `dedicated` - The Capacity Reservation Fleet is created on
    #     single-tenant hardware that is dedicated to a single Amazon Web
    #     Services account.
    #   @return [String]
    #
    # @!attribute [rw] end_date
    #   The date and time at which the Capacity Reservation Fleet expires.
    #   @return [Time]
    #
    # @!attribute [rw] create_time
    #   The date and time at which the Capacity Reservation Fleet was
    #   created.
    #   @return [Time]
    #
    # @!attribute [rw] instance_match_criteria
    #   Indicates the type of instance launches that the Capacity
    #   Reservation Fleet accepts. All Capacity Reservations in the Fleet
    #   inherit this instance matching criteria.
    #
    #   Currently, Capacity Reservation Fleets support `open` instance
    #   matching criteria only. This means that instances that have matching
    #   attributes (instance type, platform, and Availability Zone) run in
    #   the Capacity Reservations automatically. Instances do not need to
    #   explicitly target a Capacity Reservation Fleet to use its reserved
    #   capacity.
    #   @return [String]
    #
    # @!attribute [rw] allocation_strategy
    #   The strategy used by the Capacity Reservation Fleet to determine
    #   which of the specified instance types to use. For more information,
    #   see For more information, see [Allocation strategy][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy
    #   @return [String]
    #
    # @!attribute [rw] instance_type_specifications
    #   Information about the instance types for which to reserve the
    #   capacity.
    #   @return [Array<Types::FleetCapacityReservation>]
    #
    # @!attribute [rw] tags
    #   The tags assigned to the Capacity Reservation Fleet.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationFleet AWS API Documentation
    #
    class CapacityReservationFleet < Struct.new(
      :capacity_reservation_fleet_id,
      :capacity_reservation_fleet_arn,
      :state,
      :total_target_capacity,
      :total_fulfilled_capacity,
      :tenancy,
      :end_date,
      :create_time,
      :instance_match_criteria,
      :allocation_strategy,
      :instance_type_specifications,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Capacity Reservation Fleet that was successfully
    # cancelled.
    #
    # @!attribute [rw] current_fleet_state
    #   The current state of the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] previous_fleet_state
    #   The previous state of the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_fleet_id
    #   The ID of the Capacity Reservation Fleet that was successfully
    #   cancelled.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationFleetCancellationState AWS API Documentation
    #
    class CapacityReservationFleetCancellationState < Struct.new(
      :current_fleet_state,
      :previous_fleet_state,
      :capacity_reservation_fleet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a resource group to which a Capacity Reservation has been
    # added.
    #
    # @!attribute [rw] group_arn
    #   The ARN of the resource group.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the Amazon Web Services account that owns the resource
    #   group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationGroup AWS API Documentation
    #
    class CapacityReservationGroup < Struct.new(
      :group_arn,
      :owner_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a Capacity Reservation.
    #
    # @!attribute [rw] instance_type
    #   The instance type for the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone for the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   The tenancy of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationInfo AWS API Documentation
    #
    class CapacityReservationInfo < Struct.new(
      :instance_type,
      :availability_zone,
      :tenancy,
      :availability_zone_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the strategy for using unused Capacity Reservations for
    # fulfilling On-Demand capacity.
    #
    # <note markdown="1"> This strategy can only be used if the EC2 Fleet is of type `instant`.
    #
    #  </note>
    #
    # For more information about Capacity Reservations, see [On-Demand
    # Capacity Reservations][1] in the *Amazon EC2 User Guide*. For examples
    # of using Capacity Reservations in an EC2 Fleet, see [EC2 Fleet example
    # configurations][2] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html
    #
    # @!attribute [rw] usage_strategy
    #   Indicates whether to use unused Capacity Reservations for fulfilling
    #   On-Demand capacity.
    #
    #   If you specify `use-capacity-reservations-first`, the fleet uses
    #   unused Capacity Reservations to fulfill On-Demand capacity up to the
    #   target On-Demand capacity. If multiple instance pools have unused
    #   Capacity Reservations, the On-Demand allocation strategy
    #   (`lowest-price` or `prioritized`) is applied. If the number of
    #   unused Capacity Reservations is less than the On-Demand target
    #   capacity, the remaining On-Demand target capacity is launched
    #   according to the On-Demand allocation strategy (`lowest-price` or
    #   `prioritized`).
    #
    #   If you do not specify a value, the fleet fulfils the On-Demand
    #   capacity according to the chosen On-Demand allocation strategy.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationOptions AWS API Documentation
    #
    class CapacityReservationOptions < Struct.new(
      :usage_strategy)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the strategy for using unused Capacity Reservations for
    # fulfilling On-Demand capacity.
    #
    # <note markdown="1"> This strategy can only be used if the EC2 Fleet is of type `instant`.
    #
    #  </note>
    #
    # For more information about Capacity Reservations, see [On-Demand
    # Capacity Reservations][1] in the *Amazon EC2 User Guide*. For examples
    # of using Capacity Reservations in an EC2 Fleet, see [EC2 Fleet example
    # configurations][2] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html
    #
    # @!attribute [rw] usage_strategy
    #   Indicates whether to use unused Capacity Reservations for fulfilling
    #   On-Demand capacity.
    #
    #   If you specify `use-capacity-reservations-first`, the fleet uses
    #   unused Capacity Reservations to fulfill On-Demand capacity up to the
    #   target On-Demand capacity. If multiple instance pools have unused
    #   Capacity Reservations, the On-Demand allocation strategy
    #   (`lowest-price` or `prioritized`) is applied. If the number of
    #   unused Capacity Reservations is less than the On-Demand target
    #   capacity, the remaining On-Demand target capacity is launched
    #   according to the On-Demand allocation strategy (`lowest-price` or
    #   `prioritized`).
    #
    #   If you do not specify a value, the fleet fulfils the On-Demand
    #   capacity according to the chosen On-Demand allocation strategy.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationOptionsRequest AWS API Documentation
    #
    class CapacityReservationOptionsRequest < Struct.new(
      :usage_strategy)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an instance's Capacity Reservation targeting option.
    #
    # Use the `CapacityReservationPreference` parameter to configure the
    # instance to run as an On-Demand Instance, to run in any `open`
    # Capacity Reservation that has matching attributes, or to run only in a
    # Capacity Reservation or Capacity Reservation group. Use the
    # `CapacityReservationTarget` parameter to explicitly target a specific
    # Capacity Reservation or a Capacity Reservation group.
    #
    # You can only specify `CapacityReservationPreference` and
    # `CapacityReservationTarget` if the `CapacityReservationPreference` is
    # `capacity-reservations-only`.
    #
    # @!attribute [rw] capacity_reservation_preference
    #   Indicates the instance's Capacity Reservation preferences. Possible
    #   preferences include:
    #
    #   * `capacity-reservations-only` - The instance will only run in a
    #     Capacity Reservation or Capacity Reservation group. If capacity
    #     isn't available, the instance will fail to launch.
    #
    #   * `open` - The instance can run in any `open` Capacity Reservation
    #     that has matching attributes (instance type, platform,
    #     Availability Zone, and tenancy). If capacity isn't available, the
    #     instance runs as an On-Demand Instance.
    #
    #   * `none` - The instance doesn't run in a Capacity Reservation even
    #     if one is available. The instance runs as an On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_target
    #   Information about the target Capacity Reservation or Capacity
    #   Reservation group.
    #   @return [Types::CapacityReservationTarget]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationSpecification AWS API Documentation
    #
    class CapacityReservationSpecification < Struct.new(
      :capacity_reservation_preference,
      :capacity_reservation_target)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instance's Capacity Reservation targeting preferences.
    # The action returns the `capacityReservationPreference` response
    # element if the instance is configured to run in On-Demand capacity, or
    # if it is configured in run in any `open` Capacity Reservation that has
    # matching attributes (instance type, platform, Availability Zone). The
    # action returns the `capacityReservationTarget` response element if the
    # instance explicily targets a specific Capacity Reservation or Capacity
    # Reservation group.
    #
    # @!attribute [rw] capacity_reservation_preference
    #   Describes the instance's Capacity Reservation preferences. Possible
    #   preferences include:
    #
    #   * `open` - The instance can run in any `open` Capacity Reservation
    #     that has matching attributes (instance type, platform,
    #     Availability Zone).
    #
    #   * `none` - The instance avoids running in a Capacity Reservation
    #     even if one is available. The instance runs in On-Demand capacity.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_target
    #   Information about the targeted Capacity Reservation or Capacity
    #   Reservation group.
    #   @return [Types::CapacityReservationTargetResponse]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationSpecificationResponse AWS API Documentation
    #
    class CapacityReservationSpecificationResponse < Struct.new(
      :capacity_reservation_preference,
      :capacity_reservation_target)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the availability of capacity for a Capacity Reservation.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] total_capacity
    #   The combined amount of `Available` and `Unavailable` capacity in the
    #   Capacity Reservation.
    #   @return [Integer]
    #
    # @!attribute [rw] total_available_capacity
    #   The remaining capacity. Indicates the amount of resources that can
    #   be launched into the Capacity Reservation.
    #   @return [Integer]
    #
    # @!attribute [rw] total_unavailable_capacity
    #   The used capacity. Indicates that the capacity is in use by
    #   resources that are running in the Capacity Reservation.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationStatus AWS API Documentation
    #
    class CapacityReservationStatus < Struct.new(
      :capacity_reservation_id,
      :total_capacity,
      :total_available_capacity,
      :total_unavailable_capacity)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a target Capacity Reservation or Capacity Reservation group.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation in which to run the instance.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_resource_group_arn
    #   The ARN of the Capacity Reservation resource group in which to run
    #   the instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationTarget AWS API Documentation
    #
    class CapacityReservationTarget < Struct.new(
      :capacity_reservation_id,
      :capacity_reservation_resource_group_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a target Capacity Reservation or Capacity Reservation group.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the targeted Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_resource_group_arn
    #   The ARN of the targeted Capacity Reservation group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationTargetResponse AWS API Documentation
    #
    class CapacityReservationTargetResponse < Struct.new(
      :capacity_reservation_id,
      :capacity_reservation_resource_group_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the Capacity Reservation topology.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] capacity_block_id
    #   The ID of the Capacity Block. This parameter is only supported for
    #   UltraServer instances and identifies instances within the
    #   UltraServer domain.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The current state of the Capacity Reservation. For the list of
    #   possible states, see [DescribeCapacityReservations][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCapacityReservations.html
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   The name of the placement group that the Capacity Reservation is in.
    #   @return [String]
    #
    # @!attribute [rw] network_nodes
    #   The network nodes. The nodes are hashed based on your account.
    #   Capacity Reservations from different accounts running under the same
    #   server will return a different hashed list of strings.
    #
    #   The value is `null` or empty if:
    #
    #   * The instance type is not supported.
    #
    #   * The Capacity Reservation is in a state other than `active` or
    #     `pending`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone or Local Zone that the Capacity
    #   Reservation is in.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The name of the Availability Zone or Local Zone that the Capacity
    #   Reservation is in.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationTopology AWS API Documentation
    #
    class CapacityReservationTopology < Struct.new(
      :capacity_reservation_id,
      :capacity_block_id,
      :state,
      :instance_type,
      :group_name,
      :network_nodes,
      :availability_zone_id,
      :availability_zone)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a carrier gateway.
    #
    # @!attribute [rw] carrier_gateway_id
    #   The ID of the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC associated with the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The Amazon Web Services account ID of the owner of the carrier
    #   gateway.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags assigned to the carrier gateway.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CarrierGateway AWS API Documentation
    #
    class CarrierGateway < Struct.new(
      :carrier_gateway_id,
      :vpc_id,
      :state,
      :owner_id,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the client certificate used for authentication.
    #
    # @!attribute [rw] client_root_certificate_chain
    #   The ARN of the client certificate.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CertificateAuthentication AWS API Documentation
    #
    class CertificateAuthentication < Struct.new(
      :client_root_certificate_chain)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the client certificate to be used for
    # authentication.
    #
    # @!attribute [rw] client_root_certificate_chain_arn
    #   The ARN of the client certificate. The certificate must be signed by
    #   a certificate authority (CA) and it must be provisioned in
    #   Certificate Manager (ACM).
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CertificateAuthenticationRequest AWS API Documentation
    #
    class CertificateAuthenticationRequest < Struct.new(
      :client_root_certificate_chain_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Provides authorization for Amazon to bring a specific IP address range
    # to a specific Amazon Web Services account using bring your own IP
    # addresses (BYOIP). For more information, see [Configuring your BYOIP
    # address range][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip
    #
    # @!attribute [rw] message
    #   The plain-text authorization message for the prefix and account.
    #   @return [String]
    #
    # @!attribute [rw] signature
    #   The signed authorization message for the prefix and account.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CidrAuthorizationContext AWS API Documentation
    #
    class CidrAuthorizationContext < Struct.new(
      :message,
      :signature)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an IPv4 CIDR block.
    #
    # @!attribute [rw] cidr_block
    #   The IPv4 CIDR block.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CidrBlock AWS API Documentation
    #
    class CidrBlock < Struct.new(
      :cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # <note markdown="1"> Deprecated.
    #
    #  </note>
    #
    # Describes the ClassicLink DNS support status of a VPC.
    #
    # @!attribute [rw] classic_link_dns_supported
    #   Indicates whether ClassicLink DNS support is enabled for the VPC.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkDnsSupport AWS API Documentation
    #
    class ClassicLinkDnsSupport < Struct.new(
      :classic_link_dns_supported,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # <note markdown="1"> Deprecated.
    #
    #  </note>
    #
    # Describes a linked EC2-Classic instance.
    #
    # @!attribute [rw] groups
    #   The security groups.
    #   @return [Array<Types::GroupIdentifier>]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the instance.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkInstance AWS API Documentation
    #
    class ClassicLinkInstance < Struct.new(
      :groups,
      :instance_id,
      :tags,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Classic Load Balancer.
    #
    # @!attribute [rw] name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLoadBalancer AWS API Documentation
    #
    class ClassicLoadBalancer < Struct.new(
      :name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the Classic Load Balancers to attach to a Spot Fleet. Spot
    # Fleet registers the running Spot Instances with these Classic Load
    # Balancers.
    #
    # @!attribute [rw] classic_load_balancers
    #   One or more Classic Load Balancers.
    #   @return [Array<Types::ClassicLoadBalancer>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLoadBalancersConfig AWS API Documentation
    #
    class ClassicLoadBalancersConfig < Struct.new(
      :classic_load_balancers)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a client certificate revocation list.
    #
    # @!attribute [rw] code
    #   The state of the client certificate revocation list.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the client certificate revocation
    #   list, if applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientCertificateRevocationListStatus AWS API Documentation
    #
    class ClientCertificateRevocationListStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for managing connection authorization for new client
    # connections.
    #
    # @!attribute [rw] enabled
    #   Indicates whether client connect options are enabled. The default is
    #   `false` (not enabled).
    #   @return [Boolean]
    #
    # @!attribute [rw] lambda_function_arn
    #   The Amazon Resource Name (ARN) of the Lambda function used for
    #   connection authorization.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientConnectOptions AWS API Documentation
    #
    class ClientConnectOptions < Struct.new(
      :enabled,
      :lambda_function_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for managing connection authorization for new client
    # connections.
    #
    # @!attribute [rw] enabled
    #   Indicates whether client connect options are enabled.
    #   @return [Boolean]
    #
    # @!attribute [rw] lambda_function_arn
    #   The Amazon Resource Name (ARN) of the Lambda function used for
    #   connection authorization.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The status of any updates to the client connect options.
    #   @return [Types::ClientVpnEndpointAttributeStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientConnectResponseOptions AWS API Documentation
    #
    class ClientConnectResponseOptions < Struct.new(
      :enabled,
      :lambda_function_arn,
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the client-specific data.
    #
    # @!attribute [rw] comment
    #   A user-defined comment about the disk upload.
    #   @return [String]
    #
    # @!attribute [rw] upload_end
    #   The time that the disk upload ends.
    #   @return [Time]
    #
    # @!attribute [rw] upload_size
    #   The size of the uploaded disk image, in GiB.
    #   @return [Float]
    #
    # @!attribute [rw] upload_start
    #   The time that the disk upload starts.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientData AWS API Documentation
    #
    class ClientData < Struct.new(
      :comment,
      :upload_end,
      :upload_size,
      :upload_start)
      SENSITIVE = []
      include Aws::Structure
    end

    # Options for enabling a customizable text banner that will be displayed
    # on Amazon Web Services provided clients when a VPN session is
    # established.
    #
    # @!attribute [rw] enabled
    #   Enable or disable a customizable text banner that will be displayed
    #   on Amazon Web Services provided clients when a VPN session is
    #   established.
    #
    #   Valid values: `true | false`
    #
    #   Default value: `false`
    #   @return [Boolean]
    #
    # @!attribute [rw] banner_text
    #   Customizable text that will be displayed in a banner on Amazon Web
    #   Services provided clients when a VPN session is established. UTF-8
    #   encoded characters only. Maximum of 1400 characters.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientLoginBannerOptions AWS API Documentation
    #
    class ClientLoginBannerOptions < Struct.new(
      :enabled,
      :banner_text)
      SENSITIVE = []
      include Aws::Structure
    end

    # Current state of options for customizable text banner that will be
    # displayed on Amazon Web Services provided clients when a VPN session
    # is established.
    #
    # @!attribute [rw] enabled
    #   Current state of text banner feature.
    #
    #   Valid values: `true | false`
    #   @return [Boolean]
    #
    # @!attribute [rw] banner_text
    #   Customizable text that will be displayed in a banner on Amazon Web
    #   Services provided clients when a VPN session is established. UTF-8
    #   encoded characters only. Maximum of 1400 characters.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientLoginBannerResponseOptions AWS API Documentation
    #
    class ClientLoginBannerResponseOptions < Struct.new(
      :enabled,
      :banner_text)
      SENSITIVE = []
      include Aws::Structure
    end

    # Client Route Enforcement is a feature of Client VPN that helps enforce
    # administrator defined routes on devices connected through the VPN.
    # This feature helps improve your security posture by ensuring that
    # network traffic originating from a connected client is not
    # inadvertently sent outside the VPN tunnel.
    #
    # Client Route Enforcement works by monitoring the route table of a
    # connected device for routing policy changes to the VPN connection. If
    # the feature detects any VPN routing policy modifications, it will
    # automatically force an update to the route table, reverting it back to
    # the expected route configurations.
    #
    # @!attribute [rw] enforced
    #   Enable or disable Client Route Enforcement. The state can either be
    #   `true` (enabled) or `false` (disabled). The default is `false`.
    #
    #   Valid values: `true | false`
    #
    #   Default value: `false`
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientRouteEnforcementOptions AWS API Documentation
    #
    class ClientRouteEnforcementOptions < Struct.new(
      :enforced)
      SENSITIVE = []
      include Aws::Structure
    end

    # The current status of Client Route Enforcement.
    #
    # @!attribute [rw] enforced
    #   Status of the client route enforcement feature, indicating whether
    #   Client Route Enforcement is `true` (enabled) or `false` (disabled).
    #
    #   Valid values: `true | false`
    #
    #   Default value: `false`
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientRouteEnforcementResponseOptions AWS API Documentation
    #
    class ClientRouteEnforcementResponseOptions < Struct.new(
      :enforced)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the authentication methods used by a Client VPN endpoint.
    # For more information, see [Authentication][1] in the *Client VPN
    # Administrator Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html
    #
    # @!attribute [rw] type
    #   The authentication type used.
    #   @return [String]
    #
    # @!attribute [rw] active_directory
    #   Information about the Active Directory, if applicable.
    #   @return [Types::DirectoryServiceAuthentication]
    #
    # @!attribute [rw] mutual_authentication
    #   Information about the authentication certificates, if applicable.
    #   @return [Types::CertificateAuthentication]
    #
    # @!attribute [rw] federated_authentication
    #   Information about the IAM SAML identity provider, if applicable.
    #   @return [Types::FederatedAuthentication]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthentication AWS API Documentation
    #
    class ClientVpnAuthentication < Struct.new(
      :type,
      :active_directory,
      :mutual_authentication,
      :federated_authentication)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the authentication method to be used by a Client VPN
    # endpoint. For more information, see [Authentication][1] in the *Client
    # VPN Administrator Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication
    #
    # @!attribute [rw] type
    #   The type of client authentication to be used.
    #   @return [String]
    #
    # @!attribute [rw] active_directory
    #   Information about the Active Directory to be used, if applicable.
    #   You must provide this information if **Type** is
    #   `directory-service-authentication`.
    #   @return [Types::DirectoryServiceAuthenticationRequest]
    #
    # @!attribute [rw] mutual_authentication
    #   Information about the authentication certificates to be used, if
    #   applicable. You must provide this information if **Type** is
    #   `certificate-authentication`.
    #   @return [Types::CertificateAuthenticationRequest]
    #
    # @!attribute [rw] federated_authentication
    #   Information about the IAM SAML identity provider to be used, if
    #   applicable. You must provide this information if **Type** is
    #   `federated-authentication`.
    #   @return [Types::FederatedAuthenticationRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthenticationRequest AWS API Documentation
    #
    class ClientVpnAuthenticationRequest < Struct.new(
      :type,
      :active_directory,
      :mutual_authentication,
      :federated_authentication)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of an authorization rule.
    #
    # @!attribute [rw] code
    #   The state of the authorization rule.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the authorization rule, if applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthorizationRuleStatus AWS API Documentation
    #
    class ClientVpnAuthorizationRuleStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a client connection.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint to which the client is connected.
    #   @return [String]
    #
    # @!attribute [rw] timestamp
    #   The current date and time.
    #   @return [String]
    #
    # @!attribute [rw] connection_id
    #   The ID of the client connection.
    #   @return [String]
    #
    # @!attribute [rw] username
    #   The username of the client who established the client connection.
    #   This information is only provided if Active Directory client
    #   authentication is used.
    #   @return [String]
    #
    # @!attribute [rw] connection_established_time
    #   The date and time the client connection was established.
    #   @return [String]
    #
    # @!attribute [rw] ingress_bytes
    #   The number of bytes sent by the client.
    #   @return [String]
    #
    # @!attribute [rw] egress_bytes
    #   The number of bytes received by the client.
    #   @return [String]
    #
    # @!attribute [rw] ingress_packets
    #   The number of packets sent by the client.
    #   @return [String]
    #
    # @!attribute [rw] egress_packets
    #   The number of packets received by the client.
    #   @return [String]
    #
    # @!attribute [rw] client_ip
    #   The IP address of the client.
    #   @return [String]
    #
    # @!attribute [rw] client_ipv_6_address
    #   The IPv6 address assigned to the client connection when using a
    #   dual-stack Client VPN endpoint. This field is only populated when
    #   the endpoint is configured for dual-stack addressing, and the client
    #   is using IPv6 for connectivity.
    #   @return [String]
    #
    # @!attribute [rw] common_name
    #   The common name associated with the client. This is either the name
    #   of the client certificate, or the Active Directory user name.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the client connection.
    #   @return [Types::ClientVpnConnectionStatus]
    #
    # @!attribute [rw] connection_end_time
    #   The date and time the client connection was terminated.
    #   @return [String]
    #
    # @!attribute [rw] posture_compliance_statuses
    #   The statuses returned by the client connect handler for posture
    #   compliance, if applicable.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnConnection AWS API Documentation
    #
    class ClientVpnConnection < Struct.new(
      :client_vpn_endpoint_id,
      :timestamp,
      :connection_id,
      :username,
      :connection_established_time,
      :ingress_bytes,
      :egress_bytes,
      :ingress_packets,
      :egress_packets,
      :client_ip,
      :client_ipv_6_address,
      :common_name,
      :status,
      :connection_end_time,
      :posture_compliance_statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the status of a client connection.
    #
    # @!attribute [rw] code
    #   The state of the client connection.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the client connection, if applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnConnectionStatus AWS API Documentation
    #
    class ClientVpnConnectionStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Client VPN endpoint.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A brief description of the endpoint.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the Client VPN endpoint.
    #   @return [Types::ClientVpnEndpointStatus]
    #
    # @!attribute [rw] creation_time
    #   The date and time the Client VPN endpoint was created.
    #   @return [String]
    #
    # @!attribute [rw] deletion_time
    #   The date and time the Client VPN endpoint was deleted, if
    #   applicable.
    #   @return [String]
    #
    # @!attribute [rw] dns_name
    #   The DNS name to be used by clients when connecting to the Client VPN
    #   endpoint.
    #   @return [String]
    #
    # @!attribute [rw] client_cidr_block
    #   The IPv4 address range, in CIDR notation, from which client IP
    #   addresses are assigned.
    #   @return [String]
    #
    # @!attribute [rw] dns_servers
    #   Information about the DNS servers to be used for DNS resolution.
    #   @return [Array<String>]
    #
    # @!attribute [rw] split_tunnel
    #   Indicates whether split-tunnel is enabled in the Client VPN
    #   endpoint.
    #
    #   For information about split-tunnel VPN endpoints, see [Split-Tunnel
    #   Client VPN endpoint][1] in the *Client VPN Administrator Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
    #   @return [Boolean]
    #
    # @!attribute [rw] vpn_protocol
    #   The protocol used by the VPN session.
    #   @return [String]
    #
    # @!attribute [rw] transport_protocol
    #   The transport protocol used by the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] vpn_port
    #   The port number for the Client VPN endpoint.
    #   @return [Integer]
    #
    # @!attribute [rw] associated_target_networks
    #   Information about the associated target networks. A target network
    #   is a subnet in a VPC.
    #   @return [Array<Types::AssociatedTargetNetwork>]
    #
    # @!attribute [rw] server_certificate_arn
    #   The ARN of the server certificate.
    #   @return [String]
    #
    # @!attribute [rw] authentication_options
    #   Information about the authentication method used by the Client VPN
    #   endpoint.
    #   @return [Array<Types::ClientVpnAuthentication>]
    #
    # @!attribute [rw] connection_log_options
    #   Information about the client connection logging options for the
    #   Client VPN endpoint.
    #   @return [Types::ConnectionLogResponseOptions]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the Client VPN endpoint.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] security_group_ids
    #   The IDs of the security groups for the target network.
    #   @return [Array<String>]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] self_service_portal_url
    #   The URL of the self-service portal.
    #   @return [String]
    #
    # @!attribute [rw] client_connect_options
    #   The options for managing connection authorization for new client
    #   connections.
    #   @return [Types::ClientConnectResponseOptions]
    #
    # @!attribute [rw] session_timeout_hours
    #   The maximum VPN session duration time in hours.
    #
    #   Valid values: `8 | 10 | 12 | 24`
    #
    #   Default value: `24`
    #   @return [Integer]
    #
    # @!attribute [rw] client_login_banner_options
    #   Options for enabling a customizable text banner that will be
    #   displayed on Amazon Web Services provided clients when a VPN session
    #   is established.
    #   @return [Types::ClientLoginBannerResponseOptions]
    #
    # @!attribute [rw] client_route_enforcement_options
    #   Client route enforcement is a feature of the Client VPN service that
    #   helps enforce administrator defined routes on devices connected
    #   through the VPN. T his feature helps improve your security posture
    #   by ensuring that network traffic originating from a connected client
    #   is not inadvertently sent outside the VPN tunnel.
    #
    #   Client route enforcement works by monitoring the route table of a
    #   connected device for routing policy changes to the VPN connection.
    #   If the feature detects any VPN routing policy modifications, it will
    #   automatically force an update to the route table, reverting it back
    #   to the expected route configurations.
    #   @return [Types::ClientRouteEnforcementResponseOptions]
    #
    # @!attribute [rw] disconnect_on_session_timeout
    #   Indicates whether the client VPN session is disconnected after the
    #   maximum `sessionTimeoutHours` is reached. If `true`, users are
    #   prompted to reconnect client VPN. If `false`, client VPN attempts to
    #   reconnect automatically. The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] endpoint_ip_address_type
    #   The IP address type of the Client VPN endpoint. Possible values are
    #   `ipv4` for IPv4 addressing only, `ipv6` for IPv6 addressing only, or
    #   `dual-stack `for both IPv4 and IPv6 addressing.
    #   @return [String]
    #
    # @!attribute [rw] traffic_ip_address_type
    #   The IP address type of the Client VPN endpoint. Possible values are
    #   either `ipv4` for IPv4 addressing only, `ipv6` for IPv6 addressing
    #   only, or `dual-stack` for both IPv4 and IPv6 addressing.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpoint AWS API Documentation
    #
    class ClientVpnEndpoint < Struct.new(
      :client_vpn_endpoint_id,
      :description,
      :status,
      :creation_time,
      :deletion_time,
      :dns_name,
      :client_cidr_block,
      :dns_servers,
      :split_tunnel,
      :vpn_protocol,
      :transport_protocol,
      :vpn_port,
      :associated_target_networks,
      :server_certificate_arn,
      :authentication_options,
      :connection_log_options,
      :tags,
      :security_group_ids,
      :vpc_id,
      :self_service_portal_url,
      :client_connect_options,
      :session_timeout_hours,
      :client_login_banner_options,
      :client_route_enforcement_options,
      :disconnect_on_session_timeout,
      :endpoint_ip_address_type,
      :traffic_ip_address_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the status of the Client VPN endpoint attribute.
    #
    # @!attribute [rw] code
    #   The status code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The status message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpointAttributeStatus AWS API Documentation
    #
    class ClientVpnEndpointAttributeStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a Client VPN endpoint.
    #
    # @!attribute [rw] code
    #   The state of the Client VPN endpoint. Possible states include:
    #
    #   * `pending-associate` - The Client VPN endpoint has been created but
    #     no target networks have been associated. The Client VPN endpoint
    #     cannot accept connections.
    #
    #   * `available` - The Client VPN endpoint has been created and a
    #     target network has been associated. The Client VPN endpoint can
    #     accept connections.
    #
    #   * `deleting` - The Client VPN endpoint is being deleted. The Client
    #     VPN endpoint cannot accept connections.
    #
    #   * `deleted` - The Client VPN endpoint has been deleted. The Client
    #     VPN endpoint cannot accept connections.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the Client VPN endpoint.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpointStatus AWS API Documentation
    #
    class ClientVpnEndpointStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a Client VPN endpoint route.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint with which the route is
    #   associated.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr
    #   The IPv4 address range, in CIDR notation, of the route destination.
    #   @return [String]
    #
    # @!attribute [rw] target_subnet
    #   The ID of the subnet through which traffic is routed.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The route type.
    #   @return [String]
    #
    # @!attribute [rw] origin
    #   Indicates how the route was associated with the Client VPN endpoint.
    #   `associate` indicates that the route was automatically added when
    #   the target network was associated with the Client VPN endpoint.
    #   `add-route` indicates that the route was manually added using the
    #   **CreateClientVpnRoute** action.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the route.
    #   @return [Types::ClientVpnRouteStatus]
    #
    # @!attribute [rw] description
    #   A brief description of the route.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnRoute AWS API Documentation
    #
    class ClientVpnRoute < Struct.new(
      :client_vpn_endpoint_id,
      :destination_cidr,
      :target_subnet,
      :type,
      :origin,
      :status,
      :description)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a Client VPN endpoint route.
    #
    # @!attribute [rw] code
    #   The state of the Client VPN endpoint route.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the Client VPN endpoint route, if
    #   applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnRouteStatus AWS API Documentation
    #
    class ClientVpnRouteStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Options for sending VPN tunnel logs to CloudWatch.
    #
    # @!attribute [rw] log_enabled
    #   Status of VPN tunnel logging feature. Default value is `False`.
    #
    #   Valid values: `True` \| `False`
    #   @return [Boolean]
    #
    # @!attribute [rw] log_group_arn
    #   The Amazon Resource Name (ARN) of the CloudWatch log group to send
    #   logs to.
    #   @return [String]
    #
    # @!attribute [rw] log_output_format
    #   Configured log format. Default format is `json`.
    #
    #   Valid values: `json` \| `text`
    #   @return [String]
    #
    # @!attribute [rw] bgp_log_enabled
    #   Indicates whether Border Gateway Protocol (BGP) logging is enabled
    #   for the VPN connection. Default value is `False`.
    #
    #   Valid values: `True` \| `False`
    #   @return [Boolean]
    #
    # @!attribute [rw] bgp_log_group_arn
    #   The Amazon Resource Name (ARN) of the CloudWatch log group for BGP
    #   logs.
    #   @return [String]
    #
    # @!attribute [rw] bgp_log_output_format
    #   The output format for BGP logs sent to CloudWatch. Default format is
    #   `json`.
    #
    #   Valid values: `json` \| `text`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CloudWatchLogOptions AWS API Documentation
    #
    class CloudWatchLogOptions < Struct.new(
      :log_enabled,
      :log_group_arn,
      :log_output_format,
      :bgp_log_enabled,
      :bgp_log_group_arn,
      :bgp_log_output_format)
      SENSITIVE = []
      include Aws::Structure
    end

    # Options for sending VPN tunnel logs to CloudWatch.
    #
    # @!attribute [rw] log_enabled
    #   Enable or disable VPN tunnel logging feature. Default value is
    #   `False`.
    #
    #   Valid values: `True` \| `False`
    #   @return [Boolean]
    #
    # @!attribute [rw] log_group_arn
    #   The Amazon Resource Name (ARN) of the CloudWatch log group to send
    #   logs to.
    #   @return [String]
    #
    # @!attribute [rw] log_output_format
    #   Set log format. Default format is `json`.
    #
    #   Valid values: `json` \| `text`
    #   @return [String]
    #
    # @!attribute [rw] bgp_log_enabled
    #   Specifies whether to enable BGP logging for the VPN connection.
    #   Default value is `False`.
    #
    #   Valid values: `True` \| `False`
    #   @return [Boolean]
    #
    # @!attribute [rw] bgp_log_group_arn
    #   The Amazon Resource Name (ARN) of the CloudWatch log group where BGP
    #   logs will be sent.
    #   @return [String]
    #
    # @!attribute [rw] bgp_log_output_format
    #   The desired output format for BGP logs to be sent to CloudWatch.
    #   Default format is `json`.
    #
    #   Valid values: `json` \| `text`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CloudWatchLogOptionsSpecification AWS API Documentation
    #
    class CloudWatchLogOptionsSpecification < Struct.new(
      :log_enabled,
      :log_group_arn,
      :log_output_format,
      :bgp_log_enabled,
      :bgp_log_group_arn,
      :bgp_log_output_format)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes address usage for a customer-owned address pool.
    #
    # @!attribute [rw] allocation_id
    #   The allocation ID of the address.
    #   @return [String]
    #
    # @!attribute [rw] aws_account_id
    #   The Amazon Web Services account ID.
    #   @return [String]
    #
    # @!attribute [rw] aws_service
    #   The Amazon Web Services service.
    #   @return [String]
    #
    # @!attribute [rw] co_ip
    #   The customer-owned IP address.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CoipAddressUsage AWS API Documentation
    #
    class CoipAddressUsage < Struct.new(
      :allocation_id,
      :aws_account_id,
      :aws_service,
      :co_ip)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a customer-owned IP address range.
    #
    # @!attribute [rw] cidr
    #   An address range in a customer-owned IP address space.
    #   @return [String]
    #
    # @!attribute [rw] coip_pool_id
    #   The ID of the address pool.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CoipCidr AWS API Documentation
    #
    class CoipCidr < Struct.new(
      :cidr,
      :coip_pool_id,
      :local_gateway_route_table_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a customer-owned address pool.
    #
    # @!attribute [rw] pool_id
    #   The ID of the address pool.
    #   @return [String]
    #
    # @!attribute [rw] pool_cidrs
    #   The address ranges of the address pool.
    #   @return [Array<String>]
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] pool_arn
    #   The ARN of the address pool.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CoipPool AWS API Documentation
    #
    class CoipPool < Struct.new(
      :pool_id,
      :pool_cidrs,
      :local_gateway_route_table_id,
      :tags,
      :pool_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] product_code
    #   The product code. This must be a product code that you own.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstanceRequest AWS API Documentation
    #
    class ConfirmProductInstanceRequest < Struct.new(
      :instance_id,
      :product_code,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   The return value of the request. Returns `true` if the specified
    #   product code is owned by the requester and associated with the
    #   specified instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] owner_id
    #   The Amazon Web Services account ID of the instance owner. This is
    #   only present if the product code is attached to the instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstanceResult AWS API Documentation
    #
    class ConfirmProductInstanceResult < Struct.new(
      :return,
      :owner_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the client connection logging options for the Client VPN
    # endpoint.
    #
    # @!attribute [rw] enabled
    #   Indicates whether connection logging is enabled.
    #   @return [Boolean]
    #
    # @!attribute [rw] cloudwatch_log_group
    #   The name of the CloudWatch Logs log group. Required if connection
    #   logging is enabled.
    #   @return [String]
    #
    # @!attribute [rw] cloudwatch_log_stream
    #   The name of the CloudWatch Logs log stream to which the connection
    #   data is published.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionLogOptions AWS API Documentation
    #
    class ConnectionLogOptions < Struct.new(
      :enabled,
      :cloudwatch_log_group,
      :cloudwatch_log_stream)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the client connection logging options for a Client
    # VPN endpoint.
    #
    # @!attribute [rw] enabled
    #   Indicates whether client connection logging is enabled for the
    #   Client VPN endpoint.
    #   @return [Boolean]
    #
    # @!attribute [rw] cloudwatch_log_group
    #   The name of the Amazon CloudWatch Logs log group to which connection
    #   logging data is published.
    #   @return [String]
    #
    # @!attribute [rw] cloudwatch_log_stream
    #   The name of the Amazon CloudWatch Logs log stream to which
    #   connection logging data is published.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionLogResponseOptions AWS API Documentation
    #
    class ConnectionLogResponseOptions < Struct.new(
      :enabled,
      :cloudwatch_log_group,
      :cloudwatch_log_stream)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a connection notification for a VPC endpoint or VPC endpoint
    # service.
    #
    # @!attribute [rw] connection_notification_id
    #   The ID of the notification.
    #   @return [String]
    #
    # @!attribute [rw] service_id
    #   The ID of the endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] vpc_endpoint_id
    #   The ID of the VPC endpoint.
    #   @return [String]
    #
    # @!attribute [rw] connection_notification_type
    #   The type of notification.
    #   @return [String]
    #
    # @!attribute [rw] connection_notification_arn
    #   The ARN of the SNS topic for the notification.
    #   @return [String]
    #
    # @!attribute [rw] connection_events
    #   The events for the notification. Valid values are `Accept`,
    #   `Connect`, `Delete`, and `Reject`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] connection_notification_state
    #   The state of the notification.
    #   @return [String]
    #
    # @!attribute [rw] service_region
    #   The Region for the endpoint service.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionNotification AWS API Documentation
    #
    class ConnectionNotification < Struct.new(
      :connection_notification_id,
      :service_id,
      :vpc_endpoint_id,
      :connection_notification_type,
      :connection_notification_arn,
      :connection_events,
      :connection_notification_state,
      :service_region)
      SENSITIVE = []
      include Aws::Structure
    end

    # A security group connection tracking configuration that enables you to
    # set the idle timeout for connection tracking on an Elastic network
    # interface. For more information, see [Connection tracking timeouts][1]
    # in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts
    #
    # @!attribute [rw] tcp_established_timeout
    #   Timeout (in seconds) for idle TCP connections in an established
    #   state. Min: 60 seconds. Max: 432000 seconds (5 days). Default:
    #   432000 seconds. Recommended: Less than 432000 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_stream_timeout
    #   Timeout (in seconds) for idle UDP flows classified as streams which
    #   have seen more than one request-response transaction. Min: 60
    #   seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_timeout
    #   Timeout (in seconds) for idle UDP flows that have seen traffic only
    #   in a single direction or a single request-response transaction. Min:
    #   30 seconds. Max: 60 seconds. Default: 30 seconds.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionTrackingConfiguration AWS API Documentation
    #
    class ConnectionTrackingConfiguration < Struct.new(
      :tcp_established_timeout,
      :udp_stream_timeout,
      :udp_timeout)
      SENSITIVE = []
      include Aws::Structure
    end

    # A security group connection tracking specification that enables you to
    # set the idle timeout for connection tracking on an Elastic network
    # interface. For more information, see [Connection tracking timeouts][1]
    # in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts
    #
    # @!attribute [rw] tcp_established_timeout
    #   Timeout (in seconds) for idle TCP connections in an established
    #   state. Min: 60 seconds. Max: 432000 seconds (5 days). Default:
    #   432000 seconds. Recommended: Less than 432000 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_timeout
    #   Timeout (in seconds) for idle UDP flows that have seen traffic only
    #   in a single direction or a single request-response transaction. Min:
    #   30 seconds. Max: 60 seconds. Default: 30 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_stream_timeout
    #   Timeout (in seconds) for idle UDP flows classified as streams which
    #   have seen more than one request-response transaction. Min: 60
    #   seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionTrackingSpecification AWS API Documentation
    #
    class ConnectionTrackingSpecification < Struct.new(
      :tcp_established_timeout,
      :udp_timeout,
      :udp_stream_timeout)
      SENSITIVE = []
      include Aws::Structure
    end

    # A security group connection tracking specification request that
    # enables you to set the idle timeout for connection tracking on an
    # Elastic network interface. For more information, see [Connection
    # tracking timeouts][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts
    #
    # @!attribute [rw] tcp_established_timeout
    #   Timeout (in seconds) for idle TCP connections in an established
    #   state. Min: 60 seconds. Max: 432000 seconds (5 days). Default:
    #   432000 seconds. Recommended: Less than 432000 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_stream_timeout
    #   Timeout (in seconds) for idle UDP flows classified as streams which
    #   have seen more than one request-response transaction. Min: 60
    #   seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_timeout
    #   Timeout (in seconds) for idle UDP flows that have seen traffic only
    #   in a single direction or a single request-response transaction. Min:
    #   30 seconds. Max: 60 seconds. Default: 30 seconds.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionTrackingSpecificationRequest AWS API Documentation
    #
    class ConnectionTrackingSpecificationRequest < Struct.new(
      :tcp_established_timeout,
      :udp_stream_timeout,
      :udp_timeout)
      SENSITIVE = []
      include Aws::Structure
    end

    # A security group connection tracking specification response that
    # enables you to set the idle timeout for connection tracking on an
    # Elastic network interface. For more information, see [Connection
    # tracking timeouts][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts
    #
    # @!attribute [rw] tcp_established_timeout
    #   Timeout (in seconds) for idle TCP connections in an established
    #   state. Min: 60 seconds. Max: 432000 seconds (5 days). Default:
    #   432000 seconds. Recommended: Less than 432000 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_stream_timeout
    #   Timeout (in seconds) for idle UDP flows classified as streams which
    #   have seen more than one request-response transaction. Min: 60
    #   seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
    #   @return [Integer]
    #
    # @!attribute [rw] udp_timeout
    #   Timeout (in seconds) for idle UDP flows that have seen traffic only
    #   in a single direction or a single request-response transaction. Min:
    #   30 seconds. Max: 60 seconds. Default: 30 seconds.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionTrackingSpecificationResponse AWS API Documentation
    #
    class ConnectionTrackingSpecificationResponse < Struct.new(
      :tcp_established_timeout,
      :udp_stream_timeout,
      :udp_timeout)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a conversion task.
    #
    # @!attribute [rw] conversion_task_id
    #   The ID of the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] expiration_time
    #   The time when the task expires. If the upload isn't complete before
    #   the expiration time, we automatically cancel the task.
    #   @return [String]
    #
    # @!attribute [rw] import_instance
    #   If the task is for importing an instance, this contains information
    #   about the import instance task.
    #   @return [Types::ImportInstanceTaskDetails]
    #
    # @!attribute [rw] import_volume
    #   If the task is for importing a volume, this contains information
    #   about the import volume task.
    #   @return [Types::ImportVolumeTaskDetails]
    #
    # @!attribute [rw] state
    #   The state of the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] status_message
    #   The status message related to the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the task.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConversionTask AWS API Documentation
    #
    class ConversionTask < Struct.new(
      :conversion_task_id,
      :expiration_time,
      :import_instance,
      :import_volume,
      :state,
      :status_message,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] source_fpga_image_id
    #   The ID of the source AFI.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description for the new AFI.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   The name for the new AFI. The default is the name of the source AFI.
    #   @return [String]
    #
    # @!attribute [rw] source_region
    #   The Region that contains the source AFI.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImageRequest AWS API Documentation
    #
    class CopyFpgaImageRequest < Struct.new(
      :dry_run,
      :source_fpga_image_id,
      :description,
      :name,
      :source_region,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_image_id
    #   The ID of the new AFI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImageResult AWS API Documentation
    #
    class CopyFpgaImageResult < Struct.new(
      :fpga_image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CopyImage.
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency
    #   of the request. For more information, see [Ensuring idempotency in
    #   Amazon EC2 API requests][1] in the *Amazon EC2 API Reference*.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the new AMI.
    #   @return [String]
    #
    # @!attribute [rw] encrypted
    #   Specifies whether to encrypt the snapshots of the copied image.
    #
    #   You can encrypt a copy of an unencrypted snapshot, but you cannot
    #   create an unencrypted copy of an encrypted snapshot. The default KMS
    #   key for Amazon EBS is used unless you specify a non-default Key
    #   Management Service (KMS) KMS key using `KmsKeyId`. For more
    #   information, see [Use encryption with EBS-backed AMIs][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html
    #   @return [Boolean]
    #
    # @!attribute [rw] kms_key_id
    #   The identifier of the symmetric Key Management Service (KMS) KMS key
    #   to use when creating encrypted volumes. If this parameter is not
    #   specified, your Amazon Web Services managed KMS key for Amazon EBS
    #   is used. If you specify a KMS key, you must also set the encrypted
    #   state to `true`.
    #
    #   You can specify a KMS key using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   Amazon Web Services authenticates the KMS key asynchronously.
    #   Therefore, if you specify an identifier that is not valid, the
    #   action can appear to complete, but eventually fails.
    #
    #   The specified KMS key must exist in the destination Region.
    #
    #   Amazon EBS does not support asymmetric KMS keys.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   The name of the new AMI.
    #   @return [String]
    #
    # @!attribute [rw] source_image_id
    #   The ID of the AMI to copy.
    #   @return [String]
    #
    # @!attribute [rw] source_region
    #   The name of the Region that contains the AMI to copy.
    #   @return [String]
    #
    # @!attribute [rw] destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost for the new AMI.
    #
    #   Only specify this parameter when copying an AMI from an Amazon Web
    #   Services Region to an Outpost. The AMI must be in the Region of the
    #   destination Outpost. You can't copy an AMI from an Outpost to a
    #   Region, from one Outpost to another, or within the same Outpost.
    #
    #   For more information, see [Copy AMIs from an Amazon Web Services
    #   Region to an Outpost][1] in the *Amazon EBS User Guide*.
    #
    #   Only one of `DestinationAvailabilityZone`,
    #   `DestinationAvailabilityZoneId`, or `DestinationOutpostArn` can be
    #   specified.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-amis
    #   @return [String]
    #
    # @!attribute [rw] copy_image_tags
    #   Specifies whether to copy your user-defined AMI tags to the new AMI.
    #
    #   The following tags are not be copied:
    #
    #   * System tags (prefixed with `aws:`)
    #
    #   * For public and shared AMIs, user-defined tags that are attached by
    #     other Amazon Web Services accounts
    #
    #   Default: Your user-defined AMI tags are not copied.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new AMI and new snapshots. You can tag the
    #   AMI, the snapshots, or both.
    #
    #   * To tag the new AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the new snapshots, the value for `ResourceType` must be
    #     `snapshot`. The same tag is applied to all the new snapshots.
    #
    #   If you specify other values for `ResourceType`, the request fails.
    #
    #   To tag an AMI or snapshot after it has been created, see
    #   [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] snapshot_copy_completion_duration_minutes
    #   Specify a completion duration, in 15 minute increments, to initiate
    #   a time-based AMI copy. The specified completion duration applies to
    #   each of the snapshots associated with the AMI. Each snapshot
    #   associated with the AMI will be completed within the specified
    #   completion duration, with copy throughput automatically adjusted for
    #   each snapshot based on its size to meet the timing target.
    #
    #   If you do not specify a value, the AMI copy operation is completed
    #   on a best-effort basis.
    #
    #   <note markdown="1"> This parameter is not supported when copying an AMI to or from a
    #   Local Zone, or to an Outpost.
    #
    #    </note>
    #
    #   For more information, see [Time-based copies for Amazon EBS
    #   snapshots and EBS-backed AMIs][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/time-based-copies.html
    #   @return [Integer]
    #
    # @!attribute [rw] destination_availability_zone
    #   The Local Zone for the new AMI (for example, `cn-north-1-pkx-1a`).
    #
    #   Only one of `DestinationAvailabilityZone`,
    #   `DestinationAvailabilityZoneId`, or `DestinationOutpostArn` can be
    #   specified.
    #   @return [String]
    #
    # @!attribute [rw] destination_availability_zone_id
    #   The ID of the Local Zone for the new AMI (for example,
    #   `cnn1-pkx1-az1`).
    #
    #   Only one of `DestinationAvailabilityZone`,
    #   `DestinationAvailabilityZoneId`, or `DestinationOutpostArn` can be
    #   specified.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImageRequest AWS API Documentation
    #
    class CopyImageRequest < Struct.new(
      :client_token,
      :description,
      :encrypted,
      :kms_key_id,
      :name,
      :source_image_id,
      :source_region,
      :destination_outpost_arn,
      :copy_image_tags,
      :tag_specifications,
      :snapshot_copy_completion_duration_minutes,
      :destination_availability_zone,
      :destination_availability_zone_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CopyImage.
    #
    # @!attribute [rw] image_id
    #   The ID of the new AMI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImageResult AWS API Documentation
    #
    class CopyImageResult < Struct.new(
      :image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] description
    #   A description for the EBS snapshot.
    #   @return [String]
    #
    # @!attribute [rw] destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost to which to copy the
    #   snapshot.
    #
    #   <note markdown="1"> Only supported when copying a snapshot to an Outpost.
    #
    #    </note>
    #
    #   For more information, see [ Copy snapshots from an Amazon Web
    #   Services Region to an Outpost][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-snapshots
    #   @return [String]
    #
    # @!attribute [rw] destination_region
    #   The destination Region to use in the `PresignedUrl` parameter of a
    #   snapshot copy operation. This parameter is only valid for specifying
    #   the destination Region in a `PresignedUrl` parameter, where it is
    #   required.
    #
    #   The snapshot copy is sent to the regional endpoint that you sent the
    #   HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With
    #   the CLI, this is specified using the `--region` parameter or the
    #   default Region in your Amazon Web Services configuration file.
    #   @return [String]
    #
    # @!attribute [rw] encrypted
    #   To encrypt a copy of an unencrypted snapshot if encryption by
    #   default is not enabled, enable encryption using this parameter.
    #   Otherwise, omit this parameter. Copies of encrypted snapshots are
    #   encrypted, even if you omit this parameter and encryption by default
    #   is not enabled. You cannot set this parameter to false. For more
    #   information, see [Amazon EBS encryption][1] in the *Amazon EBS User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html
    #   @return [Boolean]
    #
    # @!attribute [rw] kms_key_id
    #   The identifier of the KMS key to use for Amazon EBS encryption. If
    #   this parameter is not specified, your KMS key for Amazon EBS is
    #   used. If `KmsKeyId` is specified, the encrypted state must be
    #   `true`.
    #
    #   You can specify the KMS key using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   Amazon Web Services authenticates the KMS key asynchronously.
    #   Therefore, if you specify an ID, alias, or ARN that is not valid,
    #   the action can appear to complete, but eventually fails.
    #   @return [String]
    #
    # @!attribute [rw] presigned_url
    #   When you copy an encrypted source snapshot using the Amazon EC2
    #   Query API, you must supply a pre-signed URL. This parameter is
    #   optional for unencrypted snapshots. For more information, see [Query
    #   requests][1].
    #
    #   The `PresignedUrl` should use the snapshot source endpoint, the
    #   `CopySnapshot` action, and include the `SourceRegion`,
    #   `SourceSnapshotId`, and `DestinationRegion` parameters. The
    #   `PresignedUrl` must be signed using Amazon Web Services Signature
    #   Version 4. Because EBS snapshots are stored in Amazon S3, the
    #   signing algorithm for this parameter uses the same logic that is
    #   described in [ Authenticating Requests: Using Query Parameters
    #   (Amazon Web Services Signature Version 4)][2] in the *Amazon S3 API
    #   Reference*. An invalid or improperly signed `PresignedUrl` will
    #   cause the copy operation to fail asynchronously, and the snapshot
    #   will move to an `error` state.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html
    #   [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #   @return [String]
    #
    # @!attribute [rw] source_region
    #   The ID of the Region that contains the snapshot to be copied.
    #   @return [String]
    #
    # @!attribute [rw] source_snapshot_id
    #   The ID of the EBS snapshot to copy.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new snapshot.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] completion_duration_minutes
    #   <note markdown="1"> Not supported when copying snapshots to or from Local Zones or
    #   Outposts.
    #
    #    </note>
    #
    #   Specify a completion duration, in 15 minute increments, to initiate
    #   a time-based snapshot copy. Time-based snapshot copy operations
    #   complete within the specified duration. For more information, see [
    #   Time-based copies][1].
    #
    #   If you do not specify a value, the snapshot copy operation is
    #   completed on a best-effort basis.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/time-based-copies.html
    #   @return [Integer]
    #
    # @!attribute [rw] destination_availability_zone
    #   The Local Zone, for example, `cn-north-1-pkx-1a` to which to copy
    #   the snapshot.
    #
    #   <note markdown="1"> Only supported when copying a snapshot to a Local Zone.
    #
    #    </note>
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshotRequest AWS API Documentation
    #
    class CopySnapshotRequest < Struct.new(
      :description,
      :destination_outpost_arn,
      :destination_region,
      :encrypted,
      :kms_key_id,
      :presigned_url,
      :source_region,
      :source_snapshot_id,
      :tag_specifications,
      :completion_duration_minutes,
      :destination_availability_zone,
      :dry_run)
      SENSITIVE = [:presigned_url]
      include Aws::Structure
    end

    # @!attribute [rw] tags
    #   Any tags applied to the new snapshot.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the new snapshot.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshotResult AWS API Documentation
    #
    class CopySnapshotResult < Struct.new(
      :tags,
      :snapshot_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] source_volume_id
    #   The ID of the source EBS volume to copy.
    #   @return [String]
    #
    # @!attribute [rw] iops
    #   The number of I/O operations per second (IOPS) to provision for the
    #   volume copy. Required for `io1` and `io2` volumes. Optional for
    #   `gp3` volumes. Omit for all other volume types. Full provisioned
    #   IOPS performance can be achieved only once the volume copy is fully
    #   initialized.
    #
    #   Valid ranges:
    #
    #   * gp3: `3,000 `(*default*)` - 80,000` IOPS
    #
    #   * io1: `100 - 64,000` IOPS
    #
    #   * io2: `100 - 256,000` IOPS
    #
    #   <note markdown="1"> [ Instances built on the Nitro System][1] can support up to 256,000
    #   IOPS. Other instances can support up to 32,000 IOPS.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html
    #   @return [Integer]
    #
    # @!attribute [rw] size
    #   The size of the volume copy, in GiBs. The size must be equal to or
    #   greater than the size of the source volume. If not specified, the
    #   size defaults to the size of the source volume.
    #
    #   Maximum supported sizes:
    #
    #   * gp2: `16,384` GiB
    #
    #   * gp3: `65,536` GiB
    #
    #   * io1: `16,384` GiB
    #
    #   * io2: `65,536` GiB
    #
    #   * st1 and sc1: `16,384` GiB
    #
    #   * standard: `1024` GiB
    #   @return [Integer]
    #
    # @!attribute [rw] volume_type
    #   The volume type for the volume copy. If not specified, the volume
    #   type defaults to `gp2`.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the volume copy during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] multi_attach_enabled
    #   Indicates whether to enable Amazon EBS Multi-Attach for the volume
    #   copy. If you enable Multi-Attach, you can attach the volume to up to
    #   16 Nitro instances in the same Availability Zone simultaneously.
    #   Supported with `io1` and `io2` volumes only. For more information,
    #   see [ Amazon EBS Multi-Attach][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html
    #   @return [Boolean]
    #
    # @!attribute [rw] throughput
    #   The throughput to provision for the volume copy, in MiB/s. Supported
    #   for `gp3` volumes only. Omit for all other volume types. Full
    #   provisioned throughput performance can be achieved only once the
    #   volume copy is fully initialized.
    #
    #   Valid Range: `125 - 2000` MiB/s
    #   @return [Integer]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [ Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyVolumesRequest AWS API Documentation
    #
    class CopyVolumesRequest < Struct.new(
      :source_volume_id,
      :iops,
      :size,
      :volume_type,
      :dry_run,
      :tag_specifications,
      :multi_attach_enabled,
      :throughput,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] volumes
    #   Information about the volume copy.
    #   @return [Array<Types::Volume>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyVolumesResult AWS API Documentation
    #
    class CopyVolumesResult < Struct.new(
      :volumes)
      SENSITIVE = []
      include Aws::Structure
    end

    # The CPU options for the instance.
    #
    # @!attribute [rw] core_count
    #   The number of CPU cores for the instance.
    #   @return [Integer]
    #
    # @!attribute [rw] threads_per_core
    #   The number of threads per CPU core.
    #   @return [Integer]
    #
    # @!attribute [rw] amd_sev_snp
    #   Indicates whether the instance is enabled for AMD SEV-SNP. For more
    #   information, see [AMD SEV-SNP][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html
    #   @return [String]
    #
    # @!attribute [rw] nested_virtualization
    #   Indicates whether the instance is enabled for nested virtualization.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuOptions AWS API Documentation
    #
    class CpuOptions < Struct.new(
      :core_count,
      :threads_per_core,
      :amd_sev_snp,
      :nested_virtualization)
      SENSITIVE = []
      include Aws::Structure
    end

    # The CPU options for the instance. Both the core count and threads per
    # core must be specified in the request.
    #
    # @!attribute [rw] core_count
    #   The number of CPU cores for the instance.
    #   @return [Integer]
    #
    # @!attribute [rw] threads_per_core
    #   The number of threads per CPU core. To disable multithreading for
    #   the instance, specify a value of `1`. Otherwise, specify the default
    #   value of `2`.
    #   @return [Integer]
    #
    # @!attribute [rw] amd_sev_snp
    #   Indicates whether to enable the instance for AMD SEV-SNP. AMD
    #   SEV-SNP is supported with M6a, R6a, and C6a instance types only. For
    #   more information, see [AMD SEV-SNP][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html
    #   @return [String]
    #
    # @!attribute [rw] nested_virtualization
    #   Indicates whether to enable the instance for nested virtualization.
    #   Nested virtualization is supported only on 8th generation
    #   Intel-based instance types (c8i, m8i, r8i, and their flex variants).
    #   When nested virtualization is enabled, Virtual Secure Mode (VSM) is
    #   automatically disabled for the instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuOptionsRequest AWS API Documentation
    #
    class CpuOptionsRequest < Struct.new(
      :core_count,
      :threads_per_core,
      :amd_sev_snp,
      :nested_virtualization)
      SENSITIVE = []
      include Aws::Structure
    end

    # The CPU performance to consider, using an instance family as the
    # baseline reference.
    #
    # @!attribute [rw] references
    #   Specify an instance family to use as the baseline reference for CPU
    #   performance. All instance types that match your specified attributes
    #   will be compared against the CPU performance of the referenced
    #   instance family, regardless of CPU manufacturer or architecture
    #   differences.
    #
    #   <note markdown="1"> Currently, only one instance family can be specified in the list.
    #
    #    </note>
    #   @return [Array<Types::PerformanceFactorReference>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuPerformanceFactor AWS API Documentation
    #
    class CpuPerformanceFactor < Struct.new(
      :references)
      SENSITIVE = []
      include Aws::Structure
    end

    # The CPU performance to consider, using an instance family as the
    # baseline reference.
    #
    # @!attribute [rw] references
    #   Specify an instance family to use as the baseline reference for CPU
    #   performance. All instance types that match your specified attributes
    #   will be compared against the CPU performance of the referenced
    #   instance family, regardless of CPU manufacturer or architecture
    #   differences.
    #
    #   <note markdown="1"> Currently, only one instance family can be specified in the list.
    #
    #    </note>
    #   @return [Array<Types::PerformanceFactorReferenceRequest>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuPerformanceFactorRequest AWS API Documentation
    #
    class CpuPerformanceFactorRequest < Struct.new(
      :references)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] s3_bucket_name
    #   The name of the S3 bucket where the capacity data export files will
    #   be delivered. The bucket must exist and you must have write
    #   permissions to it.
    #   @return [String]
    #
    # @!attribute [rw] s3_bucket_prefix
    #   The S3 key prefix for the exported data files. This allows you to
    #   organize exports in a specific folder structure within your bucket.
    #   If not specified, files are placed at the bucket root.
    #   @return [String]
    #
    # @!attribute [rw] schedule
    #   The frequency at which data exports are generated.
    #   @return [String]
    #
    # @!attribute [rw] output_format
    #   The file format for the exported data. Parquet format is recommended
    #   for large datasets and better compression.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see Ensure
    #   Idempotency.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the data export configuration. You can tag the
    #   export for organization and cost tracking purposes.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityManagerDataExportRequest AWS API Documentation
    #
    class CreateCapacityManagerDataExportRequest < Struct.new(
      :s3_bucket_name,
      :s3_bucket_prefix,
      :schedule,
      :output_format,
      :client_token,
      :dry_run,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_manager_data_export_id
    #   The unique identifier for the created data export configuration. Use
    #   this ID to reference the export in other API calls.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityManagerDataExportResult AWS API Documentation
    #
    class CreateCapacityManagerDataExportResult < Struct.new(
      :capacity_manager_data_export_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] source_capacity_reservation_id
    #   The ID of the Capacity Reservation from which you want to split the
    #   capacity.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances to split from the source Capacity
    #   Reservation.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new Capacity Reservation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationBySplittingRequest AWS API Documentation
    #
    class CreateCapacityReservationBySplittingRequest < Struct.new(
      :dry_run,
      :client_token,
      :source_capacity_reservation_id,
      :instance_count,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] source_capacity_reservation
    #   Information about the source Capacity Reservation.
    #   @return [Types::CapacityReservation]
    #
    # @!attribute [rw] destination_capacity_reservation
    #   Information about the destination Capacity Reservation.
    #   @return [Types::CapacityReservation]
    #
    # @!attribute [rw] instance_count
    #   The number of instances in the new Capacity Reservation. The number
    #   of instances in the source Capacity Reservation was reduced by this
    #   amount.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationBySplittingResult AWS API Documentation
    #
    class CreateCapacityReservationBySplittingResult < Struct.new(
      :source_capacity_reservation,
      :destination_capacity_reservation,
      :instance_count)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] allocation_strategy
    #   The strategy used by the Capacity Reservation Fleet to determine
    #   which of the specified instance types to use. Currently, only the
    #   `prioritized` allocation strategy is supported. For more
    #   information, see [ Allocation strategy][1] in the *Amazon EC2 User
    #   Guide*.
    #
    #   Valid values: `prioritized`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] instance_type_specifications
    #   Information about the instance types for which to reserve the
    #   capacity.
    #   @return [Array<Types::ReservationFleetInstanceSpecification>]
    #
    # @!attribute [rw] tenancy
    #   Indicates the tenancy of the Capacity Reservation Fleet. All
    #   Capacity Reservations in the Fleet inherit this tenancy. The
    #   Capacity Reservation Fleet can have one of the following tenancy
    #   settings:
    #
    #   * `default` - The Capacity Reservation Fleet is created on hardware
    #     that is shared with other Amazon Web Services accounts.
    #
    #   * `dedicated` - The Capacity Reservations are created on
    #     single-tenant hardware that is dedicated to a single Amazon Web
    #     Services account.
    #   @return [String]
    #
    # @!attribute [rw] total_target_capacity
    #   The total number of capacity units to be reserved by the Capacity
    #   Reservation Fleet. This value, together with the instance type
    #   weights that you assign to each instance type used by the Fleet
    #   determine the number of instances for which the Fleet reserves
    #   capacity. Both values are based on units that make sense for your
    #   workload. For more information, see [Total target capacity][1] in
    #   the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity
    #   @return [Integer]
    #
    # @!attribute [rw] end_date
    #   The date and time at which the Capacity Reservation Fleet expires.
    #   When the Capacity Reservation Fleet expires, its state changes to
    #   `expired` and all of the Capacity Reservations in the Fleet expire.
    #
    #   The Capacity Reservation Fleet expires within an hour after the
    #   specified time. For example, if you specify `5/31/2019`, `13:30:55`,
    #   the Capacity Reservation Fleet is guaranteed to expire between
    #   `13:30:55` and `14:30:55` on `5/31/2019`.
    #   @return [Time]
    #
    # @!attribute [rw] instance_match_criteria
    #   Indicates the type of instance launches that the Capacity
    #   Reservation Fleet accepts. All Capacity Reservations in the Fleet
    #   inherit this instance matching criteria.
    #
    #   Currently, Capacity Reservation Fleets support `open` instance
    #   matching criteria only. This means that instances that have matching
    #   attributes (instance type, platform, and Availability Zone) run in
    #   the Capacity Reservations automatically. Instances do not need to
    #   explicitly target a Capacity Reservation Fleet to use its reserved
    #   capacity.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Capacity Reservation Fleet. The tags are
    #   automatically assigned to the Capacity Reservations in the Fleet.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleetRequest AWS API Documentation
    #
    class CreateCapacityReservationFleetRequest < Struct.new(
      :allocation_strategy,
      :client_token,
      :instance_type_specifications,
      :tenancy,
      :total_target_capacity,
      :end_date,
      :instance_match_criteria,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_fleet_id
    #   The ID of the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The status of the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] total_target_capacity
    #   The total number of capacity units for which the Capacity
    #   Reservation Fleet reserves capacity.
    #   @return [Integer]
    #
    # @!attribute [rw] total_fulfilled_capacity
    #   The requested capacity units that have been successfully reserved.
    #   @return [Float]
    #
    # @!attribute [rw] instance_match_criteria
    #   The instance matching criteria for the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] allocation_strategy
    #   The allocation strategy used by the Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] create_time
    #   The date and time at which the Capacity Reservation Fleet was
    #   created.
    #   @return [Time]
    #
    # @!attribute [rw] end_date
    #   The date and time at which the Capacity Reservation Fleet expires.
    #   @return [Time]
    #
    # @!attribute [rw] tenancy
    #   Indicates the tenancy of Capacity Reservation Fleet.
    #   @return [String]
    #
    # @!attribute [rw] fleet_capacity_reservations
    #   Information about the individual Capacity Reservations in the
    #   Capacity Reservation Fleet.
    #   @return [Array<Types::FleetCapacityReservation>]
    #
    # @!attribute [rw] tags
    #   The tags assigned to the Capacity Reservation Fleet.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleetResult AWS API Documentation
    #
    class CreateCapacityReservationFleetResult < Struct.new(
      :capacity_reservation_fleet_id,
      :state,
      :total_target_capacity,
      :total_fulfilled_capacity,
      :instance_match_criteria,
      :allocation_strategy,
      :create_time,
      :end_date,
      :tenancy,
      :fleet_capacity_reservations,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type for which to reserve capacity.
    #
    #   <note markdown="1"> You can request future-dated Capacity Reservations for instance
    #   types in the C, M, R, I, T, and G instance families only.
    #
    #    </note>
    #
    #   For more information, see [Instance types][1] in the *Amazon EC2
    #   User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #   @return [String]
    #
    # @!attribute [rw] instance_platform
    #   The type of operating system for which to reserve capacity.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which to create the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone in which to create the Capacity
    #   Reservation.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   Indicates the tenancy of the Capacity Reservation. A Capacity
    #   Reservation can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation is created on hardware that
    #     is shared with other Amazon Web Services accounts.
    #
    #   * `dedicated` - The Capacity Reservation is created on single-tenant
    #     hardware that is dedicated to a single Amazon Web Services
    #     account.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances for which to reserve capacity.
    #
    #   <note markdown="1"> You can request future-dated Capacity Reservations for an instance
    #   count with a minimum of 32 vCPUs. For example, if you request a
    #   future-dated Capacity Reservation for `m5.xlarge` instances, you
    #   must request at least 8 instances (*8 * m5.xlarge = 32 vCPUs*).
    #
    #    </note>
    #
    #   Valid range: 1 - 1000
    #   @return [Integer]
    #
    # @!attribute [rw] ebs_optimized
    #   Indicates whether the Capacity Reservation supports EBS-optimized
    #   instances. This optimization provides dedicated throughput to Amazon
    #   EBS and an optimized configuration stack to provide optimal I/O
    #   performance. This optimization isn't available with all instance
    #   types. Additional usage charges apply when using an EBS- optimized
    #   instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] ephemeral_storage
    #   *Deprecated.*
    #   @return [Boolean]
    #
    # @!attribute [rw] end_date
    #   The date and time at which the Capacity Reservation expires. When a
    #   Capacity Reservation expires, the reserved capacity is released and
    #   you can no longer launch instances into it. The Capacity
    #   Reservation's state changes to `expired` when it reaches its end
    #   date and time.
    #
    #   You must provide an `EndDate` value if `EndDateType` is `limited`.
    #   Omit `EndDate` if `EndDateType` is `unlimited`.
    #
    #   If the `EndDateType` is `limited`, the Capacity Reservation is
    #   cancelled within an hour from the specified time. For example, if
    #   you specify 5/31/2019, 13:30:55, the Capacity Reservation is
    #   guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
    #
    #   If you are requesting a future-dated Capacity Reservation, you
    #   can't specify an end date and time that is within the commitment
    #   duration.
    #   @return [Time]
    #
    # @!attribute [rw] end_date_type
    #   Indicates the way in which the Capacity Reservation ends. A Capacity
    #   Reservation can have one of the following end types:
    #
    #   * `unlimited` - The Capacity Reservation remains active until you
    #     explicitly cancel it. Do not provide an `EndDate` if the
    #     `EndDateType` is `unlimited`.
    #
    #   * `limited` - The Capacity Reservation expires automatically at a
    #     specified date and time. You must provide an `EndDate` value if
    #     the `EndDateType` value is `limited`.
    #   @return [String]
    #
    # @!attribute [rw] instance_match_criteria
    #   Indicates the type of instance launches that the Capacity
    #   Reservation accepts. The options include:
    #
    #   * `open` - The Capacity Reservation automatically matches all
    #     instances that have matching attributes (instance type, platform,
    #     and Availability Zone). Instances that have matching attributes
    #     run in the Capacity Reservation automatically without specifying
    #     any additional parameters.
    #
    #   * `targeted` - The Capacity Reservation only accepts instances that
    #     have matching attributes (instance type, platform, and
    #     Availability Zone), and explicitly target the Capacity
    #     Reservation. This ensures that only permitted instances can use
    #     the reserved capacity.
    #
    #   <note markdown="1"> If you are requesting a future-dated Capacity Reservation, you must
    #   specify `targeted`.
    #
    #    </note>
    #
    #   Default: `open`
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Capacity Reservation during launch.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] outpost_arn
    #   <note markdown="1"> Not supported for future-dated Capacity Reservations.
    #
    #    </note>
    #
    #   The Amazon Resource Name (ARN) of the Outpost on which to create the
    #   Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] placement_group_arn
    #   <note markdown="1"> Not supported for future-dated Capacity Reservations.
    #
    #    </note>
    #
    #   The Amazon Resource Name (ARN) of the cluster placement group in
    #   which to create the Capacity Reservation. For more information, see
    #   [ Capacity Reservations for cluster placement groups][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html
    #   @return [String]
    #
    # @!attribute [rw] start_date
    #   <note markdown="1"> Required for future-dated Capacity Reservations only. To create a
    #   Capacity Reservation for immediate use, omit this parameter.
    #
    #    </note>
    #
    #   The date and time at which the future-dated Capacity Reservation
    #   should become available for use, in the ISO8601 format in the UTC
    #   time zone (`YYYY-MM-DDThh:mm:ss.sssZ`).
    #
    #   You can request a future-dated Capacity Reservation between 5 and
    #   120 days in advance.
    #   @return [Time]
    #
    # @!attribute [rw] commitment_duration
    #   <note markdown="1"> Required for future-dated Capacity Reservations only. To create a
    #   Capacity Reservation for immediate use, omit this parameter.
    #
    #    </note>
    #
    #   Specify a commitment duration, in seconds, for the future-dated
    #   Capacity Reservation.
    #
    #   The commitment duration is a minimum duration for which you commit
    #   to having the future-dated Capacity Reservation in the `active`
    #   state in your account after it has been delivered.
    #
    #   For more information, see [ Commitment duration][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-concepts.html#cr-commitment-duration
    #   @return [Integer]
    #
    # @!attribute [rw] delivery_preference
    #   <note markdown="1"> Required for future-dated Capacity Reservations only. To create a
    #   Capacity Reservation for immediate use, omit this parameter.
    #
    #    </note>
    #
    #   Indicates that the requested capacity will be delivered in addition
    #   to any running instances or reserved capacity that you have in your
    #   account at the requested date and time.
    #
    #   The only supported value is `incremental`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationRequest AWS API Documentation
    #
    class CreateCapacityReservationRequest < Struct.new(
      :client_token,
      :instance_type,
      :instance_platform,
      :availability_zone,
      :availability_zone_id,
      :tenancy,
      :instance_count,
      :ebs_optimized,
      :ephemeral_storage,
      :end_date,
      :end_date_type,
      :instance_match_criteria,
      :tag_specifications,
      :dry_run,
      :outpost_arn,
      :placement_group_arn,
      :start_date,
      :commitment_duration,
      :delivery_preference)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation
    #   Information about the Capacity Reservation.
    #   @return [Types::CapacityReservation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationResult AWS API Documentation
    #
    class CreateCapacityReservationResult < Struct.new(
      :capacity_reservation)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_id
    #   The ID of the VPC to associate with the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to associate with the carrier gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGatewayRequest AWS API Documentation
    #
    class CreateCarrierGatewayRequest < Struct.new(
      :vpc_id,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateway
    #   Information about the carrier gateway.
    #   @return [Types::CarrierGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGatewayResult AWS API Documentation
    #
    class CreateCarrierGatewayResult < Struct.new(
      :carrier_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_cidr_block
    #   The IPv4 address range, in CIDR notation, from which to assign
    #   client IP addresses. The address range cannot overlap with the local
    #   CIDR of the VPC in which the associated subnet is located, or the
    #   routes that you add manually. The address range cannot be changed
    #   after the Client VPN endpoint has been created. Client CIDR range
    #   must have a size of at least /22 and must not be greater than /12.
    #   @return [String]
    #
    # @!attribute [rw] server_certificate_arn
    #   The ARN of the server certificate. For more information, see the
    #   [Certificate Manager User Guide][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/acm/latest/userguide/
    #   @return [String]
    #
    # @!attribute [rw] authentication_options
    #   Information about the authentication method to be used to
    #   authenticate clients.
    #   @return [Array<Types::ClientVpnAuthenticationRequest>]
    #
    # @!attribute [rw] connection_log_options
    #   Information about the client connection logging options.
    #
    #   If you enable client connection logging, data about client
    #   connections is sent to a Cloudwatch Logs log stream. The following
    #   information is logged:
    #
    #   * Client connection requests
    #
    #   * Client connection results (successful and unsuccessful)
    #
    #   * Reasons for unsuccessful client connection requests
    #
    #   * Client connection termination time
    #   @return [Types::ConnectionLogOptions]
    #
    # @!attribute [rw] dns_servers
    #   Information about the DNS servers to be used for DNS resolution. A
    #   Client VPN endpoint can have up to two DNS servers. If no DNS server
    #   is specified, the DNS address configured on the device is used for
    #   the DNS server.
    #   @return [Array<String>]
    #
    # @!attribute [rw] transport_protocol
    #   The transport protocol to be used by the VPN session.
    #
    #   Default value: `udp`
    #   @return [String]
    #
    # @!attribute [rw] vpn_port
    #   The port number to assign to the Client VPN endpoint for TCP and UDP
    #   traffic.
    #
    #   Valid Values: `443` \| `1194`
    #
    #   Default Value: `443`
    #   @return [Integer]
    #
    # @!attribute [rw] description
    #   A brief description of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] split_tunnel
    #   Indicates whether split-tunnel is enabled on the Client VPN
    #   endpoint.
    #
    #   By default, split-tunnel on a VPN endpoint is disabled.
    #
    #   For information about split-tunnel VPN endpoints, see [Split-tunnel
    #   Client VPN endpoint][1] in the *Client VPN Administrator Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Client VPN endpoint during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] security_group_ids
    #   The IDs of one or more security groups to apply to the target
    #   network. You must also specify the ID of the VPC that contains the
    #   security groups.
    #   @return [Array<String>]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC to associate with the Client VPN endpoint. If no
    #   security group IDs are specified in the request, the default
    #   security group for the VPC is applied.
    #   @return [String]
    #
    # @!attribute [rw] self_service_portal
    #   Specify whether to enable the self-service portal for the Client VPN
    #   endpoint.
    #
    #   Default Value: `enabled`
    #   @return [String]
    #
    # @!attribute [rw] client_connect_options
    #   The options for managing connection authorization for new client
    #   connections.
    #   @return [Types::ClientConnectOptions]
    #
    # @!attribute [rw] session_timeout_hours
    #   The maximum VPN session duration time in hours.
    #
    #   Valid values: `8 | 10 | 12 | 24`
    #
    #   Default value: `24`
    #   @return [Integer]
    #
    # @!attribute [rw] client_login_banner_options
    #   Options for enabling a customizable text banner that will be
    #   displayed on Amazon Web Services provided clients when a VPN session
    #   is established.
    #   @return [Types::ClientLoginBannerOptions]
    #
    # @!attribute [rw] client_route_enforcement_options
    #   Client route enforcement is a feature of the Client VPN service that
    #   helps enforce administrator defined routes on devices connected
    #   through the VPN. T his feature helps improve your security posture
    #   by ensuring that network traffic originating from a connected client
    #   is not inadvertently sent outside the VPN tunnel.
    #
    #   Client route enforcement works by monitoring the route table of a
    #   connected device for routing policy changes to the VPN connection.
    #   If the feature detects any VPN routing policy modifications, it will
    #   automatically force an update to the route table, reverting it back
    #   to the expected route configurations.
    #   @return [Types::ClientRouteEnforcementOptions]
    #
    # @!attribute [rw] disconnect_on_session_timeout
    #   Indicates whether the client VPN session is disconnected after the
    #   maximum timeout specified in `SessionTimeoutHours` is reached. If
    #   `true`, users are prompted to reconnect client VPN. If `false`,
    #   client VPN attempts to reconnect automatically. The default value is
    #   `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] endpoint_ip_address_type
    #   The IP address type for the Client VPN endpoint. Valid values are
    #   `ipv4` (default) for IPv4 addressing only, `ipv6` for IPv6
    #   addressing only, or `dual-stack` for both IPv4 and IPv6 addressing.
    #   When set to `dual-stack,` clients can connect to the endpoint using
    #   either IPv4 or IPv6 addresses..
    #   @return [String]
    #
    # @!attribute [rw] traffic_ip_address_type
    #   The IP address type for traffic within the Client VPN tunnel. Valid
    #   values are `ipv4` (default) for IPv4 traffic only, `ipv6` for IPv6
    #   addressing only, or `dual-stack` for both IPv4 and IPv6 traffic.
    #   When set to `dual-stack`, clients can access both IPv4 and IPv6
    #   resources through the VPN .
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpointRequest AWS API Documentation
    #
    class CreateClientVpnEndpointRequest < Struct.new(
      :client_cidr_block,
      :server_certificate_arn,
      :authentication_options,
      :connection_log_options,
      :dns_servers,
      :transport_protocol,
      :vpn_port,
      :description,
      :split_tunnel,
      :dry_run,
      :client_token,
      :tag_specifications,
      :security_group_ids,
      :vpc_id,
      :self_service_portal,
      :client_connect_options,
      :session_timeout_hours,
      :client_login_banner_options,
      :client_route_enforcement_options,
      :disconnect_on_session_timeout,
      :endpoint_ip_address_type,
      :traffic_ip_address_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the Client VPN endpoint.
    #   @return [Types::ClientVpnEndpointStatus]
    #
    # @!attribute [rw] dns_name
    #   The DNS name to be used by clients when establishing their VPN
    #   session.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpointResult AWS API Documentation
    #
    class CreateClientVpnEndpointResult < Struct.new(
      :client_vpn_endpoint_id,
      :status,
      :dns_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint to which to add the route.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route destination.
    #   For example:
    #
    #   * To add a route for Internet access, enter `0.0.0.0/0`
    #
    #   * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR
    #     range
    #
    #   * To add a route for an on-premises network, enter the Amazon Web
    #     Services Site-to-Site VPN connection's IPv4 CIDR range
    #
    #   * To add a route for the local network, enter the client CIDR range
    #   @return [String]
    #
    # @!attribute [rw] target_vpc_subnet_id
    #   The ID of the subnet through which you want to route traffic. The
    #   specified subnet must be an existing target network of the Client
    #   VPN endpoint.
    #
    #   Alternatively, if you're adding a route for the local network,
    #   specify `local`.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A brief description of the route.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRouteRequest AWS API Documentation
    #
    class CreateClientVpnRouteRequest < Struct.new(
      :client_vpn_endpoint_id,
      :destination_cidr_block,
      :target_vpc_subnet_id,
      :description,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the route.
    #   @return [Types::ClientVpnRouteStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRouteResult AWS API Documentation
    #
    class CreateClientVpnRouteResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cidr
    #   A customer-owned IP address range to create.
    #   @return [String]
    #
    # @!attribute [rw] coip_pool_id
    #   The ID of the address pool.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidrRequest AWS API Documentation
    #
    class CreateCoipCidrRequest < Struct.new(
      :cidr,
      :coip_pool_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] coip_cidr
    #   Information about a range of customer-owned IP addresses.
    #   @return [Types::CoipCidr]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidrResult AWS API Documentation
    #
    class CreateCoipCidrResult < Struct.new(
      :coip_cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the CoIP address pool.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPoolRequest AWS API Documentation
    #
    class CreateCoipPoolRequest < Struct.new(
      :local_gateway_route_table_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] coip_pool
    #   Information about the CoIP address pool.
    #   @return [Types::CoipPool]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPoolResult AWS API Documentation
    #
    class CreateCoipPoolResult < Struct.new(
      :coip_pool)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateCustomerGateway.
    #
    # @!attribute [rw] bgp_asn
    #   For customer gateway devices that support BGP, specify the device's
    #   ASN. You must specify either `BgpAsn` or `BgpAsnExtended` when
    #   creating the customer gateway. If the ASN is larger than
    #   `2,147,483,647`, you must use `BgpAsnExtended`.
    #
    #   Default: 65000
    #
    #   Valid values: `1` to `2,147,483,647`
    #   @return [Integer]
    #
    # @!attribute [rw] public_ip
    #   *This member has been deprecated.* The Internet-routable IP address
    #   for the customer gateway's outside interface. The address must be
    #   static.
    #   @return [String]
    #
    # @!attribute [rw] certificate_arn
    #   The Amazon Resource Name (ARN) for the customer gateway certificate.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection that this customer gateway supports
    #   (`ipsec.1`).
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the customer gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] device_name
    #   A name for the customer gateway device.
    #
    #   Length Constraints: Up to 255 characters.
    #   @return [String]
    #
    # @!attribute [rw] ip_address
    #   The IP address for the customer gateway device's outside interface.
    #   The address must be static. If `OutsideIpAddressType` in your VPN
    #   connection options is set to `PrivateIpv4`, you can use an RFC6598
    #   or RFC1918 private IPv4 address. If `OutsideIpAddressType` is set to
    #   `Ipv6`, you can use an IPv6 address.
    #   @return [String]
    #
    # @!attribute [rw] bgp_asn_extended
    #   For customer gateway devices that support BGP, specify the device's
    #   ASN. You must specify either `BgpAsn` or `BgpAsnExtended` when
    #   creating the customer gateway. If the ASN is larger than
    #   `2,147,483,647`, you must use `BgpAsnExtended`.
    #
    #   Valid values: `2,147,483,648` to `4,294,967,295`
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGatewayRequest AWS API Documentation
    #
    class CreateCustomerGatewayRequest < Struct.new(
      :bgp_asn,
      :public_ip,
      :certificate_arn,
      :type,
      :tag_specifications,
      :device_name,
      :ip_address,
      :bgp_asn_extended,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateCustomerGateway.
    #
    # @!attribute [rw] customer_gateway
    #   Information about the customer gateway.
    #   @return [Types::CustomerGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGatewayResult AWS API Documentation
    #
    class CreateCustomerGatewayResult < Struct.new(
      :customer_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] availability_zone
    #   The Availability Zone in which to create the default subnet.
    #
    #   Either `AvailabilityZone` or `AvailabilityZoneId` must be specified,
    #   but not both.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipv_6_native
    #   Indicates whether to create an IPv6 only subnet. If you already have
    #   a default subnet for this Availability Zone, you must delete it
    #   before you can create an IPv6 only subnet.
    #   @return [Boolean]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone.
    #
    #   Either `AvailabilityZone` or `AvailabilityZoneId` must be specified,
    #   but not both.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnetRequest AWS API Documentation
    #
    class CreateDefaultSubnetRequest < Struct.new(
      :availability_zone,
      :dry_run,
      :ipv_6_native,
      :availability_zone_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet
    #   Information about the subnet.
    #   @return [Types::Subnet]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnetResult AWS API Documentation
    #
    class CreateDefaultSubnetResult < Struct.new(
      :subnet)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpcRequest AWS API Documentation
    #
    class CreateDefaultVpcRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc
    #   Information about the VPC.
    #   @return [Types::Vpc]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpcResult AWS API Documentation
    #
    class CreateDefaultVpcResult < Struct.new(
      :vpc)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the Amazon EC2 Mac instance.
    #   @return [String]
    #
    # @!attribute [rw] mac_credentials
    #   Specifies the following credentials:
    #
    #   * **Internal disk administrative user**
    #
    #     * **Username** - Only the default administrative user
    #       (`aws-managed-user`) is supported and it is used by default. You
    #       can't specify a different administrative user.
    #
    #     * **Password** - If you did not change the default password for
    #       `aws-managed-user`, specify the default password, which is
    #       *blank*. Otherwise, specify your password.
    #   * **Amazon EBS root volume administrative user**
    #
    #     * **Username** - If you did not change the default administrative
    #       user, specify `ec2-user`. Otherwise, specify the username for
    #       your administrative user.
    #
    #     * **Password** - Specify the password for the administrative user.
    #
    #   The credentials must be specified in the following JSON format:
    #
    #   `{ "internalDiskPassword":"internal-disk-admin_password",
    #   "rootVolumeUsername":"root-volume-admin_username",
    #   "rootVolumepassword":"root-volume-admin_password" }`
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the volume ownership delegation task.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDelegateMacVolumeOwnershipTaskRequest AWS API Documentation
    #
    class CreateDelegateMacVolumeOwnershipTaskRequest < Struct.new(
      :client_token,
      :dry_run,
      :instance_id,
      :mac_credentials,
      :tag_specifications)
      SENSITIVE = [:mac_credentials]
      include Aws::Structure
    end

    # @!attribute [rw] mac_modification_task
    #   Information about the volume ownership delegation task.
    #   @return [Types::MacModificationTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDelegateMacVolumeOwnershipTaskResult AWS API Documentation
    #
    class CreateDelegateMacVolumeOwnershipTaskResult < Struct.new(
      :mac_modification_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dhcp_configurations
    #   A DHCP configuration option.
    #   @return [Array<Types::NewDhcpConfiguration>]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the DHCP option.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptionsRequest AWS API Documentation
    #
    class CreateDhcpOptionsRequest < Struct.new(
      :dhcp_configurations,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dhcp_options
    #   A set of DHCP options.
    #   @return [Types::DhcpOptions]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptionsResult AWS API Documentation
    #
    class CreateDhcpOptionsResult < Struct.new(
      :dhcp_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC for which to create the egress-only internet
    #   gateway.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the egress-only internet gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGatewayRequest AWS API Documentation
    #
    class CreateEgressOnlyInternetGatewayRequest < Struct.new(
      :client_token,
      :dry_run,
      :vpc_id,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @!attribute [rw] egress_only_internet_gateway
    #   Information about the egress-only internet gateway.
    #   @return [Types::EgressOnlyInternetGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGatewayResult AWS API Documentation
    #
    class CreateEgressOnlyInternetGatewayResult < Struct.new(
      :client_token,
      :egress_only_internet_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that could not be launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that could not be launched was a Spot
    #   Instance or On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] error_code
    #   The error code that indicates why the instance could not be
    #   launched. For more information about error codes, see [Error
    #   codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html
    #   @return [String]
    #
    # @!attribute [rw] error_message
    #   The error message that describes why the instance could not be
    #   launched. For more information about error messages, see [Error
    #   codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetError AWS API Documentation
    #
    class CreateFleetError < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :error_code,
      :error_message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that were launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that was launched is a Spot Instance or
    #   On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_ids
    #   The IDs of the instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] instance_type
    #   The instance type.
    #   @return [String]
    #
    # @!attribute [rw] platform
    #   The value is `windows` for Windows instances in an EC2 Fleet.
    #   Otherwise, the value is blank.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetInstance AWS API Documentation
    #
    class CreateFleetInstance < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :instance_ids,
      :instance_type,
      :platform)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. If you do not specify a client token, a
    #   randomly generated token is used for the request to ensure
    #   idempotency.
    #
    #   For more information, see [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] spot_options
    #   Describes the configuration of Spot Instances in an EC2 Fleet.
    #   @return [Types::SpotOptionsRequest]
    #
    # @!attribute [rw] on_demand_options
    #   Describes the configuration of On-Demand Instances in an EC2 Fleet.
    #   @return [Types::OnDemandOptionsRequest]
    #
    # @!attribute [rw] excess_capacity_termination_policy
    #   Indicates whether running instances should be terminated if the
    #   total target capacity of the EC2 Fleet is decreased below the
    #   current size of the EC2 Fleet.
    #
    #   Supported only for fleets of type `maintain`.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_configs
    #   The configuration for the EC2 Fleet.
    #   @return [Array<Types::FleetLaunchTemplateConfigRequest>]
    #
    # @!attribute [rw] target_capacity_specification
    #   The number of units to request.
    #   @return [Types::TargetCapacitySpecificationRequest]
    #
    # @!attribute [rw] terminate_instances_with_expiration
    #   Indicates whether running instances should be terminated when the
    #   EC2 Fleet expires.
    #   @return [Boolean]
    #
    # @!attribute [rw] type
    #   The fleet type. The default value is `maintain`.
    #
    #   * `maintain` - The EC2 Fleet places an asynchronous request for your
    #     desired capacity, and continues to maintain your desired Spot
    #     capacity by replenishing interrupted Spot Instances.
    #
    #   * `request` - The EC2 Fleet places an asynchronous one-time request
    #     for your desired capacity, but does submit Spot requests in
    #     alternative capacity pools if Spot capacity is unavailable, and
    #     does not maintain Spot capacity if Spot Instances are interrupted.
    #
    #   * `instant` - The EC2 Fleet places a synchronous one-time request
    #     for your desired capacity, and returns errors for any instances
    #     that could not be launched.
    #
    #   For more information, see [EC2 Fleet request types][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html
    #   @return [String]
    #
    # @!attribute [rw] valid_from
    #   The start date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). The default is to start
    #   fulfilling the request immediately.
    #   @return [Time]
    #
    # @!attribute [rw] valid_until
    #   The end date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). At this point, no new EC2 Fleet
    #   requests are placed or able to fulfill the request. If no value is
    #   specified, the request remains until you cancel it.
    #   @return [Time]
    #
    # @!attribute [rw] replace_unhealthy_instances
    #   Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
    #   Supported only for fleets of type `maintain`. For more information,
    #   see [EC2 Fleet health checks][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The key-value pair for tagging the EC2 Fleet request on creation.
    #   For more information, see [Tag your resources][1].
    #
    #   If the fleet type is `instant`, specify a resource type of `fleet`
    #   to tag the fleet or `instance` to tag the instances at launch.
    #
    #   If the fleet type is `maintain` or `request`, specify a resource
    #   type of `fleet` to tag the fleet. You cannot specify a resource type
    #   of `instance`. To tag instances at launch, specify the tags in a
    #   [launch template][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] context
    #   Reserved.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetRequest AWS API Documentation
    #
    class CreateFleetRequest < Struct.new(
      :dry_run,
      :client_token,
      :spot_options,
      :on_demand_options,
      :excess_capacity_termination_policy,
      :launch_template_configs,
      :target_capacity_specification,
      :terminate_instances_with_expiration,
      :type,
      :valid_from,
      :valid_until,
      :replace_unhealthy_instances,
      :tag_specifications,
      :context)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] errors
    #   Information about the instances that could not be launched by the
    #   fleet. Supported only for fleets of type `instant`.
    #   @return [Array<Types::CreateFleetError>]
    #
    # @!attribute [rw] instances
    #   Information about the instances that were launched by the fleet.
    #   Supported only for fleets of type `instant`.
    #   @return [Array<Types::CreateFleetInstance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetResult AWS API Documentation
    #
    class CreateFleetResult < Struct.new(
      :fleet_id,
      :errors,
      :instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] deliver_logs_permission_arn
    #   The ARN of the IAM role that allows Amazon EC2 to publish flow logs
    #   to the log destination.
    #
    #   This parameter is required if the destination type is
    #   `cloud-watch-logs`, or if the destination type is
    #   `kinesis-data-firehose` and the delivery stream and the resources to
    #   monitor are in different accounts.
    #   @return [String]
    #
    # @!attribute [rw] deliver_cross_account_role
    #   The ARN of the IAM role that allows Amazon EC2 to publish flow logs
    #   across accounts.
    #   @return [String]
    #
    # @!attribute [rw] log_group_name
    #   The name of a new or existing CloudWatch Logs log group where Amazon
    #   EC2 publishes your flow logs.
    #
    #   This parameter is valid only if the destination type is
    #   `cloud-watch-logs`.
    #   @return [String]
    #
    # @!attribute [rw] resource_ids
    #   The IDs of the resources to monitor. For example, if the resource
    #   type is `VPC`, specify the IDs of the VPCs.
    #
    #   Constraints: Maximum of 25 for transit gateway resource types.
    #   Maximum of 1000 for the other resource types.
    #   @return [Array<String>]
    #
    # @!attribute [rw] resource_type
    #   The type of resource to monitor.
    #   @return [String]
    #
    # @!attribute [rw] traffic_type
    #   The type of traffic to monitor (accepted traffic, rejected traffic,
    #   or all traffic). This parameter is not supported for transit gateway
    #   resource types. It is required for the other resource types.
    #   @return [String]
    #
    # @!attribute [rw] log_destination_type
    #   The type of destination for the flow log data.
    #
    #   Default: `cloud-watch-logs`
    #   @return [String]
    #
    # @!attribute [rw] log_destination
    #   The destination for the flow log data. The meaning of this parameter
    #   depends on the destination type.
    #
    #   * If the destination type is `cloud-watch-logs`, specify the ARN of
    #     a CloudWatch Logs log group. For example:
    #
    #     arn:aws:logs:*region*:*account\_id*:log-group:*my\_group*
    #
    #     Alternatively, use the `LogGroupName` parameter.
    #
    #   * If the destination type is `s3`, specify the ARN of an S3 bucket.
    #     For example:
    #
    #     arn:aws:s3:::*my\_bucket*/*my\_subfolder*/
    #
    #     The subfolder is optional. Note that you can't use `AWSLogs` as a
    #     subfolder name.
    #
    #   * If the destination type is `kinesis-data-firehose`, specify the
    #     ARN of a Kinesis Data Firehose delivery stream. For example:
    #
    #     arn:aws:firehose:*region*:*account\_id*:deliverystream:*my\_stream*
    #   @return [String]
    #
    # @!attribute [rw] log_format
    #   The fields to include in the flow log record. List the fields in the
    #   order in which they should appear. If you omit this parameter, the
    #   flow log is created using the default format. If you specify this
    #   parameter, you must include at least one field. For more information
    #   about the available fields, see [Flow log records][1] in the *Amazon
    #   VPC User Guide* or [Transit Gateway Flow Log records][2] in the
    #   *Amazon Web Services Transit Gateway Guide*.
    #
    #   Specify the fields using the `${field-id}` format, separated by
    #   spaces.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-log-records.html
    #   [2]: https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the flow logs.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] max_aggregation_interval
    #   The maximum interval of time during which a flow of packets is
    #   captured and aggregated into a flow log record. The possible values
    #   are 60 seconds (1 minute) or 600 seconds (10 minutes). This
    #   parameter must be 60 seconds for transit gateway resource types.
    #
    #   When a network interface is attached to a [Nitro-based instance][1],
    #   the aggregation interval is always 60 seconds or less, regardless of
    #   the value that you specify.
    #
    #   Default: 600
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html
    #   @return [Integer]
    #
    # @!attribute [rw] destination_options
    #   The destination options.
    #   @return [Types::DestinationOptionsRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogsRequest AWS API Documentation
    #
    class CreateFlowLogsRequest < Struct.new(
      :dry_run,
      :client_token,
      :deliver_logs_permission_arn,
      :deliver_cross_account_role,
      :log_group_name,
      :resource_ids,
      :resource_type,
      :traffic_type,
      :log_destination_type,
      :log_destination,
      :log_format,
      :tag_specifications,
      :max_aggregation_interval,
      :destination_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @!attribute [rw] flow_log_ids
    #   The IDs of the flow logs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] unsuccessful
    #   Information about the flow logs that could not be created
    #   successfully.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogsResult AWS API Documentation
    #
    class CreateFlowLogsResult < Struct.new(
      :client_token,
      :flow_log_ids,
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] input_storage_location
    #   The location of the encrypted design checkpoint in Amazon S3. The
    #   input must be a tarball.
    #   @return [Types::StorageLocation]
    #
    # @!attribute [rw] logs_storage_location
    #   The location in Amazon S3 for the output logs.
    #   @return [Types::StorageLocation]
    #
    # @!attribute [rw] description
    #   A description for the AFI.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   A name for the AFI.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the FPGA image during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImageRequest AWS API Documentation
    #
    class CreateFpgaImageRequest < Struct.new(
      :dry_run,
      :input_storage_location,
      :logs_storage_location,
      :description,
      :name,
      :client_token,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_image_id
    #   The FPGA image identifier (AFI ID).
    #   @return [String]
    #
    # @!attribute [rw] fpga_image_global_id
    #   The global FPGA image identifier (AGFI ID).
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImageResult AWS API Documentation
    #
    class CreateFpgaImageResult < Struct.new(
      :fpga_image_id,
      :fpga_image_global_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] tag_specifications
    #   The tags to apply to the AMI and snapshots on creation. You can tag
    #   the AMI, the snapshots, or both.
    #
    #   * To tag the AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the snapshots that are created of the root volume and of
    #     other Amazon EBS volumes that are attached to the instance, the
    #     value for `ResourceType` must be `snapshot`. The same tag is
    #     applied to all of the snapshots that are created.
    #
    #   If you specify other values for `ResourceType`, the request fails.
    #
    #   To tag an AMI or snapshot after it has been created, see
    #   [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] snapshot_location
    #   <note markdown="1"> Only supported for instances in Local Zones. If the source instance
    #   is not in a Local Zone, omit this parameter.
    #
    #    </note>
    #
    #   The Amazon S3 location where the snapshots will be stored.
    #
    #   * To create local snapshots in the same Local Zone as the source
    #     instance, specify `local`.
    #
    #   * To create regional snapshots in the parent Region of the Local
    #     Zone, specify `regional` or omit this parameter.
    #
    #   Default: `regional`
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   A name for the new image.
    #
    #   Constraints: 3-128 alphanumeric characters, parentheses (()), square
    #   brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
    #   single quotes ('), at-signs (@), or underscores(\_)
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the new image.
    #   @return [String]
    #
    # @!attribute [rw] no_reboot
    #   Indicates whether or not the instance should be automatically
    #   rebooted before creating the image. Specify one of the following
    #   values:
    #
    #   * `true` - The instance is not rebooted before creating the image.
    #     This creates crash-consistent snapshots that include only the data
    #     that has been written to the volumes at the time the snapshots are
    #     created. Buffered data and data in memory that has not yet been
    #     written to the volumes is not included in the snapshots.
    #
    #   * `false` - The instance is rebooted before creating the image. This
    #     ensures that all buffered data and data in memory is written to
    #     the volumes before the snapshots are created.
    #
    #   Default: `false`
    #   @return [Boolean]
    #
    # @!attribute [rw] block_device_mappings
    #   The block device mappings.
    #
    #   When using the CreateImage action:
    #
    #   * You can't change the volume size using the VolumeSize parameter.
    #     If you want a different volume size, you must first change the
    #     volume size of the source instance.
    #
    #   * You can't modify the encryption status of existing volumes or
    #     snapshots. To create an AMI with volumes or snapshots that have a
    #     different encryption status (for example, where the source volume
    #     and snapshots are unencrypted, and you want to create an AMI with
    #     encrypted volumes or snapshots), copy the image instead.
    #
    #   * The only option that can be changed for existing mappings or
    #     snapshots is `DeleteOnTermination`.
    #   @return [Array<Types::BlockDeviceMapping>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageRequest AWS API Documentation
    #
    class CreateImageRequest < Struct.new(
      :tag_specifications,
      :snapshot_location,
      :dry_run,
      :instance_id,
      :name,
      :description,
      :no_reboot,
      :block_device_mappings)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_id
    #   The ID of the new AMI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageResult AWS API Documentation
    #
    class CreateImageResult < Struct.new(
      :image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_id
    #   The ID of the image to report on.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] resource_types
    #   The resource types to include in the report.
    #   @return [Array<Types::ImageUsageResourceTypeRequest>]
    #
    # @!attribute [rw] account_ids
    #   The Amazon Web Services account IDs to include in the report. To
    #   include all accounts, omit this parameter.
    #   @return [Array<String>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure
    #   idempotency of the request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the report on creation. The `ResourceType` must
    #   be set to `image-usage-report`; any other value will cause the
    #   report creation to fail.
    #
    #   To tag a report after it has been created, see [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageUsageReportRequest AWS API Documentation
    #
    class CreateImageUsageReportRequest < Struct.new(
      :image_id,
      :dry_run,
      :resource_types,
      :account_ids,
      :client_token,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] report_id
    #   The ID of the report.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageUsageReportResult AWS API Documentation
    #
    class CreateImageUsageReportResult < Struct.new(
      :report_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet in which to create the EC2 Instance Connect
    #   Endpoint.
    #   @return [String]
    #
    # @!attribute [rw] security_group_ids
    #   One or more security groups to associate with the endpoint. If you
    #   don't specify a security group, the default security group for your
    #   VPC will be associated with the endpoint.
    #   @return [Array<String>]
    #
    # @!attribute [rw] preserve_client_ip
    #   Indicates whether the client IP address is preserved as the source.
    #   The following are the possible values.
    #
    #   * `true` - Use the client IP address as the source.
    #
    #   * `false` - Use the network interface IP address as the source.
    #
    #   <note markdown="1"> `PreserveClientIp` is only supported on IPv4 EC2 Instance Connect
    #   Endpoints. To use `PreserveClientIp`, the value for `IpAddressType`
    #   must be `ipv4`.
    #
    #    </note>
    #
    #   Default: `false`
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the EC2 Instance Connect Endpoint during
    #   creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] ip_address_type
    #   The IP address type of the endpoint.
    #
    #   If no value is specified, the default value is determined by the IP
    #   address type of the subnet:
    #
    #   * `dualstack` - If the subnet has both IPv4 and IPv6 CIDRs
    #
    #   * `ipv4` - If the subnet has only IPv4 CIDRs
    #
    #   * `ipv6` - If the subnet has only IPv6 CIDRs
    #
    #   <note markdown="1"> `PreserveClientIp` is only supported on IPv4 EC2 Instance Connect
    #   Endpoints. To use `PreserveClientIp`, the value for `IpAddressType`
    #   must be `ipv4`.
    #
    #    </note>
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpointRequest AWS API Documentation
    #
    class CreateInstanceConnectEndpointRequest < Struct.new(
      :dry_run,
      :subnet_id,
      :security_group_ids,
      :preserve_client_ip,
      :client_token,
      :tag_specifications,
      :ip_address_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_connect_endpoint
    #   Information about the EC2 Instance Connect Endpoint.
    #   @return [Types::Ec2InstanceConnectEndpoint]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive idempotency token provided by the client in
    #   the the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpointResult AWS API Documentation
    #
    class CreateInstanceConnectEndpointResult < Struct.new(
      :instance_connect_endpoint,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] name
    #   The name of the event window.
    #   @return [String]
    #
    # @!attribute [rw] time_ranges
    #   The time range for the event window. If you specify a time range,
    #   you can't specify a cron expression.
    #   @return [Array<Types::InstanceEventWindowTimeRangeRequest>]
    #
    # @!attribute [rw] cron_expression
    #   The cron expression for the event window, for example, `* 0-4,20-23
    #   * * 1,5`. If you specify a cron expression, you can't specify a
    #   time range.
    #
    #   Constraints:
    #
    #   * Only hour and day of the week values are supported.
    #
    #   * For day of the week values, you can specify either integers `0`
    #     through `6`, or alternative single values `SUN` through `SAT`.
    #
    #   * The minute, month, and year must be specified by `*`.
    #
    #   * The hour value must be one or a multiple range, for example, `0-4`
    #     or `0-4,20-23`.
    #
    #   * Each hour range must be &gt;= 2 hours, for example, `0-2` or
    #     `20-23`.
    #
    #   * The event window must be &gt;= 4 hours. The combined total time
    #     ranges in the event window must be &gt;= 4 hours.
    #
    #   For more information about cron expressions, see [cron][1] on the
    #   *Wikipedia website*.
    #
    #
    #
    #   [1]: https://en.wikipedia.org/wiki/Cron
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the event window.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindowRequest AWS API Documentation
    #
    class CreateInstanceEventWindowRequest < Struct.new(
      :dry_run,
      :name,
      :time_ranges,
      :cron_expression,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_event_window
    #   Information about the event window.
    #   @return [Types::InstanceEventWindow]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindowResult AWS API Documentation
    #
    class CreateInstanceEventWindowResult < Struct.new(
      :instance_event_window)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] tag_specifications
    #   The tags to apply to the export instance task during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] description
    #   A description for the conversion task or the resource being
    #   exported. The maximum length is 255 characters.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] target_environment
    #   The target virtualization environment.
    #   @return [String]
    #
    # @!attribute [rw] export_to_s3_task
    #   The format and location for an export instance task.
    #   @return [Types::ExportToS3TaskSpecification]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTaskRequest AWS API Documentation
    #
    class CreateInstanceExportTaskRequest < Struct.new(
      :tag_specifications,
      :description,
      :instance_id,
      :target_environment,
      :export_to_s3_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] export_task
    #   Information about the export instance task.
    #   @return [Types::ExportTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTaskResult AWS API Documentation
    #
    class CreateInstanceExportTaskResult < Struct.new(
      :export_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] tag_specifications
    #   The tags to assign to the internet gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGatewayRequest AWS API Documentation
    #
    class CreateInternetGatewayRequest < Struct.new(
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] internet_gateway
    #   Information about the internet gateway.
    #   @return [Types::InternetGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGatewayResult AWS API Documentation
    #
    class CreateInternetGatewayResult < Struct.new(
      :internet_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_id
    #   The ID of the source Capacity Reservation from which to create the
    #   interruptible Capacity Reservation. Your Capacity Reservation must
    #   be in active state with no end date set and have available capacity
    #   for allocation.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances to allocate from your source reservation.
    #   You can only allocate available instances (also called unused
    #   capacity).
    #   @return [Integer]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the interruptible Capacity Reservation during
    #   creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInterruptibleCapacityReservationAllocationRequest AWS API Documentation
    #
    class CreateInterruptibleCapacityReservationAllocationRequest < Struct.new(
      :capacity_reservation_id,
      :instance_count,
      :client_token,
      :dry_run,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] source_capacity_reservation_id
    #   The ID of the source Capacity Reservation from which the
    #   interruptible Capacity Reservation was created.
    #   @return [String]
    #
    # @!attribute [rw] target_instance_count
    #   The number of instances allocated to the interruptible reservation.
    #   @return [Integer]
    #
    # @!attribute [rw] status
    #   The current status of the allocation request (creating, active,
    #   updating).
    #   @return [String]
    #
    # @!attribute [rw] interruption_type
    #   The type of interruption applied to the interruptible reservation.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInterruptibleCapacityReservationAllocationResult AWS API Documentation
    #
    class CreateInterruptibleCapacityReservationAllocationResult < Struct.new(
      :source_capacity_reservation_id,
      :target_instance_count,
      :status,
      :interruption_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_id
    #   The ID of the IPAM that will create the token.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   Token tags.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamExternalResourceVerificationTokenRequest AWS API Documentation
    #
    class CreateIpamExternalResourceVerificationTokenRequest < Struct.new(
      :dry_run,
      :ipam_id,
      :tag_specifications,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_external_resource_verification_token
    #   The verification token.
    #   @return [Types::IpamExternalResourceVerificationToken]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamExternalResourceVerificationTokenResult AWS API Documentation
    #
    class CreateIpamExternalResourceVerificationTokenResult < Struct.new(
      :ipam_external_resource_verification_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the IPAM policy.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier to ensure the idempotency of the
    #   request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @!attribute [rw] ipam_id
    #   The ID of the IPAM for which you're creating the policy.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPolicyRequest AWS API Documentation
    #
    class CreateIpamPolicyRequest < Struct.new(
      :dry_run,
      :tag_specifications,
      :client_token,
      :ipam_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_policy
    #   Information about the created IPAM policy.
    #
    #   An IPAM policy is a set of rules that define how public IPv4
    #   addresses from IPAM pools are allocated to Amazon Web Services
    #   resources. Each rule maps an Amazon Web Services service to IPAM
    #   pools that the service will use to get IP addresses. A single policy
    #   can have multiple rules and be applied to multiple Amazon Web
    #   Services Regions. If the IPAM pool run out of addresses then the
    #   services fallback to Amazon-provided IP addresses. A policy can be
    #   applied to an individual Amazon Web Services account or an entity
    #   within Amazon Web Services Organizations.
    #   @return [Types::IpamPolicy]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPolicyResult AWS API Documentation
    #
    class CreateIpamPolicyResult < Struct.new(
      :ipam_policy)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_scope_id
    #   The ID of the scope in which you would like to create the IPAM pool.
    #   @return [String]
    #
    # @!attribute [rw] locale
    #   The locale for the pool should be one of the following:
    #
    #   * An Amazon Web Services Region where you want this IPAM pool to be
    #     available for allocations.
    #
    #   * The network border group for an Amazon Web Services Local Zone
    #     where you want this IPAM pool to be available for allocations
    #     ([supported Local Zones][1]). This option is only available for
    #     IPAM IPv4 pools in the public scope.
    #
    #   Possible values: Any Amazon Web Services Region or supported Amazon
    #   Web Services Local Zone. Default is `none` and means any locale.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail
    #   @return [String]
    #
    # @!attribute [rw] source_ipam_pool_id
    #   The ID of the source IPAM pool. Use this option to create a pool
    #   within an existing pool. Note that the CIDR you provision for the
    #   pool within the source pool must be available in the source pool's
    #   CIDR range.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the IPAM pool.
    #   @return [String]
    #
    # @!attribute [rw] address_family
    #   The IP protocol assigned to this IPAM pool. You must choose either
    #   IPv4 or IPv6 protocol for a pool.
    #   @return [String]
    #
    # @!attribute [rw] auto_import
    #   If selected, IPAM will continuously look for resources within the
    #   CIDR range of this pool and automatically import them as allocations
    #   into your IPAM. The CIDRs that will be allocated for these resources
    #   must not already be allocated to other resources in order for the
    #   import to succeed. IPAM will import a CIDR regardless of its
    #   compliance with the pool's allocation rules, so a resource might be
    #   imported and subsequently marked as noncompliant. If IPAM discovers
    #   multiple CIDRs that overlap, IPAM will import the largest CIDR only.
    #   If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will
    #   randomly import one of them only.
    #
    #   A locale must be set on the pool for this feature to work.
    #   @return [Boolean]
    #
    # @!attribute [rw] publicly_advertisable
    #   Determines if the pool is publicly advertisable. The request can
    #   only contain `PubliclyAdvertisable` if `AddressFamily` is `ipv6` and
    #   `PublicIpSource` is `byoip`.
    #   @return [Boolean]
    #
    # @!attribute [rw] allocation_min_netmask_length
    #   The minimum netmask length required for CIDR allocations in this
    #   IPAM pool to be compliant. The minimum netmask length must be less
    #   than the maximum netmask length. Possible netmask lengths for IPv4
    #   addresses are 0 - 32. Possible netmask lengths for IPv6 addresses
    #   are 0 - 128.
    #   @return [Integer]
    #
    # @!attribute [rw] allocation_max_netmask_length
    #   The maximum netmask length possible for CIDR allocations in this
    #   IPAM pool to be compliant. The maximum netmask length must be
    #   greater than the minimum netmask length. Possible netmask lengths
    #   for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6
    #   addresses are 0 - 128.
    #   @return [Integer]
    #
    # @!attribute [rw] allocation_default_netmask_length
    #   The default netmask length for allocations added to this pool. If,
    #   for example, the CIDR assigned to this pool is 10.0.0.0/8 and you
    #   enter 16 here, new allocations will default to 10.0.0.0/16.
    #   @return [Integer]
    #
    # @!attribute [rw] allocation_resource_tags
    #   Tags that are required for resources that use CIDRs from this IPAM
    #   pool. Resources that do not have these tags will not be allowed to
    #   allocate space from the pool. If the resources have their tags
    #   changed after they have allocated space or if the allocation tagging
    #   requirements are changed on the pool, the resource may be marked as
    #   noncompliant.
    #   @return [Array<Types::RequestIpamResourceTag>]
    #
    # @!attribute [rw] tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value.
    #   For example, to find all resources that have a tag with the key
    #   `Owner` and the value `TeamA`, specify `tag:Owner` for the filter
    #   name and `TeamA` for the filter value.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] aws_service
    #   Limits which service in Amazon Web Services that the pool can be
    #   used in. "ec2", for example, allows users to use space for Elastic
    #   IP addresses and VPCs.
    #   @return [String]
    #
    # @!attribute [rw] public_ip_source
    #   The IP address source for pools in the public scope. Only used for
    #   provisioning IP address CIDRs to pools in the public scope. Default
    #   is `byoip`. For more information, see [Create IPv6 pools][1] in the
    #   *Amazon VPC IPAM User Guide*. By default, you can add only one
    #   Amazon-provided IPv6 CIDR block to a top-level IPv6 pool if
    #   PublicIpSource is `amazon`. For information on increasing the
    #   default limit, see [ Quotas for your IPAM][2] in the *Amazon VPC
    #   IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/intro-create-ipv6-pools.html
    #   [2]: https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html
    #   @return [String]
    #
    # @!attribute [rw] source_resource
    #   The resource used to provision CIDRs to a resource planning pool.
    #   @return [Types::IpamPoolSourceResourceRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPoolRequest AWS API Documentation
    #
    class CreateIpamPoolRequest < Struct.new(
      :dry_run,
      :ipam_scope_id,
      :locale,
      :source_ipam_pool_id,
      :description,
      :address_family,
      :auto_import,
      :publicly_advertisable,
      :allocation_min_netmask_length,
      :allocation_max_netmask_length,
      :allocation_default_netmask_length,
      :allocation_resource_tags,
      :tag_specifications,
      :client_token,
      :aws_service,
      :public_ip_source,
      :source_resource)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_pool
    #   Information about the IPAM pool created.
    #   @return [Types::IpamPool]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPoolResult AWS API Documentation
    #
    class CreateIpamPoolResult < Struct.new(
      :ipam_pool)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_id
    #   The ID of the IPAM that will serve as the source of the IP address
    #   database for CIDR selection. The IPAM must be in the Advanced tier
    #   to use this feature.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the IPAM prefix list resolver to help you identify
    #   its purpose and configuration.
    #   @return [String]
    #
    # @!attribute [rw] address_family
    #   The address family for the IPAM prefix list resolver. Valid values
    #   are `ipv4` and `ipv6`. You must create separate resolvers for IPv4
    #   and IPv6 CIDRs as they cannot be mixed in the same resolver.
    #   @return [String]
    #
    # @!attribute [rw] rules
    #   The CIDR selection rules for the resolver.
    #
    #   CIDR selection rules define the business logic for selecting CIDRs
    #   from IPAM. If a CIDR matches any of the rules, it will be included.
    #   If a rule has multiple conditions, the CIDR has to match every
    #   condition of that rule. You can create a prefix list resolver
    #   without any CIDR selection rules, but it will generate empty
    #   versions (containing no CIDRs) until you add rules.
    #   @return [Array<Types::IpamPrefixListResolverRuleRequest>]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the IPAM prefix list resolver during creation.
    #   Tags help you organize and manage your Amazon Web Services
    #   resources.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPrefixListResolverRequest AWS API Documentation
    #
    class CreateIpamPrefixListResolverRequest < Struct.new(
      :dry_run,
      :ipam_id,
      :description,
      :address_family,
      :rules,
      :tag_specifications,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_prefix_list_resolver
    #   Information about the IPAM prefix list resolver that was created.
    #   @return [Types::IpamPrefixListResolver]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPrefixListResolverResult AWS API Documentation
    #
    class CreateIpamPrefixListResolverResult < Struct.new(
      :ipam_prefix_list_resolver)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_prefix_list_resolver_id
    #   The ID of the IPAM prefix list resolver that will manage the
    #   synchronization of CIDRs to the target prefix list.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_id
    #   The ID of the managed prefix list that will be synchronized with
    #   CIDRs selected by the IPAM prefix list resolver. This prefix list
    #   becomes an IPAM managed prefix list.
    #
    #   An IPAM-managed prefix list is a customer-managed prefix list that
    #   has been associated with an IPAM prefix list resolver target. When a
    #   prefix list becomes IPAM managed, its CIDRs are automatically
    #   synchronized based on the IPAM prefix list resolver's CIDR
    #   selection rules, and direct CIDR modifications are restricted.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_region
    #   The Amazon Web Services Region where the prefix list is located.
    #   This is required when referencing a prefix list in a different
    #   Region.
    #   @return [String]
    #
    # @!attribute [rw] desired_version
    #   The specific version of the prefix list to target. If not specified,
    #   the resolver will target the latest version.
    #   @return [Integer]
    #
    # @!attribute [rw] track_latest_version
    #   Indicates whether the resolver target should automatically track the
    #   latest version of the prefix list. When enabled, the target will
    #   always synchronize with the most current version of the prefix list.
    #
    #   Choose this for automatic updates when you want your prefix lists to
    #   stay current with infrastructure changes without manual
    #   intervention.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the IPAM prefix list resolver target during
    #   creation. Tags help you organize and manage your Amazon Web Services
    #   resources.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPrefixListResolverTargetRequest AWS API Documentation
    #
    class CreateIpamPrefixListResolverTargetRequest < Struct.new(
      :dry_run,
      :ipam_prefix_list_resolver_id,
      :prefix_list_id,
      :prefix_list_region,
      :desired_version,
      :track_latest_version,
      :tag_specifications,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_prefix_list_resolver_target
    #   Information about the IPAM prefix list resolver target that was
    #   created.
    #   @return [Types::IpamPrefixListResolverTarget]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPrefixListResolverTargetResult AWS API Documentation
    #
    class CreateIpamPrefixListResolverTargetResult < Struct.new(
      :ipam_prefix_list_resolver_target)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] description
    #   A description for the IPAM.
    #   @return [String]
    #
    # @!attribute [rw] operating_regions
    #   The operating Regions for the IPAM. Operating Regions are Amazon Web
    #   Services Regions where the IPAM is allowed to manage IP address
    #   CIDRs. IPAM only discovers and monitors resources in the Amazon Web
    #   Services Regions you select as operating Regions.
    #
    #   For more information about operating Regions, see [Create an
    #   IPAM][1] in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html
    #   @return [Array<Types::AddIpamOperatingRegion>]
    #
    # @!attribute [rw] tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value.
    #   For example, to find all resources that have a tag with the key
    #   `Owner` and the value `TeamA`, specify `tag:Owner` for the filter
    #   name and `TeamA` for the filter value.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tier
    #   IPAM is offered in a Free Tier and an Advanced Tier. For more
    #   information about the features available in each tier and the costs
    #   associated with the tiers, see [Amazon VPC pricing &gt; IPAM
    #   tab][1].
    #
    #
    #
    #   [1]: http://aws.amazon.com/vpc/pricing/
    #   @return [String]
    #
    # @!attribute [rw] enable_private_gua
    #   Enable this option to use your own GUA ranges as private IPv6
    #   addresses. This option is disabled by default.
    #   @return [Boolean]
    #
    # @!attribute [rw] metered_account
    #   A metered account is an Amazon Web Services account that is charged
    #   for active IP addresses managed in IPAM. For more information, see
    #   [Enable cost distribution][1] in the *Amazon VPC IPAM User Guide*.
    #
    #   Possible values:
    #
    #   * `ipam-owner` (default): The Amazon Web Services account which owns
    #     the IPAM is charged for all active IP addresses managed in IPAM.
    #
    #   * `resource-owner`: The Amazon Web Services account that owns the IP
    #     address is charged for the active IP address.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamRequest AWS API Documentation
    #
    class CreateIpamRequest < Struct.new(
      :dry_run,
      :description,
      :operating_regions,
      :tag_specifications,
      :client_token,
      :tier,
      :enable_private_gua,
      :metered_account)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] description
    #   A description for the IPAM resource discovery.
    #   @return [String]
    #
    # @!attribute [rw] operating_regions
    #   Operating Regions for the IPAM resource discovery. Operating Regions
    #   are Amazon Web Services Regions where the IPAM is allowed to manage
    #   IP address CIDRs. IPAM only discovers and monitors resources in the
    #   Amazon Web Services Regions you select as operating Regions.
    #   @return [Array<Types::AddIpamOperatingRegion>]
    #
    # @!attribute [rw] tag_specifications
    #   Tag specifications for the IPAM resource discovery.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A client token for the IPAM resource discovery.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscoveryRequest AWS API Documentation
    #
    class CreateIpamResourceDiscoveryRequest < Struct.new(
      :dry_run,
      :description,
      :operating_regions,
      :tag_specifications,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_resource_discovery
    #   An IPAM resource discovery.
    #   @return [Types::IpamResourceDiscovery]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscoveryResult AWS API Documentation
    #
    class CreateIpamResourceDiscoveryResult < Struct.new(
      :ipam_resource_discovery)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam
    #   Information about the IPAM created.
    #   @return [Types::Ipam]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResult AWS API Documentation
    #
    class CreateIpamResult < Struct.new(
      :ipam)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_id
    #   The ID of the IPAM for which you're creating this scope.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the scope you're creating.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value.
    #   For example, to find all resources that have a tag with the key
    #   `Owner` and the value `TeamA`, specify `tag:Owner` for the filter
    #   name and `TeamA` for the filter value.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] external_authority_configuration
    #   The configuration that links an Amazon VPC IPAM scope to an external
    #   authority system. It specifies the type of external system and the
    #   external resource identifier that identifies your account or
    #   instance in that system.
    #
    #   In IPAM, an external authority is a third-party IP address
    #   management system that provides CIDR blocks when you provision
    #   address space for top-level IPAM pools. This allows you to use your
    #   existing IP management system to control which address ranges are
    #   allocated to Amazon Web Services while using Amazon VPC IPAM to
    #   manage subnets within those ranges.
    #   @return [Types::ExternalAuthorityConfiguration]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScopeRequest AWS API Documentation
    #
    class CreateIpamScopeRequest < Struct.new(
      :dry_run,
      :ipam_id,
      :description,
      :tag_specifications,
      :client_token,
      :external_authority_configuration)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_scope
    #   Information about the created scope.
    #   @return [Types::IpamScope]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScopeResult AWS API Documentation
    #
    class CreateIpamScopeResult < Struct.new(
      :ipam_scope)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] key_name
    #   A unique name for the key pair.
    #
    #   Constraints: Up to 255 ASCII characters
    #   @return [String]
    #
    # @!attribute [rw] key_type
    #   The type of key pair. Note that ED25519 keys are not supported for
    #   Windows instances.
    #
    #   Default: `rsa`
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new key pair.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] key_format
    #   The format of the key pair.
    #
    #   Default: `pem`
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPairRequest AWS API Documentation
    #
    class CreateKeyPairRequest < Struct.new(
      :key_name,
      :key_type,
      :tag_specifications,
      :key_format,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. If a client token isn't specified, a
    #   randomly generated token is used in the request to ensure
    #   idempotency.
    #
    #   For more information, see [Ensuring idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   A name for the launch template.
    #   @return [String]
    #
    # @!attribute [rw] version_description
    #   A description for the first version of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_data
    #   The information for the launch template.
    #   @return [Types::RequestLaunchTemplateData]
    #
    # @!attribute [rw] operator
    #   Reserved for internal use.
    #   @return [Types::OperatorRequest]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the launch template on creation. To tag the
    #   launch template, the resource type must be `launch-template`.
    #
    #   To specify the tags for the resources that are created when an
    #   instance is launched, you must use the `TagSpecifications` parameter
    #   in the [launch template data][1] structure.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateRequest AWS API Documentation
    #
    class CreateLaunchTemplateRequest < Struct.new(
      :dry_run,
      :client_token,
      :launch_template_name,
      :version_description,
      :launch_template_data,
      :operator,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_template
    #   Information about the launch template.
    #   @return [Types::LaunchTemplate]
    #
    # @!attribute [rw] warning
    #   If the launch template contains parameters or parameter combinations
    #   that are not valid, an error code and an error message are returned
    #   for each issue that's found.
    #   @return [Types::ValidationWarning]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateResult AWS API Documentation
    #
    class CreateLaunchTemplateResult < Struct.new(
      :launch_template,
      :warning)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. If a client token isn't specified, a
    #   randomly generated token is used in the request to ensure
    #   idempotency.
    #
    #   For more information, see [Ensuring idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template.
    #
    #   You must specify either the launch template ID or the launch
    #   template name, but not both.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template.
    #
    #   You must specify either the launch template ID or the launch
    #   template name, but not both.
    #   @return [String]
    #
    # @!attribute [rw] source_version
    #   The version of the launch template on which to base the new version.
    #   Snapshots applied to the block device mapping are ignored when
    #   creating a new version unless they are explicitly included.
    #
    #   If you specify this parameter, the new version inherits the launch
    #   parameters from the source version. If you specify additional launch
    #   parameters for the new version, they overwrite any corresponding
    #   launch parameters inherited from the source version.
    #
    #   If you omit this parameter, the new version contains only the launch
    #   parameters that you specify for the new version.
    #   @return [String]
    #
    # @!attribute [rw] version_description
    #   A description for the version of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_data
    #   The information for the launch template.
    #   @return [Types::RequestLaunchTemplateData]
    #
    # @!attribute [rw] resolve_alias
    #   If `true`, and if a Systems Manager parameter is specified for
    #   `ImageId`, the AMI ID is displayed in the response for `imageID`.
    #   For more information, see [Use a Systems Manager parameter instead
    #   of an AMI ID][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `false`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersionRequest AWS API Documentation
    #
    class CreateLaunchTemplateVersionRequest < Struct.new(
      :dry_run,
      :client_token,
      :launch_template_id,
      :launch_template_name,
      :source_version,
      :version_description,
      :launch_template_data,
      :resolve_alias)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_template_version
    #   Information about the launch template version.
    #   @return [Types::LaunchTemplateVersion]
    #
    # @!attribute [rw] warning
    #   If the new version of the launch template contains parameters or
    #   parameter combinations that are not valid, an error code and an
    #   error message are returned for each issue that's found.
    #   @return [Types::ValidationWarning]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersionResult AWS API Documentation
    #
    class CreateLaunchTemplateVersionResult < Struct.new(
      :launch_template_version,
      :warning)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_virtual_interface_group_id
    #   The ID of the virtual interface group.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] destination_prefix_list_id
    #   The ID of the prefix list. Use a prefix list in place of
    #   `DestinationCidrBlock`. You cannot use `DestinationPrefixListId` and
    #   `DestinationCidrBlock` in the same request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteRequest AWS API Documentation
    #
    class CreateLocalGatewayRouteRequest < Struct.new(
      :destination_cidr_block,
      :local_gateway_route_table_id,
      :local_gateway_virtual_interface_group_id,
      :dry_run,
      :network_interface_id,
      :destination_prefix_list_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::LocalGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteResult AWS API Documentation
    #
    class CreateLocalGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_id
    #   The ID of the local gateway.
    #   @return [String]
    #
    # @!attribute [rw] mode
    #   The mode of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags assigned to the local gateway route table.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableRequest AWS API Documentation
    #
    class CreateLocalGatewayRouteTableRequest < Struct.new(
      :local_gateway_id,
      :mode,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table
    #   Information about the local gateway route table.
    #   @return [Types::LocalGatewayRouteTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableResult AWS API Documentation
    #
    class CreateLocalGatewayRouteTableResult < Struct.new(
      :local_gateway_route_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_virtual_interface_group_id
    #   The ID of the local gateway route table virtual interface group
    #   association.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags assigned to the local gateway route table virtual interface
    #   group association.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest AWS API Documentation
    #
    class CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest < Struct.new(
      :local_gateway_route_table_id,
      :local_gateway_virtual_interface_group_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_virtual_interface_group_association
    #   Information about the local gateway route table virtual interface
    #   group association.
    #   @return [Types::LocalGatewayRouteTableVirtualInterfaceGroupAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult AWS API Documentation
    #
    class CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult < Struct.new(
      :local_gateway_route_table_virtual_interface_group_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the local gateway route table VPC association.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociationRequest AWS API Documentation
    #
    class CreateLocalGatewayRouteTableVpcAssociationRequest < Struct.new(
      :local_gateway_route_table_id,
      :vpc_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_vpc_association
    #   Information about the association.
    #   @return [Types::LocalGatewayRouteTableVpcAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociationResult AWS API Documentation
    #
    class CreateLocalGatewayRouteTableVpcAssociationResult < Struct.new(
      :local_gateway_route_table_vpc_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_id
    #   The ID of the local gateway.
    #   @return [String]
    #
    # @!attribute [rw] local_bgp_asn
    #   The Autonomous System Number(ASN) for the local Border Gateway
    #   Protocol (BGP).
    #   @return [Integer]
    #
    # @!attribute [rw] local_bgp_asn_extended
    #   The extended 32-bit ASN for the local BGP configuration.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the local gateway virtual interface group when
    #   the resource is being created.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterfaceGroupRequest AWS API Documentation
    #
    class CreateLocalGatewayVirtualInterfaceGroupRequest < Struct.new(
      :local_gateway_id,
      :local_bgp_asn,
      :local_bgp_asn_extended,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface_group
    #   Information about the created local gateway virtual interface group.
    #   @return [Types::LocalGatewayVirtualInterfaceGroup]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterfaceGroupResult AWS API Documentation
    #
    class CreateLocalGatewayVirtualInterfaceGroupResult < Struct.new(
      :local_gateway_virtual_interface_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface_group_id
    #   The ID of the local gateway virtual interface group.
    #   @return [String]
    #
    # @!attribute [rw] outpost_lag_id
    #   References the Link Aggregation Group (LAG) that connects the
    #   Outpost to on-premises network devices.
    #   @return [String]
    #
    # @!attribute [rw] vlan
    #   The virtual local area network (VLAN) used for the local gateway
    #   virtual interface.
    #   @return [Integer]
    #
    # @!attribute [rw] local_address
    #   The IP address assigned to the local gateway virtual interface on
    #   the Outpost side. Only IPv4 is supported.
    #   @return [String]
    #
    # @!attribute [rw] peer_address
    #   The peer IP address for the local gateway virtual interface. Only
    #   IPv4 is supported.
    #   @return [String]
    #
    # @!attribute [rw] peer_bgp_asn
    #   The Autonomous System Number (ASN) of the Border Gateway Protocol
    #   (BGP) peer.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to a resource when the local gateway virtual
    #   interface is being created.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] peer_bgp_asn_extended
    #   The extended 32-bit ASN of the BGP peer for use with larger ASN
    #   values.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterfaceRequest AWS API Documentation
    #
    class CreateLocalGatewayVirtualInterfaceRequest < Struct.new(
      :local_gateway_virtual_interface_group_id,
      :outpost_lag_id,
      :vlan,
      :local_address,
      :peer_address,
      :peer_bgp_asn,
      :tag_specifications,
      :dry_run,
      :peer_bgp_asn_extended)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface
    #   Information about the local gateway virtual interface.
    #   @return [Types::LocalGatewayVirtualInterface]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterfaceResult AWS API Documentation
    #
    class CreateLocalGatewayVirtualInterfaceResult < Struct.new(
      :local_gateway_virtual_interface)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the Amazon EC2 Mac instance.
    #   @return [String]
    #
    # @!attribute [rw] mac_credentials
    #   **\[Apple silicon Mac instances only\]** Specifies the following
    #   credentials:
    #
    #   * **Internal disk administrative user**
    #
    #     * **Username** - Only the default administrative user
    #       (`aws-managed-user`) is supported and it is used by default. You
    #       can't specify a different administrative user.
    #
    #     * **Password** - If you did not change the default password for
    #       `aws-managed-user`, specify the default password, which is
    #       *blank*. Otherwise, specify your password.
    #   * **Amazon EBS root volume administrative user**
    #
    #     * **Username** - If you did not change the default administrative
    #       user, specify `ec2-user`. Otherwise, specify the username for
    #       your administrative user.
    #
    #     * **Password** - Specify the password for the administrative user.
    #
    #   The credentials must be specified in the following JSON format:
    #
    #   `{ "internalDiskPassword":"internal-disk-admin_password",
    #   "rootVolumeUsername":"root-volume-admin_username",
    #   "rootVolumepassword":"root-volume-admin_password" }`
    #   @return [String]
    #
    # @!attribute [rw] mac_system_integrity_protection_configuration
    #   Specifies the overrides to selectively enable or disable individual
    #   SIP settings. The individual settings you specify here override the
    #   overall SIP status you specify for
    #   **MacSystemIntegrityProtectionStatus**.
    #   @return [Types::MacSystemIntegrityProtectionConfigurationRequest]
    #
    # @!attribute [rw] mac_system_integrity_protection_status
    #   Specifies the overall SIP status for the instance. To enable all SIP
    #   settings, specify `enabled`. To disable all SIP settings, specify
    #   `disabled`.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   Specifies tags to apply to the SIP modification task.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateMacSystemIntegrityProtectionModificationTaskRequest AWS API Documentation
    #
    class CreateMacSystemIntegrityProtectionModificationTaskRequest < Struct.new(
      :client_token,
      :dry_run,
      :instance_id,
      :mac_credentials,
      :mac_system_integrity_protection_configuration,
      :mac_system_integrity_protection_status,
      :tag_specifications)
      SENSITIVE = [:mac_credentials]
      include Aws::Structure
    end

    # @!attribute [rw] mac_modification_task
    #   Information about the SIP modification task.
    #   @return [Types::MacModificationTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateMacSystemIntegrityProtectionModificationTaskResult AWS API Documentation
    #
    class CreateMacSystemIntegrityProtectionModificationTaskResult < Struct.new(
      :mac_modification_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] prefix_list_name
    #   A name for the prefix list.
    #
    #   Constraints: Up to 255 characters in length. The name cannot start
    #   with `com.amazonaws`.
    #   @return [String]
    #
    # @!attribute [rw] entries
    #   One or more entries for the prefix list.
    #   @return [Array<Types::AddPrefixListEntry>]
    #
    # @!attribute [rw] max_entries
    #   The maximum number of entries for the prefix list.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the prefix list during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] address_family
    #   The IP address type.
    #
    #   Valid Values: `IPv4` \| `IPv6`
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   Constraints: Up to 255 UTF-8 characters in length.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixListRequest AWS API Documentation
    #
    class CreateManagedPrefixListRequest < Struct.new(
      :dry_run,
      :prefix_list_name,
      :entries,
      :max_entries,
      :tag_specifications,
      :address_family,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] prefix_list
    #   Information about the prefix list.
    #   @return [Types::ManagedPrefixList]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixListResult AWS API Documentation
    #
    class CreateManagedPrefixListResult < Struct.new(
      :prefix_list)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] availability_mode
    #   Specifies whether to create a zonal (single-AZ) or regional
    #   (multi-AZ) NAT gateway. Defaults to `zonal`.
    #
    #   A zonal NAT gateway is a NAT Gateway that provides redundancy and
    #   scalability within a single availability zone. A regional NAT
    #   gateway is a single NAT Gateway that works across multiple
    #   availability zones (AZs) in your VPC, providing redundancy,
    #   scalability and availability across all the AZs in a Region.
    #
    #   For more information, see [Regional NAT gateways for automatic
    #   multi-AZ expansion][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html
    #   @return [String]
    #
    # @!attribute [rw] allocation_id
    #   \[Public NAT gateways only\] The allocation ID of an Elastic IP
    #   address to associate with the NAT gateway. You cannot specify an
    #   Elastic IP address with a private NAT gateway. If the Elastic IP
    #   address is associated with another resource, you must first
    #   disassociate it.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   Constraint: Maximum 64 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet in which to create the NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC where you want to create a regional NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_addresses
    #   For regional NAT gateways only: Specifies which Availability Zones
    #   you want the NAT gateway to support and the Elastic IP addresses
    #   (EIPs) to use in each AZ. The regional NAT gateway uses these EIPs
    #   to handle outbound NAT traffic from their respective AZs. If not
    #   specified, the NAT gateway will automatically expand to new AZs and
    #   associate EIPs upon detection of an elastic network interface. If
    #   you specify this parameter, auto-expansion is disabled and you must
    #   manually manage AZ coverage.
    #
    #   A regional NAT gateway is a single NAT Gateway that works across
    #   multiple availability zones (AZs) in your VPC, providing redundancy,
    #   scalability and availability across all the AZs in a Region.
    #
    #   For more information, see [Regional NAT gateways for automatic
    #   multi-AZ expansion][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html
    #   @return [Array<Types::AvailabilityZoneAddress>]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the NAT gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] connectivity_type
    #   Indicates whether the NAT gateway supports public or private
    #   connectivity. The default is public connectivity.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_address
    #   The private IPv4 address to assign to the NAT gateway. If you don't
    #   provide an address, a private IPv4 address will be automatically
    #   assigned.
    #   @return [String]
    #
    # @!attribute [rw] secondary_allocation_ids
    #   Secondary EIP allocation IDs. For more information, see [Create a
    #   NAT gateway][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    #   @return [Array<String>]
    #
    # @!attribute [rw] secondary_private_ip_addresses
    #   Secondary private IPv4 addresses. For more information about
    #   secondary addresses, see [Create a NAT gateway][1] in the *Amazon
    #   VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    #   @return [Array<String>]
    #
    # @!attribute [rw] secondary_private_ip_address_count
    #   \[Private NAT gateway only\] The number of secondary private IPv4
    #   addresses you want to assign to the NAT gateway. For more
    #   information about secondary addresses, see [Create a NAT gateway][1]
    #   in the *Amazon VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGatewayRequest AWS API Documentation
    #
    class CreateNatGatewayRequest < Struct.new(
      :availability_mode,
      :allocation_id,
      :client_token,
      :dry_run,
      :subnet_id,
      :vpc_id,
      :availability_zone_addresses,
      :tag_specifications,
      :connectivity_type,
      :private_ip_address,
      :secondary_allocation_ids,
      :secondary_private_ip_addresses,
      :secondary_private_ip_address_count)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway
    #   Information about the NAT gateway.
    #   @return [Types::NatGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGatewayResult AWS API Documentation
    #
    class CreateNatGatewayResult < Struct.new(
      :client_token,
      :nat_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_acl_id
    #   The ID of the network ACL.
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The rule number for the entry (for example, 100). ACL entries are
    #   processed in ascending order by rule number.
    #
    #   Constraints: Positive integer from 1 to 32766. The range 32767 to
    #   65535 is reserved for internal use.
    #   @return [Integer]
    #
    # @!attribute [rw] protocol
    #   The protocol number. A value of "-1" means all protocols. If you
    #   specify "-1" or a protocol number other than "6" (TCP), "17"
    #   (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless
    #   of any ports or ICMP types or codes that you specify. If you specify
    #   protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for
    #   all ICMP types and codes allowed, regardless of any that you
    #   specify. If you specify protocol "58" (ICMPv6) and specify an IPv6
    #   CIDR block, you must specify an ICMP type and code.
    #   @return [String]
    #
    # @!attribute [rw] rule_action
    #   Indicates whether to allow or deny the traffic that matches the
    #   rule.
    #   @return [String]
    #
    # @!attribute [rw] egress
    #   Indicates whether this is an egress rule (rule is applied to traffic
    #   leaving the subnet).
    #   @return [Boolean]
    #
    # @!attribute [rw] cidr_block
    #   The IPv4 network range to allow or deny, in CIDR notation (for
    #   example `172.16.0.0/24`). We modify the specified CIDR block to its
    #   canonical form; for example, if you specify `100.68.0.18/18`, we
    #   modify it to `100.68.0.0/18`.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 network range to allow or deny, in CIDR notation (for
    #   example `2001:db8:1234:1a00::/64`).
    #   @return [String]
    #
    # @!attribute [rw] icmp_type_code
    #   ICMP protocol: The ICMP or ICMPv6 type and code. Required if
    #   specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6
    #   CIDR block.
    #   @return [Types::IcmpTypeCode]
    #
    # @!attribute [rw] port_range
    #   TCP or UDP protocols: The range of ports the rule applies to.
    #   Required if specifying protocol 6 (TCP) or 17 (UDP).
    #   @return [Types::PortRange]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntryRequest AWS API Documentation
    #
    class CreateNetworkAclEntryRequest < Struct.new(
      :dry_run,
      :network_acl_id,
      :rule_number,
      :protocol,
      :rule_action,
      :egress,
      :cidr_block,
      :ipv_6_cidr_block,
      :icmp_type_code,
      :port_range)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] tag_specifications
    #   The tags to assign to the network ACL.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclRequest AWS API Documentation
    #
    class CreateNetworkAclRequest < Struct.new(
      :tag_specifications,
      :client_token,
      :dry_run,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_acl
    #   Information about the network ACL.
    #   @return [Types::NetworkAcl]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclResult AWS API Documentation
    #
    class CreateNetworkAclResult < Struct.new(
      :network_acl,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] match_paths
    #   The paths to match.
    #   @return [Array<Types::AccessScopePathRequest>]
    #
    # @!attribute [rw] exclude_paths
    #   The paths to exclude.
    #   @return [Array<Types::AccessScopePathRequest>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScopeRequest AWS API Documentation
    #
    class CreateNetworkInsightsAccessScopeRequest < Struct.new(
      :match_paths,
      :exclude_paths,
      :client_token,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_access_scope
    #   The Network Access Scope.
    #   @return [Types::NetworkInsightsAccessScope]
    #
    # @!attribute [rw] network_insights_access_scope_content
    #   The Network Access Scope content.
    #   @return [Types::NetworkInsightsAccessScopeContent]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScopeResult AWS API Documentation
    #
    class CreateNetworkInsightsAccessScopeResult < Struct.new(
      :network_insights_access_scope,
      :network_insights_access_scope_content)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] source_ip
    #   The IP address of the source.
    #   @return [String]
    #
    # @!attribute [rw] destination_ip
    #   The IP address of the destination.
    #   @return [String]
    #
    # @!attribute [rw] source
    #   The ID or ARN of the source. If the resource is in another account,
    #   you must specify an ARN.
    #   @return [String]
    #
    # @!attribute [rw] destination
    #   The ID or ARN of the destination. If the resource is in another
    #   account, you must specify an ARN.
    #   @return [String]
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] destination_port
    #   The destination port.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to add to the path.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] filter_at_source
    #   Scopes the analysis to network paths that match specific filters at
    #   the source. If you specify this parameter, you can't specify the
    #   parameters for the source IP address or the destination port.
    #   @return [Types::PathRequestFilter]
    #
    # @!attribute [rw] filter_at_destination
    #   Scopes the analysis to network paths that match specific filters at
    #   the destination. If you specify this parameter, you can't specify
    #   the parameter for the destination IP address.
    #   @return [Types::PathRequestFilter]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPathRequest AWS API Documentation
    #
    class CreateNetworkInsightsPathRequest < Struct.new(
      :source_ip,
      :destination_ip,
      :source,
      :destination,
      :protocol,
      :destination_port,
      :tag_specifications,
      :dry_run,
      :client_token,
      :filter_at_source,
      :filter_at_destination)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_path
    #   Information about the path.
    #   @return [Types::NetworkInsightsPath]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPathResult AWS API Documentation
    #
    class CreateNetworkInsightsPathResult < Struct.new(
      :network_insights_path)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateNetworkInterfacePermission.
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] aws_account_id
    #   The Amazon Web Services account ID.
    #   @return [String]
    #
    # @!attribute [rw] aws_service
    #   The Amazon Web Services service. Currently not supported.
    #   @return [String]
    #
    # @!attribute [rw] permission
    #   The type of permission to grant.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermissionRequest AWS API Documentation
    #
    class CreateNetworkInterfacePermissionRequest < Struct.new(
      :network_interface_id,
      :aws_account_id,
      :aws_service,
      :permission,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateNetworkInterfacePermission.
    #
    # @!attribute [rw] interface_permission
    #   Information about the permission for the network interface.
    #   @return [Types::NetworkInterfacePermission]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermissionResult AWS API Documentation
    #
    class CreateNetworkInterfacePermissionResult < Struct.new(
      :interface_permission)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_4_prefixes
    #   The IPv4 prefixes assigned to the network interface.
    #
    #   You can't specify IPv4 prefixes if you've specified one of the
    #   following: a count of IPv4 prefixes, specific private IPv4
    #   addresses, or a count of private IPv4 addresses.
    #   @return [Array<Types::Ipv4PrefixSpecificationRequest>]
    #
    # @!attribute [rw] ipv_4_prefix_count
    #   The number of IPv4 prefixes that Amazon Web Services automatically
    #   assigns to the network interface.
    #
    #   You can't specify a count of IPv4 prefixes if you've specified one
    #   of the following: specific IPv4 prefixes, specific private IPv4
    #   addresses, or a count of private IPv4 addresses.
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_prefixes
    #   The IPv6 prefixes assigned to the network interface.
    #
    #   You can't specify IPv6 prefixes if you've specified one of the
    #   following: a count of IPv6 prefixes, specific IPv6 addresses, or a
    #   count of IPv6 addresses.
    #   @return [Array<Types::Ipv6PrefixSpecificationRequest>]
    #
    # @!attribute [rw] ipv_6_prefix_count
    #   The number of IPv6 prefixes that Amazon Web Services automatically
    #   assigns to the network interface.
    #
    #   You can't specify a count of IPv6 prefixes if you've specified one
    #   of the following: specific IPv6 prefixes, specific IPv6 addresses,
    #   or a count of IPv6 addresses.
    #   @return [Integer]
    #
    # @!attribute [rw] interface_type
    #   The type of network interface. The default is `interface`.
    #
    #   If you specify `efa-only`, do not assign any IP addresses to the
    #   network interface. EFA-only network interfaces do not support IP
    #   addresses.
    #
    #   The only supported values are `interface`, `efa`, `efa-only`, and
    #   `trunk`.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new network interface.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] enable_primary_ipv_6
    #   If you’re creating a network interface in a dual-stack or IPv6-only
    #   subnet, you have the option to assign a primary IPv6 IP address. A
    #   primary IPv6 address is an IPv6 GUA address associated with an ENI
    #   that you have enabled to use a primary IPv6 address. Use this option
    #   if the instance that this ENI will be attached to relies on its IPv6
    #   address not changing. Amazon Web Services will automatically assign
    #   an IPv6 address associated with the ENI attached to your instance to
    #   be the primary IPv6 address. Once you enable an IPv6 GUA address to
    #   be a primary IPv6, you cannot disable it. When you enable an IPv6
    #   GUA address to be a primary IPv6, the first IPv6 GUA will be made
    #   the primary IPv6 address until the instance is terminated or the
    #   network interface is detached. If you have multiple IPv6 addresses
    #   associated with an ENI attached to your instance and you enable a
    #   primary IPv6 address, the first IPv6 GUA address associated with the
    #   ENI becomes the primary IPv6 address.
    #   @return [Boolean]
    #
    # @!attribute [rw] connection_tracking_specification
    #   A connection tracking specification for the network interface.
    #   @return [Types::ConnectionTrackingSpecificationRequest]
    #
    # @!attribute [rw] operator
    #   Reserved for internal use.
    #   @return [Types::OperatorRequest]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet to associate with the network interface.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the network interface.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_address
    #   The primary private IPv4 address of the network interface. If you
    #   don't specify an IPv4 address, Amazon EC2 selects one for you from
    #   the subnet's IPv4 CIDR range. If you specify an IP address, you
    #   cannot indicate any IP addresses specified in `privateIpAddresses`
    #   as primary (only one IP address can be designated as primary).
    #   @return [String]
    #
    # @!attribute [rw] groups
    #   The IDs of the security groups.
    #   @return [Array<String>]
    #
    # @!attribute [rw] private_ip_addresses
    #   The private IPv4 addresses.
    #
    #   You can't specify private IPv4 addresses if you've specified one
    #   of the following: a count of private IPv4 addresses, specific IPv4
    #   prefixes, or a count of IPv4 prefixes.
    #   @return [Array<Types::PrivateIpAddressSpecification>]
    #
    # @!attribute [rw] secondary_private_ip_address_count
    #   The number of secondary private IPv4 addresses to assign to a
    #   network interface. When you specify a number of secondary IPv4
    #   addresses, Amazon EC2 selects these IP addresses within the
    #   subnet's IPv4 CIDR range. You can't specify this option and
    #   specify more than one private IP address using `privateIpAddresses`.
    #
    #   You can't specify a count of private IPv4 addresses if you've
    #   specified one of the following: specific private IPv4 addresses,
    #   specific IPv4 prefixes, or a count of IPv4 prefixes.
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_addresses
    #   The IPv6 addresses from the IPv6 CIDR block range of your subnet.
    #
    #   You can't specify IPv6 addresses using this parameter if you've
    #   specified one of the following: a count of IPv6 addresses, specific
    #   IPv6 prefixes, or a count of IPv6 prefixes.
    #   @return [Array<Types::InstanceIpv6Address>]
    #
    # @!attribute [rw] ipv_6_address_count
    #   The number of IPv6 addresses to assign to a network interface.
    #   Amazon EC2 automatically selects the IPv6 addresses from the subnet
    #   range.
    #
    #   You can't specify a count of IPv6 addresses using this parameter if
    #   you've specified one of the following: specific IPv6 addresses,
    #   specific IPv6 prefixes, or a count of IPv6 prefixes.
    #
    #   If your subnet has the `AssignIpv6AddressOnCreation` attribute set,
    #   you can override that setting by specifying 0 as the IPv6 address
    #   count.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfaceRequest AWS API Documentation
    #
    class CreateNetworkInterfaceRequest < Struct.new(
      :ipv_4_prefixes,
      :ipv_4_prefix_count,
      :ipv_6_prefixes,
      :ipv_6_prefix_count,
      :interface_type,
      :tag_specifications,
      :client_token,
      :enable_primary_ipv_6,
      :connection_tracking_specification,
      :operator,
      :subnet_id,
      :description,
      :private_ip_address,
      :groups,
      :private_ip_addresses,
      :secondary_private_ip_address_count,
      :ipv_6_addresses,
      :ipv_6_address_count,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_interface
    #   Information about the network interface.
    #   @return [Types::NetworkInterface]
    #
    # @!attribute [rw] client_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfaceResult AWS API Documentation
    #
    class CreateNetworkInterfaceResult < Struct.new(
      :network_interface,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] partition_count
    #   The number of partitions. Valid only when **Strategy** is set to
    #   `partition`.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new placement group.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] spread_level
    #   Determines how placement groups spread instances.
    #
    #   * Host – You can use `host` only with Outpost placement groups.
    #
    #   * Rack – No usage restrictions.
    #   @return [String]
    #
    # @!attribute [rw] linked_group_id
    #   Reserved for future use.
    #   @return [String]
    #
    # @!attribute [rw] operator
    #   Reserved for internal use.
    #   @return [Types::OperatorRequest]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_name
    #   A name for the placement group. Must be unique within the scope of
    #   your account for the Region.
    #
    #   Constraints: Up to 255 ASCII characters
    #   @return [String]
    #
    # @!attribute [rw] strategy
    #   The placement strategy.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupRequest AWS API Documentation
    #
    class CreatePlacementGroupRequest < Struct.new(
      :partition_count,
      :tag_specifications,
      :spread_level,
      :linked_group_id,
      :operator,
      :dry_run,
      :group_name,
      :strategy)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] placement_group
    #   Information about the placement group.
    #   @return [Types::PlacementGroup]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupResult AWS API Documentation
    #
    class CreatePlacementGroupResult < Struct.new(
      :placement_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value.
    #   For example, to find all resources that have a tag with the key
    #   `Owner` and the value `TeamA`, specify `tag:Owner` for the filter
    #   name and `TeamA` for the filter value.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] network_border_group
    #   The Availability Zone (AZ) or Local Zone (LZ) network border group
    #   that the resource that the IP address is assigned to is in. Defaults
    #   to an AZ network border group. For more information on available
    #   Local Zones, see [Local Zone availability][1] in the *Amazon EC2
    #   User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4PoolRequest AWS API Documentation
    #
    class CreatePublicIpv4PoolRequest < Struct.new(
      :dry_run,
      :tag_specifications,
      :network_border_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] pool_id
    #   The ID of the public IPv4 pool.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4PoolResult AWS API Documentation
    #
    class CreatePublicIpv4PoolResult < Struct.new(
      :pool_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_id
    #   The ID of the instance for which to replace the root volume.
    #   @return [String]
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the snapshot from which to restore the replacement root
    #   volume. The specified snapshot must be a snapshot that you
    #   previously created from the original root volume.
    #
    #   If you want to restore the replacement root volume to the initial
    #   launch state, or if you want to restore the replacement root volume
    #   from an AMI, omit this parameter.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. If you do not specify a client token, a
    #   randomly generated token is used for the request to ensure
    #   idempotency. For more information, see [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the root volume replacement task.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] image_id
    #   The ID of the AMI to use to restore the root volume. The specified
    #   AMI must have the same product code, billing information,
    #   architecture type, and virtualization type as that of the instance.
    #
    #   If you want to restore the replacement volume from a specific
    #   snapshot, or if you want to restore it to its launch state, omit
    #   this parameter.
    #   @return [String]
    #
    # @!attribute [rw] delete_replaced_root_volume
    #   Indicates whether to automatically delete the original root volume
    #   after the root volume replacement task completes. To delete the
    #   original root volume, specify `true`. If you choose to keep the
    #   original root volume after the replacement task completes, you must
    #   manually delete it when you no longer need it.
    #   @return [Boolean]
    #
    # @!attribute [rw] volume_initialization_rate
    #   Specifies the Amazon EBS Provisioned Rate for Volume Initialization
    #   (volume initialization rate), in MiB/s, at which to download the
    #   snapshot blocks from Amazon S3 to the replacement root volume. This
    #   is also known as *volume initialization*. Specifying a volume
    #   initialization rate ensures that the volume is initialized at a
    #   predictable and consistent rate after creation.
    #
    #   Omit this parameter if:
    #
    #   * You want to create the volume using fast snapshot restore. You
    #     must specify a snapshot that is enabled for fast snapshot restore.
    #     In this case, the volume is fully initialized at creation.
    #
    #     <note markdown="1"> If you specify a snapshot that is enabled for fast snapshot
    #     restore and a volume initialization rate, the volume will be
    #     initialized at the specified rate instead of fast snapshot
    #     restore.
    #
    #      </note>
    #
    #   * You want to create a volume that is initialized at the default
    #     rate.
    #
    #   For more information, see [ Initialize Amazon EBS volumes][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #   Valid range: 100 - 300 MiB/s
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTaskRequest AWS API Documentation
    #
    class CreateReplaceRootVolumeTaskRequest < Struct.new(
      :instance_id,
      :snapshot_id,
      :client_token,
      :dry_run,
      :tag_specifications,
      :image_id,
      :delete_replaced_root_volume,
      :volume_initialization_rate)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] replace_root_volume_task
    #   Information about the root volume replacement task.
    #   @return [Types::ReplaceRootVolumeTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTaskResult AWS API Documentation
    #
    class CreateReplaceRootVolumeTaskResult < Struct.new(
      :replace_root_volume_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateReservedInstancesListing.
    #
    # @!attribute [rw] reserved_instances_id
    #   The ID of the active Standard Reserved Instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances that are a part of a Reserved Instance
    #   account to be listed in the Reserved Instance Marketplace. This
    #   number should be less than or equal to the instance count associated
    #   with the Reserved Instance ID specified in this call.
    #   @return [Integer]
    #
    # @!attribute [rw] price_schedules
    #   A list specifying the price of the Standard Reserved Instance for
    #   each month remaining in the Reserved Instance term.
    #   @return [Array<Types::PriceScheduleSpecification>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency
    #   of your listings. This helps avoid duplicate listings. For more
    #   information, see [Ensuring Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListingRequest AWS API Documentation
    #
    class CreateReservedInstancesListingRequest < Struct.new(
      :reserved_instances_id,
      :instance_count,
      :price_schedules,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateReservedInstancesListing.
    #
    # @!attribute [rw] reserved_instances_listings
    #   Information about the Standard Reserved Instance listing.
    #   @return [Array<Types::ReservedInstancesListing>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListingResult AWS API Documentation
    #
    class CreateReservedInstancesListingResult < Struct.new(
      :reserved_instances_listings)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] bucket
    #   The name of the Amazon S3 bucket that contains the stored AMI
    #   object.
    #   @return [String]
    #
    # @!attribute [rw] object_key
    #   The name of the stored AMI object in the bucket.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   The name for the restored AMI. The name must be unique for AMIs in
    #   the Region for this account. If you do not provide a name, the new
    #   AMI gets the same name as the original AMI.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the AMI and snapshots on restoration. You can
    #   tag the AMI, the snapshots, or both.
    #
    #   * To tag the AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the snapshots, the value for `ResourceType` must be
    #     `snapshot`. The same tag is applied to all of the snapshots that
    #     are created.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTaskRequest AWS API Documentation
    #
    class CreateRestoreImageTaskRequest < Struct.new(
      :bucket,
      :object_key,
      :name,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_id
    #   The AMI ID.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTaskResult AWS API Documentation
    #
    class CreateRestoreImageTaskResult < Struct.new(
      :image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] destination_prefix_list_id
    #   The ID of a prefix list used for the destination match.
    #   @return [String]
    #
    # @!attribute [rw] vpc_endpoint_id
    #   The ID of a VPC endpoint. Supported for Gateway Load Balancer
    #   endpoints only.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of a transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_id
    #   The ID of the local gateway.
    #   @return [String]
    #
    # @!attribute [rw] carrier_gateway_id
    #   The ID of the carrier gateway.
    #
    #   You can only use this option when the VPC contains a subnet which is
    #   associated with a Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] core_network_arn
    #   The Amazon Resource Name (ARN) of the core network.
    #   @return [String]
    #
    # @!attribute [rw] odb_network_arn
    #   The Amazon Resource Name (ARN) of the ODB network.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table for the route.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 CIDR address block used for the destination match. Routing
    #   decisions are based on the most specific match. We modify the
    #   specified CIDR block to its canonical form; for example, if you
    #   specify `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
    #   @return [String]
    #
    # @!attribute [rw] gateway_id
    #   The ID of an internet gateway or virtual private gateway attached to
    #   your VPC.
    #   @return [String]
    #
    # @!attribute [rw] destination_ipv_6_cidr_block
    #   The IPv6 CIDR block used for the destination match. Routing
    #   decisions are based on the most specific match.
    #   @return [String]
    #
    # @!attribute [rw] egress_only_internet_gateway_id
    #   \[IPv6 traffic only\] The ID of an egress-only internet gateway.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of a NAT instance in your VPC. The operation fails if you
    #   specify an instance ID unless exactly one network interface is
    #   attached.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of a network interface.
    #   @return [String]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of a VPC peering connection.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway_id
    #   \[IPv4 traffic only\] The ID of a NAT gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteRequest AWS API Documentation
    #
    class CreateRouteRequest < Struct.new(
      :destination_prefix_list_id,
      :vpc_endpoint_id,
      :transit_gateway_id,
      :local_gateway_id,
      :carrier_gateway_id,
      :core_network_arn,
      :odb_network_arn,
      :dry_run,
      :route_table_id,
      :destination_cidr_block,
      :gateway_id,
      :destination_ipv_6_cidr_block,
      :egress_only_internet_gateway_id,
      :instance_id,
      :network_interface_id,
      :vpc_peering_connection_id,
      :nat_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteResult AWS API Documentation
    #
    class CreateRouteResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_id
    #   The ID of the route server for which to create an endpoint.
    #   @return [String]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet in which to create the route server endpoint.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure idempotency of the
    #   request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the route server endpoint during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerEndpointRequest AWS API Documentation
    #
    class CreateRouteServerEndpointRequest < Struct.new(
      :route_server_id,
      :subnet_id,
      :client_token,
      :dry_run,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_endpoint
    #   Information about the created route server endpoint.
    #   @return [Types::RouteServerEndpoint]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerEndpointResult AWS API Documentation
    #
    class CreateRouteServerEndpointResult < Struct.new(
      :route_server_endpoint)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_endpoint_id
    #   The ID of the route server endpoint for which to create a peer.
    #   @return [String]
    #
    # @!attribute [rw] peer_address
    #   The IPv4 address of the peer device.
    #   @return [String]
    #
    # @!attribute [rw] bgp_options
    #   The BGP options for the peer, including ASN (Autonomous System
    #   Number) and BFD (Bidrectional Forwarding Detection) settings.
    #   @return [Types::RouteServerBgpOptionsRequest]
    #
    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the route server peer during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerPeerRequest AWS API Documentation
    #
    class CreateRouteServerPeerRequest < Struct.new(
      :route_server_endpoint_id,
      :peer_address,
      :bgp_options,
      :dry_run,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_peer
    #   Information about the created route server peer.
    #   @return [Types::RouteServerPeer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerPeerResult AWS API Documentation
    #
    class CreateRouteServerPeerResult < Struct.new(
      :route_server_peer)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] amazon_side_asn
    #   The private Autonomous System Number (ASN) for the Amazon side of
    #   the BGP session. Valid values are from 1 to 4294967295. We recommend
    #   using a private ASN in the 64512–65534 (16-bit ASN) or
    #   4200000000–4294967294 (32-bit ASN) range.
    #   @return [Integer]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure idempotency of the
    #   request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] persist_routes
    #   Indicates whether routes should be persisted after all BGP sessions
    #   are terminated.
    #   @return [String]
    #
    # @!attribute [rw] persist_routes_duration
    #   The number of minutes a route server will wait after BGP is
    #   re-established to unpersist the routes in the FIB and RIB. Value
    #   must be in the range of 1-5. Required if PersistRoutes is `enabled`.
    #
    #   If you set the duration to 1 minute, then when your network
    #   appliance re-establishes BGP with route server, it has 1 minute to
    #   relearn it's adjacent network and advertise those routes to route
    #   server before route server resumes normal functionality. In most
    #   cases, 1 minute is probably sufficient. If, however, you have
    #   concerns that your BGP network may not be capable of fully
    #   re-establishing and re-learning everything in 1 minute, you can
    #   increase the duration up to 5 minutes.
    #   @return [Integer]
    #
    # @!attribute [rw] sns_notifications_enabled
    #   Indicates whether SNS notifications should be enabled for route
    #   server events. Enabling SNS notifications persists BGP status
    #   changes to an SNS topic provisioned by Amazon Web Services.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the route server during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerRequest AWS API Documentation
    #
    class CreateRouteServerRequest < Struct.new(
      :amazon_side_asn,
      :client_token,
      :dry_run,
      :persist_routes,
      :persist_routes_duration,
      :sns_notifications_enabled,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server
    #   Information about the created route server.
    #   @return [Types::RouteServer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerResult AWS API Documentation
    #
    class CreateRouteServerResult < Struct.new(
      :route_server)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] tag_specifications
    #   The tags to assign to the route table.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTableRequest AWS API Documentation
    #
    class CreateRouteTableRequest < Struct.new(
      :tag_specifications,
      :client_token,
      :dry_run,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_table
    #   Information about the route table.
    #   @return [Types::RouteTable]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTableResult AWS API Documentation
    #
    class CreateRouteTableResult < Struct.new(
      :route_table,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipv_4_cidr_block
    #   The IPv4 CIDR block for the secondary network. The CIDR block size
    #   must be between /12 and /28.
    #   @return [String]
    #
    # @!attribute [rw] network_type
    #   The type of secondary network.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the secondary network.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecondaryNetworkRequest AWS API Documentation
    #
    class CreateSecondaryNetworkRequest < Struct.new(
      :client_token,
      :dry_run,
      :ipv_4_cidr_block,
      :network_type,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] secondary_network
    #   Information about the secondary network.
    #   @return [Types::SecondaryNetwork]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecondaryNetworkResult AWS API Documentation
    #
    class CreateSecondaryNetworkResult < Struct.new(
      :secondary_network,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone for the secondary subnet. You cannot specify
    #   both `AvailabilityZone` and `AvailabilityZoneId` in the same
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone for the secondary subnet. This
    #   option is preferred over `AvailabilityZone` as it provides a
    #   consistent identifier across Amazon Web Services accounts. You
    #   cannot specify both `AvailabilityZone` and `AvailabilityZoneId` in
    #   the same request.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipv_4_cidr_block
    #   The IPv4 CIDR block for the secondary subnet. The CIDR block size
    #   must be between /12 and /28.
    #   @return [String]
    #
    # @!attribute [rw] secondary_network_id
    #   The ID of the secondary network in which to create the secondary
    #   subnet.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the secondary subnet.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecondarySubnetRequest AWS API Documentation
    #
    class CreateSecondarySubnetRequest < Struct.new(
      :client_token,
      :availability_zone,
      :availability_zone_id,
      :dry_run,
      :ipv_4_cidr_block,
      :secondary_network_id,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] secondary_subnet
    #   Information about the secondary subnet.
    #   @return [Types::SecondarySubnet]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecondarySubnetResult AWS API Documentation
    #
    class CreateSecondarySubnetResult < Struct.new(
      :secondary_subnet,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] description
    #   A description for the security group.
    #
    #   Constraints: Up to 255 characters in length
    #
    #   Valid characters: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\{}!$*
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   The name of the security group. Names are case-insensitive and must
    #   be unique within the VPC.
    #
    #   Constraints: Up to 255 characters in length. Can't start with
    #   `sg-`.
    #
    #   Valid characters: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\{}!$*
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC. Required for a nondefault VPC.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the security group.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroupRequest AWS API Documentation
    #
    class CreateSecurityGroupRequest < Struct.new(
      :description,
      :group_name,
      :vpc_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] group_id
    #   The ID of the security group.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags assigned to the security group.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] security_group_arn
    #   The security group ARN.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroupResult AWS API Documentation
    #
    class CreateSecurityGroupResult < Struct.new(
      :group_id,
      :tags,
      :security_group_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] description
    #   A description for the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] outpost_arn
    #   <note markdown="1"> Only supported for volumes on Outposts. If the source volume is not
    #   on an Outpost, omit this parameter.
    #
    #    </note>
    #
    #   * To create the snapshot on the same Outpost as the source volume,
    #     specify the ARN of that Outpost. The snapshot must be created on
    #     the same Outpost as the volume.
    #
    #   * To create the snapshot in the parent Region of the Outpost, omit
    #     this parameter.
    #
    #   For more information, see [Create local snapshots from volumes on an
    #   Outpost][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot
    #   @return [String]
    #
    # @!attribute [rw] volume_id
    #   The ID of the Amazon EBS volume.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the snapshot during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] location
    #   <note markdown="1"> Only supported for volumes in Local Zones. If the source volume is
    #   not in a Local Zone, omit this parameter.
    #
    #    </note>
    #
    #   * To create a local snapshot in the same Local Zone as the source
    #     volume, specify `local`.
    #
    #   * To create a regional snapshot in the parent Region of the Local
    #     Zone, specify `regional` or omit this parameter.
    #
    #   Default value: `regional`
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshotRequest AWS API Documentation
    #
    class CreateSnapshotRequest < Struct.new(
      :description,
      :outpost_arn,
      :volume_id,
      :tag_specifications,
      :location,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] description
    #   A description propagated to every snapshot specified by the
    #   instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_specification
    #   The instance to specify which volumes should be included in the
    #   snapshots.
    #   @return [Types::InstanceSpecification]
    #
    # @!attribute [rw] outpost_arn
    #   <note markdown="1"> Only supported for instances on Outposts. If the source instance is
    #   not on an Outpost, omit this parameter.
    #
    #    </note>
    #
    #   * To create the snapshots on the same Outpost as the source
    #     instance, specify the ARN of that Outpost. The snapshots must be
    #     created on the same Outpost as the instance.
    #
    #   * To create the snapshots in the parent Region of the Outpost, omit
    #     this parameter.
    #
    #   For more information, see [ Create local snapshots from volumes on
    #   an Outpost][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   Tags to apply to every snapshot specified by the instance.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] copy_tags_from_source
    #   Copies the tags from the specified volume to corresponding snapshot.
    #   @return [String]
    #
    # @!attribute [rw] location
    #   <note markdown="1"> Only supported for instances in Local Zones. If the source instance
    #   is not in a Local Zone, omit this parameter.
    #
    #    </note>
    #
    #   * To create local snapshots in the same Local Zone as the source
    #     instance, specify `local`.
    #
    #   * To create regional snapshots in the parent Region of the Local
    #     Zone, specify `regional` or omit this parameter.
    #
    #   Default value: `regional`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshotsRequest AWS API Documentation
    #
    class CreateSnapshotsRequest < Struct.new(
      :description,
      :instance_specification,
      :outpost_arn,
      :tag_specifications,
      :dry_run,
      :copy_tags_from_source,
      :location)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] snapshots
    #   List of snapshots.
    #   @return [Array<Types::SnapshotInfo>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshotsResult AWS API Documentation
    #
    class CreateSnapshotsResult < Struct.new(
      :snapshots)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateSpotDatafeedSubscription.
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] bucket
    #   The name of the Amazon S3 bucket in which to store the Spot Instance
    #   data feed. For more information about bucket names, see [Bucket
    #   naming rules][1] in the *Amazon S3 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html
    #   @return [String]
    #
    # @!attribute [rw] prefix
    #   The prefix for the data feed file names.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscriptionRequest AWS API Documentation
    #
    class CreateSpotDatafeedSubscriptionRequest < Struct.new(
      :dry_run,
      :bucket,
      :prefix)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateSpotDatafeedSubscription.
    #
    # @!attribute [rw] spot_datafeed_subscription
    #   The Spot Instance data feed subscription.
    #   @return [Types::SpotDatafeedSubscription]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscriptionResult AWS API Documentation
    #
    class CreateSpotDatafeedSubscriptionResult < Struct.new(
      :spot_datafeed_subscription)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_id
    #   The ID of the AMI.
    #   @return [String]
    #
    # @!attribute [rw] bucket
    #   The name of the Amazon S3 bucket in which the AMI object will be
    #   stored. The bucket must be in the Region in which the request is
    #   being made. The AMI object appears in the bucket only after the
    #   upload task has completed.
    #   @return [String]
    #
    # @!attribute [rw] s3_object_tags
    #   The tags to apply to the AMI object that will be stored in the
    #   Amazon S3 bucket.
    #   @return [Array<Types::S3ObjectTag>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTaskRequest AWS API Documentation
    #
    class CreateStoreImageTaskRequest < Struct.new(
      :image_id,
      :bucket,
      :s3_object_tags,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] object_key
    #   The name of the stored AMI object in the S3 bucket.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTaskResult AWS API Documentation
    #
    class CreateStoreImageTaskResult < Struct.new(
      :object_key)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] cidr
    #   The IPv4 or IPV6 CIDR range to reserve.
    #   @return [String]
    #
    # @!attribute [rw] reservation_type
    #   The type of reservation. The reservation type determines how the
    #   reserved IP addresses are assigned to resources.
    #
    #   * `prefix` - Amazon Web Services assigns the reserved IP addresses
    #     to network interfaces.
    #
    #   * `explicit` - You assign the reserved IP addresses to network
    #     interfaces.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description to assign to the subnet CIDR reservation.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the subnet CIDR reservation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservationRequest AWS API Documentation
    #
    class CreateSubnetCidrReservationRequest < Struct.new(
      :subnet_id,
      :cidr,
      :reservation_type,
      :description,
      :dry_run,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet_cidr_reservation
    #   Information about the created subnet CIDR reservation.
    #   @return [Types::SubnetCidrReservation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservationResult AWS API Documentation
    #
    class CreateSubnetCidrReservationResult < Struct.new(
      :subnet_cidr_reservation)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] tag_specifications
    #   The tags to assign to the subnet.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone or Local Zone for the subnet.
    #
    #   Default: Amazon Web Services selects one for you. If you create more
    #   than one subnet in your VPC, we do not necessarily select a
    #   different zone for each subnet.
    #
    #   To create a subnet in a Local Zone, set this value to the Local Zone
    #   ID, for example `us-west-2-lax-1a`. For information about the
    #   Regions that support Local Zones, see [Available Local Zones][1].
    #
    #   To create a subnet in an Outpost, set this value to the Availability
    #   Zone for the Outpost and specify the Outpost ARN.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The AZ ID or the Local Zone ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] cidr_block
    #   The IPv4 network range for the subnet, in CIDR notation. For
    #   example, `10.0.0.0/24`. We modify the specified CIDR block to its
    #   canonical form; for example, if you specify `100.68.0.18/18`, we
    #   modify it to `100.68.0.0/18`.
    #
    #   This parameter is not supported for an IPv6 only subnet.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 network range for the subnet, in CIDR notation. This
    #   parameter is required for an IPv6 only subnet.
    #   @return [String]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost. If you specify an
    #   Outpost ARN, you must also specify the Availability Zone of the
    #   Outpost subnet.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_native
    #   Indicates whether to create an IPv6 only subnet.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipv_4_ipam_pool_id
    #   An IPv4 IPAM pool ID for the subnet.
    #   @return [String]
    #
    # @!attribute [rw] ipv_4_netmask_length
    #   An IPv4 netmask length for the subnet.
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_ipam_pool_id
    #   An IPv6 IPAM pool ID for the subnet.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_netmask_length
    #   An IPv6 netmask length for the subnet.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetRequest AWS API Documentation
    #
    class CreateSubnetRequest < Struct.new(
      :tag_specifications,
      :availability_zone,
      :availability_zone_id,
      :cidr_block,
      :ipv_6_cidr_block,
      :outpost_arn,
      :vpc_id,
      :ipv_6_native,
      :ipv_4_ipam_pool_id,
      :ipv_4_netmask_length,
      :ipv_6_ipam_pool_id,
      :ipv_6_netmask_length,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet
    #   Information about the subnet.
    #   @return [Types::Subnet]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetResult AWS API Documentation
    #
    class CreateSubnetResult < Struct.new(
      :subnet)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tags
    #   The tags. The `value` parameter is required, but if you don't want
    #   the tag to have a value, specify the parameter with no value, and we
    #   set the value to an empty string.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTagsRequest AWS API Documentation
    #
    class CreateTagsRequest < Struct.new(
      :dry_run,
      :resources,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] description
    #   The description of the Traffic Mirror filter.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to a Traffic Mirror filter.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRequest AWS API Documentation
    #
    class CreateTrafficMirrorFilterRequest < Struct.new(
      :description,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter
    #   Information about the Traffic Mirror filter.
    #   @return [Types::TrafficMirrorFilter]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterResult AWS API Documentation
    #
    class CreateTrafficMirrorFilterResult < Struct.new(
      :traffic_mirror_filter,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the filter that this rule is associated with.
    #   @return [String]
    #
    # @!attribute [rw] traffic_direction
    #   The type of traffic.
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The number of the Traffic Mirror rule. This number must be unique
    #   for each Traffic Mirror rule in a given direction. The rules are
    #   processed in ascending order by rule number.
    #   @return [Integer]
    #
    # @!attribute [rw] rule_action
    #   The action to take on the filtered traffic.
    #   @return [String]
    #
    # @!attribute [rw] destination_port_range
    #   The destination port range.
    #   @return [Types::TrafficMirrorPortRangeRequest]
    #
    # @!attribute [rw] source_port_range
    #   The source port range.
    #   @return [Types::TrafficMirrorPortRangeRequest]
    #
    # @!attribute [rw] protocol
    #   The protocol, for example UDP, to assign to the Traffic Mirror rule.
    #
    #   For information about the protocol value, see [Protocol Numbers][1]
    #   on the Internet Assigned Numbers Authority (IANA) website.
    #
    #
    #
    #   [1]: https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #   @return [Integer]
    #
    # @!attribute [rw] destination_cidr_block
    #   The destination CIDR block to assign to the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] source_cidr_block
    #   The source CIDR block to assign to the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description of the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   Traffic Mirroring tags specifications.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRuleRequest AWS API Documentation
    #
    class CreateTrafficMirrorFilterRuleRequest < Struct.new(
      :traffic_mirror_filter_id,
      :traffic_direction,
      :rule_number,
      :rule_action,
      :destination_port_range,
      :source_port_range,
      :protocol,
      :destination_cidr_block,
      :source_cidr_block,
      :description,
      :dry_run,
      :client_token,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_rule
    #   The Traffic Mirror rule.
    #   @return [Types::TrafficMirrorFilterRule]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRuleResult AWS API Documentation
    #
    class CreateTrafficMirrorFilterRuleResult < Struct.new(
      :traffic_mirror_filter_rule,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_interface_id
    #   The ID of the source network interface.
    #   @return [String]
    #
    # @!attribute [rw] traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #   @return [String]
    #
    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #   @return [String]
    #
    # @!attribute [rw] packet_length
    #   The number of bytes in each packet to mirror. These are bytes after
    #   the VXLAN header. Do not specify this parameter when you want to
    #   mirror the entire packet. To mirror a subset of the packet, set this
    #   to the length (in bytes) that you want to mirror. For example, if
    #   you set this value to 100, then the first 100 bytes that meet the
    #   filter criteria are copied to the target.
    #
    #   If you do not want to mirror the entire packet, use the
    #   `PacketLength` parameter to specify the number of bytes in each
    #   packet to mirror.
    #
    #   For sessions with Network Load Balancer (NLB) Traffic Mirror targets
    #   the default `PacketLength` will be set to 8500. Valid values are
    #   1-8500. Setting a `PacketLength` greater than 8500 will result in an
    #   error response.
    #   @return [Integer]
    #
    # @!attribute [rw] session_number
    #   The session number determines the order in which sessions are
    #   evaluated when an interface is used by multiple sessions. The first
    #   session with a matching filter is the one that mirrors the packets.
    #
    #   Valid values are 1-32766.
    #   @return [Integer]
    #
    # @!attribute [rw] virtual_network_id
    #   The VXLAN ID for the Traffic Mirror session. For more information
    #   about the VXLAN protocol, see [RFC 7348][1]. If you do not specify a
    #   `VirtualNetworkId`, an account-wide unique ID is chosen at random.
    #
    #
    #
    #   [1]: https://datatracker.ietf.org/doc/html/rfc7348
    #   @return [Integer]
    #
    # @!attribute [rw] description
    #   The description of the Traffic Mirror session.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to a Traffic Mirror session.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSessionRequest AWS API Documentation
    #
    class CreateTrafficMirrorSessionRequest < Struct.new(
      :network_interface_id,
      :traffic_mirror_target_id,
      :traffic_mirror_filter_id,
      :packet_length,
      :session_number,
      :virtual_network_id,
      :description,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_session
    #   Information about the Traffic Mirror session.
    #   @return [Types::TrafficMirrorSession]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSessionResult AWS API Documentation
    #
    class CreateTrafficMirrorSessionResult < Struct.new(
      :traffic_mirror_session,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_interface_id
    #   The network interface ID that is associated with the target.
    #   @return [String]
    #
    # @!attribute [rw] network_load_balancer_arn
    #   The Amazon Resource Name (ARN) of the Network Load Balancer that is
    #   associated with the target.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description of the Traffic Mirror target.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Traffic Mirror target.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] gateway_load_balancer_endpoint_id
    #   The ID of the Gateway Load Balancer endpoint.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTargetRequest AWS API Documentation
    #
    class CreateTrafficMirrorTargetRequest < Struct.new(
      :network_interface_id,
      :network_load_balancer_arn,
      :description,
      :tag_specifications,
      :dry_run,
      :client_token,
      :gateway_load_balancer_endpoint_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_target
    #   Information about the Traffic Mirror target.
    #   @return [Types::TrafficMirrorTarget]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTargetResult AWS API Documentation
    #
    class CreateTrafficMirrorTargetResult < Struct.new(
      :traffic_mirror_target,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the Connect attachment.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_address
    #   The peer IP address (GRE outer IP address) on the transit gateway
    #   side of the Connect peer, which must be specified from a transit
    #   gateway CIDR block. If not specified, Amazon automatically assigns
    #   the first available IP address from the transit gateway CIDR block.
    #   @return [String]
    #
    # @!attribute [rw] peer_address
    #   The peer IP address (GRE outer IP address) on the appliance side of
    #   the Connect peer.
    #   @return [String]
    #
    # @!attribute [rw] bgp_options
    #   The BGP options for the Connect peer.
    #   @return [Types::TransitGatewayConnectRequestBgpOptions]
    #
    # @!attribute [rw] inside_cidr_blocks
    #   The range of inside IP addresses that are used for BGP peering. You
    #   must specify a size /29 IPv4 CIDR block from the `169.254.0.0/16`
    #   range. The first address from the range must be configured on the
    #   appliance as the BGP IP address. You can also optionally specify a
    #   size /125 IPv6 CIDR block from the `fd00::/8` range.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Connect peer.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeerRequest AWS API Documentation
    #
    class CreateTransitGatewayConnectPeerRequest < Struct.new(
      :transit_gateway_attachment_id,
      :transit_gateway_address,
      :peer_address,
      :bgp_options,
      :inside_cidr_blocks,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect_peer
    #   Information about the Connect peer.
    #   @return [Types::TransitGatewayConnectPeer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeerResult AWS API Documentation
    #
    class CreateTransitGatewayConnectPeerResult < Struct.new(
      :transit_gateway_connect_peer)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transport_transit_gateway_attachment_id
    #   The ID of the transit gateway attachment. You can specify a VPC
    #   attachment or Amazon Web Services Direct Connect attachment.
    #   @return [String]
    #
    # @!attribute [rw] options
    #   The Connect attachment options.
    #   @return [Types::CreateTransitGatewayConnectRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Connect attachment.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectRequest AWS API Documentation
    #
    class CreateTransitGatewayConnectRequest < Struct.new(
      :transport_transit_gateway_attachment_id,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for a Connect attachment.
    #
    # @!attribute [rw] protocol
    #   The tunnel protocol.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectRequestOptions AWS API Documentation
    #
    class CreateTransitGatewayConnectRequestOptions < Struct.new(
      :protocol)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect
    #   Information about the Connect attachment.
    #   @return [Types::TransitGatewayConnect]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectResult AWS API Documentation
    #
    class CreateTransitGatewayConnectResult < Struct.new(
      :transit_gateway_connect)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_metering_policy_id
    #   The ID of the transit gateway metering policy to add the entry to.
    #   @return [String]
    #
    # @!attribute [rw] policy_rule_number
    #   The rule number for the metering policy entry. Rules are processed
    #   in order from lowest to highest number.
    #   @return [Integer]
    #
    # @!attribute [rw] source_transit_gateway_attachment_id
    #   The ID of the source transit gateway attachment for traffic
    #   matching.
    #   @return [String]
    #
    # @!attribute [rw] source_transit_gateway_attachment_type
    #   The type of the source transit gateway attachment for traffic
    #   matching. Note that the `tgw-peering` resource type has been
    #   deprecated. To configure metering policies for Connect, use the
    #   transport attachment type.
    #   @return [String]
    #
    # @!attribute [rw] source_cidr_block
    #   The source CIDR block for traffic matching.
    #   @return [String]
    #
    # @!attribute [rw] source_port_range
    #   The source port range for traffic matching.
    #   @return [String]
    #
    # @!attribute [rw] destination_transit_gateway_attachment_id
    #   The ID of the destination transit gateway attachment for traffic
    #   matching.
    #   @return [String]
    #
    # @!attribute [rw] destination_transit_gateway_attachment_type
    #   The type of the destination transit gateway attachment for traffic
    #   matching. Note that the `tgw-peering` resource type has been
    #   deprecated. To configure metering policies for Connect, use the
    #   transport attachment type.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The destination CIDR block for traffic matching.
    #   @return [String]
    #
    # @!attribute [rw] destination_port_range
    #   The destination port range for traffic matching.
    #   @return [String]
    #
    # @!attribute [rw] protocol
    #   The protocol for traffic matching (1, 6, 17, etc.).
    #   @return [String]
    #
    # @!attribute [rw] metered_account
    #   The Amazon Web Services account ID to which the metered traffic
    #   should be attributed.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMeteringPolicyEntryRequest AWS API Documentation
    #
    class CreateTransitGatewayMeteringPolicyEntryRequest < Struct.new(
      :transit_gateway_metering_policy_id,
      :policy_rule_number,
      :source_transit_gateway_attachment_id,
      :source_transit_gateway_attachment_type,
      :source_cidr_block,
      :source_port_range,
      :destination_transit_gateway_attachment_id,
      :destination_transit_gateway_attachment_type,
      :destination_cidr_block,
      :destination_port_range,
      :protocol,
      :metered_account,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_metering_policy_entry
    #   Information about the created transit gateway metering policy entry.
    #   @return [Types::TransitGatewayMeteringPolicyEntry]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMeteringPolicyEntryResult AWS API Documentation
    #
    class CreateTransitGatewayMeteringPolicyEntryResult < Struct.new(
      :transit_gateway_metering_policy_entry)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway for which to create the metering
    #   policy.
    #   @return [String]
    #
    # @!attribute [rw] middlebox_attachment_ids
    #   The IDs of the middlebox attachments to include in the metering
    #   policy.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the metering policy.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMeteringPolicyRequest AWS API Documentation
    #
    class CreateTransitGatewayMeteringPolicyRequest < Struct.new(
      :transit_gateway_id,
      :middlebox_attachment_ids,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_metering_policy
    #   Information about the created transit gateway metering policy.
    #   @return [Types::TransitGatewayMeteringPolicy]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMeteringPolicyResult AWS API Documentation
    #
    class CreateTransitGatewayMeteringPolicyResult < Struct.new(
      :transit_gateway_metering_policy)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] options
    #   The options for the transit gateway multicast domain.
    #   @return [Types::CreateTransitGatewayMulticastDomainRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags for the transit gateway multicast domain.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomainRequest AWS API Documentation
    #
    class CreateTransitGatewayMulticastDomainRequest < Struct.new(
      :transit_gateway_id,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for the transit gateway multicast domain.
    #
    # @!attribute [rw] igmpv_2_support
    #   Specify whether to enable Internet Group Management Protocol (IGMP)
    #   version 2 for the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] static_sources_support
    #   Specify whether to enable support for statically configuring
    #   multicast group sources for a domain.
    #   @return [String]
    #
    # @!attribute [rw] auto_accept_shared_associations
    #   Indicates whether to automatically accept cross-account subnet
    #   associations that are associated with the transit gateway multicast
    #   domain.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomainRequestOptions AWS API Documentation
    #
    class CreateTransitGatewayMulticastDomainRequestOptions < Struct.new(
      :igmpv_2_support,
      :static_sources_support,
      :auto_accept_shared_associations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain
    #   Information about the transit gateway multicast domain.
    #   @return [Types::TransitGatewayMulticastDomain]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomainResult AWS API Documentation
    #
    class CreateTransitGatewayMulticastDomainResult < Struct.new(
      :transit_gateway_multicast_domain)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] peer_transit_gateway_id
    #   The ID of the peer transit gateway with which to create the peering
    #   attachment.
    #   @return [String]
    #
    # @!attribute [rw] peer_account_id
    #   The ID of the Amazon Web Services account that owns the peer transit
    #   gateway.
    #   @return [String]
    #
    # @!attribute [rw] peer_region
    #   The Region where the peer transit gateway is located.
    #   @return [String]
    #
    # @!attribute [rw] options
    #   Requests a transit gateway peering attachment.
    #   @return [Types::CreateTransitGatewayPeeringAttachmentRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the transit gateway peering attachment.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachmentRequest AWS API Documentation
    #
    class CreateTransitGatewayPeeringAttachmentRequest < Struct.new(
      :transit_gateway_id,
      :peer_transit_gateway_id,
      :peer_account_id,
      :peer_region,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes whether dynamic routing is enabled or disabled for the
    # transit gateway peering request.
    #
    # @!attribute [rw] dynamic_routing
    #   Indicates whether dynamic routing is enabled or disabled.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachmentRequestOptions AWS API Documentation
    #
    class CreateTransitGatewayPeeringAttachmentRequestOptions < Struct.new(
      :dynamic_routing)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_peering_attachment
    #   The transit gateway peering attachment.
    #   @return [Types::TransitGatewayPeeringAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachmentResult AWS API Documentation
    #
    class CreateTransitGatewayPeeringAttachmentResult < Struct.new(
      :transit_gateway_peering_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway used for the policy table.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags specification for the transit gateway policy table created
    #   during the request.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTableRequest AWS API Documentation
    #
    class CreateTransitGatewayPolicyTableRequest < Struct.new(
      :transit_gateway_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_policy_table
    #   Describes the created transit gateway policy table.
    #   @return [Types::TransitGatewayPolicyTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTableResult AWS API Documentation
    #
    class CreateTransitGatewayPolicyTableResult < Struct.new(
      :transit_gateway_policy_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_id
    #   The ID of the prefix list that is used for destination matches.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment to which traffic is routed.
    #   @return [String]
    #
    # @!attribute [rw] blackhole
    #   Indicates whether to drop traffic that matches this route.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReferenceRequest AWS API Documentation
    #
    class CreateTransitGatewayPrefixListReferenceRequest < Struct.new(
      :transit_gateway_route_table_id,
      :prefix_list_id,
      :transit_gateway_attachment_id,
      :blackhole,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_prefix_list_reference
    #   Information about the prefix list reference.
    #   @return [Types::TransitGatewayPrefixListReference]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReferenceResult AWS API Documentation
    #
    class CreateTransitGatewayPrefixListReferenceResult < Struct.new(
      :transit_gateway_prefix_list_reference)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] description
    #   A description of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] options
    #   The transit gateway options.
    #   @return [Types::TransitGatewayRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the transit gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRequest AWS API Documentation
    #
    class CreateTransitGatewayRequest < Struct.new(
      :description,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway
    #   Information about the transit gateway.
    #   @return [Types::TransitGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayResult AWS API Documentation
    #
    class CreateTransitGatewayResult < Struct.new(
      :transit_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] blackhole
    #   Indicates whether to drop traffic that matches this route.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteRequest AWS API Documentation
    #
    class CreateTransitGatewayRouteRequest < Struct.new(
      :destination_cidr_block,
      :transit_gateway_route_table_id,
      :transit_gateway_attachment_id,
      :blackhole,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::TransitGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteResult AWS API Documentation
    #
    class CreateTransitGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] peering_attachment_id
    #   The ID of the peering attachment.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags specifications applied to the transit gateway route table
    #   announcement.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncementRequest AWS API Documentation
    #
    class CreateTransitGatewayRouteTableAnnouncementRequest < Struct.new(
      :transit_gateway_route_table_id,
      :peering_attachment_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_announcement
    #   Provides details about the transit gateway route table announcement.
    #   @return [Types::TransitGatewayRouteTableAnnouncement]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncementResult AWS API Documentation
    #
    class CreateTransitGatewayRouteTableAnnouncementResult < Struct.new(
      :transit_gateway_route_table_announcement)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the transit gateway route table.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableRequest AWS API Documentation
    #
    class CreateTransitGatewayRouteTableRequest < Struct.new(
      :transit_gateway_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table
    #   Information about the transit gateway route table.
    #   @return [Types::TransitGatewayRouteTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableResult AWS API Documentation
    #
    class CreateTransitGatewayRouteTableResult < Struct.new(
      :transit_gateway_route_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of one or more subnets. You can specify only one subnet per
    #   Availability Zone. You must specify at least one subnet, but we
    #   recommend that you specify two subnets for better availability. The
    #   transit gateway uses one IP address from each specified subnet.
    #   @return [Array<String>]
    #
    # @!attribute [rw] options
    #   The VPC attachment options.
    #   @return [Types::CreateTransitGatewayVpcAttachmentRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the VPC attachment.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachmentRequest AWS API Documentation
    #
    class CreateTransitGatewayVpcAttachmentRequest < Struct.new(
      :transit_gateway_id,
      :vpc_id,
      :subnet_ids,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the options for a VPC attachment.
    #
    # @!attribute [rw] dns_support
    #   Enable or disable DNS support. The default is `enable`.
    #   @return [String]
    #
    # @!attribute [rw] security_group_referencing_support
    #   Enables you to reference a security group across VPCs attached to a
    #   transit gateway to simplify security group management.
    #
    #   This option is set to `enable` by default. However, at the transit
    #   gateway level the default is set to `disable`.
    #
    #   For more information about security group referencing, see [Security
    #   group referencing ][1] in the *Amazon Web Services Transit Gateways
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_support
    #   Enable or disable IPv6 support. The default is `disable`.
    #   @return [String]
    #
    # @!attribute [rw] appliance_mode_support
    #   Enable or disable support for appliance mode. If enabled, a traffic
    #   flow between a source and destination uses the same Availability
    #   Zone for the VPC attachment for the lifetime of that flow. The
    #   default is `disable`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachmentRequestOptions AWS API Documentation
    #
    class CreateTransitGatewayVpcAttachmentRequestOptions < Struct.new(
      :dns_support,
      :security_group_referencing_support,
      :ipv_6_support,
      :appliance_mode_support)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_vpc_attachment
    #   Information about the VPC attachment.
    #   @return [Types::TransitGatewayVpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachmentResult AWS API Documentation
    #
    class CreateTransitGatewayVpcAttachmentResult < Struct.new(
      :transit_gateway_vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the CIDR options for a Verified Access endpoint.
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets.
    #   @return [Array<String>]
    #
    # @!attribute [rw] cidr
    #   The CIDR.
    #   @return [String]
    #
    # @!attribute [rw] port_ranges
    #   The port ranges.
    #   @return [Array<Types::CreateVerifiedAccessEndpointPortRange>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpointCidrOptions AWS API Documentation
    #
    class CreateVerifiedAccessEndpointCidrOptions < Struct.new(
      :protocol,
      :subnet_ids,
      :cidr,
      :port_ranges)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the network interface options when creating an Amazon Web
    # Services Verified Access endpoint using the `network-interface` type.
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] protocol
    #   The IP protocol.
    #   @return [String]
    #
    # @!attribute [rw] port
    #   The IP port number.
    #   @return [Integer]
    #
    # @!attribute [rw] port_ranges
    #   The port ranges.
    #   @return [Array<Types::CreateVerifiedAccessEndpointPortRange>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpointEniOptions AWS API Documentation
    #
    class CreateVerifiedAccessEndpointEniOptions < Struct.new(
      :network_interface_id,
      :protocol,
      :port,
      :port_ranges)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the load balancer options when creating an Amazon Web
    # Services Verified Access endpoint using the `load-balancer` type.
    #
    # @!attribute [rw] protocol
    #   The IP protocol.
    #   @return [String]
    #
    # @!attribute [rw] port
    #   The IP port number.
    #   @return [Integer]
    #
    # @!attribute [rw] load_balancer_arn
    #   The ARN of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets. You can specify only one subnet per
    #   Availability Zone.
    #   @return [Array<String>]
    #
    # @!attribute [rw] port_ranges
    #   The port ranges.
    #   @return [Array<Types::CreateVerifiedAccessEndpointPortRange>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpointLoadBalancerOptions AWS API Documentation
    #
    class CreateVerifiedAccessEndpointLoadBalancerOptions < Struct.new(
      :protocol,
      :port,
      :load_balancer_arn,
      :subnet_ids,
      :port_ranges)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the port range for a Verified Access endpoint.
    #
    # @!attribute [rw] from_port
    #   The start of the port range.
    #   @return [Integer]
    #
    # @!attribute [rw] to_port
    #   The end of the port range.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpointPortRange AWS API Documentation
    #
    class CreateVerifiedAccessEndpointPortRange < Struct.new(
      :from_port,
      :to_port)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the RDS options for a Verified Access endpoint.
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] port
    #   The port.
    #   @return [Integer]
    #
    # @!attribute [rw] rds_db_instance_arn
    #   The ARN of the RDS instance.
    #   @return [String]
    #
    # @!attribute [rw] rds_db_cluster_arn
    #   The ARN of the DB cluster.
    #   @return [String]
    #
    # @!attribute [rw] rds_db_proxy_arn
    #   The ARN of the RDS proxy.
    #   @return [String]
    #
    # @!attribute [rw] rds_endpoint
    #   The RDS endpoint.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets. You can specify only one subnet per
    #   Availability Zone.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpointRdsOptions AWS API Documentation
    #
    class CreateVerifiedAccessEndpointRdsOptions < Struct.new(
      :protocol,
      :port,
      :rds_db_instance_arn,
      :rds_db_cluster_arn,
      :rds_db_proxy_arn,
      :rds_endpoint,
      :subnet_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_group_id
    #   The ID of the Verified Access group to associate the endpoint with.
    #   @return [String]
    #
    # @!attribute [rw] endpoint_type
    #   The type of Verified Access endpoint to create.
    #   @return [String]
    #
    # @!attribute [rw] attachment_type
    #   The type of attachment.
    #   @return [String]
    #
    # @!attribute [rw] domain_certificate_arn
    #   The ARN of the public TLS/SSL certificate in Amazon Web Services
    #   Certificate Manager to associate with the endpoint. The CN in the
    #   certificate must match the DNS name your end users will use to reach
    #   your application.
    #   @return [String]
    #
    # @!attribute [rw] application_domain
    #   The DNS name for users to reach your application.
    #   @return [String]
    #
    # @!attribute [rw] endpoint_domain_prefix
    #   A custom identifier that is prepended to the DNS name that is
    #   generated for the endpoint.
    #   @return [String]
    #
    # @!attribute [rw] security_group_ids
    #   The IDs of the security groups to associate with the Verified Access
    #   endpoint. Required if `AttachmentType` is set to `vpc`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] load_balancer_options
    #   The load balancer details. This parameter is required if the
    #   endpoint type is `load-balancer`.
    #   @return [Types::CreateVerifiedAccessEndpointLoadBalancerOptions]
    #
    # @!attribute [rw] network_interface_options
    #   The network interface details. This parameter is required if the
    #   endpoint type is `network-interface`.
    #   @return [Types::CreateVerifiedAccessEndpointEniOptions]
    #
    # @!attribute [rw] description
    #   A description for the Verified Access endpoint.
    #   @return [String]
    #
    # @!attribute [rw] policy_document
    #   The Verified Access policy document.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Verified Access endpoint.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] sse_specification
    #   The options for server side encryption.
    #   @return [Types::VerifiedAccessSseSpecificationRequest]
    #
    # @!attribute [rw] rds_options
    #   The RDS details. This parameter is required if the endpoint type is
    #   `rds`.
    #   @return [Types::CreateVerifiedAccessEndpointRdsOptions]
    #
    # @!attribute [rw] cidr_options
    #   The CIDR options. This parameter is required if the endpoint type is
    #   `cidr`.
    #   @return [Types::CreateVerifiedAccessEndpointCidrOptions]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpointRequest AWS API Documentation
    #
    class CreateVerifiedAccessEndpointRequest < Struct.new(
      :verified_access_group_id,
      :endpoint_type,
      :attachment_type,
      :domain_certificate_arn,
      :application_domain,
      :endpoint_domain_prefix,
      :security_group_ids,
      :load_balancer_options,
      :network_interface_options,
      :description,
      :policy_document,
      :tag_specifications,
      :client_token,
      :dry_run,
      :sse_specification,
      :rds_options,
      :cidr_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_endpoint
    #   Details about the Verified Access endpoint.
    #   @return [Types::VerifiedAccessEndpoint]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpointResult AWS API Documentation
    #
    class CreateVerifiedAccessEndpointResult < Struct.new(
      :verified_access_endpoint)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_instance_id
    #   The ID of the Verified Access instance.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the Verified Access group.
    #   @return [String]
    #
    # @!attribute [rw] policy_document
    #   The Verified Access policy document.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Verified Access group.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] sse_specification
    #   The options for server side encryption.
    #   @return [Types::VerifiedAccessSseSpecificationRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroupRequest AWS API Documentation
    #
    class CreateVerifiedAccessGroupRequest < Struct.new(
      :verified_access_instance_id,
      :description,
      :policy_document,
      :tag_specifications,
      :client_token,
      :dry_run,
      :sse_specification)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_group
    #   Details about the Verified Access group.
    #   @return [Types::VerifiedAccessGroup]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroupResult AWS API Documentation
    #
    class CreateVerifiedAccessGroupResult < Struct.new(
      :verified_access_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] description
    #   A description for the Verified Access instance.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Verified Access instance.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fips_enabled
    #   Enable or disable support for Federal Information Processing
    #   Standards (FIPS) on the instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] cidr_endpoints_custom_sub_domain
    #   The custom subdomain.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstanceRequest AWS API Documentation
    #
    class CreateVerifiedAccessInstanceRequest < Struct.new(
      :description,
      :tag_specifications,
      :client_token,
      :dry_run,
      :fips_enabled,
      :cidr_endpoints_custom_sub_domain)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_instance
    #   Details about the Verified Access instance.
    #   @return [Types::VerifiedAccessInstance]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstanceResult AWS API Documentation
    #
    class CreateVerifiedAccessInstanceResult < Struct.new(
      :verified_access_instance)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the OpenID Connect (OIDC) options.
    #
    # @!attribute [rw] public_signing_key_endpoint
    #   The public signing key endpoint.
    #   @return [String]
    #
    # @!attribute [rw] issuer
    #   The OIDC issuer identifier of the IdP.
    #   @return [String]
    #
    # @!attribute [rw] authorization_endpoint
    #   The authorization endpoint of the IdP.
    #   @return [String]
    #
    # @!attribute [rw] token_endpoint
    #   The token endpoint of the IdP.
    #   @return [String]
    #
    # @!attribute [rw] user_info_endpoint
    #   The user info endpoint of the IdP.
    #   @return [String]
    #
    # @!attribute [rw] client_id
    #   The OAuth 2.0 client identifier.
    #   @return [String]
    #
    # @!attribute [rw] client_secret
    #   The OAuth 2.0 client secret.
    #   @return [String]
    #
    # @!attribute [rw] scope
    #   The set of user claims to be requested from the IdP.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessNativeApplicationOidcOptions AWS API Documentation
    #
    class CreateVerifiedAccessNativeApplicationOidcOptions < Struct.new(
      :public_signing_key_endpoint,
      :issuer,
      :authorization_endpoint,
      :token_endpoint,
      :user_info_endpoint,
      :client_id,
      :client_secret,
      :scope)
      SENSITIVE = [:client_secret]
      include Aws::Structure
    end

    # Describes the options when creating an Amazon Web Services Verified
    # Access trust provider using the `device` type.
    #
    # @!attribute [rw] tenant_id
    #   The ID of the tenant application with the device-identity provider.
    #   @return [String]
    #
    # @!attribute [rw] public_signing_key_url
    #   The URL Amazon Web Services Verified Access will use to verify the
    #   authenticity of the device tokens.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProviderDeviceOptions AWS API Documentation
    #
    class CreateVerifiedAccessTrustProviderDeviceOptions < Struct.new(
      :tenant_id,
      :public_signing_key_url)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the options when creating an Amazon Web Services Verified
    # Access trust provider using the `user` type.
    #
    # @!attribute [rw] issuer
    #   The OIDC issuer.
    #   @return [String]
    #
    # @!attribute [rw] authorization_endpoint
    #   The OIDC authorization endpoint.
    #   @return [String]
    #
    # @!attribute [rw] token_endpoint
    #   The OIDC token endpoint.
    #   @return [String]
    #
    # @!attribute [rw] user_info_endpoint
    #   The OIDC user info endpoint.
    #   @return [String]
    #
    # @!attribute [rw] client_id
    #   The client identifier.
    #   @return [String]
    #
    # @!attribute [rw] client_secret
    #   The client secret.
    #   @return [String]
    #
    # @!attribute [rw] scope
    #   OpenID Connect (OIDC) scopes are used by an application during
    #   authentication to authorize access to a user's details. Each scope
    #   returns a specific set of user attributes.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProviderOidcOptions AWS API Documentation
    #
    class CreateVerifiedAccessTrustProviderOidcOptions < Struct.new(
      :issuer,
      :authorization_endpoint,
      :token_endpoint,
      :user_info_endpoint,
      :client_id,
      :client_secret,
      :scope)
      SENSITIVE = [:client_secret]
      include Aws::Structure
    end

    # @!attribute [rw] trust_provider_type
    #   The type of trust provider.
    #   @return [String]
    #
    # @!attribute [rw] user_trust_provider_type
    #   The type of user-based trust provider. This parameter is required
    #   when the provider type is `user`.
    #   @return [String]
    #
    # @!attribute [rw] device_trust_provider_type
    #   The type of device-based trust provider. This parameter is required
    #   when the provider type is `device`.
    #   @return [String]
    #
    # @!attribute [rw] oidc_options
    #   The options for a OpenID Connect-compatible user-identity trust
    #   provider. This parameter is required when the provider type is
    #   `user`.
    #   @return [Types::CreateVerifiedAccessTrustProviderOidcOptions]
    #
    # @!attribute [rw] device_options
    #   The options for a device-based trust provider. This parameter is
    #   required when the provider type is `device`.
    #   @return [Types::CreateVerifiedAccessTrustProviderDeviceOptions]
    #
    # @!attribute [rw] policy_reference_name
    #   The identifier to be used when working with policy rules.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the Verified Access trust provider.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Verified Access trust provider.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] sse_specification
    #   The options for server side encryption.
    #   @return [Types::VerifiedAccessSseSpecificationRequest]
    #
    # @!attribute [rw] native_application_oidc_options
    #   The OpenID Connect (OIDC) options.
    #   @return [Types::CreateVerifiedAccessNativeApplicationOidcOptions]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProviderRequest AWS API Documentation
    #
    class CreateVerifiedAccessTrustProviderRequest < Struct.new(
      :trust_provider_type,
      :user_trust_provider_type,
      :device_trust_provider_type,
      :oidc_options,
      :device_options,
      :policy_reference_name,
      :description,
      :tag_specifications,
      :client_token,
      :dry_run,
      :sse_specification,
      :native_application_oidc_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_trust_provider
    #   Details about the Verified Access trust provider.
    #   @return [Types::VerifiedAccessTrustProvider]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProviderResult AWS API Documentation
    #
    class CreateVerifiedAccessTrustProviderResult < Struct.new(
      :verified_access_trust_provider)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the user or group to be added or removed from the list of
    # create volume permissions for a volume.
    #
    # @!attribute [rw] user_id
    #   The ID of the Amazon Web Services account to be added or removed.
    #   @return [String]
    #
    # @!attribute [rw] group
    #   The group to be added or removed. The possible value is `all`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermission AWS API Documentation
    #
    class CreateVolumePermission < Struct.new(
      :user_id,
      :group)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes modifications to the list of create volume permissions for a
    # volume.
    #
    # @!attribute [rw] add
    #   Adds the specified Amazon Web Services account ID or group to the
    #   list.
    #   @return [Array<Types::CreateVolumePermission>]
    #
    # @!attribute [rw] remove
    #   Removes the specified Amazon Web Services account ID or group from
    #   the list.
    #   @return [Array<Types::CreateVolumePermission>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermissionModifications AWS API Documentation
    #
    class CreateVolumePermissionModifications < Struct.new(
      :add,
      :remove)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] availability_zone
    #   The ID of the Availability Zone in which to create the volume. For
    #   example, `us-east-1a`.
    #
    #   Either `AvailabilityZone` or `AvailabilityZoneId` must be specified,
    #   but not both.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone in which to create the volume. For
    #   example, `use1-az1`.
    #
    #   Either `AvailabilityZone` or `AvailabilityZoneId` must be specified,
    #   but not both.
    #   @return [String]
    #
    # @!attribute [rw] encrypted
    #   Indicates whether the volume should be encrypted. The effect of
    #   setting the encryption state to `true` depends on the volume origin
    #   (new or from a snapshot), starting encryption state, ownership, and
    #   whether encryption by default is enabled. For more information, see
    #   [Encryption by default][1] in the *Amazon EBS User Guide*.
    #
    #   Encrypted Amazon EBS volumes must be attached to instances that
    #   support Amazon EBS encryption. For more information, see [Supported
    #   instance types][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default
    #   [2]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances
    #   @return [Boolean]
    #
    # @!attribute [rw] iops
    #   The number of I/O operations per second (IOPS) to provision for the
    #   volume. Required for `io1` and `io2` volumes. Optional for `gp3`
    #   volumes. Omit for all other volume types.
    #
    #   Valid ranges:
    #
    #   * gp3: `3,000 `(*default*)` - 80,000` IOPS
    #
    #   * io1: `100 - 64,000` IOPS
    #
    #   * io2: `100 - 256,000` IOPS
    #
    #   <note markdown="1"> [ Instances built on the Nitro System][1] can support up to 256,000
    #   IOPS. Other instances can support up to 32,000 IOPS.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html
    #   @return [Integer]
    #
    # @!attribute [rw] kms_key_id
    #   The identifier of the KMS key to use for Amazon EBS encryption. If
    #   this parameter is not specified, your KMS key for Amazon EBS is
    #   used. If `KmsKeyId` is specified, the encrypted state must be
    #   `true`.
    #
    #   You can specify the KMS key using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   Amazon Web Services authenticates the KMS key asynchronously.
    #   Therefore, if you specify an ID, alias, or ARN that is not valid,
    #   the action can appear to complete, but eventually fails.
    #   @return [String]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost on which to create the
    #   volume.
    #
    #   If you intend to use a volume with an instance running on an
    #   outpost, then you must create the volume on the same outpost as the
    #   instance. You can't use a volume created in an Amazon Web Services
    #   Region with an instance on an Amazon Web Services outpost, or the
    #   other way around.
    #   @return [String]
    #
    # @!attribute [rw] size
    #   The size of the volume, in GiBs. You must specify either a snapshot
    #   ID or a volume size. If you specify a snapshot, the default is the
    #   snapshot size, and you can specify a volume size that is equal to or
    #   larger than the snapshot size.
    #
    #   Valid sizes:
    #
    #   * gp2: `1 - 16,384` GiB
    #
    #   * gp3: `1 - 65,536` GiB
    #
    #   * io1: `4 - 16,384` GiB
    #
    #   * io2: `4 - 65,536` GiB
    #
    #   * st1 and sc1: `125 - 16,384` GiB
    #
    #   * standard: `1 - 1024` GiB
    #   @return [Integer]
    #
    # @!attribute [rw] snapshot_id
    #   The snapshot from which to create the volume. You must specify
    #   either a snapshot ID or a volume size.
    #   @return [String]
    #
    # @!attribute [rw] volume_type
    #   The volume type. This parameter can be one of the following values:
    #
    #   * General Purpose SSD: `gp2` \| `gp3`
    #
    #   * Provisioned IOPS SSD: `io1` \| `io2`
    #
    #   * Throughput Optimized HDD: `st1`
    #
    #   * Cold HDD: `sc1`
    #
    #   * Magnetic: `standard`
    #
    #   Throughput Optimized HDD (`st1`) and Cold HDD (`sc1`) volumes can't
    #   be used as boot volumes.
    #
    #   For more information, see [Amazon EBS volume types][1] in the
    #   *Amazon EBS User Guide*.
    #
    #   Default: `gp2`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the volume during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] multi_attach_enabled
    #   Indicates whether to enable Amazon EBS Multi-Attach. If you enable
    #   Multi-Attach, you can attach the volume to up to 16 [Instances built
    #   on the Nitro System][1] in the same Availability Zone. This
    #   parameter is supported with `io1` and `io2` volumes only. For more
    #   information, see [ Amazon EBS Multi-Attach][2] in the *Amazon EBS
    #   User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html
    #   [2]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html
    #   @return [Boolean]
    #
    # @!attribute [rw] throughput
    #   The throughput to provision for the volume, in MiB/s. Supported for
    #   `gp3` volumes only. Omit for all other volume types.
    #
    #   Valid Range: `125 - 2000` MiB/s
    #   @return [Integer]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] volume_initialization_rate
    #   Specifies the Amazon EBS Provisioned Rate for Volume Initialization
    #   (volume initialization rate), in MiB/s, at which to download the
    #   snapshot blocks from Amazon S3 to the volume. This is also known as
    #   *volume initialization*. Specifying a volume initialization rate
    #   ensures that the volume is initialized at a predictable and
    #   consistent rate after creation.
    #
    #   This parameter is supported only for volumes created from snapshots.
    #   Omit this parameter if:
    #
    #   * You want to create the volume using fast snapshot restore. You
    #     must specify a snapshot that is enabled for fast snapshot restore.
    #     In this case, the volume is fully initialized at creation.
    #
    #     <note markdown="1"> If you specify a snapshot that is enabled for fast snapshot
    #     restore and a volume initialization rate, the volume will be
    #     initialized at the specified rate instead of fast snapshot
    #     restore.
    #
    #      </note>
    #
    #   * You want to create a volume that is initialized at the default
    #     rate.
    #
    #   For more information, see [ Initialize Amazon EBS volumes][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #   Valid range: 100 - 300 MiB/s
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html
    #   @return [Integer]
    #
    # @!attribute [rw] operator
    #   Reserved for internal use.
    #   @return [Types::OperatorRequest]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumeRequest AWS API Documentation
    #
    class CreateVolumeRequest < Struct.new(
      :availability_zone,
      :availability_zone_id,
      :encrypted,
      :iops,
      :kms_key_id,
      :outpost_arn,
      :size,
      :snapshot_id,
      :volume_type,
      :tag_specifications,
      :multi_attach_enabled,
      :throughput,
      :client_token,
      :volume_initialization_rate,
      :operator,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] subnet_id
    #   A subnet ID.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   A VPC ID.
    #   @return [String]
    #
    # @!attribute [rw] internet_gateway_exclusion_mode
    #   The exclusion mode for internet gateway traffic.
    #
    #   * `allow-bidirectional`: Allow all internet traffic to and from the
    #     excluded VPCs and subnets.
    #
    #   * `allow-egress`: Allow outbound internet traffic from the excluded
    #     VPCs and subnets. Block inbound internet traffic to the excluded
    #     VPCs and subnets. Only applies when VPC Block Public Access is set
    #     to Bidirectional.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   `tag` - The key/value combination of a tag assigned to the resource.
    #   Use the tag key in the filter name and the tag value as the filter
    #   value. For example, to find all resources that have a tag with the
    #   key `Owner` and the value `TeamA`, specify `tag:Owner` for the
    #   filter name and `TeamA` for the filter value.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcBlockPublicAccessExclusionRequest AWS API Documentation
    #
    class CreateVpcBlockPublicAccessExclusionRequest < Struct.new(
      :dry_run,
      :subnet_id,
      :vpc_id,
      :internet_gateway_exclusion_mode,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_block_public_access_exclusion
    #   Details about an exclusion.
    #   @return [Types::VpcBlockPublicAccessExclusion]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcBlockPublicAccessExclusionResult AWS API Documentation
    #
    class CreateVpcBlockPublicAccessExclusionResult < Struct.new(
      :vpc_block_public_access_exclusion)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC for which to create the encryption control
    #   configuration.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the VPC Encryption Control resource.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEncryptionControlRequest AWS API Documentation
    #
    class CreateVpcEncryptionControlRequest < Struct.new(
      :dry_run,
      :vpc_id,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_encryption_control
    #   Information about the VPC Encryption Control configuration.
    #   @return [Types::VpcEncryptionControl]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEncryptionControlResult AWS API Documentation
    #
    class CreateVpcEncryptionControlResult < Struct.new(
      :vpc_encryption_control)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_id
    #   The ID of the endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] vpc_endpoint_id
    #   The ID of the endpoint.
    #   @return [String]
    #
    # @!attribute [rw] connection_notification_arn
    #   The ARN of the SNS topic for the notifications.
    #   @return [String]
    #
    # @!attribute [rw] connection_events
    #   The endpoint events for which to receive notifications. Valid values
    #   are `Accept`, `Connect`, `Delete`, and `Reject`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotificationRequest AWS API Documentation
    #
    class CreateVpcEndpointConnectionNotificationRequest < Struct.new(
      :dry_run,
      :service_id,
      :vpc_endpoint_id,
      :connection_notification_arn,
      :connection_events,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] connection_notification
    #   Information about the notification.
    #   @return [Types::ConnectionNotification]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotificationResult AWS API Documentation
    #
    class CreateVpcEndpointConnectionNotificationResult < Struct.new(
      :connection_notification,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_endpoint_type
    #   The type of endpoint.
    #
    #   Default: Gateway
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] service_name
    #   The name of the endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] policy_document
    #   (Interface and gateway endpoints) A policy to attach to the endpoint
    #   that controls access to the service. The policy must be in valid
    #   JSON format. If this parameter is not specified, we attach a default
    #   policy that allows full access to the service.
    #   @return [String]
    #
    # @!attribute [rw] route_table_ids
    #   (Gateway endpoint) The route table IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] subnet_ids
    #   (Interface and Gateway Load Balancer endpoints) The IDs of the
    #   subnets in which to create endpoint network interfaces. For a
    #   Gateway Load Balancer endpoint, you can specify only one subnet.
    #   @return [Array<String>]
    #
    # @!attribute [rw] security_group_ids
    #   (Interface endpoint) The IDs of the security groups to associate
    #   with the endpoint network interfaces. If this parameter is not
    #   specified, we use the default security group for the VPC.
    #   @return [Array<String>]
    #
    # @!attribute [rw] ip_address_type
    #   The IP address type for the endpoint.
    #   @return [String]
    #
    # @!attribute [rw] dns_options
    #   The DNS options for the endpoint.
    #   @return [Types::DnsOptionsSpecification]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] private_dns_enabled
    #   (Interface endpoint) Indicates whether to associate a private hosted
    #   zone with the specified VPC. The private hosted zone contains a
    #   record set for the default public DNS name for the service for the
    #   Region (for example, `kinesis.us-east-1.amazonaws.com`), which
    #   resolves to the private IP addresses of the endpoint network
    #   interfaces in the VPC. This enables you to make requests to the
    #   default public DNS name for the service instead of the public DNS
    #   names that are automatically generated by the VPC endpoint service.
    #
    #   To use a private hosted zone, you must set the following VPC
    #   attributes to `true`: `enableDnsHostnames` and `enableDnsSupport`.
    #   Use ModifyVpcAttribute to set the VPC attributes.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to associate with the endpoint.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] subnet_configurations
    #   The subnet configurations for the endpoint.
    #   @return [Array<Types::SubnetConfiguration>]
    #
    # @!attribute [rw] service_network_arn
    #   The Amazon Resource Name (ARN) of a service network that will be
    #   associated with the VPC endpoint of type service-network.
    #   @return [String]
    #
    # @!attribute [rw] resource_configuration_arn
    #   The Amazon Resource Name (ARN) of a resource configuration that will
    #   be associated with the VPC endpoint of type resource.
    #   @return [String]
    #
    # @!attribute [rw] service_region
    #   The Region where the service is hosted. The default is the current
    #   Region.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointRequest AWS API Documentation
    #
    class CreateVpcEndpointRequest < Struct.new(
      :dry_run,
      :vpc_endpoint_type,
      :vpc_id,
      :service_name,
      :policy_document,
      :route_table_ids,
      :subnet_ids,
      :security_group_ids,
      :ip_address_type,
      :dns_options,
      :client_token,
      :private_dns_enabled,
      :tag_specifications,
      :subnet_configurations,
      :service_network_arn,
      :resource_configuration_arn,
      :service_region)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_endpoint
    #   Information about the endpoint.
    #   @return [Types::VpcEndpoint]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointResult AWS API Documentation
    #
    class CreateVpcEndpointResult < Struct.new(
      :vpc_endpoint,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] acceptance_required
    #   Indicates whether requests from service consumers to create an
    #   endpoint to your service must be accepted manually.
    #   @return [Boolean]
    #
    # @!attribute [rw] private_dns_name
    #   (Interface endpoint configuration) The private DNS name to assign to
    #   the VPC endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] network_load_balancer_arns
    #   The Amazon Resource Names (ARNs) of the Network Load Balancers.
    #   @return [Array<String>]
    #
    # @!attribute [rw] gateway_load_balancer_arns
    #   The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
    #   @return [Array<String>]
    #
    # @!attribute [rw] supported_ip_address_types
    #   The supported IP address types. The possible values are `ipv4` and
    #   `ipv6`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] supported_regions
    #   The Regions from which service consumers can access the service.
    #   @return [Array<String>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to associate with the service.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfigurationRequest AWS API Documentation
    #
    class CreateVpcEndpointServiceConfigurationRequest < Struct.new(
      :dry_run,
      :acceptance_required,
      :private_dns_name,
      :network_load_balancer_arns,
      :gateway_load_balancer_arns,
      :supported_ip_address_types,
      :supported_regions,
      :client_token,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] service_configuration
    #   Information about the service configuration.
    #   @return [Types::ServiceConfiguration]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfigurationResult AWS API Documentation
    #
    class CreateVpcEndpointServiceConfigurationResult < Struct.new(
      :service_configuration,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] peer_region
    #   The Region code for the accepter VPC, if the accepter VPC is located
    #   in a Region other than the Region in which you make the request.
    #
    #   Default: The Region in which you make the request.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the peering connection.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the requester VPC. You must specify this parameter in the
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] peer_vpc_id
    #   The ID of the VPC with which you are creating the VPC peering
    #   connection. You must specify this parameter in the request.
    #   @return [String]
    #
    # @!attribute [rw] peer_owner_id
    #   The Amazon Web Services account ID of the owner of the accepter VPC.
    #
    #   Default: Your Amazon Web Services account ID
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnectionRequest AWS API Documentation
    #
    class CreateVpcPeeringConnectionRequest < Struct.new(
      :peer_region,
      :tag_specifications,
      :dry_run,
      :vpc_id,
      :peer_vpc_id,
      :peer_owner_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_peering_connection
    #   Information about the VPC peering connection.
    #   @return [Types::VpcPeeringConnection]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnectionResult AWS API Documentation
    #
    class CreateVpcPeeringConnectionResult < Struct.new(
      :vpc_peering_connection)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cidr_block
    #   The IPv4 network range for the VPC, in CIDR notation. For example,
    #   `10.0.0.0/16`. We modify the specified CIDR block to its canonical
    #   form; for example, if you specify `100.68.0.18/18`, we modify it to
    #   `100.68.0.0/18`.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_pool
    #   The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
    #   block.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 CIDR block from the IPv6 address pool. You must also
    #   specify `Ipv6Pool` in the request.
    #
    #   To let Amazon choose the IPv6 CIDR block for you, omit this
    #   parameter.
    #   @return [String]
    #
    # @!attribute [rw] ipv_4_ipam_pool_id
    #   The ID of an IPv4 IPAM pool you want to use for allocating this
    #   VPC's CIDR. For more information, see [What is IPAM?][1] in the
    #   *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [String]
    #
    # @!attribute [rw] ipv_4_netmask_length
    #   The netmask length of the IPv4 CIDR you want to allocate to this VPC
    #   from an Amazon VPC IP Address Manager (IPAM) pool. For more
    #   information about IPAM, see [What is IPAM?][1] in the *Amazon VPC
    #   IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_ipam_pool_id
    #   The ID of an IPv6 IPAM pool which will be used to allocate this VPC
    #   an IPv6 CIDR. IPAM is a VPC feature that you can use to automate
    #   your IP address management workflows including assigning, tracking,
    #   troubleshooting, and auditing IP addresses across Amazon Web
    #   Services Regions and accounts throughout your Amazon Web Services
    #   Organization. For more information, see [What is IPAM?][1] in the
    #   *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_netmask_length
    #   The netmask length of the IPv6 CIDR you want to allocate to this VPC
    #   from an Amazon VPC IP Address Manager (IPAM) pool. For more
    #   information about IPAM, see [What is IPAM?][1] in the *Amazon VPC
    #   IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_cidr_block_network_border_group
    #   The name of the location from which we advertise the IPV6 CIDR
    #   block. Use this parameter to limit the address to this location.
    #
    #   You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
    #   parameter.
    #   @return [String]
    #
    # @!attribute [rw] vpc_encryption_control
    #   Specifies the encryption control configuration to apply to the VPC
    #   during creation. VPC Encryption Control enables you to enforce
    #   encryption for all data in transit within and between VPCs to meet
    #   compliance requirements.
    #
    #   For more information, see [Enforce VPC encryption in transit][1] in
    #   the *Amazon VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-encryption-controls.html
    #   @return [Types::VpcEncryptionControlConfiguration]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the VPC.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_tenancy
    #   The tenancy options for instances launched into the VPC. For
    #   `default`, instances are launched with shared tenancy by default.
    #   You can launch instances with any tenancy into a shared tenancy VPC.
    #   For `dedicated`, instances are launched as dedicated tenancy
    #   instances by default. You can only launch instances with a tenancy
    #   of `dedicated` or `host` into a dedicated tenancy VPC.
    #
    #   **Important:** The `host` value cannot be used with this parameter.
    #   Use the `default` or `dedicated` values only.
    #
    #   Default: `default`
    #   @return [String]
    #
    # @!attribute [rw] amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IP addresses, or the
    #   size of the CIDR block.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcRequest AWS API Documentation
    #
    class CreateVpcRequest < Struct.new(
      :cidr_block,
      :ipv_6_pool,
      :ipv_6_cidr_block,
      :ipv_4_ipam_pool_id,
      :ipv_4_netmask_length,
      :ipv_6_ipam_pool_id,
      :ipv_6_netmask_length,
      :ipv_6_cidr_block_network_border_group,
      :vpc_encryption_control,
      :tag_specifications,
      :dry_run,
      :instance_tenancy,
      :amazon_provided_ipv_6_cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc
    #   Information about the VPC.
    #   @return [Types::Vpc]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcResult AWS API Documentation
    #
    class CreateVpcResult < Struct.new(
      :vpc)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] type
    #   The type of VPN concentrator to create.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway to attach the VPN concentrator to.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the VPN concentrator during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConcentratorRequest AWS API Documentation
    #
    class CreateVpnConcentratorRequest < Struct.new(
      :type,
      :transit_gateway_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpn_concentrator
    #   Information about the VPN concentrator.
    #   @return [Types::VpnConcentrator]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConcentratorResult AWS API Documentation
    #
    class CreateVpnConcentratorResult < Struct.new(
      :vpn_concentrator)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateVpnConnection.
    #
    # @!attribute [rw] customer_gateway_id
    #   The ID of the customer gateway.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection (`ipsec.1`).
    #   @return [String]
    #
    # @!attribute [rw] vpn_gateway_id
    #   The ID of the virtual private gateway. If you specify a virtual
    #   private gateway, you cannot specify a transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway. If you specify a transit gateway, you
    #   cannot specify a virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpn_concentrator_id
    #   The ID of the VPN concentrator to associate with the VPN connection.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the VPN connection.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] pre_shared_key_storage
    #   Specifies the storage mode for the pre-shared key (PSK). Valid
    #   values are `Standard`" (stored in the Site-to-Site VPN service) or
    #   `SecretsManager` (stored in Amazon Web Services Secrets Manager).
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] options
    #   The options for the VPN connection.
    #   @return [Types::VpnConnectionOptionsSpecification]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRequest AWS API Documentation
    #
    class CreateVpnConnectionRequest < Struct.new(
      :customer_gateway_id,
      :type,
      :vpn_gateway_id,
      :transit_gateway_id,
      :vpn_concentrator_id,
      :tag_specifications,
      :pre_shared_key_storage,
      :dry_run,
      :options)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateVpnConnection.
    #
    # @!attribute [rw] vpn_connection
    #   Information about the VPN connection.
    #   @return [Types::VpnConnection]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionResult AWS API Documentation
    #
    class CreateVpnConnectionResult < Struct.new(
      :vpn_connection)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateVpnConnectionRoute.
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #   @return [String]
    #
    # @!attribute [rw] vpn_connection_id
    #   The ID of the VPN connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRouteRequest AWS API Documentation
    #
    class CreateVpnConnectionRouteRequest < Struct.new(
      :destination_cidr_block,
      :vpn_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateVpnGateway.
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone for the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection this virtual private gateway supports.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the virtual private gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] amazon_side_asn
    #   A private Autonomous System Number (ASN) for the Amazon side of a
    #   BGP session. If you're using a 16-bit ASN, it must be in the 64512
    #   to 65534 range. If you're using a 32-bit ASN, it must be in the
    #   4200000000 to 4294967294 range.
    #
    #   Default: 64512
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGatewayRequest AWS API Documentation
    #
    class CreateVpnGatewayRequest < Struct.new(
      :availability_zone,
      :type,
      :tag_specifications,
      :amazon_side_asn,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateVpnGateway.
    #
    # @!attribute [rw] vpn_gateway
    #   Information about the virtual private gateway.
    #   @return [Types::VpnGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGatewayResult AWS API Documentation
    #
    class CreateVpnGatewayResult < Struct.new(
      :vpn_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # The maximum age for allowed images.
    #
    # @!attribute [rw] maximum_days_since_created
    #   The maximum number of days that have elapsed since the image was
    #   created. For example, a value of `300` allows images that were
    #   created within the last 300 days.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreationDateCondition AWS API Documentation
    #
    class CreationDateCondition < Struct.new(
      :maximum_days_since_created)
      SENSITIVE = []
      include Aws::Structure
    end

    # The maximum age for allowed images.
    #
    # @!attribute [rw] maximum_days_since_created
    #   The maximum number of days that have elapsed since the image was
    #   created. For example, a value of `300` allows images that were
    #   created within the last 300 days.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreationDateConditionRequest AWS API Documentation
    #
    class CreationDateConditionRequest < Struct.new(
      :maximum_days_since_created)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the credit option for CPU usage of a T instance.
    #
    # @!attribute [rw] cpu_credits
    #   The credit option for CPU usage of a T instance.
    #
    #   Valid values: `standard` \| `unlimited`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreditSpecification AWS API Documentation
    #
    class CreditSpecification < Struct.new(
      :cpu_credits)
      SENSITIVE = []
      include Aws::Structure
    end

    # The credit option for CPU usage of a T instance.
    #
    # @!attribute [rw] cpu_credits
    #   The credit option for CPU usage of a T instance.
    #
    #   Valid values: `standard` \| `unlimited`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreditSpecificationRequest AWS API Documentation
    #
    class CreditSpecificationRequest < Struct.new(
      :cpu_credits)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a customer gateway.
    #
    # @!attribute [rw] certificate_arn
    #   The Amazon Resource Name (ARN) for the customer gateway certificate.
    #   @return [String]
    #
    # @!attribute [rw] device_name
    #   The name of customer gateway device.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the customer gateway.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] bgp_asn_extended
    #   The customer gateway device's Border Gateway Protocol (BGP)
    #   Autonomous System Number (ASN).
    #
    #   Valid values: `2,147,483,648` to `4,294,967,295`
    #   @return [String]
    #
    # @!attribute [rw] customer_gateway_id
    #   The ID of the customer gateway.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The current state of the customer gateway (`pending | available |
    #   deleting | deleted`).
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection the customer gateway supports
    #   (`ipsec.1`).
    #   @return [String]
    #
    # @!attribute [rw] ip_address
    #   The IP address for the customer gateway device's outside interface.
    #   The address must be static. If `OutsideIpAddressType` in your VPN
    #   connection options is set to `PrivateIpv4`, you can use an RFC6598
    #   or RFC1918 private IPv4 address. If `OutsideIpAddressType` is set to
    #   `PublicIpv4`, you can use a public IPv4 address. If
    #   `OutsideIpAddressType` is set to `Ipv6`, you can use a public IPv6
    #   address.
    #   @return [String]
    #
    # @!attribute [rw] bgp_asn
    #   The customer gateway device's Border Gateway Protocol (BGP)
    #   Autonomous System Number (ASN).
    #
    #   Valid values: `1` to `2,147,483,647`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CustomerGateway AWS API Documentation
    #
    class CustomerGateway < Struct.new(
      :certificate_arn,
      :device_name,
      :tags,
      :bgp_asn_extended,
      :customer_gateway_id,
      :state,
      :type,
      :ip_address,
      :bgp_asn)
      SENSITIVE = []
      include Aws::Structure
    end

    # A query used for retrieving network health data.
    #
    # @!attribute [rw] id
    #   A user-defined ID associated with a data query that's returned in
    #   the `dataResponse` identifying the query. For example, if you set
    #   the Id to `MyQuery01`in the query, the `dataResponse` identifies the
    #   query as `MyQuery01`.
    #   @return [String]
    #
    # @!attribute [rw] source
    #   The Region or Availability Zone that's the source for the data
    #   query. For example, `us-east-1`.
    #   @return [String]
    #
    # @!attribute [rw] destination
    #   The Region or Availability Zone that's the target for the data
    #   query. For example, `eu-north-1`.
    #   @return [String]
    #
    # @!attribute [rw] metric
    #   The metric used for the network performance request.
    #   @return [String]
    #
    # @!attribute [rw] statistic
    #   The metric data aggregation period, `p50`, between the specified
    #   `startDate` and `endDate`. For example, a metric of `five_minutes`
    #   is the median of all the data points gathered within those five
    #   minutes. `p50` is the only supported metric.
    #   @return [String]
    #
    # @!attribute [rw] period
    #   The aggregation period used for the data query.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DataQuery AWS API Documentation
    #
    class DataQuery < Struct.new(
      :id,
      :source,
      :destination,
      :metric,
      :statistic,
      :period)
      SENSITIVE = []
      include Aws::Structure
    end

    # The response to a `DataQuery`.
    #
    # @!attribute [rw] id
    #   The ID passed in the `DataQuery`.
    #   @return [String]
    #
    # @!attribute [rw] source
    #   The Region or Availability Zone that's the source for the data
    #   query. For example, `us-east-1`.
    #   @return [String]
    #
    # @!attribute [rw] destination
    #   The Region or Availability Zone that's the destination for the data
    #   query. For example, `eu-west-1`.
    #   @return [String]
    #
    # @!attribute [rw] metric
    #   The metric used for the network performance request.
    #   @return [String]
    #
    # @!attribute [rw] statistic
    #   The statistic used for the network performance request.
    #   @return [String]
    #
    # @!attribute [rw] period
    #   The period used for the network performance request.
    #   @return [String]
    #
    # @!attribute [rw] metric_points
    #   A list of `MetricPoint` objects.
    #   @return [Array<Types::MetricPoint>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DataResponse AWS API Documentation
    #
    class DataResponse < Struct.new(
      :id,
      :source,
      :destination,
      :metric,
      :statistic,
      :period,
      :metric_points)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the metadata of the account status report.
    #
    # @!attribute [rw] report_id
    #   The ID of the report.
    #   @return [String]
    #
    # @!attribute [rw] s3_bucket
    #   The name of the Amazon S3 bucket where the report is located.
    #   @return [String]
    #
    # @!attribute [rw] s3_prefix
    #   The prefix for your S3 object.
    #   @return [String]
    #
    # @!attribute [rw] target_id
    #   The root ID, organizational unit ID, or account ID.
    #
    #   Format:
    #
    #   * For root: `r-ab12`
    #
    #   * For OU: `ou-ab12-cdef1234`
    #
    #   * For account: `123456789012`
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The time when the report generation started.
    #   @return [Time]
    #
    # @!attribute [rw] end_time
    #   The time when the report generation ended.
    #   @return [Time]
    #
    # @!attribute [rw] status
    #   The current status of the report.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the report.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeclarativePoliciesReport AWS API Documentation
    #
    class DeclarativePoliciesReport < Struct.new(
      :report_id,
      :s3_bucket,
      :s3_prefix,
      :target_id,
      :start_time,
      :end_time,
      :status,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_manager_data_export_id
    #   The unique identifier of the data export configuration to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCapacityManagerDataExportRequest AWS API Documentation
    #
    class DeleteCapacityManagerDataExportRequest < Struct.new(
      :capacity_manager_data_export_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_manager_data_export_id
    #   The unique identifier of the deleted data export configuration.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCapacityManagerDataExportResult AWS API Documentation
    #
    class DeleteCapacityManagerDataExportResult < Struct.new(
      :capacity_manager_data_export_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateway_id
    #   The ID of the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGatewayRequest AWS API Documentation
    #
    class DeleteCarrierGatewayRequest < Struct.new(
      :carrier_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateway
    #   Information about the carrier gateway.
    #   @return [Types::CarrierGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGatewayResult AWS API Documentation
    #
    class DeleteCarrierGatewayResult < Struct.new(
      :carrier_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN to be deleted.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpointRequest AWS API Documentation
    #
    class DeleteClientVpnEndpointRequest < Struct.new(
      :client_vpn_endpoint_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the Client VPN endpoint.
    #   @return [Types::ClientVpnEndpointStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpointResult AWS API Documentation
    #
    class DeleteClientVpnEndpointResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint from which the route is to be
    #   deleted.
    #   @return [String]
    #
    # @!attribute [rw] target_vpc_subnet_id
    #   The ID of the target subnet used by the route.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route to be
    #   deleted.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRouteRequest AWS API Documentation
    #
    class DeleteClientVpnRouteRequest < Struct.new(
      :client_vpn_endpoint_id,
      :target_vpc_subnet_id,
      :destination_cidr_block,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the route.
    #   @return [Types::ClientVpnRouteStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRouteResult AWS API Documentation
    #
    class DeleteClientVpnRouteResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cidr
    #   A customer-owned IP address range that you want to delete.
    #   @return [String]
    #
    # @!attribute [rw] coip_pool_id
    #   The ID of the customer-owned address pool.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidrRequest AWS API Documentation
    #
    class DeleteCoipCidrRequest < Struct.new(
      :cidr,
      :coip_pool_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] coip_cidr
    #   Information about a range of customer-owned IP addresses.
    #   @return [Types::CoipCidr]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidrResult AWS API Documentation
    #
    class DeleteCoipCidrResult < Struct.new(
      :coip_cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] coip_pool_id
    #   The ID of the CoIP pool that you want to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPoolRequest AWS API Documentation
    #
    class DeleteCoipPoolRequest < Struct.new(
      :coip_pool_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] coip_pool
    #   Information about the CoIP address pool.
    #   @return [Types::CoipPool]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPoolResult AWS API Documentation
    #
    class DeleteCoipPoolResult < Struct.new(
      :coip_pool)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteCustomerGateway.
    #
    # @!attribute [rw] customer_gateway_id
    #   The ID of the customer gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGatewayRequest AWS API Documentation
    #
    class DeleteCustomerGatewayRequest < Struct.new(
      :customer_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dhcp_options_id
    #   The ID of the DHCP options set.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptionsRequest AWS API Documentation
    #
    class DeleteDhcpOptionsRequest < Struct.new(
      :dhcp_options_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] egress_only_internet_gateway_id
    #   The ID of the egress-only internet gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGatewayRequest AWS API Documentation
    #
    class DeleteEgressOnlyInternetGatewayRequest < Struct.new(
      :dry_run,
      :egress_only_internet_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return_code
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGatewayResult AWS API Documentation
    #
    class DeleteEgressOnlyInternetGatewayResult < Struct.new(
      :return_code)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an EC2 Fleet error.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The description for the error code.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetError AWS API Documentation
    #
    class DeleteFleetError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an EC2 Fleet that was not successfully deleted.
    #
    # @!attribute [rw] error
    #   The error.
    #   @return [Types::DeleteFleetError]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetErrorItem AWS API Documentation
    #
    class DeleteFleetErrorItem < Struct.new(
      :error,
      :fleet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an EC2 Fleet that was successfully deleted.
    #
    # @!attribute [rw] current_fleet_state
    #   The current state of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] previous_fleet_state
    #   The previous state of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetSuccessItem AWS API Documentation
    #
    class DeleteFleetSuccessItem < Struct.new(
      :current_fleet_state,
      :previous_fleet_state,
      :fleet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fleet_ids
    #   The IDs of the EC2 Fleets.
    #
    #   Constraints: In a single request, you can specify up to 25 `instant`
    #   fleet IDs and up to 100 `maintain` or `request` fleet IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] terminate_instances
    #   Indicates whether to terminate the associated instances when the EC2
    #   Fleet is deleted. The default is to terminate the instances.
    #
    #   To let the instances continue to run after the EC2 Fleet is deleted,
    #   specify `no-terminate-instances`. Supported only for fleets of type
    #   `maintain` and `request`.
    #
    #   For `instant` fleets, you cannot specify `NoTerminateInstances`. A
    #   deleted `instant` fleet with running instances is not supported.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetsRequest AWS API Documentation
    #
    class DeleteFleetsRequest < Struct.new(
      :dry_run,
      :fleet_ids,
      :terminate_instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successful_fleet_deletions
    #   Information about the EC2 Fleets that are successfully deleted.
    #   @return [Array<Types::DeleteFleetSuccessItem>]
    #
    # @!attribute [rw] unsuccessful_fleet_deletions
    #   Information about the EC2 Fleets that are not successfully deleted.
    #   @return [Array<Types::DeleteFleetErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetsResult AWS API Documentation
    #
    class DeleteFleetsResult < Struct.new(
      :successful_fleet_deletions,
      :unsuccessful_fleet_deletions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogsRequest AWS API Documentation
    #
    class DeleteFlowLogsRequest < Struct.new(
      :dry_run,
      :flow_log_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the flow logs that could not be deleted
    #   successfully.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogsResult AWS API Documentation
    #
    class DeleteFlowLogsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fpga_image_id
    #   The ID of the AFI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImageRequest AWS API Documentation
    #
    class DeleteFpgaImageRequest < Struct.new(
      :dry_run,
      :fpga_image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Is `true` if the request succeeds, and an error otherwise.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImageResult AWS API Documentation
    #
    class DeleteFpgaImageResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] report_id
    #   The ID of the report to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteImageUsageReportRequest AWS API Documentation
    #
    class DeleteImageUsageReportRequest < Struct.new(
      :report_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteImageUsageReportResult AWS API Documentation
    #
    class DeleteImageUsageReportResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_connect_endpoint_id
    #   The ID of the EC2 Instance Connect Endpoint to delete.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpointRequest AWS API Documentation
    #
    class DeleteInstanceConnectEndpointRequest < Struct.new(
      :dry_run,
      :instance_connect_endpoint_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_connect_endpoint
    #   Information about the EC2 Instance Connect Endpoint.
    #   @return [Types::Ec2InstanceConnectEndpoint]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpointResult AWS API Documentation
    #
    class DeleteInstanceConnectEndpointResult < Struct.new(
      :instance_connect_endpoint)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] force_delete
    #   Specify `true` to force delete the event window. Use the force
    #   delete parameter if the event window is currently associated with
    #   targets.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_event_window_id
    #   The ID of the event window.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindowRequest AWS API Documentation
    #
    class DeleteInstanceEventWindowRequest < Struct.new(
      :dry_run,
      :force_delete,
      :instance_event_window_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_event_window_state
    #   The state of the event window.
    #   @return [Types::InstanceEventWindowStateChange]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindowResult AWS API Documentation
    #
    class DeleteInstanceEventWindowResult < Struct.new(
      :instance_event_window_state)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] internet_gateway_id
    #   The ID of the internet gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGatewayRequest AWS API Documentation
    #
    class DeleteInternetGatewayRequest < Struct.new(
      :dry_run,
      :internet_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_external_resource_verification_token_id
    #   The token ID.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamExternalResourceVerificationTokenRequest AWS API Documentation
    #
    class DeleteIpamExternalResourceVerificationTokenRequest < Struct.new(
      :dry_run,
      :ipam_external_resource_verification_token_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_external_resource_verification_token
    #   The verification token.
    #   @return [Types::IpamExternalResourceVerificationToken]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamExternalResourceVerificationTokenResult AWS API Documentation
    #
    class DeleteIpamExternalResourceVerificationTokenResult < Struct.new(
      :ipam_external_resource_verification_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_policy_id
    #   The ID of the IPAM policy to delete.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPolicyRequest AWS API Documentation
    #
    class DeleteIpamPolicyRequest < Struct.new(
      :dry_run,
      :ipam_policy_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_policy
    #   Information about the deleted IPAM policy.
    #
    #   An IPAM policy is a set of rules that define how public IPv4
    #   addresses from IPAM pools are allocated to Amazon Web Services
    #   resources. Each rule maps an Amazon Web Services service to IPAM
    #   pools that the service will use to get IP addresses. A single policy
    #   can have multiple rules and be applied to multiple Amazon Web
    #   Services Regions. If the IPAM pool run out of addresses then the
    #   services fallback to Amazon-provided IP addresses. A policy can be
    #   applied to an individual Amazon Web Services account or an entity
    #   within Amazon Web Services Organizations.
    #   @return [Types::IpamPolicy]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPolicyResult AWS API Documentation
    #
    class DeleteIpamPolicyResult < Struct.new(
      :ipam_policy)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_pool_id
    #   The ID of the pool to delete.
    #   @return [String]
    #
    # @!attribute [rw] cascade
    #   Enables you to quickly delete an IPAM pool and all resources within
    #   that pool, including provisioned CIDRs, allocations, and other
    #   pools.
    #
    #   You can only use this option to delete pools in the private scope or
    #   pools in the public scope with a source resource. A source resource
    #   is a resource used to provision CIDRs to a resource planning pool.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPoolRequest AWS API Documentation
    #
    class DeleteIpamPoolRequest < Struct.new(
      :dry_run,
      :ipam_pool_id,
      :cascade)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_pool
    #   Information about the results of the deletion.
    #   @return [Types::IpamPool]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPoolResult AWS API Documentation
    #
    class DeleteIpamPoolResult < Struct.new(
      :ipam_pool)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_prefix_list_resolver_id
    #   The ID of the IPAM prefix list resolver to delete.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPrefixListResolverRequest AWS API Documentation
    #
    class DeleteIpamPrefixListResolverRequest < Struct.new(
      :dry_run,
      :ipam_prefix_list_resolver_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_prefix_list_resolver
    #   Information about the IPAM prefix list resolver that was deleted.
    #   @return [Types::IpamPrefixListResolver]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPrefixListResolverResult AWS API Documentation
    #
    class DeleteIpamPrefixListResolverResult < Struct.new(
      :ipam_prefix_list_resolver)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_prefix_list_resolver_target_id
    #   The ID of the IPAM prefix list resolver target to delete.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPrefixListResolverTargetRequest AWS API Documentation
    #
    class DeleteIpamPrefixListResolverTargetRequest < Struct.new(
      :dry_run,
      :ipam_prefix_list_resolver_target_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_prefix_list_resolver_target
    #   Information about the IPAM prefix list resolver target that was
    #   deleted.
    #   @return [Types::IpamPrefixListResolverTarget]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPrefixListResolverTargetResult AWS API Documentation
    #
    class DeleteIpamPrefixListResolverTargetResult < Struct.new(
      :ipam_prefix_list_resolver_target)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_id
    #   The ID of the IPAM to delete.
    #   @return [String]
    #
    # @!attribute [rw] cascade
    #   Enables you to quickly delete an IPAM, private scopes, pools in
    #   private scopes, and any allocations in the pools in private scopes.
    #   You cannot delete the IPAM with this option if there is a pool in
    #   your public scope. If you use this option, IPAM does the following:
    #
    #   * Deallocates any CIDRs allocated to VPC resources (such as VPCs) in
    #     pools in private scopes.
    #
    #     <note markdown="1"> No VPC resources are deleted as a result of enabling this option.
    #     The CIDR associated with the resource will no longer be allocated
    #     from an IPAM pool, but the CIDR itself will remain unchanged.
    #
    #      </note>
    #
    #   * Deprovisions all IPv4 CIDRs provisioned to IPAM pools in private
    #     scopes.
    #
    #   * Deletes all IPAM pools in private scopes.
    #
    #   * Deletes all non-default private scopes in the IPAM.
    #
    #   * Deletes the default public and private scopes and the IPAM.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamRequest AWS API Documentation
    #
    class DeleteIpamRequest < Struct.new(
      :dry_run,
      :ipam_id,
      :cascade)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_resource_discovery_id
    #   The IPAM resource discovery ID.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscoveryRequest AWS API Documentation
    #
    class DeleteIpamResourceDiscoveryRequest < Struct.new(
      :dry_run,
      :ipam_resource_discovery_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_resource_discovery
    #   The IPAM resource discovery.
    #   @return [Types::IpamResourceDiscovery]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscoveryResult AWS API Documentation
    #
    class DeleteIpamResourceDiscoveryResult < Struct.new(
      :ipam_resource_discovery)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam
    #   Information about the results of the deletion.
    #   @return [Types::Ipam]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResult AWS API Documentation
    #
    class DeleteIpamResult < Struct.new(
      :ipam)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_scope_id
    #   The ID of the scope to delete.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScopeRequest AWS API Documentation
    #
    class DeleteIpamScopeRequest < Struct.new(
      :dry_run,
      :ipam_scope_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_scope
    #   Information about the results of the deletion.
    #   @return [Types::IpamScope]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScopeResult AWS API Documentation
    #
    class DeleteIpamScopeResult < Struct.new(
      :ipam_scope)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] key_name
    #   The name of the key pair.
    #   @return [String]
    #
    # @!attribute [rw] key_pair_id
    #   The ID of the key pair.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPairRequest AWS API Documentation
    #
    class DeleteKeyPairRequest < Struct.new(
      :key_name,
      :key_pair_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Is `true` if the request succeeds, and an error otherwise.
    #   @return [Boolean]
    #
    # @!attribute [rw] key_pair_id
    #   The ID of the key pair.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPairResult AWS API Documentation
    #
    class DeleteKeyPairResult < Struct.new(
      :return,
      :key_pair_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template.
    #
    #   You must specify either the launch template ID or the launch
    #   template name, but not both.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template.
    #
    #   You must specify either the launch template ID or the launch
    #   template name, but not both.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateRequest AWS API Documentation
    #
    class DeleteLaunchTemplateRequest < Struct.new(
      :dry_run,
      :launch_template_id,
      :launch_template_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_template
    #   Information about the launch template.
    #   @return [Types::LaunchTemplate]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateResult AWS API Documentation
    #
    class DeleteLaunchTemplateResult < Struct.new(
      :launch_template)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template.
    #
    #   You must specify either the launch template ID or the launch
    #   template name, but not both.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template.
    #
    #   You must specify either the launch template ID or the launch
    #   template name, but not both.
    #   @return [String]
    #
    # @!attribute [rw] versions
    #   The version numbers of one or more launch template versions to
    #   delete. You can specify up to 200 launch template version numbers.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsRequest AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsRequest < Struct.new(
      :dry_run,
      :launch_template_id,
      :launch_template_name,
      :versions)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a launch template version that could not be deleted.
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] version_number
    #   The version number of the launch template.
    #   @return [Integer]
    #
    # @!attribute [rw] response_error
    #   Information about the error.
    #   @return [Types::ResponseError]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResponseErrorItem AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsResponseErrorItem < Struct.new(
      :launch_template_id,
      :launch_template_name,
      :version_number,
      :response_error)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a launch template version that was successfully deleted.
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] version_number
    #   The version number of the launch template.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResponseSuccessItem AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsResponseSuccessItem < Struct.new(
      :launch_template_id,
      :launch_template_name,
      :version_number)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successfully_deleted_launch_template_versions
    #   Information about the launch template versions that were
    #   successfully deleted.
    #   @return [Array<Types::DeleteLaunchTemplateVersionsResponseSuccessItem>]
    #
    # @!attribute [rw] unsuccessfully_deleted_launch_template_versions
    #   Information about the launch template versions that could not be
    #   deleted.
    #   @return [Array<Types::DeleteLaunchTemplateVersionsResponseErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResult AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsResult < Struct.new(
      :successfully_deleted_launch_template_versions,
      :unsuccessfully_deleted_launch_template_versions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] destination_cidr_block
    #   The CIDR range for the route. This must match the CIDR for the route
    #   exactly.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] destination_prefix_list_id
    #   Use a prefix list in place of `DestinationCidrBlock`. You cannot use
    #   `DestinationPrefixListId` and `DestinationCidrBlock` in the same
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteRequest AWS API Documentation
    #
    class DeleteLocalGatewayRouteRequest < Struct.new(
      :destination_cidr_block,
      :local_gateway_route_table_id,
      :dry_run,
      :destination_prefix_list_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::LocalGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteResult AWS API Documentation
    #
    class DeleteLocalGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableRequest AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableRequest < Struct.new(
      :local_gateway_route_table_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table
    #   Information about the local gateway route table.
    #   @return [Types::LocalGatewayRouteTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableResult AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableResult < Struct.new(
      :local_gateway_route_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_virtual_interface_group_association_id
    #   The ID of the local gateway route table virtual interface group
    #   association.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest < Struct.new(
      :local_gateway_route_table_virtual_interface_group_association_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_virtual_interface_group_association
    #   Information about the association.
    #   @return [Types::LocalGatewayRouteTableVirtualInterfaceGroupAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult < Struct.new(
      :local_gateway_route_table_virtual_interface_group_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_vpc_association_id
    #   The ID of the association.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociationRequest AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableVpcAssociationRequest < Struct.new(
      :local_gateway_route_table_vpc_association_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_vpc_association
    #   Information about the association.
    #   @return [Types::LocalGatewayRouteTableVpcAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociationResult AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableVpcAssociationResult < Struct.new(
      :local_gateway_route_table_vpc_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface_group_id
    #   The ID of the local gateway virtual interface group to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayVirtualInterfaceGroupRequest AWS API Documentation
    #
    class DeleteLocalGatewayVirtualInterfaceGroupRequest < Struct.new(
      :local_gateway_virtual_interface_group_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface_group
    #   Information about the deleted local gateway virtual interface group.
    #   @return [Types::LocalGatewayVirtualInterfaceGroup]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayVirtualInterfaceGroupResult AWS API Documentation
    #
    class DeleteLocalGatewayVirtualInterfaceGroupResult < Struct.new(
      :local_gateway_virtual_interface_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface_id
    #   The ID of the local virtual interface to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayVirtualInterfaceRequest AWS API Documentation
    #
    class DeleteLocalGatewayVirtualInterfaceRequest < Struct.new(
      :local_gateway_virtual_interface_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface
    #   Information about the deleted local gateway virtual interface.
    #   @return [Types::LocalGatewayVirtualInterface]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayVirtualInterfaceResult AWS API Documentation
    #
    class DeleteLocalGatewayVirtualInterfaceResult < Struct.new(
      :local_gateway_virtual_interface)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] prefix_list_id
    #   The ID of the prefix list.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixListRequest AWS API Documentation
    #
    class DeleteManagedPrefixListRequest < Struct.new(
      :dry_run,
      :prefix_list_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] prefix_list
    #   Information about the prefix list.
    #   @return [Types::ManagedPrefixList]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixListResult AWS API Documentation
    #
    class DeleteManagedPrefixListResult < Struct.new(
      :prefix_list)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGatewayRequest AWS API Documentation
    #
    class DeleteNatGatewayRequest < Struct.new(
      :dry_run,
      :nat_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGatewayResult AWS API Documentation
    #
    class DeleteNatGatewayResult < Struct.new(
      :nat_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_acl_id
    #   The ID of the network ACL.
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The rule number of the entry to delete.
    #   @return [Integer]
    #
    # @!attribute [rw] egress
    #   Indicates whether the rule is an egress rule.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntryRequest AWS API Documentation
    #
    class DeleteNetworkAclEntryRequest < Struct.new(
      :dry_run,
      :network_acl_id,
      :rule_number,
      :egress)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_acl_id
    #   The ID of the network ACL.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclRequest AWS API Documentation
    #
    class DeleteNetworkAclRequest < Struct.new(
      :dry_run,
      :network_acl_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_access_scope_analysis_id
    #   The ID of the Network Access Scope analysis.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysisRequest AWS API Documentation
    #
    class DeleteNetworkInsightsAccessScopeAnalysisRequest < Struct.new(
      :network_insights_access_scope_analysis_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_access_scope_analysis_id
    #   The ID of the Network Access Scope analysis.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysisResult AWS API Documentation
    #
    class DeleteNetworkInsightsAccessScopeAnalysisResult < Struct.new(
      :network_insights_access_scope_analysis_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_insights_access_scope_id
    #   The ID of the Network Access Scope.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeRequest AWS API Documentation
    #
    class DeleteNetworkInsightsAccessScopeRequest < Struct.new(
      :dry_run,
      :network_insights_access_scope_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_access_scope_id
    #   The ID of the Network Access Scope.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeResult AWS API Documentation
    #
    class DeleteNetworkInsightsAccessScopeResult < Struct.new(
      :network_insights_access_scope_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_insights_analysis_id
    #   The ID of the network insights analysis.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysisRequest AWS API Documentation
    #
    class DeleteNetworkInsightsAnalysisRequest < Struct.new(
      :dry_run,
      :network_insights_analysis_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_analysis_id
    #   The ID of the network insights analysis.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysisResult AWS API Documentation
    #
    class DeleteNetworkInsightsAnalysisResult < Struct.new(
      :network_insights_analysis_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_insights_path_id
    #   The ID of the path.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPathRequest AWS API Documentation
    #
    class DeleteNetworkInsightsPathRequest < Struct.new(
      :dry_run,
      :network_insights_path_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_path_id
    #   The ID of the path.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPathResult AWS API Documentation
    #
    class DeleteNetworkInsightsPathResult < Struct.new(
      :network_insights_path_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteNetworkInterfacePermission.
    #
    # @!attribute [rw] network_interface_permission_id
    #   The ID of the network interface permission.
    #   @return [String]
    #
    # @!attribute [rw] force
    #   Specify `true` to remove the permission even if the network
    #   interface is attached to an instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermissionRequest AWS API Documentation
    #
    class DeleteNetworkInterfacePermissionRequest < Struct.new(
      :network_interface_permission_id,
      :force,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for DeleteNetworkInterfacePermission.
    #
    # @!attribute [rw] return
    #   Is `true` if the request succeeds and an error otherwise.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermissionResult AWS API Documentation
    #
    class DeleteNetworkInterfacePermissionResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteNetworkInterface.
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfaceRequest AWS API Documentation
    #
    class DeleteNetworkInterfaceRequest < Struct.new(
      :dry_run,
      :network_interface_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_name
    #   The name of the placement group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroupRequest AWS API Documentation
    #
    class DeletePlacementGroupRequest < Struct.new(
      :dry_run,
      :group_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] pool_id
    #   The ID of the public IPv4 pool you want to delete.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   The Availability Zone (AZ) or Local Zone (LZ) network border group
    #   that the resource that the IP address is assigned to is in. Defaults
    #   to an AZ network border group. For more information on available
    #   Local Zones, see [Local Zone availability][1] in the *Amazon EC2
    #   User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4PoolRequest AWS API Documentation
    #
    class DeletePublicIpv4PoolRequest < Struct.new(
      :dry_run,
      :pool_id,
      :network_border_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return_value
    #   Information about the result of deleting the public IPv4 pool.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4PoolResult AWS API Documentation
    #
    class DeletePublicIpv4PoolResult < Struct.new(
      :return_value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the error for a Reserved Instance whose queued purchase
    # could not be deleted.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The error message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstancesError AWS API Documentation
    #
    class DeleteQueuedReservedInstancesError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] reserved_instances_ids
    #   The IDs of the Reserved Instances.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstancesRequest AWS API Documentation
    #
    class DeleteQueuedReservedInstancesRequest < Struct.new(
      :dry_run,
      :reserved_instances_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successful_queued_purchase_deletions
    #   Information about the queued purchases that were successfully
    #   deleted.
    #   @return [Array<Types::SuccessfulQueuedPurchaseDeletion>]
    #
    # @!attribute [rw] failed_queued_purchase_deletions
    #   Information about the queued purchases that could not be deleted.
    #   @return [Array<Types::FailedQueuedPurchaseDeletion>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstancesResult AWS API Documentation
    #
    class DeleteQueuedReservedInstancesResult < Struct.new(
      :successful_queued_purchase_deletions,
      :failed_queued_purchase_deletions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] destination_prefix_list_id
    #   The ID of the prefix list for the route.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #   @return [String]
    #
    # @!attribute [rw] destination_ipv_6_cidr_block
    #   The IPv6 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteRequest AWS API Documentation
    #
    class DeleteRouteRequest < Struct.new(
      :destination_prefix_list_id,
      :dry_run,
      :route_table_id,
      :destination_cidr_block,
      :destination_ipv_6_cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_endpoint_id
    #   The ID of the route server endpoint to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerEndpointRequest AWS API Documentation
    #
    class DeleteRouteServerEndpointRequest < Struct.new(
      :route_server_endpoint_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_endpoint
    #   Information about the deleted route server endpoint.
    #   @return [Types::RouteServerEndpoint]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerEndpointResult AWS API Documentation
    #
    class DeleteRouteServerEndpointResult < Struct.new(
      :route_server_endpoint)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_peer_id
    #   The ID of the route server peer to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerPeerRequest AWS API Documentation
    #
    class DeleteRouteServerPeerRequest < Struct.new(
      :route_server_peer_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_peer
    #   Information about the deleted route server peer.
    #   @return [Types::RouteServerPeer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerPeerResult AWS API Documentation
    #
    class DeleteRouteServerPeerResult < Struct.new(
      :route_server_peer)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server_id
    #   The ID of the route server to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerRequest AWS API Documentation
    #
    class DeleteRouteServerRequest < Struct.new(
      :route_server_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_server
    #   Information about the deleted route server.
    #   @return [Types::RouteServer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerResult AWS API Documentation
    #
    class DeleteRouteServerResult < Struct.new(
      :route_server)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTableRequest AWS API Documentation
    #
    class DeleteRouteTableRequest < Struct.new(
      :dry_run,
      :route_table_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] secondary_network_id
    #   The ID of the secondary network.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecondaryNetworkRequest AWS API Documentation
    #
    class DeleteSecondaryNetworkRequest < Struct.new(
      :client_token,
      :dry_run,
      :secondary_network_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] secondary_network
    #   Information about the secondary network.
    #   @return [Types::SecondaryNetwork]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecondaryNetworkResult AWS API Documentation
    #
    class DeleteSecondaryNetworkResult < Struct.new(
      :secondary_network,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] secondary_subnet_id
    #   The ID of the secondary subnet to delete.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecondarySubnetRequest AWS API Documentation
    #
    class DeleteSecondarySubnetRequest < Struct.new(
      :client_token,
      :dry_run,
      :secondary_subnet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] secondary_subnet
    #   Information about the secondary subnet being deleted.
    #   @return [Types::SecondarySubnet]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecondarySubnetResult AWS API Documentation
    #
    class DeleteSecondarySubnetResult < Struct.new(
      :secondary_subnet,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] group_id
    #   The ID of the security group.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   \[Default VPC\] The name of the security group. You can specify
    #   either the security group name or the security group ID. For
    #   security groups in a nondefault VPC, you must specify the security
    #   group ID.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroupRequest AWS API Documentation
    #
    class DeleteSecurityGroupRequest < Struct.new(
      :group_id,
      :group_name,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, returns an error.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_id
    #   The ID of the deleted security group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroupResult AWS API Documentation
    #
    class DeleteSecurityGroupResult < Struct.new(
      :return,
      :group_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] snapshot_id
    #   The ID of the EBS snapshot.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshotRequest AWS API Documentation
    #
    class DeleteSnapshotRequest < Struct.new(
      :snapshot_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # The snapshot ID and its deletion result code.
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] return_code
    #   The result code from the snapshot deletion attempt. Possible values:
    #
    #   * `success` - The snapshot was successfully deleted.
    #
    #   * `skipped` - The snapshot was not deleted because it's associated
    #     with other AMIs.
    #
    #   * `missing-permissions` - The snapshot was not deleted because the
    #     role lacks `DeleteSnapshot` permissions. For more information, see
    #     [How Amazon EBS works with IAM][1].
    #
    #   * `internal-error` - The snapshot was not deleted due to a server
    #     error.
    #
    #   * `client-error` - The snapshot was not deleted due to a client
    #     configuration error.
    #
    #   For details about an error, check the `DeleteSnapshot` event in the
    #   CloudTrail event history. For more information, see [View event
    #   history][2] in the *Amazon Web Services CloudTrail User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/security_iam_service-with-iam.html
    #   [2]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/tutorial-event-history.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshotReturnCode AWS API Documentation
    #
    class DeleteSnapshotReturnCode < Struct.new(
      :snapshot_id,
      :return_code)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteSpotDatafeedSubscription.
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscriptionRequest AWS API Documentation
    #
    class DeleteSpotDatafeedSubscriptionRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet_cidr_reservation_id
    #   The ID of the subnet CIDR reservation.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservationRequest AWS API Documentation
    #
    class DeleteSubnetCidrReservationRequest < Struct.new(
      :subnet_cidr_reservation_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] deleted_subnet_cidr_reservation
    #   Information about the deleted subnet CIDR reservation.
    #   @return [Types::SubnetCidrReservation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservationResult AWS API Documentation
    #
    class DeleteSubnetCidrReservationResult < Struct.new(
      :deleted_subnet_cidr_reservation)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetRequest AWS API Documentation
    #
    class DeleteSubnetRequest < Struct.new(
      :subnet_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tags
    #   The tags to delete. Specify a tag key and an optional tag value to
    #   delete specific tags. If you specify a tag key without a tag value,
    #   we delete any tag with this key regardless of its value. If you
    #   specify a tag key with an empty string as the tag value, we delete
    #   the tag only if its value is an empty string.
    #
    #   If you omit this parameter, we delete all user-defined tags for the
    #   specified resources. We do not delete Amazon Web Services-generated
    #   tags (tags that have the `aws:` prefix).
    #
    #   Constraints: Up to 1000 tags.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTagsRequest AWS API Documentation
    #
    class DeleteTagsRequest < Struct.new(
      :dry_run,
      :resources,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRequest AWS API Documentation
    #
    class DeleteTrafficMirrorFilterRequest < Struct.new(
      :traffic_mirror_filter_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterResult AWS API Documentation
    #
    class DeleteTrafficMirrorFilterResult < Struct.new(
      :traffic_mirror_filter_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_rule_id
    #   The ID of the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRuleRequest AWS API Documentation
    #
    class DeleteTrafficMirrorFilterRuleRequest < Struct.new(
      :traffic_mirror_filter_rule_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_rule_id
    #   The ID of the deleted Traffic Mirror rule.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRuleResult AWS API Documentation
    #
    class DeleteTrafficMirrorFilterRuleResult < Struct.new(
      :traffic_mirror_filter_rule_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_session_id
    #   The ID of the Traffic Mirror session.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSessionRequest AWS API Documentation
    #
    class DeleteTrafficMirrorSessionRequest < Struct.new(
      :traffic_mirror_session_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_session_id
    #   The ID of the deleted Traffic Mirror session.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSessionResult AWS API Documentation
    #
    class DeleteTrafficMirrorSessionResult < Struct.new(
      :traffic_mirror_session_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTargetRequest AWS API Documentation
    #
    class DeleteTrafficMirrorTargetRequest < Struct.new(
      :traffic_mirror_target_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_target_id
    #   The ID of the deleted Traffic Mirror target.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTargetResult AWS API Documentation
    #
    class DeleteTrafficMirrorTargetResult < Struct.new(
      :traffic_mirror_target_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect_peer_id
    #   The ID of the Connect peer.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeerRequest AWS API Documentation
    #
    class DeleteTransitGatewayConnectPeerRequest < Struct.new(
      :transit_gateway_connect_peer_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect_peer
    #   Information about the deleted Connect peer.
    #   @return [Types::TransitGatewayConnectPeer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeerResult AWS API Documentation
    #
    class DeleteTransitGatewayConnectPeerResult < Struct.new(
      :transit_gateway_connect_peer)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the Connect attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectRequest AWS API Documentation
    #
    class DeleteTransitGatewayConnectRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect
    #   Information about the deleted Connect attachment.
    #   @return [Types::TransitGatewayConnect]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectResult AWS API Documentation
    #
    class DeleteTransitGatewayConnectResult < Struct.new(
      :transit_gateway_connect)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_metering_policy_id
    #   The ID of the transit gateway metering policy containing the entry
    #   to delete.
    #   @return [String]
    #
    # @!attribute [rw] policy_rule_number
    #   The rule number of the metering policy entry to delete.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMeteringPolicyEntryRequest AWS API Documentation
    #
    class DeleteTransitGatewayMeteringPolicyEntryRequest < Struct.new(
      :transit_gateway_metering_policy_id,
      :policy_rule_number,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_metering_policy_entry
    #   Information about the deleted transit gateway metering policy entry.
    #   @return [Types::TransitGatewayMeteringPolicyEntry]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMeteringPolicyEntryResult AWS API Documentation
    #
    class DeleteTransitGatewayMeteringPolicyEntryResult < Struct.new(
      :transit_gateway_metering_policy_entry)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_metering_policy_id
    #   The ID of the transit gateway metering policy to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMeteringPolicyRequest AWS API Documentation
    #
    class DeleteTransitGatewayMeteringPolicyRequest < Struct.new(
      :transit_gateway_metering_policy_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_metering_policy
    #   Information about the deleted transit gateway metering policy.
    #   @return [Types::TransitGatewayMeteringPolicy]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMeteringPolicyResult AWS API Documentation
    #
    class DeleteTransitGatewayMeteringPolicyResult < Struct.new(
      :transit_gateway_metering_policy)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomainRequest AWS API Documentation
    #
    class DeleteTransitGatewayMulticastDomainRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain
    #   Information about the deleted transit gateway multicast domain.
    #   @return [Types::TransitGatewayMulticastDomain]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomainResult AWS API Documentation
    #
    class DeleteTransitGatewayMulticastDomainResult < Struct.new(
      :transit_gateway_multicast_domain)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway peering attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachmentRequest AWS API Documentation
    #
    class DeleteTransitGatewayPeeringAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_peering_attachment
    #   The transit gateway peering attachment.
    #   @return [Types::TransitGatewayPeeringAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachmentResult AWS API Documentation
    #
    class DeleteTransitGatewayPeeringAttachmentResult < Struct.new(
      :transit_gateway_peering_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_policy_table_id
    #   The transit gateway policy table to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTableRequest AWS API Documentation
    #
    class DeleteTransitGatewayPolicyTableRequest < Struct.new(
      :transit_gateway_policy_table_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_policy_table
    #   Provides details about the deleted transit gateway policy table.
    #   @return [Types::TransitGatewayPolicyTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTableResult AWS API Documentation
    #
    class DeleteTransitGatewayPolicyTableResult < Struct.new(
      :transit_gateway_policy_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_id
    #   The ID of the prefix list.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReferenceRequest AWS API Documentation
    #
    class DeleteTransitGatewayPrefixListReferenceRequest < Struct.new(
      :transit_gateway_route_table_id,
      :prefix_list_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_prefix_list_reference
    #   Information about the deleted prefix list reference.
    #   @return [Types::TransitGatewayPrefixListReference]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReferenceResult AWS API Documentation
    #
    class DeleteTransitGatewayPrefixListReferenceResult < Struct.new(
      :transit_gateway_prefix_list_reference)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRequest AWS API Documentation
    #
    class DeleteTransitGatewayRequest < Struct.new(
      :transit_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway
    #   Information about the deleted transit gateway.
    #   @return [Types::TransitGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayResult AWS API Documentation
    #
    class DeleteTransitGatewayResult < Struct.new(
      :transit_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR range for the route. This must match the CIDR for the route
    #   exactly.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteRequest AWS API Documentation
    #
    class DeleteTransitGatewayRouteRequest < Struct.new(
      :transit_gateway_route_table_id,
      :destination_cidr_block,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::TransitGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteResult AWS API Documentation
    #
    class DeleteTransitGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_announcement_id
    #   The transit gateway route table ID that's being deleted.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncementRequest AWS API Documentation
    #
    class DeleteTransitGatewayRouteTableAnnouncementRequest < Struct.new(
      :transit_gateway_route_table_announcement_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_announcement
    #   Provides details about a deleted transit gateway route table.
    #   @return [Types::TransitGatewayRouteTableAnnouncement]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncementResult AWS API Documentation
    #
    class DeleteTransitGatewayRouteTableAnnouncementResult < Struct.new(
      :transit_gateway_route_table_announcement)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableRequest AWS API Documentation
    #
    class DeleteTransitGatewayRouteTableRequest < Struct.new(
      :transit_gateway_route_table_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table
    #   Information about the deleted transit gateway route table.
    #   @return [Types::TransitGatewayRouteTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableResult AWS API Documentation
    #
    class DeleteTransitGatewayRouteTableResult < Struct.new(
      :transit_gateway_route_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachmentRequest AWS API Documentation
    #
    class DeleteTransitGatewayVpcAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_vpc_attachment
    #   Information about the deleted VPC attachment.
    #   @return [Types::TransitGatewayVpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachmentResult AWS API Documentation
    #
    class DeleteTransitGatewayVpcAttachmentResult < Struct.new(
      :transit_gateway_vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_endpoint_id
    #   The ID of the Verified Access endpoint.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpointRequest AWS API Documentation
    #
    class DeleteVerifiedAccessEndpointRequest < Struct.new(
      :verified_access_endpoint_id,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_endpoint
    #   Details about the Verified Access endpoint.
    #   @return [Types::VerifiedAccessEndpoint]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpointResult AWS API Documentation
    #
    class DeleteVerifiedAccessEndpointResult < Struct.new(
      :verified_access_endpoint)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_group_id
    #   The ID of the Verified Access group.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroupRequest AWS API Documentation
    #
    class DeleteVerifiedAccessGroupRequest < Struct.new(
      :verified_access_group_id,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_group
    #   Details about the Verified Access group.
    #   @return [Types::VerifiedAccessGroup]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroupResult AWS API Documentation
    #
    class DeleteVerifiedAccessGroupResult < Struct.new(
      :verified_access_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_instance_id
    #   The ID of the Verified Access instance.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstanceRequest AWS API Documentation
    #
    class DeleteVerifiedAccessInstanceRequest < Struct.new(
      :verified_access_instance_id,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_instance
    #   Details about the Verified Access instance.
    #   @return [Types::VerifiedAccessInstance]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstanceResult AWS API Documentation
    #
    class DeleteVerifiedAccessInstanceResult < Struct.new(
      :verified_access_instance)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_trust_provider_id
    #   The ID of the Verified Access trust provider.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   A unique, case-sensitive token that you provide to ensure
    #   idempotency of your modification request. For more information, see
    #   [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProviderRequest AWS API Documentation
    #
    class DeleteVerifiedAccessTrustProviderRequest < Struct.new(
      :verified_access_trust_provider_id,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] verified_access_trust_provider
    #   Details about the Verified Access trust provider.
    #   @return [Types::VerifiedAccessTrustProvider]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProviderResult AWS API Documentation
    #
    class DeleteVerifiedAccessTrustProviderResult < Struct.new(
      :verified_access_trust_provider)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] volume_id
    #   The ID of the volume.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolumeRequest AWS API Documentation
    #
    class DeleteVolumeRequest < Struct.new(
      :volume_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] exclusion_id
    #   The ID of the exclusion.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcBlockPublicAccessExclusionRequest AWS API Documentation
    #
    class DeleteVpcBlockPublicAccessExclusionRequest < Struct.new(
      :dry_run,
      :exclusion_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_block_public_access_exclusion
    #   Details about an exclusion.
    #   @return [Types::VpcBlockPublicAccessExclusion]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcBlockPublicAccessExclusionResult AWS API Documentation
    #
    class DeleteVpcBlockPublicAccessExclusionResult < Struct.new(
      :vpc_block_public_access_exclusion)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_encryption_control_id
    #   The ID of the VPC Encryption Control resource to delete.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEncryptionControlRequest AWS API Documentation
    #
    class DeleteVpcEncryptionControlRequest < Struct.new(
      :dry_run,
      :vpc_encryption_control_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_encryption_control
    #   Information about the deleted VPC Encryption Control configuration.
    #   @return [Types::VpcEncryptionControl]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEncryptionControlResult AWS API Documentation
    #
    class DeleteVpcEncryptionControlResult < Struct.new(
      :vpc_encryption_control)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] connection_notification_ids
    #   The IDs of the notifications.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotificationsRequest AWS API Documentation
    #
    class DeleteVpcEndpointConnectionNotificationsRequest < Struct.new(
      :dry_run,
      :connection_notification_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the notifications that could not be deleted
    #   successfully.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotificationsResult AWS API Documentation
    #
    class DeleteVpcEndpointConnectionNotificationsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_ids
    #   The IDs of the services.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurationsRequest AWS API Documentation
    #
    class DeleteVpcEndpointServiceConfigurationsRequest < Struct.new(
      :dry_run,
      :service_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the service configurations that were not deleted,
    #   if applicable.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurationsResult AWS API Documentation
    #
    class DeleteVpcEndpointServiceConfigurationsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_endpoint_ids
    #   The IDs of the VPC endpoints.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointsRequest AWS API Documentation
    #
    class DeleteVpcEndpointsRequest < Struct.new(
      :dry_run,
      :vpc_endpoint_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the VPC endpoints that were not successfully
    #   deleted.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointsResult AWS API Documentation
    #
    class DeleteVpcEndpointsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of the VPC peering connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnectionRequest AWS API Documentation
    #
    class DeleteVpcPeeringConnectionRequest < Struct.new(
      :dry_run,
      :vpc_peering_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnectionResult AWS API Documentation
    #
    class DeleteVpcPeeringConnectionResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcRequest AWS API Documentation
    #
    class DeleteVpcRequest < Struct.new(
      :vpc_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpn_concentrator_id
    #   The ID of the VPN concentrator to delete.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConcentratorRequest AWS API Documentation
    #
    class DeleteVpnConcentratorRequest < Struct.new(
      :vpn_concentrator_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConcentratorResult AWS API Documentation
    #
    class DeleteVpnConcentratorResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteVpnConnection.
    #
    # @!attribute [rw] vpn_connection_id
    #   The ID of the VPN connection.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRequest AWS API Documentation
    #
    class DeleteVpnConnectionRequest < Struct.new(
      :vpn_connection_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteVpnConnectionRoute.
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #   @return [String]
    #
    # @!attribute [rw] vpn_connection_id
    #   The ID of the VPN connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRouteRequest AWS API Documentation
    #
    class DeleteVpnConnectionRouteRequest < Struct.new(
      :destination_cidr_block,
      :vpn_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteVpnGateway.
    #
    # @!attribute [rw] vpn_gateway_id
    #   The ID of the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGatewayRequest AWS API Documentation
    #
    class DeleteVpnGatewayRequest < Struct.new(
      :vpn_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # The maximum period since deprecation for allowed images.
    #
    # @!attribute [rw] maximum_days_since_deprecated
    #   The maximum number of days that have elapsed since the image was
    #   deprecated. When set to `0`, no deprecated images are allowed.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprecationTimeCondition AWS API Documentation
    #
    class DeprecationTimeCondition < Struct.new(
      :maximum_days_since_deprecated)
      SENSITIVE = []
      include Aws::Structure
    end

    # The maximum period since deprecation for allowed images.
    #
    # @!attribute [rw] maximum_days_since_deprecated
    #   The maximum number of days that have elapsed since the image was
    #   deprecated. Set to `0` to exclude all deprecated images.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprecationTimeConditionRequest AWS API Documentation
    #
    class DeprecationTimeConditionRequest < Struct.new(
      :maximum_days_since_deprecated)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] cidr
    #   The address range, in CIDR notation. The prefix must be the same
    #   prefix that you specified when you provisioned the address range.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidrRequest AWS API Documentation
    #
    class DeprovisionByoipCidrRequest < Struct.new(
      :cidr,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoip_cidr
    #   Information about the address range.
    #   @return [Types::ByoipCidr]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidrResult AWS API Documentation
    #
    class DeprovisionByoipCidrResult < Struct.new(
      :byoip_cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_id
    #   The IPAM ID.
    #   @return [String]
    #
    # @!attribute [rw] asn
    #   An ASN.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasnRequest AWS API Documentation
    #
    class DeprovisionIpamByoasnRequest < Struct.new(
      :dry_run,
      :ipam_id,
      :asn)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoasn
    #   An ASN and BYOIP CIDR association.
    #   @return [Types::Byoasn]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasnResult AWS API Documentation
    #
    class DeprovisionIpamByoasnResult < Struct.new(
      :byoasn)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipam_pool_id
    #   The ID of the pool that has the CIDR you want to deprovision.
    #   @return [String]
    #
    # @!attribute [rw] cidr
    #   The CIDR which you want to deprovision from the pool.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidrRequest AWS API Documentation
    #
    class DeprovisionIpamPoolCidrRequest < Struct.new(
      :dry_run,
      :ipam_pool_id,
      :cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipam_pool_cidr
    #   The deprovisioned pool CIDR.
    #   @return [Types::IpamPoolCidr]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidrResult AWS API Documentation
    #
    class DeprovisionIpamPoolCidrResult < Struct.new(
      :ipam_pool_cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] pool_id
    #   The ID of the pool that you want to deprovision the CIDR from.
    #   @return [String]
    #
    # @!attribute [rw] cidr
    #   The CIDR you want to deprovision from the pool.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidrRequest AWS API Documentation
    #
    class DeprovisionPublicIpv4PoolCidrRequest < Struct.new(
      :dry_run,
      :pool_id,
      :cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] pool_id
    #   The ID of the pool that you deprovisioned the CIDR from.
    #   @return [String]
    #
    # @!attribute [rw] deprovisioned_addresses
    #   The deprovisioned CIDRs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidrResult AWS API Documentation
    #
    class DeprovisionPublicIpv4PoolCidrResult < Struct.new(
      :pool_id,
      :deprovisioned_addresses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeregisterImage.
    #
    # @!attribute [rw] image_id
    #   The ID of the AMI.
    #   @return [String]
    #
    # @!attribute [rw] delete_associated_snapshots
    #   Specifies whether to delete the snapshots associated with the AMI
    #   during deregistration.
    #
    #   <note markdown="1"> If a snapshot is associated with multiple AMIs, it is not deleted,
    #   regardless of this setting.
    #
    #    </note>
    #
    #   Default: The snapshots are not deleted.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImageRequest AWS API Documentation
    #
    class DeregisterImageRequest < Struct.new(
      :image_id,
      :delete_associated_snapshots,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @!attribute [rw] delete_snapshot_results
    #   The deletion result for each snapshot associated with the AMI,
    #   including the snapshot ID and its success or error code.
    #   @return [Array<Types::DeleteSnapshotReturnCode>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImageResult AWS API Documentation
    #
    class DeregisterImageResult < Struct.new(
      :return,
      :delete_snapshot_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_tag_attribute
    #   Information about the tag keys to deregister.
    #   @return [Types::DeregisterInstanceTagAttributeRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributesRequest AWS API Documentation
    #
    class DeregisterInstanceEventNotificationAttributesRequest < Struct.new(
      :dry_run,
      :instance_tag_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_tag_attribute
    #   The resulting set of tag keys.
    #   @return [Types::InstanceTagNotificationAttribute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributesResult AWS API Documentation
    #
    class DeregisterInstanceEventNotificationAttributesResult < Struct.new(
      :instance_tag_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the tag keys to deregister for the current Region.
    # You can either specify individual tag keys or deregister all tag keys
    # in the current Region. You must specify either
    # `IncludeAllTagsOfInstance` or `InstanceTagKeys` in the request
    #
    # @!attribute [rw] include_all_tags_of_instance
    #   Indicates whether to deregister all tag keys in the current Region.
    #   Specify `false` to deregister all tag keys.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_tag_keys
    #   Information about the tag keys to deregister.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceTagAttributeRequest AWS API Documentation
    #
    class DeregisterInstanceTagAttributeRequest < Struct.new(
      :include_all_tags_of_instance,
      :instance_tag_keys)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] group_ip_address
    #   The IP address assigned to the transit gateway multicast group.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_ids
    #   The IDs of the group members' network interfaces.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembersRequest AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupMembersRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :group_ip_address,
      :network_interface_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] deregistered_multicast_group_members
    #   Information about the deregistered members.
    #   @return [Types::TransitGatewayMulticastDeregisteredGroupMembers]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembersResult AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupMembersResult < Struct.new(
      :deregistered_multicast_group_members)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] group_ip_address
    #   The IP address assigned to the transit gateway multicast group.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_ids
    #   The IDs of the group sources' network interfaces.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSourcesRequest AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupSourcesRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :group_ip_address,
      :network_interface_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] deregistered_multicast_group_sources
    #   Information about the deregistered group sources.
    #   @return [Types::TransitGatewayMulticastDeregisteredGroupSources]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSourcesResult AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupSourcesResult < Struct.new(
      :deregistered_multicast_group_sources)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] attribute_names
    #   The account attribute names.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributesRequest AWS API Documentation
    #
    class DescribeAccountAttributesRequest < Struct.new(
      :dry_run,
      :attribute_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_attributes
    #   Information about the account attributes.
    #   @return [Array<Types::AccountAttribute>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributesResult AWS API Documentation
    #
    class DescribeAccountAttributesResult < Struct.new(
      :account_attributes)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] allocation_ids
    #   The allocation IDs of Elastic IP addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   Specify the pagination token from a previous request to retrieve the
    #   next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of address transfers to return in one page of
    #   results.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressTransfersRequest AWS API Documentation
    #
    class DescribeAddressTransfersRequest < Struct.new(
      :allocation_ids,
      :next_token,
      :max_results,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] address_transfers
    #   The Elastic IP address transfer.
    #   @return [Array<Types::AddressTransfer>]
    #
    # @!attribute [rw] next_token
    #   Specify the pagination token from a previous request to retrieve the
    #   next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressTransfersResult AWS API Documentation
    #
    class DescribeAddressTransfersResult < Struct.new(
      :address_transfers,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] allocation_ids
    #   \[EC2-VPC\] The allocation IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] attribute
    #   The attribute of the IP address.
    #   @return [String]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttributeRequest AWS API Documentation
    #
    class DescribeAddressesAttributeRequest < Struct.new(
      :allocation_ids,
      :attribute,
      :next_token,
      :max_results,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] addresses
    #   Information about the IP addresses.
    #   @return [Array<Types::AddressAttribute>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttributeResult AWS API Documentation
    #
    class DescribeAddressesAttributeResult < Struct.new(
      :addresses,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] public_ips
    #   One or more Elastic IP addresses.
    #
    #   Default: Describes all your Elastic IP addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `allocation-id` - The allocation ID for the address.
    #
    #   * `association-id` - The association ID for the address.
    #
    #   * `instance-id` - The ID of the instance the address is associated
    #     with, if any.
    #
    #   * `network-border-group` - A unique set of Availability Zones, Local
    #     Zones, or Wavelength Zones from where Amazon Web Services
    #     advertises IP addresses.
    #
    #   * `network-interface-id` - The ID of the network interface that the
    #     address is associated with, if any.
    #
    #   * `network-interface-owner-id` - The Amazon Web Services account ID
    #     of the owner.
    #
    #   * `private-ip-address` - The private IP address associated with the
    #     Elastic IP address.
    #
    #   * `public-ip` - The Elastic IP address, or the carrier IP address.
    #
    #   * `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have
    #     a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] allocation_ids
    #   Information about the allocation IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesRequest AWS API Documentation
    #
    class DescribeAddressesRequest < Struct.new(
      :public_ips,
      :dry_run,
      :filters,
      :allocation_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] addresses
    #   Information about the Elastic IP addresses.
    #   @return [Array<Types::Address>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesResult AWS API Documentation
    #
    class DescribeAddressesResult < Struct.new(
      :addresses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormatRequest AWS API Documentation
    #
    class DescribeAggregateIdFormatRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] use_long_ids_aggregated
    #   Indicates whether all resource types in the Region are configured to
    #   use longer IDs. This value is only `true` if all users are
    #   configured to use longer IDs for all resources types in the Region.
    #   @return [Boolean]
    #
    # @!attribute [rw] statuses
    #   Information about each resource's ID format.
    #   @return [Array<Types::IdFormat>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormatResult AWS API Documentation
    #
    class DescribeAggregateIdFormatResult < Struct.new(
      :use_long_ids_aggregated,
      :statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] zone_names
    #   The names of the Availability Zones, Local Zones, and Wavelength
    #   Zones.
    #   @return [Array<String>]
    #
    # @!attribute [rw] zone_ids
    #   The IDs of the Availability Zones, Local Zones, and Wavelength
    #   Zones.
    #   @return [Array<String>]
    #
    # @!attribute [rw] all_availability_zones
    #   Include all Availability Zones, Local Zones, and Wavelength Zones
    #   regardless of your opt-in status.
    #
    #   If you do not use this parameter, the results include only the zones
    #   for the Regions where you have chosen the option to opt in.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `group-long-name` - The long name of the zone group for the
    #     Availability Zone (for example, `US West (Oregon) 1`), the Local
    #     Zone (for example, for Zone group `us-west-2-lax-1`, it is `US
    #     West (Los Angeles)`, or the Wavelength Zone (for example, for Zone
    #     group `us-east-1-wl1`, it is `US East (Verizon)`.
    #
    #   * `group-name` - The name of the zone group for the Availability
    #     Zone (for example, `us-east-1-zg-1`), the Local Zone (for example,
    #     `us-west-2-lax-1`), or the Wavelength Zone (for example,
    #     `us-east-1-wl1`).
    #
    #   * `message` - The Zone message.
    #
    #   * `opt-in-status` - The opt-in status (`opted-in` \| `not-opted-in`
    #     \| `opt-in-not-required`).
    #
    #   * `parent-zone-id` - The ID of the zone that handles some of the
    #     Local Zone and Wavelength Zone control plane operations, such as
    #     API calls.
    #
    #   * `parent-zone-name` - The ID of the zone that handles some of the
    #     Local Zone and Wavelength Zone control plane operations, such as
    #     API calls.
    #
    #   * `region-name` - The name of the Region for the Zone (for example,
    #     `us-east-1`).
    #
    #   * `state` - The state of the Availability Zone, the Local Zone, or
    #     the Wavelength Zone (`available` \| `unavailable` \|
    #     `constrained`).
    #
    #   * `zone-id` - The ID of the Availability Zone (for example,
    #     `use1-az1`), the Local Zone (for example, `usw2-lax1-az1`), or the
    #     Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `zone-name` - The name of the Availability Zone (for example,
    #     `us-east-1a`), the Local Zone (for example, `us-west-2-lax-1a`),
    #     or the Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `zone-type` - The type of zone (`availability-zone` \|
    #     `local-zone` \| `wavelength-zone`).
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZonesRequest AWS API Documentation
    #
    class DescribeAvailabilityZonesRequest < Struct.new(
      :zone_names,
      :zone_ids,
      :all_availability_zones,
      :dry_run,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] availability_zones
    #   Information about the Availability Zones, Local Zones, and
    #   Wavelength Zones.
    #   @return [Array<Types::AvailabilityZone>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZonesResult AWS API Documentation
    #
    class DescribeAvailabilityZonesResult < Struct.new(
      :availability_zones)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAwsNetworkPerformanceMetricSubscriptionsRequest AWS API Documentation
    #
    class DescribeAwsNetworkPerformanceMetricSubscriptionsRequest < Struct.new(
      :max_results,
      :next_token,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] subscriptions
    #   Describes the current Infrastructure Performance subscriptions.
    #   @return [Array<Types::Subscription>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAwsNetworkPerformanceMetricSubscriptionsResult AWS API Documentation
    #
    class DescribeAwsNetworkPerformanceMetricSubscriptionsResult < Struct.new(
      :next_token,
      :subscriptions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] bundle_ids
    #   The bundle task IDs.
    #
    #   Default: Describes all your bundle tasks.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `bundle-id` - The ID of the bundle task.
    #
    #   * `error-code` - If the task failed, the error code returned.
    #
    #   * `error-message` - If the task failed, the error message returned.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `progress` - The level of task completion, as a percentage (for
    #     example, 20%).
    #
    #   * `s3-bucket` - The Amazon S3 bucket to store the AMI.
    #
    #   * `s3-prefix` - The beginning of the AMI name.
    #
    #   * `start-time` - The time the task started (for example,
    #     2013-09-15T17:15:20.000Z).
    #
    #   * `state` - The state of the task (`pending` \|
    #     `waiting-for-shutdown` \| `bundling` \| `storing` \| `cancelling`
    #     \| `complete` \| `failed`).
    #
    #   * `update-time` - The time of the most recent update for the task.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasksRequest AWS API Documentation
    #
    class DescribeBundleTasksRequest < Struct.new(
      :bundle_ids,
      :dry_run,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] bundle_tasks
    #   Information about the bundle tasks.
    #   @return [Array<Types::BundleTask>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasksResult AWS API Documentation
    #
    class DescribeBundleTasksResult < Struct.new(
      :bundle_tasks)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrsRequest AWS API Documentation
    #
    class DescribeByoipCidrsRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoip_cidrs
    #   Information about your address ranges.
    #   @return [Array<Types::ByoipCidr>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrsResult AWS API Documentation
    #
    class DescribeByoipCidrsResult < Struct.new(
      :byoip_cidrs,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_ids
    #   The IDs of Capacity Block reservations that you want to display the
    #   history for.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters
    #
    #   * `availability-zone` - The Availability Zone of the extension.
    #
    #   * `availability-zone-id` - The Availability Zone ID of the
    #     extension.
    #
    #   * `capacity-block-extension-offering-id` - The ID of the extension
    #     offering.
    #
    #   * `capacity-block-extension-status` - The status of the extension
    #     (`payment-pending` \| `payment-failed` \| `payment-succeeded`).
    #
    #   * `capacity-reservation-id` - The reservation ID of the extension.
    #
    #   * `instance-type` - The instance type of the extension.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockExtensionHistoryRequest AWS API Documentation
    #
    class DescribeCapacityBlockExtensionHistoryRequest < Struct.new(
      :capacity_reservation_ids,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_block_extensions
    #   Describes one or more of your Capacity Block extensions. The results
    #   describe only the Capacity Block extensions in the Amazon Web
    #   Services Region that you're currently using.
    #   @return [Array<Types::CapacityBlockExtension>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockExtensionHistoryResult AWS API Documentation
    #
    class DescribeCapacityBlockExtensionHistoryResult < Struct.new(
      :capacity_block_extensions,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] capacity_block_extension_duration_hours
    #   The duration of the Capacity Block extension offering in hours.
    #   @return [Integer]
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity reservation to be extended.
    #   @return [String]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockExtensionOfferingsRequest AWS API Documentation
    #
    class DescribeCapacityBlockExtensionOfferingsRequest < Struct.new(
      :dry_run,
      :capacity_block_extension_duration_hours,
      :capacity_reservation_id,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_block_extension_offerings
    #   The recommended Capacity Block extension offerings for the dates
    #   specified.
    #   @return [Array<Types::CapacityBlockExtensionOffering>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockExtensionOfferingsResult AWS API Documentation
    #
    class DescribeCapacityBlockExtensionOfferingsResult < Struct.new(
      :capacity_block_extension_offerings,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_type
    #   The type of instance for which the Capacity Block offering reserves
    #   capacity.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances for which to reserve capacity. Each Capacity
    #   Block can have up to 64 instances, and you can have up to 256
    #   instances across Capacity Blocks.
    #   @return [Integer]
    #
    # @!attribute [rw] start_date_range
    #   The earliest start date for the Capacity Block offering.
    #   @return [Time]
    #
    # @!attribute [rw] end_date_range
    #   The latest end date for the Capacity Block offering.
    #   @return [Time]
    #
    # @!attribute [rw] capacity_duration_hours
    #   The reservation duration for the Capacity Block, in hours. You must
    #   specify the duration in 1-day increments up 14 days, and in 7-day
    #   increments up to 182 days.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] ultraserver_type
    #   The EC2 UltraServer type of the Capacity Block offerings.
    #   @return [String]
    #
    # @!attribute [rw] ultraserver_count
    #   The number of EC2 UltraServers in the offerings.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockOfferingsRequest AWS API Documentation
    #
    class DescribeCapacityBlockOfferingsRequest < Struct.new(
      :dry_run,
      :instance_type,
      :instance_count,
      :start_date_range,
      :end_date_range,
      :capacity_duration_hours,
      :next_token,
      :max_results,
      :ultraserver_type,
      :ultraserver_count)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_block_offerings
    #   The recommended Capacity Block offering for the dates specified.
    #   @return [Array<Types::CapacityBlockOffering>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockOfferingsResult AWS API Documentation
    #
    class DescribeCapacityBlockOfferingsResult < Struct.new(
      :capacity_block_offerings,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_block_ids
    #   The ID of the Capacity Block.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `interconnect-status` - The status of the interconnect for the
    #     Capacity Block (`ok` \| `impaired` \| `insufficient-data`).
    #
    #   ^
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockStatusRequest AWS API Documentation
    #
    class DescribeCapacityBlockStatusRequest < Struct.new(
      :capacity_block_ids,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_block_statuses
    #   The availability of capacity for a Capacity Block.
    #   @return [Array<Types::CapacityBlockStatus>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockStatusResult AWS API Documentation
    #
    class DescribeCapacityBlockStatusResult < Struct.new(
      :capacity_block_statuses,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_block_ids
    #   The IDs of the Capacity Blocks.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `capacity-block-id` - The ID of the Capacity Block.
    #
    #   * `ultraserver-type` - The Capacity Block type. The type can be
    #     `instances` or `ultraservers`.
    #
    #   * `availability-zone` - The Availability Zone of the Capacity Block.
    #
    #   * `start-date` - The date and time at which the Capacity Block was
    #     started.
    #
    #   * `end-date` - The date and time at which the Capacity Block
    #     expires. When a Capacity Block expires, all instances in the
    #     Capacity Block are terminated.
    #
    #   * `create-date` - The date and time at which the Capacity Block was
    #     created.
    #
    #   * `state` - The state of the Capacity Block (`active` \| `expired`
    #     \| `unavailable` \| `cancelled` \| `failed` \| `scheduled` \|
    #     `payment-pending` \| `payment-failed`).
    #
    #   * `tags` - The tags assigned to the Capacity Block.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlocksRequest AWS API Documentation
    #
    class DescribeCapacityBlocksRequest < Struct.new(
      :capacity_block_ids,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_blocks
    #   The Capacity Blocks.
    #   @return [Array<Types::CapacityBlock>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlocksResult AWS API Documentation
    #
    class DescribeCapacityBlocksResult < Struct.new(
      :capacity_blocks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_manager_data_export_ids
    #   The IDs of the data export configurations to describe. If not
    #   specified, all export configurations are returned.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. If not
    #   specified, up to 1000 results are returned.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results. Use this value in a
    #   subsequent call to retrieve additional results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters to narrow the results. Supported filters include
    #   export status, creation date, and S3 bucket name.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityManagerDataExportsRequest AWS API Documentation
    #
    class DescribeCapacityManagerDataExportsRequest < Struct.new(
      :capacity_manager_data_export_ids,
      :max_results,
      :next_token,
      :dry_run,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_manager_data_exports
    #   Information about the data export configurations, including export
    #   settings, delivery status, and recent activity.
    #   @return [Array<Types::CapacityManagerDataExportResponse>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   null when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityManagerDataExportsResult AWS API Documentation
    #
    class DescribeCapacityManagerDataExportsResult < Struct.new(
      :capacity_manager_data_exports,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_ids
    #   The ID of the Capacity Reservation.
    #   @return [Array<String>]
    #
    # @!attribute [rw] role
    #   Specify one of the following:
    #
    #   * `odcr-owner` - If you are the Capacity Reservation owner, specify
    #     this value to view requests that you have initiated. Not supported
    #     with the `requested-by` filter.
    #
    #   * `unused-reservation-billing-owner` - If you are the consumer
    #     account, specify this value to view requests that have been sent
    #     to you. Not supported with the `unused-reservation-billing-owner`
    #     filter.
    #   @return [String]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `status` - The state of the request (`pending` \| `accepted` \|
    #     `rejected` \| `cancelled` \| `revoked` \| `expired`).
    #
    #   * `requested-by` - The account ID of the Capacity Reservation owner
    #     that initiated the request. Not supported if you specify
    #     `requested-by` for **Role**.
    #
    #   * `unused-reservation-billing-owner` - The ID of the consumer
    #     account to which the request was sent. Not supported if you
    #     specify `unused-reservation-billing-owner` for **Role**.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationBillingRequestsRequest AWS API Documentation
    #
    class DescribeCapacityReservationBillingRequestsRequest < Struct.new(
      :capacity_reservation_ids,
      :role,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_billing_requests
    #   Information about the request.
    #   @return [Array<Types::CapacityReservationBillingRequest>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationBillingRequestsResult AWS API Documentation
    #
    class DescribeCapacityReservationBillingRequestsResult < Struct.new(
      :next_token,
      :capacity_reservation_billing_requests)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_fleet_ids
    #   The IDs of the Capacity Reservation Fleets to describe.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `state` - The state of the Fleet (`submitted` \| `modifying` \|
    #     `active` \| `partially_fulfilled` \| `expiring` \| `expired` \|
    #     `cancelling` \| `cancelled` \| `failed`).
    #
    #   * `instance-match-criteria` - The instance matching criteria for the
    #     Fleet. Only `open` is supported.
    #
    #   * `tenancy` - The tenancy of the Fleet (`default` \| `dedicated`).
    #
    #   * `allocation-strategy` - The allocation strategy used by the Fleet.
    #     Only `prioritized` is supported.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleetsRequest AWS API Documentation
    #
    class DescribeCapacityReservationFleetsRequest < Struct.new(
      :capacity_reservation_fleet_ids,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_fleets
    #   Information about the Capacity Reservation Fleets.
    #   @return [Array<Types::CapacityReservationFleet>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleetsResult AWS API Documentation
    #
    class DescribeCapacityReservationFleetsResult < Struct.new(
      :capacity_reservation_fleets,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #   You can't specify this parameter and the Capacity Reservation IDs
    #   parameter in the same request.
    #
    #   Default: `10`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] capacity_reservation_ids
    #   The Capacity Reservation IDs.
    #
    #   Default: Describes all your Capacity Reservations.
    #
    #   Constraints: Maximum 100 explicitly specified Capacity Reservation
    #   IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The name of the Availability Zone (for
    #     example, `us-west-2a`) or Local Zone (for example,
    #     `us-west-2-lax-1b`) that the Capacity Reservation is in.
    #
    #   * `instance-type` - The instance type (for example, `p4d.24xlarge`)
    #     or instance family (for example, `p4d*`). You can use the `*`
    #     wildcard to match zero or more characters, or the `?` wildcard to
    #     match zero or one character.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationTopologyRequest AWS API Documentation
    #
    class DescribeCapacityReservationTopologyRequest < Struct.new(
      :dry_run,
      :next_token,
      :max_results,
      :capacity_reservation_ids,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservations
    #   Information about the topology of each Capacity Reservation.
    #   @return [Array<Types::CapacityReservationTopology>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationTopologyResult AWS API Documentation
    #
    class DescribeCapacityReservationTopologyResult < Struct.new(
      :next_token,
      :capacity_reservations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation_ids
    #   The ID of the Capacity Reservation.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `instance-type` - The type of instance for which the Capacity
    #     Reservation reserves capacity.
    #
    #   * `owner-id` - The ID of the Amazon Web Services account that owns
    #     the Capacity Reservation.
    #
    #   * `instance-platform` - The type of operating system for which the
    #     Capacity Reservation reserves capacity.
    #
    #   * `availability-zone` - The Availability Zone of the Capacity
    #     Reservation.
    #
    #   * `tenancy` - Indicates the tenancy of the Capacity Reservation. A
    #     Capacity Reservation can have one of the following tenancy
    #     settings:
    #
    #     * `default` - The Capacity Reservation is created on hardware that
    #       is shared with other Amazon Web Services accounts.
    #
    #     * `dedicated` - The Capacity Reservation is created on
    #       single-tenant hardware that is dedicated to a single Amazon Web
    #       Services account.
    #   * `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost on
    #     which the Capacity Reservation was created.
    #
    #   * `state` - The current state of the Capacity Reservation. A
    #     Capacity Reservation can be in one of the following states:
    #
    #     * `active`- The Capacity Reservation is active and the capacity is
    #       available for your use.
    #
    #     * `expired` - The Capacity Reservation expired automatically at
    #       the date and time specified in your request. The reserved
    #       capacity is no longer available for your use.
    #
    #     * `cancelled` - The Capacity Reservation was cancelled. The
    #       reserved capacity is no longer available for your use.
    #
    #     * `pending` - The Capacity Reservation request was successful but
    #       the capacity provisioning is still pending.
    #
    #     * `failed` - The Capacity Reservation request has failed. A
    #       request might fail due to invalid request parameters, capacity
    #       constraints, or instance limit constraints. Failed requests are
    #       retained for 60 minutes.
    #   * `start-date` - The date and time at which the Capacity Reservation
    #     was started.
    #
    #   * `end-date` - The date and time at which the Capacity Reservation
    #     expires. When a Capacity Reservation expires, the reserved
    #     capacity is released and you can no longer launch instances into
    #     it. The Capacity Reservation's state changes to expired when it
    #     reaches its end date and time.
    #
    #   * `end-date-type` - Indicates the way in which the Capacity
    #     Reservation ends. A Capacity Reservation can have one of the
    #     following end types:
    #
    #     * `unlimited` - The Capacity Reservation remains active until you
    #       explicitly cancel it.
    #
    #     * `limited` - The Capacity Reservation expires automatically at a
    #       specified date and time.
    #   * `instance-match-criteria` - Indicates the type of instance
    #     launches that the Capacity Reservation accepts. The options
    #     include:
    #
    #     * `open` - The Capacity Reservation accepts all instances that
    #       have matching attributes (instance type, platform, and
    #       Availability Zone). Instances that have matching attributes
    #       launch into the Capacity Reservation automatically without
    #       specifying any additional parameters.
    #
    #     * `targeted` - The Capacity Reservation only accepts instances
    #       that have matching attributes (instance type, platform, and
    #       Availability Zone), and explicitly target the Capacity
    #       Reservation. This ensures that only permitted instances can use
    #       the reserved capacity.
    #   * `placement-group-arn` - The ARN of the cluster placement group in
    #     which the Capacity Reservation was created.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationsRequest AWS API Documentation
    #
    class DescribeCapacityReservationsRequest < Struct.new(
      :capacity_reservation_ids,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservations
    #   Information about the Capacity Reservations.
    #   @return [Array<Types::CapacityReservation>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationsResult AWS API Documentation
    #
    class DescribeCapacityReservationsResult < Struct.new(
      :next_token,
      :capacity_reservations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateway_ids
    #   One or more carrier gateway IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `carrier-gateway-id` - The ID of the carrier gateway.
    #
    #   * `state` - The state of the carrier gateway (`pending` \| `failed`
    #     \| `available` \| `deleting` \| `deleted`).
    #
    #   * `owner-id` - The Amazon Web Services account ID of the owner of
    #     the carrier gateway.
    #
    #   * `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have
    #     a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC associated with the carrier gateway.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGatewaysRequest AWS API Documentation
    #
    class DescribeCarrierGatewaysRequest < Struct.new(
      :carrier_gateway_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateways
    #   Information about the carrier gateway.
    #   @return [Array<Types::CarrierGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGatewaysResult AWS API Documentation
    #
    class DescribeCarrierGatewaysResult < Struct.new(
      :carrier_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_ids
    #   The instance IDs. Must be instances linked to a VPC through
    #   ClassicLink.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `group-id` - The ID of a VPC security group that's associated
    #     with the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `tag` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC to which the instance is linked.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #   Constraint: If the value is greater than 1000, we return only 1000
    #   items.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstancesRequest AWS API Documentation
    #
    class DescribeClassicLinkInstancesRequest < Struct.new(
      :dry_run,
      :instance_ids,
      :filters,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instances
    #   Information about one or more linked EC2-Classic instances.
    #   @return [Array<Types::ClassicLinkInstance>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstancesResult AWS API Documentation
    #
    class DescribeClassicLinkInstancesResult < Struct.new(
      :instances,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `description` - The description of the authorization rule.
    #
    #   * `destination-cidr` - The CIDR of the network to which the
    #     authorization rule applies.
    #
    #   * `group-id` - The ID of the Active Directory group to which the
    #     authorization rule grants access.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRulesRequest AWS API Documentation
    #
    class DescribeClientVpnAuthorizationRulesRequest < Struct.new(
      :client_vpn_endpoint_id,
      :dry_run,
      :next_token,
      :filters,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] authorization_rules
    #   Information about the authorization rules.
    #   @return [Array<Types::AuthorizationRule>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRulesResult AWS API Documentation
    #
    class DescribeClientVpnAuthorizationRulesResult < Struct.new(
      :authorization_rules,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `connection-id` - The ID of the connection.
    #
    #   * `username` - For Active Directory client authentication, the user
    #     name of the client who established the client connection.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnectionsRequest AWS API Documentation
    #
    class DescribeClientVpnConnectionsRequest < Struct.new(
      :client_vpn_endpoint_id,
      :filters,
      :next_token,
      :max_results,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] connections
    #   Information about the active and terminated client connections.
    #   @return [Array<Types::ClientVpnConnection>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnectionsResult AWS API Documentation
    #
    class DescribeClientVpnConnectionsResult < Struct.new(
      :connections,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_ids
    #   The ID of the Client VPN endpoint.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `endpoint-id` - The ID of the Client VPN endpoint.
    #
    #   * `transport-protocol` - The transport protocol (`tcp` \| `udp`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpointsRequest AWS API Documentation
    #
    class DescribeClientVpnEndpointsRequest < Struct.new(
      :client_vpn_endpoint_ids,
      :max_results,
      :next_token,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoints
    #   Information about the Client VPN endpoints.
    #   @return [Array<Types::ClientVpnEndpoint>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpointsResult AWS API Documentation
    #
    class DescribeClientVpnEndpointsResult < Struct.new(
      :client_vpn_endpoints,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `destination-cidr` - The CIDR of the route destination.
    #
    #   * `origin` - How the route was associated with the Client VPN
    #     endpoint (`associate` \| `add-route`).
    #
    #   * `target-subnet` - The ID of the subnet through which traffic is
    #     routed.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutesRequest AWS API Documentation
    #
    class DescribeClientVpnRoutesRequest < Struct.new(
      :client_vpn_endpoint_id,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] routes
    #   Information about the Client VPN endpoint routes.
    #   @return [Array<Types::ClientVpnRoute>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutesResult AWS API Documentation
    #
    class DescribeClientVpnRoutesResult < Struct.new(
      :routes,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] association_ids
    #   The IDs of the target network associations.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `association-id` - The ID of the association.
    #
    #   * `target-network-id` - The ID of the subnet specified as the target
    #     network.
    #
    #   * `vpc-id` - The ID of the VPC in which the target network is
    #     located.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworksRequest AWS API Documentation
    #
    class DescribeClientVpnTargetNetworksRequest < Struct.new(
      :client_vpn_endpoint_id,
      :association_ids,
      :max_results,
      :next_token,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_target_networks
    #   Information about the associated target networks.
    #   @return [Array<Types::TargetNetwork>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworksResult AWS API Documentation
    #
    class DescribeClientVpnTargetNetworksResult < Struct.new(
      :client_vpn_target_networks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] pool_ids
    #   The IDs of the address pools.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `coip-pool.local-gateway-route-table-id` - The ID of the local
    #     gateway route table.
    #
    #   * `coip-pool.pool-id` - The ID of the address pool.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPoolsRequest AWS API Documentation
    #
    class DescribeCoipPoolsRequest < Struct.new(
      :pool_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] coip_pools
    #   Information about the address pools.
    #   @return [Array<Types::CoipPool>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPoolsResult AWS API Documentation
    #
    class DescribeCoipPoolsResult < Struct.new(
      :coip_pools,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] conversion_task_ids
    #   The conversion task IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasksRequest AWS API Documentation
    #
    class DescribeConversionTasksRequest < Struct.new(
      :dry_run,
      :conversion_task_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] conversion_tasks
    #   Information about the conversion tasks.
    #   @return [Array<Types::ConversionTask>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasksResult AWS API Documentation
    #
    class DescribeConversionTasksResult < Struct.new(
      :conversion_tasks)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeCustomerGateways.
    #
    # @!attribute [rw] customer_gateway_ids
    #   One or more customer gateway IDs.
    #
    #   Default: Describes all your customer gateways.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `bgp-asn` - The customer gateway's Border Gateway Protocol (BGP)
    #     Autonomous System Number (ASN).
    #
    #   * `customer-gateway-id` - The ID of the customer gateway.
    #
    #   * `ip-address` - The IP address of the customer gateway device's
    #     external interface.
    #
    #   * `state` - The state of the customer gateway (`pending` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `type` - The type of customer gateway. Currently, the only
    #     supported type is `ipsec.1`.
    #
    #   * `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have
    #     a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGatewaysRequest AWS API Documentation
    #
    class DescribeCustomerGatewaysRequest < Struct.new(
      :customer_gateway_ids,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeCustomerGateways.
    #
    # @!attribute [rw] customer_gateways
    #   Information about one or more customer gateways.
    #   @return [Array<Types::CustomerGateway>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGatewaysResult AWS API Documentation
    #
    class DescribeCustomerGatewaysResult < Struct.new(
      :customer_gateways)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] report_ids
    #   One or more report IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDeclarativePoliciesReportsRequest AWS API Documentation
    #
    class DescribeDeclarativePoliciesReportsRequest < Struct.new(
      :dry_run,
      :next_token,
      :max_results,
      :report_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] reports
    #   The report metadata.
    #   @return [Array<Types::DeclarativePoliciesReport>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDeclarativePoliciesReportsResult AWS API Documentation
    #
    class DescribeDeclarativePoliciesReportsResult < Struct.new(
      :next_token,
      :reports)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dhcp_options_ids
    #   The IDs of DHCP option sets.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `dhcp-options-id` - The ID of a DHCP options set.
    #
    #   * `key` - The key for one of the options (for example,
    #     `domain-name`).
    #
    #   * `value` - The value for one of the options.
    #
    #   * `owner-id` - The ID of the Amazon Web Services account that owns
    #     the DHCP options set.
    #
    #   * `tag` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptionsRequest AWS API Documentation
    #
    class DescribeDhcpOptionsRequest < Struct.new(
      :dhcp_options_ids,
      :next_token,
      :max_results,
      :dry_run,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] dhcp_options
    #   Information about the DHCP options sets.
    #   @return [Array<Types::DhcpOptions>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptionsResult AWS API Documentation
    #
    class DescribeDhcpOptionsResult < Struct.new(
      :next_token,
      :dhcp_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] egress_only_internet_gateway_ids
    #   The IDs of the egress-only internet gateways.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `tag` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGatewaysRequest AWS API Documentation
    #
    class DescribeEgressOnlyInternetGatewaysRequest < Struct.new(
      :dry_run,
      :egress_only_internet_gateway_ids,
      :max_results,
      :next_token,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] egress_only_internet_gateways
    #   Information about the egress-only internet gateways.
    #   @return [Array<Types::EgressOnlyInternetGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGatewaysResult AWS API Documentation
    #
    class DescribeEgressOnlyInternetGatewaysResult < Struct.new(
      :egress_only_internet_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] elastic_gpu_ids
    #   The Elastic Graphics accelerator IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone in which the Elastic
    #     Graphics accelerator resides.
    #
    #   * `elastic-gpu-health` - The status of the Elastic Graphics
    #     accelerator (`OK` \| `IMPAIRED`).
    #
    #   * `elastic-gpu-state` - The state of the Elastic Graphics
    #     accelerator (`ATTACHED`).
    #
    #   * `elastic-gpu-type` - The type of Elastic Graphics accelerator; for
    #     example, `eg1.medium`.
    #
    #   * `instance-id` - The ID of the instance to which the Elastic
    #     Graphics accelerator is associated.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 5 and 1000.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpusRequest AWS API Documentation
    #
    class DescribeElasticGpusRequest < Struct.new(
      :elastic_gpu_ids,
      :dry_run,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] elastic_gpu_set
    #   Information about the Elastic Graphics accelerators.
    #   @return [Array<Types::ElasticGpus>]
    #
    # @!attribute [rw] max_results
    #   The total number of items to return. If the total number of items
    #   available is more than the value specified in max-items then a
    #   Next-Token will be provided in the output that you can use to resume
    #   pagination.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpusResult AWS API Documentation
    #
    class DescribeElasticGpusResult < Struct.new(
      :elastic_gpu_set,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] export_image_task_ids
    #   The IDs of the export image tasks.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A token that indicates the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasksRequest AWS API Documentation
    #
    class DescribeExportImageTasksRequest < Struct.new(
      :dry_run,
      :filters,
      :export_image_task_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] export_image_tasks
    #   Information about the export image tasks.
    #   @return [Array<Types::ExportImageTask>]
    #
    # @!attribute [rw] next_token
    #   The token to use to get the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasksResult AWS API Documentation
    #
    class DescribeExportImageTasksResult < Struct.new(
      :export_image_tasks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] filters
    #   the filters for the export tasks.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] export_task_ids
    #   The export task IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasksRequest AWS API Documentation
    #
    class DescribeExportTasksRequest < Struct.new(
      :filters,
      :export_task_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] export_tasks
    #   Information about the export tasks.
    #   @return [Array<Types::ExportTask>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasksResult AWS API Documentation
    #
    class DescribeExportTasksResult < Struct.new(
      :export_tasks)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_ids
    #   Specify one or more Windows AMI image IDs for the request.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   Use the following filters to streamline results.
    #
    #   * `resource-type` - The resource type for pre-provisioning.
    #
    #   * `owner-id` - The owner ID for the pre-provisioning resource.
    #
    #   * `state` - The current state of fast launching for the Windows AMI.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastLaunchImagesRequest AWS API Documentation
    #
    class DescribeFastLaunchImagesRequest < Struct.new(
      :image_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fast_launch_images
    #   A collection of details about the fast-launch enabled Windows images
    #   that meet the requested criteria.
    #   @return [Array<Types::DescribeFastLaunchImagesSuccessItem>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastLaunchImagesResult AWS API Documentation
    #
    class DescribeFastLaunchImagesResult < Struct.new(
      :fast_launch_images,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describe details about a Windows image with Windows fast launch
    # enabled that meets the requested criteria. Criteria are defined by the
    # `DescribeFastLaunchImages` action filters.
    #
    # @!attribute [rw] image_id
    #   The image ID that identifies the Windows fast launch enabled image.
    #   @return [String]
    #
    # @!attribute [rw] resource_type
    #   The resource type that Amazon EC2 uses for pre-provisioning the
    #   Windows AMI. Supported values include: `snapshot`.
    #   @return [String]
    #
    # @!attribute [rw] snapshot_configuration
    #   A group of parameters that are used for pre-provisioning the
    #   associated Windows AMI using snapshots.
    #   @return [Types::FastLaunchSnapshotConfigurationResponse]
    #
    # @!attribute [rw] launch_template
    #   The launch template that the Windows fast launch enabled AMI uses
    #   when it launches Windows instances from pre-provisioned snapshots.
    #   @return [Types::FastLaunchLaunchTemplateSpecificationResponse]
    #
    # @!attribute [rw] max_parallel_launches
    #   The maximum number of instances that Amazon EC2 can launch at the
    #   same time to create pre-provisioned snapshots for Windows fast
    #   launch.
    #   @return [Integer]
    #
    # @!attribute [rw] owner_id
    #   The owner ID for the Windows fast launch enabled AMI.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The current state of Windows fast launch for the specified Windows
    #   AMI.
    #   @return [String]
    #
    # @!attribute [rw] state_transition_reason
    #   The reason that Windows fast launch for the AMI changed to the
    #   current state.
    #   @return [String]
    #
    # @!attribute [rw] state_transition_time
    #   The time that Windows fast launch for the AMI changed to the current
    #   state.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastLaunchImagesSuccessItem AWS API Documentation
    #
    class DescribeFastLaunchImagesSuccessItem < Struct.new(
      :image_id,
      :resource_type,
      :snapshot_configuration,
      :launch_template,
      :max_parallel_launches,
      :owner_id,
      :state,
      :state_transition_reason,
      :state_transition_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes fast snapshot restores for a snapshot.
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of fast snapshot restores.
    #   @return [String]
    #
    # @!attribute [rw] state_transition_reason
    #   The reason for the state transition. The possible values are as
    #   follows:
    #
    #   * `Client.UserInitiated` - The state successfully transitioned to
    #     `enabling` or `disabling`.
    #
    #   * `Client.UserInitiated - Lifecycle state transition` - The state
    #     successfully transitioned to `optimizing`, `enabled`, or
    #     `disabled`.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the Amazon Web Services account that enabled fast snapshot
    #   restores on the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] owner_alias
    #   The Amazon Web Services owner alias that enabled fast snapshot
    #   restores on the snapshot. This is intended for future use.
    #   @return [String]
    #
    # @!attribute [rw] enabling_time
    #   The time at which fast snapshot restores entered the `enabling`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] optimizing_time
    #   The time at which fast snapshot restores entered the `optimizing`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] enabled_time
    #   The time at which fast snapshot restores entered the `enabled`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] disabling_time
    #   The time at which fast snapshot restores entered the `disabling`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] disabled_time
    #   The time at which fast snapshot restores entered the `disabled`
    #   state.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestoreSuccessItem AWS API Documentation
    #
    class DescribeFastSnapshotRestoreSuccessItem < Struct.new(
      :snapshot_id,
      :availability_zone,
      :availability_zone_id,
      :state,
      :state_transition_reason,
      :owner_id,
      :owner_alias,
      :enabling_time,
      :optimizing_time,
      :enabled_time,
      :disabling_time,
      :disabled_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] filters
    #   The filters. The possible values are:
    #
    #   * `availability-zone`: The Availability Zone of the snapshot. For
    #     example, `us-east-2a`.
    #
    #   * `availability-zone-id`: The ID of the Availability Zone of the
    #     snapshot. For example, `use2-az1`.
    #
    #   * `owner-id`: The ID of the Amazon Web Services account that enabled
    #     fast snapshot restore on the snapshot.
    #
    #   * `snapshot-id`: The ID of the snapshot.
    #
    #   * `state`: The state of fast snapshot restores for the snapshot
    #     (`enabling` \| `optimizing` \| `enabled` \| `disabling` \|
    #     `disabled`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestoresRequest AWS API Documentation
    #
    class DescribeFastSnapshotRestoresRequest < Struct.new(
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fast_snapshot_restores
    #   Information about the state of fast snapshot restores.
    #   @return [Array<Types::DescribeFastSnapshotRestoreSuccessItem>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestoresResult AWS API Documentation
    #
    class DescribeFastSnapshotRestoresResult < Struct.new(
      :fast_snapshot_restores,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that could not be launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that could not be launched was a Spot
    #   Instance or On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] error_code
    #   The error code that indicates why the instance could not be
    #   launched. For more information about error codes, see [Error
    #   codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html
    #   @return [String]
    #
    # @!attribute [rw] error_message
    #   The error message that describes why the instance could not be
    #   launched. For more information about error messages, see [Error
    #   codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetError AWS API Documentation
    #
    class DescribeFleetError < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :error_code,
      :error_message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] event_type
    #   The type of events to describe. By default, all events are
    #   described.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The start date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistoryRequest AWS API Documentation
    #
    class DescribeFleetHistoryRequest < Struct.new(
      :dry_run,
      :event_type,
      :max_results,
      :next_token,
      :fleet_id,
      :start_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] history_records
    #   Information about the events in the history of the EC2 Fleet.
    #   @return [Array<Types::HistoryRecordEntry>]
    #
    # @!attribute [rw] last_evaluated_time
    #   The last date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). All records up to this time were
    #   retrieved.
    #
    #   If `nextToken` indicates that there are more items, this value is
    #   not present.
    #   @return [Time]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC Fleet.
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The start date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistoryResult AWS API Documentation
    #
    class DescribeFleetHistoryResult < Struct.new(
      :history_records,
      :last_evaluated_time,
      :next_token,
      :fleet_id,
      :start_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `instance-type` - The instance type.
    #
    #   ^
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstancesRequest AWS API Documentation
    #
    class DescribeFleetInstancesRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :fleet_id,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] active_instances
    #   The running instances. This list is refreshed periodically and might
    #   be out of date.
    #   @return [Array<Types::ActiveInstance>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstancesResult AWS API Documentation
    #
    class DescribeFleetInstancesResult < Struct.new(
      :active_instances,
      :next_token,
      :fleet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that were launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that was launched is a Spot Instance or
    #   On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_ids
    #   The IDs of the instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] instance_type
    #   The instance type.
    #   @return [String]
    #
    # @!attribute [rw] platform
    #   The value is `windows` for Windows instances in an EC2 Fleet.
    #   Otherwise, the value is blank.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetsInstances AWS API Documentation
    #
    class DescribeFleetsInstances < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :instance_ids,
      :instance_type,
      :platform)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] fleet_ids
    #   The IDs of the EC2 Fleets.
    #
    #   <note markdown="1"> If a fleet is of type `instant`, you must specify the fleet ID,
    #   otherwise it does not appear in the response.
    #
    #    </note>
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `activity-status` - The progress of the EC2 Fleet ( `error` \|
    #     `pending-fulfillment` \| `pending-termination` \| `fulfilled`).
    #
    #   * `excess-capacity-termination-policy` - Indicates whether to
    #     terminate running instances if the target capacity is decreased
    #     below the current EC2 Fleet size (`true` \| `false`).
    #
    #   * `fleet-state` - The state of the EC2 Fleet (`submitted` \|
    #     `active` \| `deleted` \| `failed` \| `deleted-running` \|
    #     `deleted-terminating` \| `modifying`).
    #
    #   * `replace-unhealthy-instances` - Indicates whether EC2 Fleet should
    #     replace unhealthy instances (`true` \| `false`).
    #
    #   * `type` - The type of request (`instant` \| `request` \|
    #     `maintain`).
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetsRequest AWS API Documentation
    #
    class DescribeFleetsRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :fleet_ids,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] fleets
    #   Information about the EC2 Fleets.
    #   @return [Array<Types::FleetData>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetsResult AWS API Documentation
    #
    class DescribeFleetsResult < Struct.new(
      :next_token,
      :fleets)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filter
    #   One or more filters.
    #
    #   * `deliver-log-status` - The status of the logs delivery (`SUCCESS`
    #     \| `FAILED`).
    #
    #   * `log-destination-type` - The type of destination for the flow log
    #     data (`cloud-watch-logs` \| `s3` \| `kinesis-data-firehose`).
    #
    #   * `flow-log-id` - The ID of the flow log.
    #
    #   * `log-group-name` - The name of the log group.
    #
    #   * `resource-id` - The ID of the VPC, subnet, or network interface.
    #
    #   * `traffic-type` - The type of traffic (`ACCEPT` \| `REJECT` \|
    #     `ALL`).
    #
    #   * `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have
    #     a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of items. Pagination continues
    #   from the end of the items returned by the previous request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogsRequest AWS API Documentation
    #
    class DescribeFlowLogsRequest < Struct.new(
      :dry_run,
      :filter,
      :flow_log_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] flow_logs
    #   Information about the flow logs.
    #   @return [Array<Types::FlowLog>]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of items. This value is `null`
    #   when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogsResult AWS API Documentation
    #
    class DescribeFlowLogsResult < Struct.new(
      :flow_logs,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fpga_image_id
    #   The ID of the AFI.
    #   @return [String]
    #
    # @!attribute [rw] attribute
    #   The AFI attribute.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttributeRequest AWS API Documentation
    #
    class DescribeFpgaImageAttributeRequest < Struct.new(
      :dry_run,
      :fpga_image_id,
      :attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_image_attribute
    #   Information about the attribute.
    #   @return [Types::FpgaImageAttribute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttributeResult AWS API Documentation
    #
    class DescribeFpgaImageAttributeResult < Struct.new(
      :fpga_image_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fpga_image_ids
    #   The AFI IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] owners
    #   Filters the AFI by owner. Specify an Amazon Web Services account ID,
    #   `self` (owner is the sender of the request), or an Amazon Web
    #   Services owner alias (valid values are `amazon` \|
    #   `aws-marketplace`).
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `create-time` - The creation time of the AFI.
    #
    #   * `fpga-image-id` - The FPGA image identifier (AFI ID).
    #
    #   * `fpga-image-global-id` - The global FPGA image identifier (AGFI
    #     ID).
    #
    #   * `name` - The name of the AFI.
    #
    #   * `owner-id` - The Amazon Web Services account ID of the AFI owner.
    #
    #   * `product-code` - The product code.
    #
    #   * `shell-version` - The version of the Amazon Web Services Shell
    #     that was used to create the bitstream.
    #
    #   * `state` - The state of the AFI (`pending` \| `failed` \|
    #     `available` \| `unavailable`).
    #
    #   * `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have
    #     a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `update-time` - The time of the most recent update.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImagesRequest AWS API Documentation
    #
    class DescribeFpgaImagesRequest < Struct.new(
      :dry_run,
      :fpga_image_ids,
      :owners,
      :filters,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_images
    #   Information about the FPGA images.
    #   @return [Array<Types::FpgaImage>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImagesResult AWS API Documentation
    #
    class DescribeFpgaImagesResult < Struct.new(
      :fpga_images,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] filter
    #   The filters.
    #
    #   * `instance-family` - The instance family of the offering (for
    #     example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_duration
    #   This is the maximum duration of the reservation to purchase,
    #   specified in seconds. Reservations are available in one-year and
    #   three-year terms. The number of seconds specified must be the number
    #   of seconds in a year (365x24x60x60) times one of the supported
    #   durations (1 or 3). For example, specify 94608000 for three years.
    #   @return [Integer]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive
    #   an error.
    #   @return [Integer]
    #
    # @!attribute [rw] min_duration
    #   This is the minimum duration of the reservation you'd like to
    #   purchase, specified in seconds. Reservations are available in
    #   one-year and three-year terms. The number of seconds specified must
    #   be the number of seconds in a year (365x24x60x60) times one of the
    #   supported durations (1 or 3). For example, specify 31536000 for one
    #   year.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] offering_id
    #   The ID of the reservation offering.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferingsRequest AWS API Documentation
    #
    class DescribeHostReservationOfferingsRequest < Struct.new(
      :filter,
      :max_duration,
      :max_results,
      :min_duration,
      :next_token,
      :offering_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] offering_set
    #   Information about the offerings.
    #   @return [Array<Types::HostOffering>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferingsResult AWS API Documentation
    #
    class DescribeHostReservationOfferingsResult < Struct.new(
      :next_token,
      :offering_set)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] filter
    #   The filters.
    #
    #   * `instance-family` - The instance family (for example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #
    #   * `state` - The state of the reservation (`payment-pending` \|
    #     `payment-failed` \| `active` \| `retired`).
    #
    #   * `tag:<key>` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] host_reservation_id_set
    #   The host reservation IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive
    #   an error.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationsRequest AWS API Documentation
    #
    class DescribeHostReservationsRequest < Struct.new(
      :filter,
      :host_reservation_id_set,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] host_reservation_set
    #   Details about the reservation's configuration.
    #   @return [Array<Types::HostReservation>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationsResult AWS API Documentation
    #
    class DescribeHostReservationsResult < Struct.new(
      :host_reservation_set,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] host_ids
    #   The IDs of the Dedicated Hosts. The IDs are used for targeted
    #   instance launches.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive
    #   an error.
    #
    #   You cannot specify this parameter and the host IDs parameter in the
    #   same request.
    #   @return [Integer]
    #
    # @!attribute [rw] filter
    #   The filters.
    #
    #   * `auto-placement` - Whether auto-placement is enabled or disabled
    #     (`on` \| `off`).
    #
    #   * `availability-zone` - The Availability Zone of the host.
    #
    #   * `client-token` - The idempotency token that you provided when you
    #     allocated the host.
    #
    #   * `host-reservation-id` - The ID of the reservation assigned to this
    #     host.
    #
    #   * `instance-type` - The instance type size that the Dedicated Host
    #     is configured to support.
    #
    #   * `state` - The allocation state of the Dedicated Host (`available`
    #     \| `under-assessment` \| `permanent-failure` \| `released` \|
    #     `released-permanent-failure`).
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostsRequest AWS API Documentation
    #
    class DescribeHostsRequest < Struct.new(
      :host_ids,
      :next_token,
      :max_results,
      :filter)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] hosts
    #   Information about the Dedicated Hosts.
    #   @return [Array<Types::Host>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostsResult AWS API Documentation
    #
    class DescribeHostsResult < Struct.new(
      :hosts,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_ids
    #   The IAM instance profile associations.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `state` - The state of the association (`associating` \|
    #     `associated` \| `disassociating`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociationsRequest AWS API Documentation
    #
    class DescribeIamInstanceProfileAssociationsRequest < Struct.new(
      :association_ids,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] iam_instance_profile_associations
    #   Information about the IAM instance profile associations.
    #   @return [Array<Types::IamInstanceProfileAssociation>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociationsResult AWS API Documentation
    #
    class DescribeIamInstanceProfileAssociationsResult < Struct.new(
      :iam_instance_profile_associations,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image`
    #   \| `import-task` \| `instance` \| `internet-gateway` \|
    #   `network-acl` \| `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \|
    #   `volume` \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint`
    #   \| `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormatRequest AWS API Documentation
    #
    class DescribeIdFormatRequest < Struct.new(
      :resource)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] statuses
    #   Information about the ID format for the resource.
    #   @return [Array<Types::IdFormat>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormatResult AWS API Documentation
    #
    class DescribeIdFormatResult < Struct.new(
      :statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image`
    #   \| `import-task` \| `instance` \| `internet-gateway` \|
    #   `network-acl` \| `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \|
    #   `volume` \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint`
    #   \| `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #   @return [String]
    #
    # @!attribute [rw] principal_arn
    #   The ARN of the principal, which can be an IAM role, IAM user, or the
    #   root user.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormatRequest AWS API Documentation
    #
    class DescribeIdentityIdFormatRequest < Struct.new(
      :resource,
      :principal_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] statuses
    #   Information about the ID format for the resources.
    #   @return [Array<Types::IdFormat>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormatResult AWS API Documentation
    #
    class DescribeIdentityIdFormatResult < Struct.new(
      :statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeImageAttribute.
    #
    # @!attribute [rw] attribute
    #   The AMI attribute.
    #
    #   **Note**: The `blockDeviceMapping` attribute is deprecated. Using
    #   this attribute returns the `Client.AuthFailure` error. To get
    #   information about the block device mappings for an AMI, describe the
    #   image instead.
    #   @return [String]
    #
    # @!attribute [rw] image_id
    #   The ID of the AMI.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttributeRequest AWS API Documentation
    #
    class DescribeImageAttributeRequest < Struct.new(
      :attribute,
      :image_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_ids
    #   The IDs of the images to check for resource references.
    #   @return [Array<String>]
    #
    # @!attribute [rw] include_all_resource_types
    #   Specifies whether to check all supported Amazon Web Services
    #   resource types for image references. When specified, default values
    #   are applied for `ResourceTypeOptions`. For the default values, see
    #   [How AMI reference checks work][1] in the *Amazon EC2 User Guide*.
    #   If you also specify `ResourceTypes` with `ResourceTypeOptions`, your
    #   specified values override the default values.
    #
    #   Supported resource types: `ec2:Instance` \| `ec2:LaunchTemplate` \|
    #   `ssm:Parameter` \| `imagebuilder:ImageRecipe` \|
    #   `imagebuilder:ContainerRecipe`
    #
    #   Either `IncludeAllResourceTypes` or `ResourceTypes` must be
    #   specified.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-ami-references.html#how-ami-references-works
    #   @return [Boolean]
    #
    # @!attribute [rw] resource_types
    #   The Amazon Web Services resource types to check for image
    #   references.
    #
    #   Either `IncludeAllResourceTypes` or `ResourceTypes` must be
    #   specified.
    #   @return [Array<Types::ResourceTypeRequest>]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageReferencesRequest AWS API Documentation
    #
    class DescribeImageReferencesRequest < Struct.new(
      :image_ids,
      :include_all_resource_types,
      :resource_types,
      :next_token,
      :dry_run,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] image_references
    #   The resources that are referencing the specified images.
    #   @return [Array<Types::ImageReference>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageReferencesResult AWS API Documentation
    #
    class DescribeImageReferencesResult < Struct.new(
      :next_token,
      :image_references)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_ids
    #   The IDs of the images for filtering the report entries. If
    #   specified, only report entries containing these images are returned.
    #   @return [Array<String>]
    #
    # @!attribute [rw] report_ids
    #   The IDs of the usage reports.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `account-id` - A 12-digit Amazon Web Services account ID.
    #
    #   * `creation-time` - The time when the report was created, in the ISO
    #     8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for
    #     example, `2025-11-29T11:04:43.305Z`. You can use a wildcard (`*`),
    #     for example, `2025-11-29T*`, which matches an entire day.
    #
    #   * `resource-type` - The resource type (`ec2:Instance` \|
    #     `ec2:LaunchTemplate`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageUsageReportEntriesRequest AWS API Documentation
    #
    class DescribeImageUsageReportEntriesRequest < Struct.new(
      :image_ids,
      :report_ids,
      :next_token,
      :filters,
      :dry_run,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] image_usage_report_entries
    #   The content of the usage reports.
    #   @return [Array<Types::ImageUsageReportEntry>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageUsageReportEntriesResult AWS API Documentation
    #
    class DescribeImageUsageReportEntriesResult < Struct.new(
      :next_token,
      :image_usage_report_entries)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_ids
    #   The IDs of the images for filtering the reports. If specified, only
    #   reports containing these images are returned.
    #   @return [Array<String>]
    #
    # @!attribute [rw] report_ids
    #   The IDs of the image usage reports.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `creation-time` - The time when the report was created, in the ISO
    #     8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for
    #     example, `2025-11-29T11:04:43.305Z`. You can use a wildcard (`*`),
    #     for example, `2025-11-29T*`, which matches an entire day.
    #
    #   * `state` - The state of the report (`available` \| `pending` \|
    #     `error`).
    #
    #   * `tag:<key>` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageUsageReportsRequest AWS API Documentation
    #
    class DescribeImageUsageReportsRequest < Struct.new(
      :image_ids,
      :report_ids,
      :next_token,
      :filters,
      :dry_run,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] image_usage_reports
    #   The image usage reports.
    #   @return [Array<Types::ImageUsageReport>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageUsageReportsResult AWS API Documentation
    #
    class DescribeImageUsageReportsResult < Struct.new(
      :next_token,
      :image_usage_reports)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] executable_users
    #   Scopes the images by users with explicit launch permissions. Specify
    #   an Amazon Web Services account ID, `self` (the sender of the
    #   request), or `all` (public AMIs).
    #
    #   * If you specify an Amazon Web Services account ID that is not your
    #     own, only AMIs shared with that specific Amazon Web Services
    #     account ID are returned. However, AMIs that are shared with the
    #     account’s organization or organizational unit (OU) are not
    #     returned.
    #
    #   * If you specify `self` or your own Amazon Web Services account ID,
    #     AMIs shared with your account are returned. In addition, AMIs that
    #     are shared with the organization or OU of which you are member are
    #     also returned.
    #
    #   * If you specify `all`, all public AMIs are returned.
    #   @return [Array<String>]
    #
    # @!attribute [rw] image_ids
    #   The image IDs.
    #
    #   Default: Describes all images available to you.
    #   @return [Array<String>]
    #
    # @!attribute [rw] owners
    #   Scopes the results to images with the specified owners. You can
    #   specify a combination of Amazon Web Services account IDs, `self`,
    #   `amazon`, `aws-backup-vault`, and `aws-marketplace`. If you omit
    #   this parameter, the results include all images for which you have
    #   launch permissions, regardless of ownership.
    #   @return [Array<String>]
    #
    # @!attribute [rw] include_deprecated
    #   Specifies whether to include deprecated AMIs.
    #
    #   Default: No deprecated AMIs are included in the response.
    #
    #   <note markdown="1"> If you are the AMI owner, all deprecated AMIs appear in the response
    #   regardless of what you specify for this parameter.
    #
    #    </note>
    #   @return [Boolean]
    #
    # @!attribute [rw] include_disabled
    #   Specifies whether to include disabled AMIs.
    #
    #   Default: No disabled AMIs are included in the response.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `architecture` - The image architecture (`i386` \| `x86_64` \|
    #     `arm64` \| `x86_64_mac` \| `arm64_mac`).
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean value
    #     that indicates whether the Amazon EBS volume is deleted on
    #     instance termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.snapshot-id` - The ID of the snapshot used
    #     for the Amazon EBS volume.
    #
    #   * `block-device-mapping.volume-size` - The volume size of the Amazon
    #     EBS volume, in GiB.
    #
    #   * `block-device-mapping.volume-type` - The volume type of the Amazon
    #     EBS volume (`io1` \| `io2` \| `gp2` \| `gp3` \| `sc1 `\| `st1` \|
    #     `standard`).
    #
    #   * `block-device-mapping.encrypted` - A Boolean that indicates
    #     whether the Amazon EBS volume is encrypted.
    #
    #   * `creation-date` - The time when the image was created, in the ISO
    #     8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for
    #     example, `2021-09-29T11:04:43.305Z`. You can use a wildcard (`*`),
    #     for example, `2021-09-29T*`, which matches an entire day.
    #
    #   * `description` - The description of the image (provided during
    #     image creation).
    #
    #   * `ena-support` - A Boolean that indicates whether enhanced
    #     networking with ENA is enabled.
    #
    #   * `free-tier-eligible` - A Boolean that indicates whether this image
    #     can be used under the Amazon Web Services Free Tier (`true` \|
    #     `false`).
    #
    #   * `hypervisor` - The hypervisor type (`ovm` \| `xen`).
    #
    #   * `image-allowed` - A Boolean that indicates whether the image meets
    #     the criteria specified for Allowed AMIs.
    #
    #   * `image-id` - The ID of the image.
    #
    #   * `image-type` - The image type (`machine` \| `kernel` \|
    #     `ramdisk`).
    #
    #   * `is-public` - A Boolean that indicates whether the image is
    #     public.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `manifest-location` - The location of the image manifest.
    #
    #   * `name` - The name of the AMI (provided during image creation).
    #
    #   * `owner-alias` - The owner alias (`amazon` \| `aws-backup-vault` \|
    #     `aws-marketplace`). The valid aliases are defined in an
    #     Amazon-maintained list. This is not the Amazon Web Services
    #     account alias that can be set using the IAM console. We recommend
    #     that you use the **Owner** request parameter instead of this
    #     filter.
    #
    #   * `owner-id` - The Amazon Web Services account ID of the owner. We
    #     recommend that you use the **Owner** request parameter instead of
    #     this filter.
    #
    #   * `platform` - The platform. The only supported value is `windows`.
    #
    #   * `product-code` - The product code.
    #
    #   * `product-code.type` - The type of the product code
    #     (`marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `root-device-name` - The device name of the root device volume
    #     (for example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `source-image-id` - The ID of the source AMI from which the AMI
    #     was created.
    #
    #   * `source-image-region` - The Region of the source AMI.
    #
    #   * `source-instance-id` - The ID of the instance that the AMI was
    #     created from if the AMI was created using CreateImage. This filter
    #     is applicable only if the AMI was created using [CreateImage][1].
    #
    #   * `state` - The state of the image (`available` \| `pending` \|
    #     `failed`).
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - The message for the state change.
    #
    #   * `sriov-net-support` - A value of `simple` indicates that enhanced
    #     networking with the Intel 82599 VF interface is enabled.
    #
    #   * `tag:<key>` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `virtualization-type` - The virtualization type (`paravirtual` \|
    #     `hvm`).
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImagesRequest AWS API Documentation
    #
    class DescribeImagesRequest < Struct.new(
      :executable_users,
      :image_ids,
      :owners,
      :include_deprecated,
      :include_disabled,
      :max_results,
      :next_token,
      :dry_run,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] images
    #   Information about the images.
    #   @return [Array<Types::Image>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImagesResult AWS API Documentation
    #
    class DescribeImagesResult < Struct.new(
      :next_token,
      :images)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] import_task_ids
    #   The IDs of the import image tasks.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A token that indicates the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasksRequest AWS API Documentation
    #
    class DescribeImportImageTasksRequest < Struct.new(
      :dry_run,
      :filters,
      :import_task_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] import_image_tasks
    #   A list of zero or more import image tasks that are currently active
    #   or were completed or canceled in the previous 7 days.
    #   @return [Array<Types::ImportImageTask>]
    #
    # @!attribute [rw] next_token
    #   The token to use to get the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasksResult AWS API Documentation
    #
    class DescribeImportImageTasksResult < Struct.new(
      :import_image_tasks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] import_task_ids
    #   A list of import snapshot task IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A token that indicates the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasksRequest AWS API Documentation
    #
    class DescribeImportSnapshotTasksRequest < Struct.new(
      :dry_run,
      :filters,
      :import_task_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] import_snapshot_tasks
    #   A list of zero or more import snapshot tasks that are currently
    #   active or were completed or canceled in the previous 7 days.
    #   @return [Array<Types::ImportSnapshotTask>]
    #
    # @!attribute [rw] next_token
    #   The token to use to get the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasksResult AWS API Documentation
    #
    class DescribeImportSnapshotTasksResult < Struct.new(
      :import_snapshot_tasks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] attribute
    #   The instance attribute.
    #
    #   Note that the `enaSupport` attribute is not supported.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttributeRequest AWS API Documentation
    #
    class DescribeInstanceAttributeRequest < Struct.new(
      :dry_run,
      :instance_id,
      :attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `instance-connect-endpoint-id` - The ID of the EC2 Instance
    #     Connect Endpoint.
    #
    #   * `state` - The state of the EC2 Instance Connect Endpoint
    #     (`create-in-progress` \| `create-complete` \| `create-failed` \|
    #     `delete-in-progress` \| `delete-complete` \| `delete-failed`).
    #
    #   * `subnet-id` - The ID of the subnet in which the EC2 Instance
    #     Connect Endpoint was created.
    #
    #   * `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have
    #     a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `tag-value` - The value of a tag assigned to the resource. Use
    #     this filter to find all resources that have a tag with a specific
    #     value, regardless of tag key.
    #
    #   * `vpc-id` - The ID of the VPC in which the EC2 Instance Connect
    #     Endpoint was created.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] instance_connect_endpoint_ids
    #   One or more EC2 Instance Connect Endpoint IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceConnectEndpointsRequest AWS API Documentation
    #
    class DescribeInstanceConnectEndpointsRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :filters,
      :instance_connect_endpoint_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_connect_endpoints
    #   Information about the EC2 Instance Connect Endpoints.
    #   @return [Array<Types::Ec2InstanceConnectEndpoint>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceConnectEndpointsResult AWS API Documentation
    #
    class DescribeInstanceConnectEndpointsResult < Struct.new(
      :instance_connect_endpoints,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   ^
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 1000 explicitly specified instance IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #   You cannot specify this parameter and the instance IDs parameter in
    #   the same call.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecificationsRequest AWS API Documentation
    #
    class DescribeInstanceCreditSpecificationsRequest < Struct.new(
      :dry_run,
      :filters,
      :instance_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_credit_specifications
    #   Information about the credit option for CPU usage of an instance.
    #   @return [Array<Types::InstanceCreditSpecification>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecificationsResult AWS API Documentation
    #
    class DescribeInstanceCreditSpecificationsResult < Struct.new(
      :instance_credit_specifications,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributesRequest AWS API Documentation
    #
    class DescribeInstanceEventNotificationAttributesRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_tag_attribute
    #   Information about the registered tag keys.
    #   @return [Types::InstanceTagNotificationAttribute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributesResult AWS API Documentation
    #
    class DescribeInstanceEventNotificationAttributesResult < Struct.new(
      :instance_tag_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describe instance event windows by InstanceEventWindow.
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_event_window_ids
    #   The IDs of the event windows.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `dedicated-host-id` - The event windows associated with the
    #     specified Dedicated Host ID.
    #
    #   * `event-window-name` - The event windows associated with the
    #     specified names.
    #
    #   * `instance-id` - The event windows associated with the specified
    #     instance ID.
    #
    #   * `instance-tag` - The event windows associated with the specified
    #     tag and value.
    #
    #   * `instance-tag-key` - The event windows associated with the
    #     specified tag key, regardless of the value.
    #
    #   * `instance-tag-value` - The event windows associated with the
    #     specified tag value, regardless of the key.
    #
    #   * `tag:<key>` - The key/value combination of a tag assigned to the
    #     event window. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have
    #     a tag with the key `Owner` and the value `CMX`, specify
    #     `tag:Owner` for the filter name and `CMX` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the event window. Use
    #     this filter to find all event windows that have a tag with a
    #     specific key, regardless of the tag value.
    #
    #   * `tag-value` - The value of a tag assigned to the event window. Use
    #     this filter to find all event windows that have a tag with a
    #     specific value, regardless of the tag key.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 20 and 500. You cannot
    #   specify this parameter and the event window IDs parameter in the
    #   same call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventWindowsRequest AWS API Documentation
    #
    class DescribeInstanceEventWindowsRequest < Struct.new(
      :dry_run,
      :instance_event_window_ids,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_event_windows
    #   Information about the event windows.
    #   @return [Array<Types::InstanceEventWindow>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventWindowsResult AWS API Documentation
    #
    class DescribeInstanceEventWindowsResult < Struct.new(
      :instance_event_windows,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The name of the Availability Zone (for
    #     example, `us-west-2a`) or Local Zone (for example,
    #     `us-west-2-lax-1b`) of the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `image-allowed` - A Boolean that indicates whether the image meets
    #     the criteria specified for Allowed AMIs.
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-type` - The type of instance (for example, `t3.micro`).
    #
    #   * `launch-time` - The time when the instance was launched, in the
    #     ISO 8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ),
    #     for example, `2023-09-29T11:04:43.305Z`. You can use a wildcard
    #     (`*`), for example, `2023-09-29T*`, which matches an entire day.
    #
    #   * `owner-alias` - The owner alias (`amazon` \| `aws-marketplace` \|
    #     `aws-backup-vault`). The valid aliases are defined in an
    #     Amazon-maintained list. This is not the Amazon Web Services
    #     account alias that can be set using the IAM console. We recommend
    #     that you use the `Owner` request parameter instead of this filter.
    #
    #   * `owner-id` - The Amazon Web Services account ID of the owner. We
    #     recommend that you use the `Owner` request parameter instead of
    #     this filter.
    #
    #   * `tag:<key>` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `zone-id` - The ID of the Availability Zone (for example,
    #     `usw2-az2`) or Local Zone (for example, `usw2-lax1-az1`) of the
    #     instance.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   If you don't specify an instance ID or filters, the output includes
    #   information for all instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #   Default: 1000
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceImageMetadataRequest AWS API Documentation
    #
    class DescribeInstanceImageMetadataRequest < Struct.new(
      :filters,
      :instance_ids,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_image_metadata
    #   Information about the instance and the AMI used to launch the
    #   instance.
    #   @return [Array<Types::InstanceImageMetadata>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceImageMetadataResult AWS API Documentation
    #
    class DescribeInstanceImageMetadataResult < Struct.new(
      :instance_image_metadata,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_ids
    #   The IDs of the SQL Server High Availability instances to describe.
    #   If omitted, the API returns historical states for all SQL Server
    #   High Availability instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] start_time
    #   The start data and time of the period for which to get the
    #   historical SQL Server High Availability states. If omitted, the API
    #   returns all available historical states.
    #
    #   Timezone: UTC
    #
    #   Format: `YYYY-MM-DDThh:mm:ss.sssZ`
    #   @return [Time]
    #
    # @!attribute [rw] end_time
    #   The end data and time of the period for which to get historical SQL
    #   Server High Availability states. If omitted, the API returns
    #   historical states up to the current date and time.
    #
    #   Timezone: UTC
    #
    #   Format: `YYYY-MM-DDThh:mm:ss.sssZ`
    #   @return [Time]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters to apply to the results. Supported filters
    #   include:
    #
    #   * `tag:<key>` - The tag key and value pair assigned to the instance.
    #     For example, to find all instances tagged with `Owner:TeamA`,
    #     specify `tag:Owner` for the filter name and `TeamA` for the filter
    #     value.
    #
    #   * `tag-key` - The tag key assigned to the instance.
    #
    #   * `haStatus` - The SQL Server High Availability status of the SQL
    #     Server High Availability instance (`processing` \| `active` \|
    #     `standby` \| `invalid`).
    #
    #   * `sqlServerLicenseUsage` - The license type for the SQL Server
    #     license (`full` \| `waived`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceSqlHaHistoryStatesRequest AWS API Documentation
    #
    class DescribeInstanceSqlHaHistoryStatesRequest < Struct.new(
      :instance_ids,
      :start_time,
      :end_time,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instances
    #   Information about the historical SQL Server High Availability states
    #   of the SQL Server High Availability instances.
    #   @return [Array<Types::RegisteredInstance>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceSqlHaHistoryStatesResult AWS API Documentation
    #
    class DescribeInstanceSqlHaHistoryStatesResult < Struct.new(
      :instances,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_ids
    #   The IDs of the SQL Server High Availability instances to describe.
    #   If omitted, the API returns SQL Server High Availability states for
    #   all SQL Server High Availability instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters to apply to the results. Supported filters
    #   include:
    #
    #   * `tag:<key>` - The tag key and value pair assigned to the instance.
    #     For example, to find all instances tagged with `Owner:TeamA`,
    #     specify `tag:Owner` for the filter name and `TeamA` for the filter
    #     value.
    #
    #   * `tag-key` - The tag key assigned to the instance.
    #
    #   * `haStatus` - The SQL Server High Availability status of the SQL
    #     Server High Availability instance (`processing` \| `active` \|
    #     `standby` \| `invalid`).
    #
    #   * `sqlServerLicenseUsage` - The license type for the SQL Server
    #     license (`full` \| `waived`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceSqlHaStatesRequest AWS API Documentation
    #
    class DescribeInstanceSqlHaStatesRequest < Struct.new(
      :instance_ids,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instances
    #   Information about the SQL Server High Availability instances.
    #   @return [Array<Types::RegisteredInstance>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceSqlHaStatesResult AWS API Documentation
    #
    class DescribeInstanceSqlHaStatesResult < Struct.new(
      :instances,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 100 explicitly specified instance IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #   You cannot specify this parameter and the instance IDs parameter in
    #   the same request.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `availability-zone-id` - The ID of the Availability Zone of the
    #     instance.
    #
    #   * `event.code` - The code for the scheduled event (`instance-reboot`
    #     \| `system-reboot` \| `system-maintenance` \|
    #     `instance-retirement` \| `instance-stop`).
    #
    #   * `event.description` - A description of the event.
    #
    #   * `event.instance-event-id` - The ID of the event whose date and
    #     time you are modifying.
    #
    #   * `event.not-after` - The latest end time for the scheduled event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before` - The earliest start time for the scheduled
    #     event (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before-deadline` - The deadline for starting the event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `instance-state-code` - The code for the instance state, as a
    #     16-bit unsigned integer. The high byte is used for internal
    #     purposes and should be ignored. The low byte is set based on the
    #     state represented. The valid values are 0 (pending), 16 (running),
    #     32 (shutting-down), 48 (terminated), 64 (stopping), and 80
    #     (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-status.reachability` - Filters on instance status where
    #     the name is `reachability` (`passed` \| `failed` \| `initializing`
    #     \| `insufficient-data`).
    #
    #   * `instance-status.status` - The status of the instance (`ok` \|
    #     `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #
    #   * `operator.managed` - A Boolean that indicates whether this is a
    #     managed instance.
    #
    #   * `operator.principal` - The principal that manages the instance.
    #     Only valid for managed instances, where `managed` is `true`.
    #
    #   * `system-status.reachability` - Filters on system status where the
    #     name is `reachability` (`passed` \| `failed` \| `initializing` \|
    #     `insufficient-data`).
    #
    #   * `system-status.status` - The system status of the instance (`ok`
    #     \| `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #
    #   * `attached-ebs-status.status` - The status of the attached EBS
    #     volume for the instance (`ok` \| `impaired` \| `initializing` \|
    #     `insufficient-data` \| `not-applicable`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] include_all_instances
    #   When `true`, includes the health status for all instances. When
    #   `false`, includes the health status for running instances only.
    #
    #   Default: `false`
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatusRequest AWS API Documentation
    #
    class DescribeInstanceStatusRequest < Struct.new(
      :instance_ids,
      :max_results,
      :next_token,
      :dry_run,
      :filters,
      :include_all_instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_statuses
    #   Information about the status of the instances.
    #   @return [Array<Types::InstanceStatus>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatusResult AWS API Documentation
    #
    class DescribeInstanceStatusResult < Struct.new(
      :instance_statuses,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #   You can't specify this parameter and the instance IDs parameter in
    #   the same request.
    #
    #   Default: `20`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 100 explicitly specified instance IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] group_names
    #   The name of the placement group that each instance is in.
    #
    #   Constraints: Maximum 100 explicitly specified placement group names.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The name of the Availability Zone (for
    #     example, `us-west-2a`) or Local Zone (for example,
    #     `us-west-2-lax-1b`) that the instance is in.
    #
    #   * `instance-type` - The instance type (for example, `p4d.24xlarge`)
    #     or instance family (for example, `p4d*`). You can use the `*`
    #     wildcard to match zero or more characters, or the `?` wildcard to
    #     match zero or one character.
    #
    #   * `zone-id` - The ID of the Availability Zone (for example,
    #     `usw2-az2`) or Local Zone (for example, `usw2-lax1-az1`) that the
    #     instance is in.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTopologyRequest AWS API Documentation
    #
    class DescribeInstanceTopologyRequest < Struct.new(
      :dry_run,
      :next_token,
      :max_results,
      :instance_ids,
      :group_names,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instances
    #   Information about the topology of each instance.
    #   @return [Array<Types::InstanceTopology>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTopologyResult AWS API Documentation
    #
    class DescribeInstanceTopologyResult < Struct.new(
      :instances,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] location_type
    #   The location type.
    #
    #   * `availability-zone` - The Availability Zone. When you specify a
    #     location filter, it must be an Availability Zone for the current
    #     Region.
    #
    #   * `availability-zone-id` - The AZ ID. When you specify a location
    #     filter, it must be an AZ ID for the current Region.
    #
    #   * `outpost` - The Outpost ARN. When you specify a location filter,
    #     it must be an Outpost ARN for the current Region.
    #
    #   * `region` - The current Region. If you specify a location filter,
    #     it must match the current Region.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `instance-type` - The instance type. For a list of possible
    #     values, see [Instance][1].
    #
    #   * `location` - The location. For a list of possible identifiers, see
    #     [Regions and Zones][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Instance.html
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferingsRequest AWS API Documentation
    #
    class DescribeInstanceTypeOfferingsRequest < Struct.new(
      :dry_run,
      :location_type,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_type_offerings
    #   The instance types offered in the location.
    #   @return [Array<Types::InstanceTypeOffering>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferingsResult AWS API Documentation
    #
    class DescribeInstanceTypeOfferingsResult < Struct.new(
      :instance_type_offerings,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_types
    #   The instance types.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `auto-recovery-supported` - Indicates whether Amazon CloudWatch
    #     action based recovery is supported (`true` \| `false`).
    #
    #   * `bare-metal` - Indicates whether it is a bare metal instance type
    #     (`true` \| `false`).
    #
    #   * `burstable-performance-supported` - Indicates whether the instance
    #     type is a burstable performance T instance type (`true` \|
    #     `false`).
    #
    #   * `current-generation` - Indicates whether this instance type is the
    #     latest generation instance type of an instance family (`true` \|
    #     `false`).
    #
    #   * `dedicated-hosts-supported` - Indicates whether the instance type
    #     supports Dedicated Hosts. (`true` \| `false`)
    #
    #   * `ebs-info.attachment-limit-type` - The type of Amazon EBS volume
    #     attachment limit (`shared` \| `dedicated`).
    #
    #   * `ebs-info.maximum-ebs-attachments` - The maximum number of Amazon
    #     EBS volumes that can be attached to the instance type.
    #
    #   * `ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps` - The
    #     baseline bandwidth performance for an EBS-optimized instance type,
    #     in Mbps.
    #
    #   * `ebs-info.ebs-optimized-info.baseline-iops` - The baseline
    #     input/output storage operations per second for an EBS-optimized
    #     instance type.
    #
    #   * `ebs-info.ebs-optimized-info.baseline-throughput-in-mbps` - The
    #     baseline throughput performance for an EBS-optimized instance
    #     type, in MB/s.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps` - The
    #     maximum bandwidth performance for an EBS-optimized instance type,
    #     in Mbps.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-iops` - The maximum
    #     input/output storage operations per second for an EBS-optimized
    #     instance type.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-throughput-in-mbps` - The
    #     maximum throughput performance for an EBS-optimized instance type,
    #     in MB/s.
    #
    #   * `ebs-info.ebs-optimized-support` - Indicates whether the instance
    #     type is EBS-optimized (`supported` \| `unsupported` \| `default`).
    #
    #   * `ebs-info.encryption-support` - Indicates whether EBS encryption
    #     is supported (`supported` \| `unsupported`).
    #
    #   * `ebs-info.nvme-support` - Indicates whether non-volatile memory
    #     express (NVMe) is supported for EBS volumes (`required` \|
    #     `supported` \| `unsupported`).
    #
    #   * `free-tier-eligible` - A Boolean that indicates whether this
    #     instance type can be used under the Amazon Web Services Free Tier
    #     (`true` \| `false`).
    #
    #   * `hibernation-supported` - Indicates whether On-Demand hibernation
    #     is supported (`true` \| `false`).
    #
    #   * `hypervisor` - The hypervisor (`nitro` \| `xen`).
    #
    #   * `instance-storage-info.disk.count` - The number of local disks.
    #
    #   * `instance-storage-info.disk.size-in-gb` - The storage size of each
    #     instance storage disk, in GB.
    #
    #   * `instance-storage-info.disk.type` - The storage technology for the
    #     local instance storage disks (`hdd` \| `ssd`).
    #
    #   * `instance-storage-info.encryption-support` - Indicates whether
    #     data is encrypted at rest (`required` \| `supported` \|
    #     `unsupported`).
    #
    #   * `instance-storage-info.nvme-support` - Indicates whether
    #     non-volatile memory express (NVMe) is supported for instance store
    #     (`required` \| `supported` \| `unsupported`).
    #
    #   * `instance-storage-info.total-size-in-gb` - The total amount of
    #     storage available from all local instance storage, in GB.
    #
    #   * `instance-storage-supported` - Indicates whether the instance type
    #     has local instance storage (`true` \| `false`).
    #
    #   * `instance-type` - The instance type (for example `c5.2xlarge` or
    #     c5*).
    #
    #   * `memory-info.size-in-mib` - The memory size.
    #
    #   * `network-info.bandwidth-weightings` - For instances that support
    #     bandwidth weighting to boost performance (`default`, `vpc-1`,
    #     `ebs-1`).
    #
    #   * `network-info.efa-info.maximum-efa-interfaces` - The maximum
    #     number of Elastic Fabric Adapters (EFAs) per instance.
    #
    #   * `network-info.efa-supported` - Indicates whether the instance type
    #     supports Elastic Fabric Adapter (EFA) (`true` \| `false`).
    #
    #   * `network-info.ena-support` - Indicates whether Elastic Network
    #     Adapter (ENA) is supported or required (`required` \| `supported`
    #     \| `unsupported`).
    #
    #   * `network-info.flexible-ena-queues-support` - Indicates whether an
    #     instance supports flexible ENA queues (`supported` \|
    #     `unsupported`).
    #
    #   * `network-info.encryption-in-transit-supported` - Indicates whether
    #     the instance type automatically encrypts in-transit traffic
    #     between instances (`true` \| `false`).
    #
    #   * `network-info.ipv4-addresses-per-interface` - The maximum number
    #     of private IPv4 addresses per network interface.
    #
    #   * `network-info.ipv6-addresses-per-interface` - The maximum number
    #     of private IPv6 addresses per network interface.
    #
    #   * `network-info.ipv6-supported` - Indicates whether the instance
    #     type supports IPv6 (`true` \| `false`).
    #
    #   * `network-info.maximum-network-cards` - The maximum number of
    #     network cards per instance.
    #
    #   * `network-info.maximum-network-interfaces` - The maximum number of
    #     network interfaces per instance.
    #
    #   * `network-info.network-performance` - The network performance (for
    #     example, "25 Gigabit").
    #
    #   * `nitro-enclaves-support` - Indicates whether Nitro Enclaves is
    #     supported (`supported` \| `unsupported`).
    #
    #   * `nitro-tpm-support` - Indicates whether NitroTPM is supported
    #     (`supported` \| `unsupported`).
    #
    #   * `nitro-tpm-info.supported-versions` - The supported NitroTPM
    #     version (`2.0`).
    #
    #   * `processor-info.supported-architecture` - The CPU architecture
    #     (`arm64` \| `i386` \| `x86_64`).
    #
    #   * `processor-info.sustained-clock-speed-in-ghz` - The CPU clock
    #     speed, in GHz.
    #
    #   * `processor-info.supported-features` - The supported CPU features
    #     (`amd-sev-snp`).
    #
    #   * `reboot-migration-support` - Indicates whether enabling reboot
    #     migration is supported (`supported` \| `unsupported`).
    #
    #   * `supported-boot-mode` - The boot mode (`legacy-bios` \| `uefi`).
    #
    #   * `supported-root-device-type` - The root device type (`ebs` \|
    #     `instance-store`).
    #
    #   * `supported-usage-class` - The usage class (`on-demand` \| `spot`
    #     \| `capacity-block`).
    #
    #   * `supported-virtualization-type` - The virtualization type (`hvm`
    #     \| `paravirtual`).
    #
    #   * `vcpu-info.default-cores` - The default number of cores for the
    #     instance type.
    #
    #   * `vcpu-info.default-threads-per-core` - The default number of
    #     threads per core for the instance type.
    #
    #   * `vcpu-info.default-vcpus` - The default number of vCPUs for the
    #     instance type.
    #
    #   * `vcpu-info.valid-cores` - The number of cores that can be
    #     configured for the instance type.
    #
    #   * `vcpu-info.valid-threads-per-core` - The number of threads per
    #     core that can be configured for the instance type. For example,
    #     "1" or "1,2".
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypesRequest AWS API Documentation
    #
    class DescribeInstanceTypesRequest < Struct.new(
      :dry_run,
      :instance_types,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_types
    #   The instance type.
    #   @return [Array<Types::InstanceTypeInfo>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypesResult AWS API Documentation
    #
    class DescribeInstanceTypesResult < Struct.new(
      :instance_types,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `affinity` - The affinity setting for an instance running on a
    #     Dedicated Host (`default` \| `host`).
    #
    #   * `architecture` - The instance architecture (`i386` \| `x86_64` \|
    #     `arm64`).
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `availability-zone-id` - The ID of the Availability Zone of the
    #     instance.
    #
    #   * `block-device-mapping.attach-time` - The attach time for an EBS
    #     volume mapped to the instance, for example,
    #     `2022-09-15T17:15:20.000Z`.
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean that
    #     indicates whether the EBS volume is deleted on instance
    #     termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.status` - The status for the EBS volume
    #     (`attaching` \| `attached` \| `detaching` \| `detached`).
    #
    #   * `block-device-mapping.volume-id` - The volume ID of the EBS
    #     volume.
    #
    #   * `boot-mode` - The boot mode that was specified by the AMI
    #     (`legacy-bios` \| `uefi` \| `uefi-preferred`).
    #
    #   * `capacity-reservation-id` - The ID of the Capacity Reservation
    #     into which the instance was launched.
    #
    #   * `capacity-reservation-specification.capacity-reservation-preference`
    #     - The instance's Capacity Reservation preference (`open` \|
    #     `none`).
    #
    #   * `capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id`
    #     - The ID of the targeted Capacity Reservation.
    #
    #   * `capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn`
    #     - The ARN of the targeted Capacity Reservation group.
    #
    #   * `client-token` - The idempotency token you provided when you
    #     launched the instance.
    #
    #   * `current-instance-boot-mode` - The boot mode that is used to
    #     launch the instance at launch or start (`legacy-bios` \| `uefi`).
    #
    #   * `dns-name` - The public DNS name of the instance.
    #
    #   * `ebs-optimized` - A Boolean that indicates whether the instance is
    #     optimized for Amazon EBS I/O.
    #
    #   * `ena-support` - A Boolean that indicates whether the instance is
    #     enabled for enhanced networking with ENA.
    #
    #   * `enclave-options.enabled` - A Boolean that indicates whether the
    #     instance is enabled for Amazon Web Services Nitro Enclaves.
    #
    #   * `hibernation-options.configured` - A Boolean that indicates
    #     whether the instance is enabled for hibernation. A value of `true`
    #     means that the instance is enabled for hibernation.
    #
    #   * `host-id` - The ID of the Dedicated Host on which the instance is
    #     running, if applicable.
    #
    #   * `hypervisor` - The hypervisor type of the instance (`ovm` \|
    #     `xen`). The value `xen` is used for both Xen and Nitro
    #     hypervisors.
    #
    #   * `iam-instance-profile.arn` - The instance profile associated with
    #     the instance. Specified as an ARN.
    #
    #   * `iam-instance-profile.id` - The instance profile associated with
    #     the instance. Specified as an ID.
    #
    #   * `image-id` - The ID of the image used to launch the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `instance-lifecycle` - Indicates whether this is a Spot Instance,
    #     a Scheduled Instance, or a Capacity Block (`spot` \| `scheduled`
    #     \| `capacity-block`).
    #
    #   * `instance-state-code` - The state of the instance, as a 16-bit
    #     unsigned integer. The high byte is used for internal purposes and
    #     should be ignored. The low byte is set based on the state
    #     represented. The valid values are: 0 (pending), 16 (running), 32
    #     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-type` - The type of instance (for example, `t2.micro`).
    #
    #   * `instance.group-id` - The ID of the security group for the
    #     instance.
    #
    #   * `instance.group-name` - The name of the security group for the
    #     instance.
    #
    #   * `ip-address` - The public IPv4 address of the instance.
    #
    #   * `ipv6-address` - The IPv6 address of the instance.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `key-name` - The name of the key pair used when the instance was
    #     launched.
    #
    #   * `launch-index` - When launching multiple instances, this is the
    #     index for the instance in the launch group (for example, 0, 1, 2,
    #     and so on).
    #
    #   * `launch-time` - The time when the instance was launched, in the
    #     ISO 8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ),
    #     for example, `2021-09-29T11:04:43.305Z`. You can use a wildcard
    #     (`*`), for example, `2021-09-29T*`, which matches an entire day.
    #
    #   * `maintenance-options.auto-recovery` - The current automatic
    #     recovery behavior of the instance (`disabled` \| `default`).
    #
    #   * `metadata-options.http-endpoint` - The status of access to the
    #     HTTP metadata endpoint on your instance (`enabled` \| `disabled`)
    #
    #   * `metadata-options.http-protocol-ipv4` - Indicates whether the IPv4
    #     endpoint is enabled (`disabled` \| `enabled`).
    #
    #   * `metadata-options.http-protocol-ipv6` - Indicates whether the IPv6
    #     endpoint is enabled (`disabled` \| `enabled`).
    #
    #   * `metadata-options.http-put-response-hop-limit` - The HTTP metadata
    #     request put response hop limit (integer, possible values `1` to
    #     `64`)
    #
    #   * `metadata-options.http-tokens` - The metadata request
    #     authorization state (`optional` \| `required`)
    #
    #   * `metadata-options.instance-metadata-tags` - The status of access
    #     to instance tags from the instance metadata (`enabled` \|
    #     `disabled`)
    #
    #   * `metadata-options.state` - The state of the metadata option
    #     changes (`pending` \| `applied`).
    #
    #   * `monitoring-state` - Indicates whether detailed monitoring is
    #     enabled (`disabled` \| `enabled`).
    #
    #   * `network-interface.addresses.association.allocation-id` - The
    #     allocation ID.
    #
    #   * `network-interface.addresses.association.association-id` - The
    #     association ID.
    #
    #   * `network-interface.addresses.association.carrier-ip` - The carrier
    #     IP address.
    #
    #   * `network-interface.addresses.association.customer-owned-ip` - The
    #     customer-owned IP address.
    #
    #   * `network-interface.addresses.association.ip-owner-id` - The owner
    #     ID of the private IPv4 address associated with the network
    #     interface.
    #
    #   * `network-interface.addresses.association.public-dns-name` - The
    #     public DNS name.
    #
    #   * `network-interface.addresses.association.public-ip` - The ID of
    #     the association of an Elastic IP address (IPv4) with a network
    #     interface.
    #
    #   * `network-interface.addresses.primary` - Specifies whether the IPv4
    #     address of the network interface is the primary private IPv4
    #     address.
    #
    #   * `network-interface.addresses.private-dns-name` - The private DNS
    #     name.
    #
    #   * `network-interface.addresses.private-ip-address` - The private
    #     IPv4 address associated with the network interface.
    #
    #   * `network-interface.association.allocation-id` - The allocation ID
    #     returned when you allocated the Elastic IP address (IPv4) for your
    #     network interface.
    #
    #   * `network-interface.association.association-id` - The association
    #     ID returned when the network interface was associated with an IPv4
    #     address.
    #
    #   * `network-interface.association.carrier-ip` - The customer-owned IP
    #     address.
    #
    #   * `network-interface.association.customer-owned-ip` - The
    #     customer-owned IP address.
    #
    #   * `network-interface.association.ip-owner-id` - The owner of the
    #     Elastic IP address (IPv4) associated with the network interface.
    #
    #   * `network-interface.association.public-dns-name` - The public DNS
    #     name.
    #
    #   * `network-interface.association.public-ip` - The address of the
    #     Elastic IP address (IPv4) bound to the network interface.
    #
    #   * `network-interface.attachment.attach-time` - The time that the
    #     network interface was attached to an instance.
    #
    #   * `network-interface.attachment.attachment-id` - The ID of the
    #     interface attachment.
    #
    #   * `network-interface.attachment.delete-on-termination` - Specifies
    #     whether the attachment is deleted when an instance is terminated.
    #
    #   * `network-interface.attachment.device-index` - The device index to
    #     which the network interface is attached.
    #
    #   * `network-interface.attachment.instance-id` - The ID of the
    #     instance to which the network interface is attached.
    #
    #   * `network-interface.attachment.instance-owner-id` - The owner ID of
    #     the instance to which the network interface is attached.
    #
    #   * `network-interface.attachment.network-card-index` - The index of
    #     the network card.
    #
    #   * `network-interface.attachment.status` - The status of the
    #     attachment (`attaching` \| `attached` \| `detaching` \|
    #     `detached`).
    #
    #   * `network-interface.availability-zone` - The Availability Zone for
    #     the network interface.
    #
    #   * `network-interface.deny-all-igw-traffic` - A Boolean that
    #     indicates whether a network interface with an IPv6 address is
    #     unreachable from the public internet.
    #
    #   * `network-interface.description` - The description of the network
    #     interface.
    #
    #   * `network-interface.group-id` - The ID of a security group
    #     associated with the network interface.
    #
    #   * `network-interface.group-name` - The name of a security group
    #     associated with the network interface.
    #
    #   * `network-interface.ipv4-prefixes.ipv4-prefix` - The IPv4 prefixes
    #     that are assigned to the network interface.
    #
    #   * `network-interface.ipv6-address` - The IPv6 address associated
    #     with the network interface.
    #
    #   * `network-interface.ipv6-addresses.ipv6-address` - The IPv6 address
    #     associated with the network interface.
    #
    #   * `network-interface.ipv6-addresses.is-primary-ipv6` - A Boolean
    #     that indicates whether this is the primary IPv6 address.
    #
    #   * `network-interface.ipv6-native` - A Boolean that indicates whether
    #     this is an IPv6 only network interface.
    #
    #   * `network-interface.ipv6-prefixes.ipv6-prefix` - The IPv6 prefix
    #     assigned to the network interface.
    #
    #   * `network-interface.mac-address` - The MAC address of the network
    #     interface.
    #
    #   * `network-interface.network-interface-id` - The ID of the network
    #     interface.
    #
    #   * `network-interface.operator.managed` - A Boolean that indicates
    #     whether the instance has a managed network interface.
    #
    #   * `network-interface.operator.principal` - The principal that
    #     manages the network interface. Only valid for instances with
    #     managed network interfaces, where `managed` is `true`.
    #
    #   * `network-interface.outpost-arn` - The ARN of the Outpost.
    #
    #   * `network-interface.owner-id` - The ID of the owner of the network
    #     interface.
    #
    #   * `network-interface.private-dns-name` - The private DNS name of the
    #     network interface.
    #
    #   * `network-interface.private-ip-address` - The private IPv4 address.
    #
    #   * `network-interface.public-dns-name` - The public DNS name.
    #
    #   * `network-interface.requester-id` - The requester ID for the
    #     network interface.
    #
    #   * `network-interface.requester-managed` - Indicates whether the
    #     network interface is being managed by Amazon Web Services.
    #
    #   * `network-interface.status` - The status of the network interface
    #     (`available`) \| `in-use`).
    #
    #   * `network-interface.source-dest-check` - Whether the network
    #     interface performs source/destination checking. A value of `true`
    #     means that checking is enabled, and `false` means that checking is
    #     disabled. The value must be `false` for the network interface to
    #     perform network address translation (NAT) in your VPC.
    #
    #   * `network-interface.subnet-id` - The ID of the subnet for the
    #     network interface.
    #
    #   * `network-interface.tag-key` - The key of a tag assigned to the
    #     network interface.
    #
    #   * `network-interface.tag-value` - The value of a tag assigned to the
    #     network interface.
    #
    #   * `network-interface.vpc-id` - The ID of the VPC for the network
    #     interface.
    #
    #   * `network-performance-options.bandwidth-weighting` - Where the
    #     performance boost is applied, if applicable. Valid values:
    #     `default`, `vpc-1`, `ebs-1`.
    #
    #   * `operator.managed` - A Boolean that indicates whether this is a
    #     managed instance.
    #
    #   * `operator.principal` - The principal that manages the instance.
    #     Only valid for managed instances, where `managed` is `true`.
    #
    #   * `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
    #
    #   * `owner-id` - The Amazon Web Services account ID of the instance
    #     owner.
    #
    #   * `placement-group-name` - The name of the placement group for the
    #     instance.
    #
    #   * `placement-partition-number` - The partition in which the instance
    #     is located.
    #
    #   * `platform` - The platform. To list only Windows instances, use
    #     `windows`.
    #
    #   * `platform-details` - The platform (`Linux/UNIX` \| `Red Hat BYOL
    #     Linux` \| ` Red Hat Enterprise Linux` \| `Red Hat Enterprise Linux
    #     with HA` \| `Red Hat Enterprise Linux with High Availability` \|
    #     `Red Hat Enterprise Linux with SQL Server Standard and HA` \| `Red
    #     Hat Enterprise Linux with SQL Server Enterprise and HA` \| `Red
    #     Hat Enterprise Linux with SQL Server Standard` \| `Red Hat
    #     Enterprise Linux with SQL Server Web` \| `Red Hat Enterprise Linux
    #     with SQL Server Enterprise` \| `SQL Server Enterprise` \| `SQL
    #     Server Standard` \| `SQL Server Web` \| `SUSE Linux` \| `Ubuntu
    #     Pro` \| `Windows` \| `Windows BYOL` \| `Windows with SQL Server
    #     Enterprise` \| `Windows with SQL Server Standard` \| `Windows with
    #     SQL Server Web`).
    #
    #   * `private-dns-name` - The private IPv4 DNS name of the instance.
    #
    #   * `private-dns-name-options.enable-resource-name-dns-a-record` - A
    #     Boolean that indicates whether to respond to DNS queries for
    #     instance hostnames with DNS A records.
    #
    #   * `private-dns-name-options.enable-resource-name-dns-aaaa-record` -
    #     A Boolean that indicates whether to respond to DNS queries for
    #     instance hostnames with DNS AAAA records.
    #
    #   * `private-dns-name-options.hostname-type` - The type of hostname
    #     (`ip-name` \| `resource-name`).
    #
    #   * `private-ip-address` - The private IPv4 address of the instance.
    #     This can only be used to filter by the primary IP address of the
    #     network interface attached to the instance. To filter by
    #     additional IP addresses assigned to the network interface, use the
    #     filter `network-interface.addresses.private-ip-address`.
    #
    #   * `product-code` - The product code associated with the AMI used to
    #     launch the instance.
    #
    #   * `product-code.type` - The type of product code (`devpay` \|
    #     `marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `reason` - The reason for the current state of the instance (for
    #     example, shows "User Initiated \[date\]" when you stop or
    #     terminate the instance). Similar to the state-reason-code filter.
    #
    #   * `requester-id` - The ID of the entity that launched the instance
    #     on your behalf (for example, Amazon Web Services Management
    #     Console, Auto Scaling, and so on).
    #
    #   * `reservation-id` - The ID of the instance's reservation. A
    #     reservation ID is created any time you launch an instance. A
    #     reservation ID has a one-to-one relationship with an instance
    #     launch request, but can be associated with more than one instance
    #     if you launch multiple instances using the same launch request.
    #     For example, if you launch one instance, you get one reservation
    #     ID. If you launch ten instances using the same launch request, you
    #     also get one reservation ID.
    #
    #   * `root-device-name` - The device name of the root device volume
    #     (for example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `source-dest-check` - Indicates whether the instance performs
    #     source/destination checking. A value of `true` means that checking
    #     is enabled, and `false` means that checking is disabled. The value
    #     must be `false` for the instance to perform network address
    #     translation (NAT) in your VPC.
    #
    #   * `spot-instance-request-id` - The ID of the Spot Instance request.
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - A message that describes the state
    #     change.
    #
    #   * `subnet-id` - The ID of the subnet for the instance.
    #
    #   * `tag:<key>` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources that have a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `tenancy` - The tenancy of an instance (`dedicated` \| `default`
    #     \| `host`).
    #
    #   * `tpm-support` - Indicates if the instance is configured for
    #     NitroTPM support (`v2.0`).
    #
    #   * `usage-operation` - The usage operation value for the instance
    #     (`RunInstances` \| `RunInstances:00g0` \| `RunInstances:0010` \|
    #     `RunInstances:1010` \| `RunInstances:1014` \| `RunInstances:1110`
    #     \| `RunInstances:0014` \| `RunInstances:0210` \|
    #     `RunInstances:0110` \| `RunInstances:0100` \| `RunInstances:0004`
    #     \| `RunInstances:0200` \| `RunInstances:000g` \|
    #     `RunInstances:0g00` \| `RunInstances:0002` \| `RunInstances:0800`
    #     \| `RunInstances:0102` \| `RunInstances:0006` \|
    #     `RunInstances:0202`).
    #
    #   * `usage-operation-update-time` - The time that the usage operation
    #     was last updated, for example, `2022-09-15T17:15:20.000Z`.
    #
    #   * `virtualization-type` - The virtualization type of the instance
    #     (`paravirtual` \| `hvm`).
    #
    #   * `vpc-id` - The ID of the VPC that the instance is running in.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #   You cannot specify this parameter and the instance IDs parameter in
    #   the same request.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstancesRequest AWS API Documentation
    #
    class DescribeInstancesRequest < Struct.new(
      :instance_ids,
      :dry_run,
      :filters,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @!attribute [rw] reservations
    #   Information about the reservations.
    #   @return [Array<Types::Reservation>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstancesResult AWS API Documentation
    #
    class DescribeInstancesResult < Struct.new(
      :next_token,
      :reservations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token returned from a previous paginated request. Pagination
    #   continues from the end of the items returned by the previous
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] internet_gateway_ids
    #   The IDs of the internet gateways.
    #
    #   Default: Describes all your internet gateways.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `attachment.state` - The current state of the attachment between
    #     the gateway and the VPC (`available`). Present only if a VPC is
    #     attached.
    #
    #   * `attachment.vpc-id` - The ID of an attached VPC.
    #
    #   * `internet-gateway-id` - The ID of the Internet gateway.
    #
    #   * `owner-id` - The ID of the Amazon Web Services account that owns
    #     the internet gateway.
    #
    #   * `tag` - The key/value combination of a tag assigned to the
    #     resource. Use the tag key in the filter name and the tag value as
    #     the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGatewaysRequest AWS API Documentation
    #
    class DescribeInternetGatewaysRequest < Struct.new(
      :next_token,
      :max_results,
      :dry_run,
      :internet_gateway_ids,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] internet_gateways
    #   Information about the internet gateways.
    #   @return [Array<Types::InternetGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to include in another request to get the next page of
    #   items. This value is `null` when there are no more items to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGatewaysResult AWS API Documentation
    #
    class DescribeInternetGatewaysResult < Struct.new(
      :internet_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamByoasnRequest AWS API Documentation
    #
    class DescribeIpamByoasnRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoasns
    #   ASN and BYOIP CIDR associations.
    #   @return [Array<Types::Byoasn>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamByoasnResult AWS API Documentation
    #
    class DescribeIpamByoasnResult < Struct.new(
      :byoasns,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters for the request. For more information about
    #   filtering, see [Filtering CLI output][1].
    #
    #   Available filters:
    #
    #   * `ipam-arn`
    #
    #   * `ipam-external-resource-verification-token-arn`
    #
    #   * `ipam-external-resource-verification-token-id`
    #
    #   * `ipam-id`
    #
    #   * `ipam-region`
    #
    #   * `state`
    #
    #   * `status`
    #
    #   * `token-name`
    #
    #   * `token-value`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of tokens to return in one page of results.
    #   @return [Integer]
    #
    # @!attribute [rw] ipam_external_resource_verification_token_ids
    #   Verification token IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamExternalResourceVerificationTokensRequest AWS API Documentation
    #
    class DescribeIpamExternalResourceVerificationTokensRequest < Struct.new(
      :dry_run,
      :filters,
      :next_token,
      :max_results,
      :ipam_external_resource_verification_token_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] ipam_external_resource_verification_tokens
    #   Verification tokens.
    #   @return [Array<Types::IpamExternalResourceVerificationToken>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamExternalResourceVerificationTokensResult AWS API Documentation
    #
    class DescribeIpamExternalResourceVerificationTokensResult < Struct.new(
      :next_token,
      :ipam_external_resource_verification_tokens)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters for the IPAM policy description.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] ipam_policy_ids
    #   The IDs of the IPAM policies to describe.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPoliciesRequest AWS API Documentation
    #
    class DescribeIpamPoliciesRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token,
      :ipam_policy_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] ipam_policies
    #   Information about the IPAM policies.
    #
    #   An IPAM policy is a set of rules that define how public IPv4
    #   addresses from IPAM pools are allocated to Amazon Web Services
    #   resources. Each rule maps an Amazon Web Services service to IPAM
    #   pools that the service will use to get IP addresses. A single policy
    #   can have multiple rules and be applied to multiple Amazon Web
    #   Services Regions. If the IPAM pool run out of addresses then the
    #   services fallback to Amazon-provided IP addresses. A policy can be
    #   applied to an individual Amazon Web Services account or an entity
    #   within Amazon Web Services Organizations.
    #   @return [Array<Types::IpamPolicy>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPoliciesResult AWS API Documentation
    #
    class DescribeIpamPoliciesResult < Struct.new(
      :next_token,
      :ipam_policies)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters for the request. For more information about
    #   filtering, see [Filtering CLI output][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in the request.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] ipam_pool_ids
    #   The IDs of the IPAM pools you would like information on.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPoolsRequest AWS API Documentation
    #
    class DescribeIpamPoolsRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token,
      :ipam_pool_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] ipam_pools
    #   Information about the IPAM pools.
    #   @return [Array<Types::IpamPool>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPoolsResult AWS API Documentation
    #
    class DescribeIpamPoolsResult < Struct.new(
      :next_token,
      :ipam_pools)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters to limit the results.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] ipam_prefix_list_resolver_target_ids
    #   The IDs of the IPAM prefix list resolver Targets to describe. If not
    #   specified, all targets in your account are described.
    #   @return [Array<String>]
    #
    # @!attribute [rw] ipam_prefix_list_resolver_id
    #   The ID of the IPAM prefix list resolver to filter targets by. Only
    #   targets associated with this resolver will be returned.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPrefixListResolverTargetsRequest AWS API Documentation
    #
    class DescribeIpamPrefixListResolverTargetsRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token,
      :ipam_prefix_list_resolver_target_ids,
      :ipam_prefix_list_resolver_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] ipam_prefix_list_resolver_targets
    #   Information about the IPAM prefix list resolver Targets.
    #   @return [Array<Types::IpamPrefixListResolverTarget>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPrefixListResolverTargetsResult AWS API Documentation
    #
    class DescribeIpamPrefixListResolverTargetsResult < Struct.new(
      :next_token,
      :ipam_prefix_list_resolver_targets)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters to limit the results.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. To get the
    #   next page of items, make another request with the token returned in
    #   the output. For more information, see [Pagination][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] ipam_prefix_list_resolver_ids
    #   The IDs of the IPAM prefix list resolvers to describe. If not
    #   specified, all resolvers in your account are described.