import type { BuildConfiguration } from "./config-types.d";
/**
 * A class that represents the manifest file.
 */
export declare class Manifest {
    private buildDir;
    private manifest;
    /**
     * Create a new manifest from the build directory.
     *
     * @param buildDir - The directory containing the build artifacts. It should contain a `manifest.json` file.
     */
    constructor(buildDir: string);
    /**
     * Find the compatible configs for the current runtime.
     *
     * @param platform - The platform of the current runtime.
     * @returns The compatible configs.
     */
    findCompatibleConfigs(platform: Platform): [BuildConfiguration, string][];
    /**
     * Get the config keys from the manifest in the string format.
     *
     * @returns The config keys in the string format.
     */
    getConfigKeys(): string[];
    /**
     * Get the config from the manifest.
     *
     * @param configKey - The key of the config.
     * @returns The config.
     */
    getConfig(configKey: string): BuildConfiguration;
    /**
     * Get the addon path from the manifest.
     *
     * @param configKey - The key of the config.
     * @returns The addon path.
     */
    getAddonPath(configKey: string): string;
}
/**
 * Get the platform of the current runtime.
 *
 * @returns The platform of the current runtime.
 */
export declare function getPlatform(): Platform;
/**
 * The platform of the current runtime.
 */
export type Platform = {
    os: string;
    arch: string;
    libc: string;
};
