'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function degreesToRadians(degrees) {
  return degrees * Math.PI / 180;
}
function valueBetween(value, min, max) {
  if (value > max) return max;
  if (value < min) return min;
  return value;
}
function extractPercentage(value, percentage) {
  return percentage / 100 * value;
}
function bisectorAngle(startAngle, lengthAngle) {
  return startAngle + lengthAngle / 2;
}
function shiftVectorAlongAngle(angle, distance) {
  var angleRadians = degreesToRadians(angle);
  return {
    dx: distance * Math.cos(angleRadians),
    dy: distance * Math.sin(angleRadians)
  };
}
function isNumber(value) {
  return typeof value === 'number';
}
function functionProp(prop, payload) {
  return typeof prop === 'function' ? prop(payload) : prop;
}

function sumValues(data) {
  var sum = 0;

  for (var i = 0; i < data.length; i++) {
    sum += data[i].value;
  }

  return sum;
} // Append "percentage", "degrees" and "startAngle" to each data entry


function extendData(_ref) {
  var data = _ref.data,
      totalAngle = _ref.lengthAngle,
      totalValue = _ref.totalValue,
      paddingAngle = _ref.paddingAngle,
      chartStartAngle = _ref.startAngle;
  var total = totalValue || sumValues(data);
  var normalizedTotalAngle = valueBetween(totalAngle, -360, 360);
  var numberOfPaddings = Math.abs(normalizedTotalAngle) === 360 ? data.length : data.length - 1;
  var singlePaddingDegrees = Math.abs(paddingAngle) * Math.sign(totalAngle);
  var degreesTakenByPadding = singlePaddingDegrees * numberOfPaddings;
  var degreesTakenByPaths = normalizedTotalAngle - degreesTakenByPadding;
  var lastSegmentEnd = 0;
  var extendedData = []; // @NOTE: Shall we evaluate percentage accordingly to dataEntry.value's sign?

  for (var i = 0; i < data.length; i++) {
    var dataEntry = data[i];
    var valueInPercentage = total === 0 ? 0 : dataEntry.value / total * 100;
    var degrees = extractPercentage(degreesTakenByPaths, valueInPercentage);
    var startAngle = lastSegmentEnd + chartStartAngle;
    lastSegmentEnd = lastSegmentEnd + degrees + singlePaddingDegrees;
    extendedData.push(Object.assign({
      percentage: valueInPercentage,
      startAngle: startAngle,
      degrees: degrees
    }, dataEntry));
  }

  return extendedData;
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function ReactMinimalPieChartLabel(_ref) {
  _ref.dataEntry;
      _ref.dataIndex;
      var props = _objectWithoutPropertiesLoose(_ref, ["dataEntry", "dataIndex"]);

  return /*#__PURE__*/React__default['default'].createElement("text", Object.assign({
    dominantBaseline: "central"
  }, props));
}

function round(number) {
  var divisor = 1e14; // 14 decimals

  return Math.round((number + Number.EPSILON) * divisor) / divisor;
}

function evaluateTextAnchorPosition(_ref) {
  var labelPosition = _ref.labelPosition,
      lineWidth = _ref.lineWidth,
      labelHorizontalShift = _ref.labelHorizontalShift;
  var dx = round(labelHorizontalShift); // Label in the vertical center

  if (dx === 0) {
    return 'middle';
  } // Outward label


  if (labelPosition > 100) {
    return dx > 0 ? 'start' : 'end';
  } // Inward label


  var innerRadius = 100 - lineWidth;

  if (labelPosition < innerRadius) {
    return dx > 0 ? 'end' : 'start';
  } // Overlying label


  return 'middle';
}

function renderLabelElement(renderLabel, labelProps) {
  var label = renderLabel(labelProps);

  if (typeof label === 'string' || typeof label === 'number') {
    return /*#__PURE__*/React__default['default'].createElement(ReactMinimalPieChartLabel, Object.assign({
      key: "label-" + (labelProps.dataEntry.key || labelProps.dataIndex)
    }, labelProps), label);
  }

  if (React__default['default'].isValidElement(label)) {
    return label;
  }

  return null;
}

function renderLabels(data, props) {
  return data.map(function (dataEntry, index) {
    var _functionProp;

    var segmentsShift = (_functionProp = functionProp(props.segmentsShift, index)) != null ? _functionProp : 0;
    var distanceFromCenter = extractPercentage(props.radius, props.labelPosition) + segmentsShift;

    var _shiftVectorAlongAngl = shiftVectorAlongAngle(bisectorAngle(dataEntry.startAngle, dataEntry.degrees), distanceFromCenter),
        dx = _shiftVectorAlongAngl.dx,
        dy = _shiftVectorAlongAngl.dy; // This object is passed as argument to the "label" function prop


    var labelRenderProps = {
      x: props.center[0],
      y: props.center[1],
      dx: dx,
      dy: dy,
      textAnchor: evaluateTextAnchorPosition({
        labelPosition: props.labelPosition,
        lineWidth: props.lineWidth,
        labelHorizontalShift: dx
      }),
      dataEntry: dataEntry,
      dataIndex: index,
      style: functionProp(props.labelStyle, index)
    };
    return props.label && renderLabelElement(props.label, labelRenderProps);
  });
}

var partialCircle = function partialCircle(cx, cy, r, start, end) {
  var length = end - start;
  if (length === 0) return [];
  var fromX = r * Math.cos(start) + cx;
  var fromY = r * Math.sin(start) + cy;
  var toX = r * Math.cos(end) + cx;
  var toY = r * Math.sin(end) + cy;
  var large = Math.abs(length) <= Math.PI ? '0' : '1';
  var sweep = length < 0 ? '0' : '1';
  return [['M', fromX, fromY], ['A', r, r, 0, large, sweep, toX, toY]];
};

var svgPartialCircle = partialCircle;

function makePathCommands(cx, cy, startAngle, lengthAngle, radius) {
  var patchedLengthAngle = valueBetween(lengthAngle, -359.999, 359.999);
  return svgPartialCircle(cx, cy, // center X and Y
  radius, degreesToRadians(startAngle), degreesToRadians(startAngle + patchedLengthAngle)).map(function (command) {
    return command.join(' ');
  }).join(' ');
}
function ReactMinimalPieChartPath(_ref) {
  var cx = _ref.cx,
      cy = _ref.cy,
      lengthAngle = _ref.lengthAngle,
      lineWidth = _ref.lineWidth,
      radius = _ref.radius,
      _ref$shift = _ref.shift,
      shift = _ref$shift === void 0 ? 0 : _ref$shift,
      reveal = _ref.reveal,
      rounded = _ref.rounded,
      startAngle = _ref.startAngle,
      title = _ref.title,
      props = _objectWithoutPropertiesLoose(_ref, ["cx", "cy", "lengthAngle", "lineWidth", "radius", "shift", "reveal", "rounded", "startAngle", "title"]);

  var pathRadius = radius - lineWidth / 2; //@NOTE This shift might be rendered as a translation in future

  var _shiftVectorAlongAngl = shiftVectorAlongAngle(bisectorAngle(startAngle, lengthAngle), shift),
      dx = _shiftVectorAlongAngl.dx,
      dy = _shiftVectorAlongAngl.dy;

  var pathCommands = makePathCommands(cx + dx, cy + dy, startAngle, lengthAngle, pathRadius);
  var strokeDasharray;
  var strokeDashoffset; // Animate/hide paths with "stroke-dasharray" + "stroke-dashoffset"
  // https://css-tricks.com/svg-line-animation-works/

  if (isNumber(reveal)) {
    var pathLength = degreesToRadians(pathRadius) * lengthAngle;
    strokeDasharray = Math.abs(pathLength);
    strokeDashoffset = strokeDasharray - extractPercentage(strokeDasharray, reveal);
  }

  return /*#__PURE__*/React__default['default'].createElement("path", Object.assign({
    d: pathCommands,
    fill: "none",
    strokeWidth: lineWidth,
    strokeDasharray: strokeDasharray,
    strokeDashoffset: strokeDashoffset,
    strokeLinecap: rounded ? 'round' : undefined
  }, props), title && /*#__PURE__*/React__default['default'].createElement("title", null, title));
}

function combineSegmentTransitionsStyle(duration, easing, customStyle) {
  // Merge chart's animation CSS transition with "transition" found to customStyle
  var transition = "stroke-dashoffset " + duration + "ms " + easing;

  if (customStyle && customStyle.transition) {
    transition = transition + "," + customStyle.transition;
  }

  return {
    transition: transition
  };
}

function getRevealValue(props) {
  //@NOTE When animation is on, chart has to be fully revealed when reveal is not set
  if (props.animate && !isNumber(props.reveal)) {
    return 100;
  }

  return props.reveal;
}

function makeEventHandler(eventHandler, payload) {
  return eventHandler && function (e) {
    eventHandler(e, payload);
  };
}

function renderSegments(data, props, revealOverride) {
  // @NOTE this should go in Path component. Here for performance reasons
  var reveal = revealOverride != null ? revealOverride : getRevealValue(props);
  var radius = props.radius,
      _props$center = props.center,
      cx = _props$center[0],
      cy = _props$center[1];
  var lineWidth = extractPercentage(radius, props.lineWidth);
  var paths = data.map(function (dataEntry, index) {
    var segmentsStyle = functionProp(props.segmentsStyle, index);
    return /*#__PURE__*/React__default['default'].createElement(ReactMinimalPieChartPath, {
      cx: cx,
      cy: cy,
      key: dataEntry.key || index,
      lengthAngle: dataEntry.degrees,
      lineWidth: lineWidth,
      radius: radius,
      rounded: props.rounded,
      reveal: reveal,
      shift: functionProp(props.segmentsShift, index),
      startAngle: dataEntry.startAngle,
      title: dataEntry.title,
      style: Object.assign({}, segmentsStyle, props.animate && combineSegmentTransitionsStyle(props.animationDuration, props.animationEasing, segmentsStyle)),
      stroke: dataEntry.color,
      tabIndex: props.segmentsTabIndex,
      onBlur: makeEventHandler(props.onBlur, index),
      onClick: makeEventHandler(props.onClick, index),
      onFocus: makeEventHandler(props.onFocus, index),
      onKeyDown: makeEventHandler(props.onKeyDown, index),
      onMouseOver: makeEventHandler(props.onMouseOver, index),
      onMouseOut: makeEventHandler(props.onMouseOut, index)
    });
  });

  if (props.background) {
    paths.unshift( /*#__PURE__*/React__default['default'].createElement(ReactMinimalPieChartPath, {
      cx: cx,
      cy: cy,
      key: "bg",
      lengthAngle: props.lengthAngle,
      lineWidth: lineWidth,
      radius: radius,
      rounded: props.rounded,
      startAngle: props.startAngle,
      stroke: props.background
    }));
  }

  return paths;
}

var defaultProps = {
  animationDuration: 500,
  animationEasing: 'ease-out',
  center: [50, 50],
  data: [],
  labelPosition: 50,
  lengthAngle: 360,
  lineWidth: 100,
  paddingAngle: 0,
  radius: 50,
  startAngle: 0,
  viewBoxSize: [100, 100]
};
function ReactMinimalPieChart(props) {
  var _useState = React.useState(props.animate ? 0 : null),
      revealOverride = _useState[0],
      setRevealOverride = _useState[1];

  React.useEffect(function () {
    if (props.animate) {
      return startInitialAnimation();
    }

    function startInitialAnimation() {
      var animationTimerId;
      var animationRAFId;
      animationTimerId = setTimeout(function () {
        animationTimerId = null;
        animationRAFId = requestAnimationFrame(function () {
          animationRAFId = null;
          setRevealOverride(null); // Start animation
        });
      });
      return function () {
        animationTimerId && clearTimeout(animationTimerId);
        animationRAFId && cancelAnimationFrame(animationRAFId);
      };
    }
  }, []);
  var extendedData = extendData(props);
  return /*#__PURE__*/React__default['default'].createElement("svg", {
    viewBox: "0 0 " + props.viewBoxSize[0] + " " + props.viewBoxSize[1],
    width: "100%",
    height: "100%",
    className: props.className,
    style: props.style
  }, renderSegments(extendedData, props, revealOverride), props.label && renderLabels(extendedData, props), props.children);
}
ReactMinimalPieChart.defaultProps = defaultProps;

exports.PieChart = ReactMinimalPieChart;
//# sourceMappingURL=index.js.map
