/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Pool {
    protected Client client;
    protected String elementName;
    protected String infoMethod;
    protected NodeList poolElements;
    protected static XPath xpath;
    public static final int ALL = -2;
    public static final int MINE = -3;
    public static final int MINE_GROUP = -1;
    public static final int GROUP = -4;

    protected Pool(String string, Client client, String string2) {
        this.elementName = string;
        this.infoMethod = string2;
        this.client = client;
        if (xpath == null) {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            xpath = xPathFactory.newXPath();
        }
    }

    public abstract PoolElement factory(Node var1);

    protected static OneResponse info(Client client, String string) {
        return Pool.xmlrpcInfo(client, string, new Object[0]);
    }

    protected static OneResponse info(Client client, String string, int n, int n2, int n3) {
        return Pool.xmlrpcInfo(client, string, n, n2, n3);
    }

    protected static OneResponse infoAll(Client client, String string) {
        return Pool.xmlrpcInfo(client, string, -2, -1, -1);
    }

    protected static OneResponse infoMine(Client client, String string) {
        return Pool.xmlrpcInfo(client, string, -3, -1, -1);
    }

    protected static OneResponse infoGroup(Client client, String string) {
        return Pool.xmlrpcInfo(client, string, -1, -1, -1);
    }

    protected static OneResponse infoGroupPrimary(Client client, String string) {
        return Pool.xmlrpcInfo(client, string, -4, -1, -1);
    }

    protected static OneResponse xmlrpcInfo(Client client, String string, Object ... objectArray) {
        return client.call(string, objectArray);
    }

    protected OneResponse info() {
        OneResponse oneResponse = Pool.info(this.client, this.infoMethod);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    protected OneResponse infoAll() {
        OneResponse oneResponse = Pool.infoAll(this.client, this.infoMethod);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    protected OneResponse infoMine() {
        OneResponse oneResponse = Pool.infoMine(this.client, this.infoMethod);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    protected OneResponse infoGroup() {
        OneResponse oneResponse = Pool.infoGroup(this.client, this.infoMethod);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    protected OneResponse info(int n, int n2, int n3) {
        OneResponse oneResponse = Pool.info(this.client, this.infoMethod, n, n2, n3);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    protected void processInfo(OneResponse oneResponse) {
        if (oneResponse.isError()) {
            return;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(oneResponse.getMessage().getBytes("UTF-8")));
            Element element = document.getDocumentElement();
            this.poolElements = (NodeList)xpath.evaluate(this.elementName, element, XPathConstants.NODESET);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    public PoolElement item(int n) {
        Node node;
        PoolElement poolElement = null;
        if (this.poolElements != null && (node = this.poolElements.item(n)) != null) {
            poolElement = this.factory(node);
        }
        return poolElement;
    }

    protected PoolElement getById(int n) {
        PoolElement poolElement = null;
        PoolElement poolElement2 = null;
        for (int i = 0; i < this.getLength(); ++i) {
            poolElement2 = this.item(i);
            if (poolElement2.id() != n) continue;
            poolElement = poolElement2;
            break;
        }
        return poolElement;
    }

    public int getLength() {
        return this.poolElements == null ? 0 : this.poolElements.getLength();
    }
}

