/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.datastore;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class Datastore
extends PoolElement {
    private static final String METHOD_PREFIX = "datastore.";
    private static final String INFO = "datastore.info";
    private static final String ALLOCATE = "datastore.allocate";
    private static final String DELETE = "datastore.delete";
    private static final String UPDATE = "datastore.update";
    private static final String CHOWN = "datastore.chown";
    private static final String CHMOD = "datastore.chmod";
    private static final String RENAME = "datastore.rename";
    private static final String ENABLE = "datastore.enable";
    private static final String[] DATASTORE_TYPES = new String[]{"IMAGE", "SYSTEM", "FILE"};
    private static final String[] SHORT_DATASTORE_TYPES = new String[]{"img", "sys", "fil"};
    private static final String[] DATASTORE_STATES = new String[]{"READY", "DISABLED"};
    private static final String[] SHORT_DATASTORE_STATES = new String[]{"rdy", "disa"};

    public Datastore(int n, Client client) {
        super(n, client);
    }

    protected Datastore(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string, int n) {
        return client.call(ALLOCATE, string, n);
    }

    public static OneResponse allocate(Client client, String string) {
        return Datastore.allocate(client, string, -1);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse publish(Client client, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return Datastore.chmod(client, n, -1, -1, -1, n2, -1, -1, -1, -1, -1);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return Datastore.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return Datastore.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return Datastore.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse enable(Client client, int n, boolean bl) {
        return client.call(ENABLE, n, bl);
    }

    public OneResponse info() {
        OneResponse oneResponse = Datastore.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return Datastore.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return Datastore.update(this.client, this.id, string, bl);
    }

    public OneResponse publish(boolean bl) {
        return Datastore.publish(this.client, this.id, bl);
    }

    public OneResponse publish() {
        return this.publish(true);
    }

    public OneResponse unpublish() {
        return this.publish(false);
    }

    public OneResponse chown(int n, int n2) {
        return Datastore.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Datastore.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return Datastore.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return Datastore.chmod(this.client, this.id, n);
    }

    public OneResponse rename(String string) {
        return Datastore.rename(this.client, this.id, string);
    }

    public OneResponse enable(boolean bl) {
        return Datastore.enable(this.client, this.id, bl);
    }

    public OneResponse enable() {
        return this.enable(true);
    }

    public OneResponse disable() {
        return this.enable(false);
    }

    public int type() {
        String string = this.xpath("TYPE");
        return string != null ? Integer.parseInt(string) : -1;
    }

    public String typeStr() {
        int n = this.type();
        return n != -1 ? DATASTORE_TYPES[n] : null;
    }

    public String shortTypeStr() {
        int n = this.type();
        return n != -1 ? SHORT_DATASTORE_TYPES[n] : null;
    }

    @Override
    public int state() {
        String string = this.xpath("STATE");
        return string != null ? Integer.parseInt(string) : -1;
    }

    public String stateStr() {
        int n = this.state();
        return n != -1 ? DATASTORE_STATES[n] : null;
    }

    public String shortStateStr() {
        int n = this.state();
        return n != -1 ? SHORT_DATASTORE_STATES[n] : null;
    }

    public boolean contains(int n) {
        String string = this.xpath("IMAGES/ID[.=" + n + "]");
        return string != null && string.equals("" + n);
    }
}

