/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.group;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class Group
extends PoolElement {
    private static final String METHOD_PREFIX = "group.";
    private static final String ALLOCATE = "group.allocate";
    private static final String INFO = "group.info";
    private static final String DELETE = "group.delete";
    private static final String QUOTA = "group.quota";
    private static final String UPDATE = "group.update";
    private static final String ADD_ADMIN = "group.addadmin";
    private static final String DEL_ADMIN = "group.deladmin";

    public Group(int n, Client client) {
        super(n, client);
    }

    protected Group(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse setQuota(Client client, int n, String string) {
        return client.call(QUOTA, n, string);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse addAdmin(Client client, int n, int n2) {
        return client.call(ADD_ADMIN, n, n2);
    }

    public static OneResponse delAdmin(Client client, int n, int n2) {
        return client.call(DEL_ADMIN, n, n2);
    }

    public OneResponse info() {
        OneResponse oneResponse = Group.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return Group.delete(this.client, this.id);
    }

    public OneResponse setQuota(String string) {
        return Group.setQuota(this.client, this.id, string);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return Group.update(this.client, this.id, string, bl);
    }

    public OneResponse addAdmin(int n) {
        return Group.addAdmin(this.client, this.id, n);
    }

    public OneResponse delAdmin(int n) {
        return Group.delAdmin(this.client, this.id, n);
    }

    public boolean contains(int n) {
        String string = this.xpath("USERS/ID[.=" + n + "]");
        return string != null && string.equals("" + n);
    }

    public boolean containsAdmin(int n) {
        String string = this.xpath("ADMINS/ID[.=" + n + "]");
        return string != null && string.equals("" + n);
    }
}

