/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.hook;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class Hook
extends PoolElement {
    private static final String METHOD_PREFIX = "hook.";
    private static final String ALLOCATE = "hook.allocate";
    private static final String INFO = "hook.info";
    private static final String DELETE = "hook.delete";
    private static final String UPDATE = "hook.update";
    private static final String RENAME = "hook.rename";
    private static final String LOCK = "hook.lock";
    private static final String UNLOCK = "hook.unlock";
    private static final String RETRY = "hook.retry";

    public Hook(int n, Client client) {
        super(n, client);
    }

    protected Hook(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n, false);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n, false);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public static OneResponse retry(Client client, int n, int n2) {
        return client.call(RETRY, n, n2);
    }

    public OneResponse info() {
        OneResponse oneResponse = Hook.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return Hook.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return Hook.update(this.client, this.id, string, bl);
    }

    public OneResponse rename(String string) {
        return Hook.rename(this.client, this.id, string);
    }

    public OneResponse lock(int n) {
        return Hook.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return Hook.unlock(this.client, this.id);
    }

    public OneResponse retry(int n) {
        return Hook.retry(this.client, this.id, n);
    }
}

