/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.host;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class Host
extends PoolElement {
    private static final String METHOD_PREFIX = "host.";
    private static final String ALLOCATE = "host.allocate";
    private static final String INFO = "host.info";
    private static final String DELETE = "host.delete";
    private static final String STATUS = "host.status";
    private static final String UPDATE = "host.update";
    private static final String MONITORING = "host.monitoring";
    private static final String RENAME = "host.rename";
    private static final String[] HOST_STATES = new String[]{"INIT", "MONITORING_MONITORED", "MONITORED", "ERROR", "DISABLED", "MONITORING_ERROR", "MONITORING_INIT", "MONITORING_DISABLED", "OFFLINE"};
    private static final String[] SHORT_HOST_STATES = new String[]{"init", "update", "on", "err", "dsbl", "retry", "init", "dsbl", "off"};

    public Host(int n, Client client) {
        super(n, client);
    }

    protected Host(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string, String string2, String string3, int n) {
        return client.call(ALLOCATE, string, string2, string3, n);
    }

    public static OneResponse allocate(Client client, String string, String string2, String string3) {
        return Host.allocate(client, string, string2, string3, -1);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse status(Client client, int n, Status status) {
        return client.call(STATUS, n, status.code());
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse monitoring(Client client, int n) {
        return client.call(MONITORING, n);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public OneResponse info() {
        OneResponse oneResponse = Host.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return Host.delete(this.client, this.id);
    }

    public OneResponse enable() {
        return Host.status(this.client, this.id, Status.ENABLED);
    }

    public OneResponse disable() {
        return Host.status(this.client, this.id, Status.DISABLED);
    }

    public OneResponse offline() {
        return Host.status(this.client, this.id, Status.OFFLINE);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return Host.update(this.client, this.id, string, bl);
    }

    public OneResponse monitoring() {
        return Host.monitoring(this.client, this.id);
    }

    public OneResponse rename(String string) {
        return Host.rename(this.client, this.id, string);
    }

    public String stateStr() {
        int n = this.state();
        return n != -1 ? HOST_STATES[this.state()] : null;
    }

    public String shortStateStr() {
        int n = this.state();
        return n != -1 ? SHORT_HOST_STATES[this.state()] : null;
    }

    public boolean isEnabled() {
        return this.state() != 4;
    }

    public static enum Status {
        ENABLED,
        DISABLED,
        OFFLINE;


        public int code() {
            switch (this) {
                case ENABLED: {
                    return 0;
                }
                case DISABLED: {
                    return 1;
                }
                case OFFLINE: {
                    return 2;
                }
            }
            return -1;
        }
    }
}

