/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.marketplace;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class MarketPlace
extends PoolElement {
    private static final String METHOD_PREFIX = "market.";
    private static final String INFO = "market.info";
    private static final String ALLOCATE = "market.allocate";
    private static final String DELETE = "market.delete";
    private static final String UPDATE = "market.update";
    private static final String CHOWN = "market.chown";
    private static final String CHMOD = "market.chmod";
    private static final String RENAME = "market.rename";
    private static final String ENABLE = "market.enable";

    public MarketPlace(int n, Client client) {
        super(n, client);
    }

    protected MarketPlace(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return MarketPlace.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return MarketPlace.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return MarketPlace.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse enable(Client client, int n, boolean bl) {
        return client.call(ENABLE, n, bl);
    }

    public OneResponse info() {
        OneResponse oneResponse = MarketPlace.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return MarketPlace.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return MarketPlace.update(this.client, this.id, string, bl);
    }

    public OneResponse chown(int n, int n2) {
        return MarketPlace.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return MarketPlace.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return MarketPlace.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return MarketPlace.chmod(this.client, this.id, n);
    }

    public OneResponse rename(String string) {
        return MarketPlace.rename(this.client, this.id, string);
    }

    public OneResponse enable(boolean bl) {
        return MarketPlace.enable(this.client, this.id, bl);
    }

    public boolean contains(int n) {
        String string = this.xpath("MARKETPLACEAPPS/ID[.=" + n + "]");
        return string != null && string.equals("" + n);
    }
}

