/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vm;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class VirtualMachine
extends PoolElement {
    private static final String METHOD_PREFIX = "vm.";
    private static final String ALLOCATE = "vm.allocate";
    private static final String INFO = "vm.info";
    private static final String DEPLOY = "vm.deploy";
    private static final String ACTION = "vm.action";
    private static final String MIGRATE = "vm.migrate";
    private static final String CHOWN = "vm.chown";
    private static final String CHMOD = "vm.chmod";
    private static final String MONITORING = "vm.monitoring";
    private static final String ATTACH = "vm.attach";
    private static final String DETACH = "vm.detach";
    private static final String RENAME = "vm.rename";
    private static final String UPDATE = "vm.update";
    private static final String RESIZE = "vm.resize";
    private static final String ATTACHNIC = "vm.attachnic";
    private static final String DETACHNIC = "vm.detachnic";
    private static final String UPDATENIC = "vm.updatenic";
    private static final String SNAPSHOTCREATE = "vm.snapshotcreate";
    private static final String SNAPSHOTREVERT = "vm.snapshotrevert";
    private static final String SNAPSHOTDELETE = "vm.snapshotdelete";
    private static final String RECOVER = "vm.recover";
    private static final String DISKSAVEAS = "vm.disksaveas";
    private static final String DISKSNAPSHOTCREATE = "vm.disksnapshotcreate";
    private static final String DISKSNAPSHOTREVERT = "vm.disksnapshotrevert";
    private static final String DISKSNAPSHOTDELETE = "vm.disksnapshotdelete";
    private static final String DISKSNAPSHOTRENAME = "vm.disksnapshotrename";
    private static final String DISKRESIZE = "vm.diskresize";
    private static final String UPDATECONF = "vm.updateconf";
    private static final String SCHEDADD = "vm.schedadd";
    private static final String SCHEDDELETE = "vm.scheddelete";
    private static final String SCHEDUPDATE = "vm.schedupdate";
    private static final String LOCK = "vm.lock";
    private static final String UNLOCK = "vm.unlock";
    private static final String ATTACHSG = "vm.attachsg";
    private static final String DETACHSG = "vm.detachsg";
    private static final String ATTACHPCI = "vm.attachpci";
    private static final String DETACHPCI = "vm.detachpci";
    private static final String BACKUP = "vm.backup";
    private static final String BACKUPCANCEL = "vm.backupcancel";
    private static final String RESTORE = "vm.restore";
    private static final String EXEC = "vm.exec";
    private static final String EXEC_RETRY = "vm.exec_retry";
    private static final String EXEC_CANCEL = "vm.exec_cancel";
    private static final String[] VM_STATES = new String[]{"INIT", "PENDING", "HOLD", "ACTIVE", "STOPPED", "SUSPENDED", "DONE", "FAILED", "POWEROFF", "UNDEPLOYED", "CLONING", "CLONING_FAILURE"};
    private static final String[] SHORT_VM_STATES = new String[]{"init", "pend", "hold", "actv", "stop", "susp", "done", "fail", "poff", "unde", "clon", "fail"};
    private static final String[] LCM_STATE = new String[]{"LCM_INIT", "PROLOG", "BOOT", "RUNNING", "MIGRATE", "SAVE_STOP", "SAVE_SUSPEND", "SAVE_MIGRATE", "PROLOG_MIGRATE", "PROLOG_RESUME", "EPILOG_STOP", "EPILOG", "SHUTDOWN", "CANCEL", "FAILURE", "CLEANUP_RESUBMIT", "UNKNOWN", "HOTPLUG", "SHUTDOWN_POWEROFF", "BOOT_UNKNOWN", "BOOT_POWEROFF", "BOOT_SUSPENDED", "BOOT_STOPPED", "CLEANUP_DELETE", "HOTPLUG_SNAPSHOT", "HOTPLUG_NIC", "HOTPLUG_SAVEAS", "HOTPLUG_SAVEAS_POWEROFF", "HOTPLUG_SAVEAS_SUSPENDED", "SHUTDOWN_UNDEPLOY", "EPILOG_UNDEPLOY", "PROLOG_UNDEPLOY", "BOOT_UNDEPLOY", "HOTPLUG_PROLOG_POWEROFF", "HOTPLUG_EPILOG_POWEROFF", "BOOT_MIGRATE", "BOOT_FAILURE", "BOOT_MIGRATE_FAILURE", "PROLOG_MIGRATE_FAILURE", "PROLOG_FAILURE", "EPILOG_FAILURE", "EPILOG_STOP_FAILURE", "EPILOG_UNDEPLOY_FAILURE", "PROLOG_MIGRATE_POWEROFF", "PROLOG_MIGRATE_POWEROFF_FAILURE", "PROLOG_MIGRATE_SUSPEND", "PROLOG_MIGRATE_SUSPEND_FAILURE", "BOOT_UNDEPLOY_FAILURE", "BOOT_STOPPED_FAILURE", "PROLOG_RESUME_FAILURE", "PROLOG_UNDEPLOY_FAILURE", "DISK_SNAPSHOT_POWEROFF", "DISK_SNAPSHOT_REVERT_POWEROFF", "DISK_SNAPSHOT_DELETE_POWEROFF", "DISK_SNAPSHOT_SUSPENDED", "DISK_SNAPSHOT_REVERT_SUSPENDED", "DISK_SNAPSHOT_DELETE_SUSPENDED", "DISK_SNAPSHOT", "DISK_SNAPSHOT_REVERT", "DISK_SNAPSHOT_DELETE", "PROLOG_MIGRATE_UNKNOWN", "PROLOG_MIGRATE_UNKNOWN_FAILURE", "DISK_RESIZE", "DISK_RESIZE_POWEROFF", "DISK_RESIZE_UNDEPLOYED", "HOTPLUG_NIC_POWEROFF", "HOTPLUG_RESIZE", "HOTPLUG_SAVEAS_UNDEPLOYED", "HOTPLUG_SAVEAS_STOPPED", "BACKUP", "BACKUP_POWEROFF", "RESTORE"};
    private static final String[] SHORT_LCM_STATES = new String[]{"", "prol", "boot", "runn", "migr", "save", "save", "save", "migr", "prol", "epil", "epil", "shut", "shut", "fail", "clea", "unkn", "hotp", "shut", "boot", "boot", "boot", "boot", "clea", "snap", "hotp", "hotp", "hotp", "hotp", "shut", "epil", "prol", "boot", "hotp", "hotp", "boot", "fail", "fail", "fail", "fail", "fail", "fail", "fail", "migr", "fail", "migr", "fail", "fail", "fail", "fail", "fail", "snap", "snap", "snap", "snap", "snap", "snap", "snap", "snap", "snap", "migr", "fail", "drsz", "drsz", "drsz", "hotp", "hotp", "hotp", "hotp", "back", "back", "rest"};

    public VirtualMachine(int n, Client client) {
        super(n, client);
    }

    protected VirtualMachine(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return VirtualMachine.allocate(client, string, false);
    }

    public static OneResponse allocate(Client client, String string, boolean bl) {
        return client.call(ALLOCATE, string, bl);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse resize(Client client, int n, String string, boolean bl) {
        return client.call(RESIZE, n, string, bl);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return VirtualMachine.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return VirtualMachine.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return VirtualMachine.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse monitoring(Client client, int n) {
        return client.call(MONITORING, n);
    }

    public static OneResponse diskAttach(Client client, int n, String string) {
        return client.call(ATTACH, n, string);
    }

    public static OneResponse diskDetach(Client client, int n, int n2) {
        return client.call(DETACH, n, n2);
    }

    public static OneResponse diskSaveas(Client client, int n, int n2, String string, String string2, int n3) {
        return client.call(DISKSAVEAS, n, n2, string, string2, n3);
    }

    public static OneResponse nicAttach(Client client, int n, String string) {
        return client.call(ATTACHNIC, n, string);
    }

    public static OneResponse nicDetach(Client client, int n, int n2) {
        return client.call(DETACHNIC, n, n2);
    }

    public static OneResponse nicUpdate(Client client, int n, int n2, String string, boolean bl) {
        return client.call(UPDATENIC, n, n2, string, bl ? 1 : 0);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse snapshotCreate(Client client, int n, String string) {
        return client.call(SNAPSHOTCREATE, n, string);
    }

    public static OneResponse snapshotRevert(Client client, int n, int n2) {
        return client.call(SNAPSHOTREVERT, n, n2);
    }

    public static OneResponse snapshotDelete(Client client, int n, int n2) {
        return client.call(SNAPSHOTDELETE, n, n2);
    }

    public static OneResponse diskSnapshotCreate(Client client, int n, int n2, String string) {
        return client.call(DISKSNAPSHOTCREATE, n, n2, string);
    }

    public static OneResponse diskSnapshotRevert(Client client, int n, int n2, int n3) {
        return client.call(DISKSNAPSHOTREVERT, n, n2, n3);
    }

    public static OneResponse diskSnapshotDelete(Client client, int n, int n2, int n3) {
        return client.call(DISKSNAPSHOTDELETE, n, n2, n3);
    }

    public static OneResponse diskSnapshotRename(Client client, int n, int n2, int n3, String string) {
        return client.call(DISKSNAPSHOTRENAME, n, n2, n3, string);
    }

    public static OneResponse diskResize(Client client, int n, int n2, long l) {
        return client.call(DISKRESIZE, n, n2, String.valueOf(l));
    }

    public static OneResponse updateconf(Client client, int n, String string) {
        return client.call(UPDATECONF, n, string);
    }

    public static OneResponse schedadd(Client client, int n, String string) {
        return client.call(SCHEDADD, n, string);
    }

    public static OneResponse scheddelete(Client client, int n, int n2) {
        return client.call(SCHEDDELETE, n, n2);
    }

    public static OneResponse schedupdate(Client client, int n, int n2, String string) {
        return client.call(SCHEDUPDATE, n, n2, string);
    }

    public static OneResponse recover(Client client, int n, int n2) {
        return client.call(RECOVER, n, n2);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public static OneResponse sgAttach(Client client, int n, int n2, int n3) {
        return client.call(ATTACHSG, n, n2, n3);
    }

    public static OneResponse sgDetach(Client client, int n, int n2, int n3) {
        return client.call(DETACHSG, n, n2, n3);
    }

    public static OneResponse pciAttach(Client client, int n, String string) {
        return client.call(ATTACHPCI, n, string);
    }

    public static OneResponse pciDetach(Client client, int n, int n2) {
        return client.call(DETACHPCI, n, n2);
    }

    public static OneResponse backup(Client client, int n, int n2, boolean bl) {
        return client.call(BACKUP, n, n2, bl);
    }

    public static OneResponse backupCancel(Client client, int n) {
        return client.call(BACKUPCANCEL, n);
    }

    public static OneResponse restore(Client client, int n, int n2, int n3, int n4) {
        return client.call(RESTORE, n, n2, n3, n4);
    }

    public static OneResponse exec(Client client, int n, String string, String string2) {
        return client.call(EXEC, n, string, string2);
    }

    public static OneResponse execRetry(Client client, int n) {
        return client.call(EXEC_RETRY, n);
    }

    public static OneResponse execCancel(Client client, int n) {
        return client.call(EXEC_CANCEL, n);
    }

    public OneResponse info() {
        OneResponse oneResponse = VirtualMachine.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse deploy(int n, boolean bl, int n2, String string) {
        return this.client.call(DEPLOY, this.id, n, bl, n2, string);
    }

    public OneResponse deploy(int n) {
        return this.deploy(n, false, -1, "");
    }

    protected OneResponse action(String string) {
        return this.client.call(ACTION, string, this.id);
    }

    public OneResponse migrate(int n, boolean bl, boolean bl2, int n2, int n3) {
        return this.client.call(MIGRATE, this.id, n, bl, bl2, n2, n3);
    }

    public OneResponse migrate(int n, boolean bl, boolean bl2, int n2) {
        return this.client.call(MIGRATE, this.id, n, bl, bl2, n2);
    }

    public OneResponse migrate(int n, boolean bl) {
        return this.migrate(n, bl, false, -1);
    }

    public OneResponse migrate(int n) {
        return this.migrate(n, false, false, -1);
    }

    public OneResponse chown(int n, int n2) {
        return VirtualMachine.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return VirtualMachine.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return VirtualMachine.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return VirtualMachine.chmod(this.client, this.id, n);
    }

    public OneResponse monitoring() {
        return VirtualMachine.monitoring(this.client, this.id);
    }

    public OneResponse diskAttach(String string) {
        return VirtualMachine.diskAttach(this.client, this.id, string);
    }

    public OneResponse diskDetach(int n) {
        return VirtualMachine.detachdisk(this.client, this.id, n);
    }

    public OneResponse diskSaveas(int n, String string, String string2, int n2) {
        return VirtualMachine.diskSaveas(this.client, this.id, n, string, string2, n2);
    }

    public OneResponse diskSaveas(int n, String string) {
        return this.diskSaveas(n, string, "", -1);
    }

    public OneResponse diskSaveas(int n, String string, int n2) {
        return this.diskSaveas(n, string, "", n2);
    }

    public OneResponse nicAttach(String string) {
        return VirtualMachine.nicAttach(this.client, this.id, string);
    }

    public OneResponse nicDetach(int n) {
        return VirtualMachine.nicDetach(this.client, this.id, n);
    }

    public OneResponse nicUpdate(int n, String string, boolean bl) {
        return VirtualMachine.nicUpdate(this.client, this.id, n, string, bl);
    }

    public OneResponse rename(String string) {
        return VirtualMachine.rename(this.client, this.id, string);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return VirtualMachine.update(this.client, this.id, string, bl);
    }

    public OneResponse resize(String string, boolean bl) {
        return VirtualMachine.resize(this.client, this.id, string, bl);
    }

    public OneResponse snapshotCreate(String string) {
        return VirtualMachine.snapshotCreate(this.client, this.id, string);
    }

    public OneResponse snapshotRevert(int n) {
        return VirtualMachine.snapshotRevert(this.client, this.id, n);
    }

    public OneResponse snapshotDelete(int n) {
        return VirtualMachine.snapshotDelete(this.client, this.id, n);
    }

    public OneResponse diskSnapshotCreate(int n, String string) {
        return VirtualMachine.diskSnapshotCreate(this.client, this.id, n, string);
    }

    public OneResponse diskSnapshotRevert(int n, int n2) {
        return VirtualMachine.diskSnapshotRevert(this.client, this.id, n, n2);
    }

    public OneResponse diskSnapshotDelete(int n, int n2) {
        return VirtualMachine.diskSnapshotDelete(this.client, this.id, n, n2);
    }

    public OneResponse diskResize(int n, long l) {
        return VirtualMachine.diskResize(this.client, this.id, n, l);
    }

    public OneResponse updateconf(String string) {
        return VirtualMachine.updateconf(this.client, this.id, string);
    }

    public OneResponse schedadd(String string) {
        return VirtualMachine.schedadd(this.client, this.id, string);
    }

    public OneResponse scheddelete(int n) {
        return VirtualMachine.scheddelete(this.client, this.id, n);
    }

    public OneResponse schedupdate(int n, String string) {
        return VirtualMachine.schedupdate(this.client, this.id, n, string);
    }

    public OneResponse recover(int n) {
        return VirtualMachine.recover(this.client, this.id, n);
    }

    public OneResponse lock(int n) {
        return VirtualMachine.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return VirtualMachine.unlock(this.client, this.id);
    }

    public OneResponse sgAttach(int n, int n2) {
        return VirtualMachine.sgAttach(this.client, this.id, n, n2);
    }

    public OneResponse sgDetach(int n, int n2) {
        return VirtualMachine.sgDetach(this.client, this.id, n, n2);
    }

    public OneResponse pciAttach(String string) {
        return VirtualMachine.pciAttach(this.client, this.id, string);
    }

    public OneResponse pciDetach(int n) {
        return VirtualMachine.pciDetach(this.client, this.id, n);
    }

    public OneResponse backup(int n, boolean bl) {
        return VirtualMachine.backup(this.client, this.id, n, bl);
    }

    public OneResponse backupCancel() {
        return VirtualMachine.backupCancel(this.client, this.id);
    }

    public OneResponse restore(int n, int n2, int n3) {
        return VirtualMachine.restore(this.client, this.id, n, n2, n3);
    }

    public OneResponse exec(String string, String string2) {
        return VirtualMachine.exec(this.client, this.id, string, string2);
    }

    public OneResponse execRetry() {
        return VirtualMachine.execRetry(this.client, this.id);
    }

    public OneResponse execCancel() {
        return VirtualMachine.execCancel(this.client, this.id);
    }

    public OneResponse terminate() {
        return this.terminate(false);
    }

    public OneResponse terminate(boolean bl) {
        String string = bl ? "terminate-hard" : "terminate";
        return this.action(string);
    }

    public OneResponse undeploy(boolean bl) {
        String string = bl ? "undeploy-hard" : "undeploy";
        return this.action(string);
    }

    public OneResponse poweroff() {
        return this.poweroff(false);
    }

    public OneResponse poweroff(boolean bl) {
        String string = bl ? "poweroff-hard" : "poweroff";
        return this.action(string);
    }

    public OneResponse reboot() {
        return this.action("reboot");
    }

    public OneResponse reboot(boolean bl) {
        String string = bl ? "reboot-hard" : "reboot";
        return this.action(string);
    }

    public OneResponse hold() {
        return this.action("hold");
    }

    public OneResponse release() {
        return this.action("release");
    }

    public OneResponse stop() {
        return this.action("stop");
    }

    public OneResponse suspend() {
        return this.action("suspend");
    }

    public OneResponse resume() {
        return this.action("resume");
    }

    public OneResponse resched() {
        return this.action("resched");
    }

    public OneResponse unresched() {
        return this.action("unresched");
    }

    @Override
    public int state() {
        return super.state();
    }

    public String stateStr() {
        int n = this.state();
        return n != -1 ? VM_STATES[this.state()] : null;
    }

    public int lcmState() {
        String string = this.xpath("LCM_STATE");
        return string != null ? Integer.parseInt(string) : -1;
    }

    public String lcmStateStr() {
        int n = this.lcmState();
        return n != -1 ? LCM_STATE[n] : null;
    }

    public String status() {
        int n;
        int n2 = this.state();
        String string = null;
        if (n2 != -1 && (string = SHORT_VM_STATES[n2]).equals("actv") && (n = this.lcmState()) != -1) {
            string = SHORT_LCM_STATES[n];
        }
        return string;
    }

    @Deprecated
    public static OneResponse attachdisk(Client client, int n, String string) {
        return VirtualMachine.diskAttach(client, n, string);
    }

    @Deprecated
    public static OneResponse detachdisk(Client client, int n, int n2) {
        return VirtualMachine.diskDetach(client, n, n2);
    }

    @Deprecated
    public OneResponse attachdisk(String string) {
        return this.diskAttach(string);
    }

    @Deprecated
    public OneResponse detachdisk(int n) {
        return this.diskDetach(n);
    }

    @Deprecated
    public OneResponse liveMigrate(int n) {
        return this.migrate(n, false);
    }
}

