/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vm;

import java.util.AbstractList;
import java.util.Iterator;
import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.Pool;
import org.opennebula.client.PoolElement;
import org.opennebula.client.vm.VirtualMachine;
import org.w3c.dom.Node;

public class VirtualMachinePool
extends Pool
implements Iterable<VirtualMachine> {
    private static final String ELEMENT_NAME = "VM";
    private static final String INFO_METHOD = "vmpool.info";
    private static final String INFO_EXTENDED_METHOD = "vmpool.infoextended";
    private static final String INFO_SET_METHOD = "vmpool.infoset";
    private static final String MONITORING = "vmpool.monitoring";
    private static final String ACCOUNTING = "vmpool.accounting";
    private static final String SHOWBACK = "vmpool.showback";
    private static final String CALCULATE_SHOWBACK = "vmpool.calculateshowback";
    public static final int ALL_VM = -2;
    public static final int NOT_DONE = -1;
    private int filter;

    public VirtualMachinePool(Client client) {
        super(ELEMENT_NAME, client, INFO_METHOD);
        this.filter = -1;
    }

    public VirtualMachinePool(Client client, int n) {
        super(ELEMENT_NAME, client, INFO_METHOD);
        this.filter = n;
    }

    @Override
    public PoolElement factory(Node node) {
        return new VirtualMachine(node, this.client);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO_METHOD, n, -1, -1, -1);
    }

    public static OneResponse info_extended(Client client, int n) {
        return client.call(INFO_EXTENDED_METHOD, n, -1, -1, -1);
    }

    public static OneResponse info_extended(Client client, int n, boolean bl) {
        return client.call(INFO_SET_METHOD, n, bl);
    }

    public static OneResponse infoAll(Client client) {
        return client.call(INFO_METHOD, -2, -1, -1, -1);
    }

    public static OneResponse infoMine(Client client) {
        return client.call(INFO_METHOD, -3, -1, -1, -1);
    }

    public static OneResponse infoGroup(Client client) {
        return client.call(INFO_METHOD, -1, -1, -1, -1);
    }

    public static OneResponse info(Client client, int n, int n2, int n3, int n4) {
        return client.call(INFO_METHOD, n, n2, n3, n4);
    }

    public static OneResponse info_search(Client client, int n, int n2, int n3, int n4, String string) {
        return client.call(INFO_METHOD, n, n2, n3, n4, string);
    }

    public static OneResponse monitoring(Client client, int n) {
        return client.call(MONITORING, n);
    }

    public static OneResponse monitoring(Client client, int n, int n2) {
        return client.call(MONITORING, n, n2);
    }

    public static OneResponse accounting(Client client, int n, int n2, int n3) {
        return client.call(ACCOUNTING, n, n2, n3);
    }

    public static OneResponse showback(Client client, int n, int n2, int n3, int n4, int n5) {
        return client.call(SHOWBACK, n, n2, n3, n4, n5);
    }

    public static OneResponse calculateshowback(Client client, int n, int n2, int n3, int n4, int n5) {
        return client.call(CALCULATE_SHOWBACK, n, n2, n3, n4, n5);
    }

    @Override
    public OneResponse info() {
        OneResponse oneResponse = VirtualMachinePool.info(this.client, this.filter);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse info_extended() {
        OneResponse oneResponse = VirtualMachinePool.info_extended(this.client, this.filter);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    @Override
    public OneResponse infoAll() {
        OneResponse oneResponse = VirtualMachinePool.infoAll(this.client);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    @Override
    public OneResponse infoMine() {
        OneResponse oneResponse = VirtualMachinePool.infoMine(this.client);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    @Override
    public OneResponse infoGroup() {
        OneResponse oneResponse = VirtualMachinePool.infoGroup(this.client);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse info(int n, int n2, int n3, int n4) {
        OneResponse oneResponse = VirtualMachinePool.info(this.client, n, n2, n3, n4);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse monitoring(int n) {
        return VirtualMachinePool.monitoring(this.client, n);
    }

    public OneResponse accounting(int n, int n2, int n3) {
        return VirtualMachinePool.accounting(this.client, n, n2, n3);
    }

    public OneResponse showback(int n, int n2, int n3, int n4, int n5) {
        return VirtualMachinePool.showback(this.client, n, n2, n3, n4, n5);
    }

    public OneResponse calculateshowback(int n, int n2, int n3, int n4, int n5) {
        return VirtualMachinePool.calculateshowback(this.client, n, n2, n3, n4, n5);
    }

    @Override
    public Iterator<VirtualMachine> iterator() {
        AbstractList<VirtualMachine> abstractList = new AbstractList<VirtualMachine>(){

            @Override
            public int size() {
                return VirtualMachinePool.this.getLength();
            }

            @Override
            public VirtualMachine get(int n) {
                return (VirtualMachine)VirtualMachinePool.this.item(n);
            }
        };
        return abstractList.iterator();
    }

    @Override
    public VirtualMachine getById(int n) {
        return (VirtualMachine)super.getById(n);
    }
}

